# Tensor Toolbox for MATLAB Acknowledgments

## Contributors

**Primary POC:** Tamara G. Kolda, tammy.kolda@mathsci.ai

**Other Contributors:**
* Evrim Acar - CP with optimization and missing data (`cp_opt`, `cp_wopt`)
* Woody Austin - Various fixes
* Brett W. Bader - Original author
* Grey Ballard - Various fixes
* Robert Bassett - Cleaning up symmetric tensor methods and classes (`cp_sym`, `symtensor`, `symktensor`)
* Casey Battaglino - Randomized CP (`cp_arls`)
* Johannes J. Brust - CP limited-memory optimization solver (`libraries/compact`,`tt_opt_compact`,`cp_opt`)
* Eric C. Chi - Alternating Poisson Regression with Mulitplicative Updates (`cp_apr`)
* Jed Duersch - Improved K-tensor full ('ktensor/full') and Generalized CP (`gcp_opt`)
* Daniel M. Dunlavy - CP with optimization and missing data (`cp_opt`, `cp_wopt`), various fixes
* Samantha Hansen - Alternating Poisson Regression with QN or Newton Updates (`cp_apr`)
* David Hong - Generalized CP (`gcp_opt`)
* Nirmit Joshi - ttsv for Symktensor (`symktensor/ttsv`)
* Brett W. Larsen - Randomized CP with Leverage Scores (`cp_arls_lev`)
* Jackson Mayo - Eigenvalue methods (`eig_sshopm`, `eig_sshopmc`, `eig_geap`)
* Joao M Pereira - Subspace Power method (`cp_spm`) and faster symtensor/indices method (`@symtensor/indices`)
* Todd Plantenga - Alternating Poisson Regression with QN or Newton Updates (`cp_apr`)
* Samantha Sherman - Implicit symmetric CP (`cp_isym`)
* Shaden Smith - Faster fitness computation in `cp_als`
* Jimeng Sun - Memory-efficient Tucker (distributed with version 2.6 or earlier)
* Alex Williams - Ktensor/viz method (`ktensor/viz`)
* Eric Phipps - Improvements to (`ktensor/viz`) and added (`@sptensor/squash`)
* Vatsal Sharan and Sai Anuroop Kesanapalli - Orthogonalized ALS (`cp_orth_als`)

## Funding Acknowledgments

Development of the Tensor Toolbox for MATLAB has received substantial support from
Sandia National Laboratories, including the Laboratory Directed Research & Development (LDRD) program
and the DOE Office of Science Advanced Scientific Computing Applied Mathematics research program.

## Other Acknowledgments

Banner image design by Kristin Pelletier Marketing & Design,
in conjunction with MathSci.ai.
