function disp(X,name)
%DISP Command window display of a sptensor.
%
%   DISP(X) displays the tensor without printing its name.
%
%   DISP(X,NAME) displays the tensor with the given name.
%
%   See also SPTENSOR, SPTENSOR/DISPLAY.
%
%Tensor Toolbox for MATLAB: <a href="https://www.tensortoolbox.org">www.tensortoolbox.org</a>



% Extract the number of nonzeros/values and number of dimensions
nz = nnz(X);

if ~exist('name','var')
    name = 'ans';
end

if (nz == 0)
    if issparse(X)
        tmpstr = 'all-zero sparse tensor';
    else
        tmpstr = 'totally empty incomplete tensor';
    end
    fprintf('%s is an %s of size %s\n',...
        name, tmpstr, tt_size2str(X.size));
    return;
else
    fprintf('%s is a %s tensor of size %s with %d values\n',...
        name, X.type, tt_size2str(X.size), nz);
end

% Stop insane printouts
if (nz > 10000)
    r = input('Are you sure you want to print all values? (Y/N) ','s');
    if upper(r) ~= 'Y', return, end;
end

% preallocate
output = cell(nz,1);
%%
spc = floor(log10(max(double(X.subs),[],1)))+1;
if numel(spc) == 1
    fmt = ['\t(%' num2str(spc(1)) 'd)%s'];
else
    fmt = ['\t(%' num2str(spc(1)) 'd,'];
    for i = 2:numel(spc)-1
        fmt = [fmt '%' num2str(spc(i)) 'd,'];
    end
    fmt = [fmt '%' num2str(spc(end)) 'd)%s'];
end
%%
% Get values out so that they look nice
savefmt = get(0,'FormatSpacing');
format compact
S = evalc('disp(X.vals)');
set(0,'FormatSpacing',savefmt)
S = textscan(S,'%s','delimiter','\n','whitespace','');
S = S{1};
if ~isempty(strfind(S{1},'*'))
    fprintf('%s\n',S{1});
    S = S(2:end);
end
%%
for i = 1:nz
    output{i} = sprintf(fmt,X.subs(i,:),S{i});
end
fprintf('%s\n',output{:});

%     function y = fmt(s,v)
%         % nested function has access to n from disp function workspace
%         if n > 1
%             y = [sprintf('\t(') sprintf('%d,',s(1:n-1))...
%                 sprintf('%d) ',s(n)) sprintf('\t%g',v)];
%         else
%             y = sprintf('\t(%d) \t%f',s,v);
%         end
%     end

end
