function [WeightMatrix_SNR_ideal, WeightMatrix_Rate_ideal, WeightMatrix_SNR_forecast, WeightMatrix_Rate_forecast] = build_weight_matrices_AT(Ps, channel_trace_map, elevation_quantized_all, distance_ts_all, allowed_elevs, f_c)

U = size(elevation_quantized_all, 3);
M = size(elevation_quantized_all, 1);
T = size(elevation_quantized_all, 2);

distance_m_all = distance_ts_all * 1e3;
GGU_dBi = 0; GSAT_dBi = 50;
GGU = 10^(GGU_dBi / 10); GSAT = 10^(GSAT_dBi / 10);
B = 5e6; N0_dBmHz = -174;
N0 = 10^((N0_dBmHz - 30)/10) * B;
c = 3e8;

WeightMatrix_SNR_ideal = zeros(U, M, T);
WeightMatrix_Rate_ideal = zeros(U, M, T);
WeightMatrix_SNR_forecast = zeros(U, M, T);
WeightMatrix_Rate_forecast = zeros(U, M, T);

for u = 1:U
    for m = 1:M
        elev_row = elevation_quantized_all(m, :, u);
        dist_row = distance_m_all(m, :, u);

        for k = 1:length(allowed_elevs)
            elev_val = allowed_elevs(k);
            h2_trace = channel_trace_map(elev_val);

            ind_elev_vec = find(elev_row == elev_val);
            d = dist_row(ind_elev_vec);
            L = (c ./ (4 * pi * d * f_c)).^2;
            rho = Ps * GGU * GSAT * L / N0;

            segLen = 1500;                     % samples per slot you want to average
            Lh     = numel(h2_trace);
            
            for ind = 1:length(ind_elev_vec)
                t = ind_elev_vec(ind);
            
                % start index for this time slot
                base = (t-1)*segLen;
            
                % circular indices to avoid out-of-bounds regardless of Lh
                idx  = mod(base : base+segLen-1, Lh) + 1;
            
                % 1×segLen window
                h_t = h2_trace(idx);
            
                snr_inst = rho(ind) .* h_t;
                WeightMatrix_SNR_ideal(u, m, t)  = 10 * log10(mean(snr_inst));
                WeightMatrix_Rate_ideal(u, m, t) = mean(log2(1 + snr_inst));
            end


            h_t = mean(h2_trace); % average channel power for forecast
            snr = rho .* h_t;
            WeightMatrix_SNR_forecast(u, m, ind_elev_vec) = 10 * log10(snr);
            WeightMatrix_Rate_forecast(u, m, ind_elev_vec) = log2(1 + snr);
        end
    end
end
