function impulse_response = Jakes_IR(fD, W)

% input_signal: row vector with the filter input
% fD : Doppler frequency
% W : sampling rate of the input process (typically equal to the signal
% bandwidth =1/Ts*vm

if(W < fD)
    error('The bandwidth must be greater than the doppler frequency')
end

over = round(W/fD);	
nsamp = 60;
df = fD * 0.999/nsamp; %frequency interval (avoid singularity)
delay = nsamp * over;
%dt = 1/delay/df;

f_vec = (0:nsamp) * df;
Tf_1 = 1 ./ sqrt(sqrt(1 - (f_vec / fD).^2));

impulse_response_1 = Tf_1(1) + 2 * cos(2*pi*(0:delay)'* (1:nsamp) / delay) * Tf_1(2:end)'; 
% Windowing
impulse_response_1 = impulse_response_1' .* (1+cos(pi * (0:delay) / delay));
impulse_response = [impulse_response_1(end:-1:2), impulse_response_1];
impulse_response = impulse_response ./ norm(impulse_response);
