import sys
import os
import re
from pathlib import Path

def patch_pyshark(venv_path):
    major, minor = sys.version_info[:2]
    if major == 3 and minor <= 11:
        print(f"[INFO] Python {major}.{minor} found. No patch necessary.")
        return

    print(f"[INFO] Python {major}.{minor} found. Applying patch to pyshark...")

    tshark_file = Path(venv_path) / "lib" / f"python{major}.{minor}" / "site-packages" / "pyshark" / "tshark" / "tshark.py"

    if not tshark_file.exists():
        print(f"[ERROR] File {tshark_file} not found.")
        return

    with open(tshark_file, "r", encoding="utf-8") as f:
        content = f.read()

    if "packaging.version" in content:
        print("[INFO] Pyshark is already patched.")
        return

    new_content = re.sub(
        r"from\s+distutils\.version\s+import\s+LooseVersion",
        "from packaging.version import Version as LooseVersion",
        content
    )

    with open(tshark_file, "w", encoding="utf-8") as f:
        f.write(new_content)

    print(f"[SUCCESS] Patch applied to {tshark_file}")

if __name__ == "__main__":
    venv_path = "venv"
    patch_pyshark(venv_path)
