from pathlib import Path
import logging
import os

# =========================
# CONFIGURATION FILE
# =========================

OLLAMA_MODEL_FAST = "qwen3_instruct:agentic"
OLLAMA_MODEL = "qwen3_instruct:agentic"
OLLAMA_BASE_URL = "http://0.0.0.0:11434"

#-- GEMINI --
GEMINI_API_KEY = os.environ.get("GEMINI_API_KEY", "--")
GEMINI_API_KEY_2 = os.environ.get("GEMINI_API_KEY_2", "--")
GEMINI_API_KEY_3 = os.environ.get("GEMINI_API_KEY_3", "--")
GEMINI_API_KEY_4 = os.environ.get("GEMINI_API_KEY_4", "--")


VT_API_KEY = os.environ.get("VT_API_KEY", "--")

GEMINI_MODEL_NAME = "gemini-2.5-pro"
MAX_RETRIES = 30
RETRY_WAIT = 30

#LOGS
ASK_GEMINI_LOG_LEVEL = logging.INFO
CREATECASE_LOG_LEVEL = logging.INFO
PROCESSACQUISITION_LOG_LEVEL = logging.INFO
VERIFYSIGNATURES_LOG_LEVEL = logging.INFO
SCANDISK_LOG_LEVEL = logging.INFO
DISK_AGENT_LOG_LEVEL = logging.INFO
CATFILE_LOG_LEVEL = logging.INFO
SCANMEMORY_LOG_LEVEL = logging.INFO

CREATECASE_LOG_FILE = "create_case.log"
CREATECASE_LOG_FORMAT = "%(asctime)s [%(levelname)s] %(message)s"
DISK_AGENT_LOG_FILE = "scripts/disk/AI_agent/output_log.md"
LOG_FILE_SCAN_MEMORY = "scripts/memory/scan_memory.log"

# VIRTUAL ENVIRONMENT
VENV_PATH = "./venv/"


# ---------- createcase.py ----------
BASE_DIR = Path("./")

CASE_DIRS = [
    "00_meta",
    "01_acquisition",
    "02_raw_checksums",
    "03_processing/memory",
    "03_processing/disk",
    "03_processing/network",
    "04_reports"
]

ARTIFACT_EXTENSIONS = {
    "disk": ["flat.vmdk", ".dd", ".img"],
    "memory": [".lime", ".raw"],
    "network": [".pcap", ".pcapng"]
}


# ---------- process_acquisitions.py ----------
DISK_SCRIPT_PATH = "scripts/disk/scan_disk.py"
MEMORY_SCRIPT_PATH = "scripts/memory/scan_memory.py"
NETWORK_SCRIPT_PATH = "scripts/network/scan_network.py"

ACQUISITION_FOLDER = "01_acquisition"
DISK_IMAGE_NAME = "hdd_image_flat.vmdk"
PCAP_FILE_NAME = "net_traffic.pcap"
ASK_MEMORY_SCRIPT = "scripts/memory/ask_gemini.py"
FINAL_REPORT_SCRIPT_PATH = "scripts/final_report_generation.py"
PROCESS_ACQUISITION_SCRIPT_PATH = "process_acquisitions.py"


# ---------- verify_signatures.py ----------
CHECKSUMS_SUBDIR = "02_raw_checksums"
SIG_EXTENSION = ".sig"
HASH_ALGORITHM = "sha256"


# ---------- scan_disk.py ----------
GEMINI_AGENT = "scripts/disk/AI_agent/disk_gemini_agent_alpha.py"
EXTRACTION_MAP_FILENAME = "extraction_map.csv"
OUTPUT_SUBDIR_DISK = "03_processing/disk"

# Keys of interest
# Keys of interest (relative paths only)
REGISTRY_KEYS_TO_EXTRACT = [
    # Run / RunOnce (per-user and machine)
    r"Software\Microsoft\Windows\CurrentVersion\Run",
    r"Software\Microsoft\Windows\CurrentVersion\Run",
    r"Software\Microsoft\Windows\CurrentVersion\RunOnce",
    r"Software\Microsoft\Windows\CurrentVersion\RunOnce",

    # 32-bit-on-64-bit view
    r"Software\WOW6432Node\Microsoft\Windows\CurrentVersion\Run",
    r"Software\WOW6432Node\Microsoft\Windows\CurrentVersion\RunOnce",

    # Policies (per-user and machine)
    r"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run",
    r"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer\Run",

    # Scheduled Tasks
    r"Software\Microsoft\Windows NT\CurrentVersion\Schedule\TaskCache\Tasks",
    r"Software\Microsoft\Windows NT\CurrentVersion\Schedule\TaskCache\Tree",

    # Services & drivers
    r"SYSTEM\CurrentControlSet\Services",  # inspect binPath, Start, Type
    r"Software\Microsoft\Windows NT\CurrentVersion\Svchost",

    # IFEO (Image File Execution Options)
    r"SOFTWARE\Microsoft\Windows NT\CurrentVersion\Image File Execution Options\*",

    # DLL search/order abuses / KnownDLLs / AppInit DLLs / COM
    r"CurrentControlSet\Control\Session Manager\KnownDLLs",   # KnownDLLs location in SYSTEM hive
    r"Software\Microsoft\Windows NT\CurrentVersion\Windows\AppInit_DLLs",
    r"Software\Microsoft\Windows NT\CurrentVersion\Windows\LoadAppInit_DLLs",
    r"CLSID\*",
    r"Software\Classes\CLSID\*",

    # Winlogon helpers (Shell / Userinit / Notify)
    r"Software\Microsoft\Windows NT\CurrentVersion\Winlogon",
]

LINUX_ARTIFACT_PATHS = [

    # # # Account / user manipulation
    "/etc/passwd",
    # # "/etc/shadow",
    # # "/etc/group",
    # # "/etc/gshadow",
    # "/etc/sudoers",
    # # #"/etc/sudoers.d/*",
    # # #"/home/*/",
    # # #"/root/",

    # # # Authentication & logs
    # "/var/log/auth.log",        # Debian/Ubuntu
    # # #"/var/log/secure",          # RHEL/CentOS
    # # "/var/log/wtmp",
    # # "/var/log/btmp",
    # # "/var/log/lastlog",
    # # "/var/log/faillog",

    # # # SSH persistence
    #"/home/*/.ssh/authorized_keys",
    #"/root/.ssh/authorized_keys",

    # # # Cron
    "/etc/crontab",
    "/etc/cron.d/",
    #"/etc/cron.hourly/",
    #"/etc/cron.daily/",
    # # #"/etc/cron.weekly/",
    # # #"/etc/cron.monthly/",
    # "/var/spool/cron/crontabs/*",
    # # #"/var/spool/cron/",

    # # # Systemd / init / services
    "/etc/systemd/system/",
    "/lib/systemd/system/",
    "/usr/lib/systemd/system/",
    "/home/*/.config/systemd/user/",
    "/etc/systemd/system/*.service.d/",
    # #"/etc/systemd/system/*.wants/",
    # #"/run/systemd/system/",
    "/var/lib/systemd/",

    # # Init scripts / legacy boot
    "/etc/init.d/",
    # #"/etc/rc*.d/",
    # "/etc/rc.local",

    # # User startup scripts / shell hooks
    "/etc/profile",
    "/etc/profile.d/*",
    "/etc/bash.bashrc",
    "/etc/bash_logout",
    "/home/*/.bashrc",
    "/home/*/.bash_profile",
    "/home/*/.bash_login",
    "/home/*/.profile",
    "/home/*/.bash_logout",
    "/home/*/.config/autostart/*",            # XDG autostart
    "/home/*/.local/share/autostart/*",

    # # Developer / package tooling hooks
    #"/etc/apt/apt.conf.d/*",
    # # "/home/*/.git/hooks/*",
    # #"/home/*/.gitconfig",

    # # Library preloading / loader abuse
    "/etc/ld.so.preload",
    # #"/usr/local/lib/",
    # #"/home/*/.lib/",

    # # Kernel modules / low-level
    # #"/lib/modules/*",                  # malicious kernel modules locations
    # #"/proc/modules",                   # loaded module inspection (not a file to copy but worth checking)

    # # SUID / system binaries (possible replacements)
    # #"/usr/bin/",
    # #"/usr/sbin/",
    # #"/usr/local/bin/",
    # #"/bin/",
    # #"/sbin/",

    # # Package manager metadata & hooks
    # #"/etc/dpkg/dpkg.cfg.d/",
    # #"/etc/yum.repos.d/",
    # "/etc/dnf/dnf.conf",

    # # Miscellaneous user artifacts
    # #"/home/*/.mozilla/",
    # #"/home/*/.config/",
    # #"/home/*/.local/share/",
    # #"/home/*/.local/share/Trash/"
]

# --- Windows artifacts ---
WINDOWS_ARTIFACT_PATHS = [
    # # paper persistance

    # Machine & user hives (on-disk)
    "/Windows/System32/config/SOFTWARE",
    "/Windows/System32/config/SYSTEM",
    "/Users/*/NTUSER.DAT",

    # Startup folders
    "/Users/*/AppData/Roaming/Microsoft/Windows/Start Menu/Programs/Startup/",  # per-user
    "/ProgramData/Microsoft/Windows/Start Menu/Programs/Startup/",               # all users

    # # Scheduled tasks (on-disk)
    "/Windows/System32/Tasks/",
    # "/Windows/Tasks/",

    # # AppInit DLLs / unexpected DLLs loaded from writable dirs (on-disk)
    # #"/Windows/System32/",
    # #"/Users/*/AppData/Roaming/",
    # #"/Users/*/AppData/Local/",

    # # Accessibility / binary replacement (utilman.exe, sethc.exe, etc.)
    # # "/Windows/System32/utilman.exe",
    # # "/Windows/System32/sethc.exe",

    # # WMI repository (possible WMI persistence)
    # #"/Windows/System32/wbem/Repository/",

    # # Group Policy / logon scripts
    # #"/Windows/System32/GroupPolicy/",
    # #"/Windows/SysWOW64/GroupPolicy/",
    # "/Users/*/AppData/Roaming/Microsoft/Windows/Start Menu/Scripts/",

    # # User activity & browser profiles (possible payloads / persistence helpers)
    # #"/Users/*/AppData/Roaming/",
    # #"/Users/*/AppData/Local/Microsoft/Windows/History/",
    # #"/Users/*/AppData/Local/Microsoft/Windows/Recent/",
    # #"/Users/*/AppData/Local/Microsoft/Windows/INetCache/",
    # #"/Users/*/AppData/Local/Google/Chrome/User Data/Default/",
    # #"/Users/*/AppData/Roaming/Mozilla/Firefox/Profiles/",

    # # Scheduled task XMLs (on-disk)
    # "/Windows/System32/Tasks/",

    # # Other on-disk payload locations frequently abused
    # #"/Temp/",
    # #"/ProgramData/",
    # #"C:/Temp/",
    # # Machine hives (to decide how to extract the only reg keys needed)
    # #"/Windows/System32/Config/SOFTWARE",
    # #"/WINDOWS/System32/Config/SOFTWARE",
    # #"/windows/system32/config/software",
    # #"/Windows/System32/config/SOFTWARE",  # mix-case
    # #"/*[Ww][Ii][Nn][Dd][Oo][Ww][Ss]/*[Ss][Yy][Ss][Tt][Ee][Mm]32/[Cc]onfig/[Ss]oftware",
    # #"/Windows/System32/Config/SOFTWARE",

    # # "/Windows/System32/config/SOFTWARE",
    # # "/Windows/System32/config/SYSTEM",
    # # "/Users/*/NTUSER.DAT",

    # # "/Users/*/AppData/Roaming/Microsoft/Windows/Start Menu/Programs/Startup",

    # # #"/Users/*/AppData/Local/",
    # # "/Windows/System32/Tasks/"

]



# ---------- disk_gemini_agent_alpha.py ----------
SCRIPT_TIMEOUT = 120  # seconds
SCRIPT_PATH = "scripts/disk/AI_agent/actions/folder_scan.py"
SCRIPT2_PATH = "scripts/disk/AI_agent/actions/cat_file.py"

PYTHON_BIN = os.path.join(VENV_PATH, "bin" if os.name != "nt" else "Scripts", "python.exe" if os.name == "nt" else "python")
SHOW_NOT_SUSPICIOUS = False
MAX_TPM = 125000



# ---------- cat_file.py ----------
MAX_OUTPUT = 10000
CHUNK_SIZE = 500 * 1024 * 1024  # 500 MB


# ---------- ask_gemini.py ----------
# Gemini API keys
GEMINI_API_KEY_ENV_VAR = GEMINI_API_KEY
DEFAULT_GEMINI_API_KEY = GEMINI_API_KEY
SECONDARY_GEMINI_API_KEY = GEMINI_API_KEY_2

# Output settings
OUTPUT_SUBDIR_MEMORY = "03_processing/memory/00 - agent reports"
TIMESTAMP_FORMAT = "%Y%m%d_%H%M%S"

# Limits (free tier)
MAX_RPM = 2
MAX_TPM = 125_000

# Rate limiter files
DB_JSON_PATH = "rate_limiter.json"
LOCK_PATH = "rate_limiter.lock"


# ---------- scan_memory.py ----------
BASE_PATHS = {
    "windows": "windows",
    "linux": "linux"
}

INPUT_RELPATHS = {
    "windows": "memdump.raw",
    "linux": "memdump.lime"
}

OUTPUT_RELPATH = "03_processing/memory"
VOL_SCRIPT = "python3 /app/volatility3/vol.py"
MAX_WORKERS = 7

PLUGINS_BY_OS = {
    "windows": [
        "windows.pslist.PsList",
        #"windows.psscan",
        #"windows.malfind.Malfind",
        #"windows.netstat.NetStat",
        # "windows.info",
        # "windows.pstree.PsTree",
        # "windows.dlllist.DllList",
        # "windows.vadinfo.VadInfo",
        # "windows.cmdline.CmdLine",
        # "windows.hashdump.Hashdump",
        # "windows.getservicesids.GetServiceSIDs",
        # "windows.svcscan.SvcScan",
        # "windows.handles.Handles",
        # "windows.modules.Modules",
        # "windows.ssdt.SSDT",
        # "windows.registry.hivelist.HiveList",
        # "windows.registry.printkey.PrintKey",
        # "windows.registry.userassist.UserAssist",
        # "windows.sessions.Sessions",
        # "windows.userassist.UserAssist",
        # "windows.threads.Threads"
    ],
    "linux": [
        "linux.pslist.PsList",
        #"linux.psscan",
        #"linux.bash.Bash",
        #"linux.lsof.Lsof",
        # "linux.pstree.PsTree",
        # "linux.envars.Envars",
        # "linux.check_afinfo.Check_afinfo",
        # "linux.check_creds.Check_creds",
        # "linux.lsmod.Lsmod",
        # "linux.kmsg.Kmsg",
        # "linux.capabilities.Capabilities",
        # "linux.netfilter.Netfilter",
        # "linux.ip.Link",
        # "linux.ip.Addr",
        # "linux.sockstat.Sockstat",
        # "linux.keyboard_notifiers.Keyboard_notifiers",
        # "linux.mountinfo.MountInfo"
    ]
}



# ---------- scan_network.py ----------

VT_BASE_URL = "https://www.virustotal.com/api/v3"
VT_RATE_LIMIT_DELAY = 16
VT_RESULT_FILENAME = "vt_ioc_results.csv"
VT_JSON_LINES_LIMIT = 20


# ---------- final_report_generation.py ----------
REPORT_FOLDER = "04_reports"
DISK_SUBFOLDER = "03_processing/disk/00 - agent_reports"
MEMORY_SUBFOLDER = "03_processing/memory/00 - agent reports"
NETWORK_SUBFOLDER = "03_processing/network"
SUPPORTED_EXTENSIONS = [".md", ".json", ".txt",".csv"]

FINAL_GEMINI_MODEL_NAME = "gemini-2.5-pro"
FINAL_MAX_TPM = 125000


# ---------- Prompts ----------

# Disk agent prompts

DISK_AGENT_SUMMARIZE_PROMPT = """You are a subagent that assists a main forensic LLM agent. 
Your task is to reduce the context length of its history by condensing it into the following format:

LLM: <summarize all LLM responses so far in a concise way>
Observation: <summarize all observations so far>
Final Answer: <summarize all final answers so far>

Each section must start with its label exactly as written (LLM:, Observation:, Final Answer:).
Do not add any extra reasoning or commentary. Only produce these three fields.

Here is the history you have to manage:""" #+ "\n".join(history)

DISK_AGENT_ANALYZE_FILE_PROMPT = """You are a digital forensics expert. Analyze the following file for potential malicious behavior, suspicious indicators, or anomalies.

Instructions:
1. Examine the content carefully.
2. Decide if the file is suspicious or benign.
3. Identify any indicators of compromise (IoCs) you can find.
4. Return your response in EXACTLY this JSON format:
5. Look out for the dates, today is {current_date}

{{
  "file_name": "{file_to_examine}",
  "suspicious": true/false,
  "reasoning": "<brief explanation of why it is suspicious or benign>",
  "indicators": ["<list of any IoCs or suspicious patterns found>"]
}}

File content:
{file_content}
"""

DISK_AGENT_ANALYZE_FOLDER_PROMPT = """You are a forensic agent that can use a Python script to analyze a folder.

Your task:
    • The input is the output of an ls (Linux/macOS) or dir (Windows) command, if linux use "/" if Windows use "\\"".
    • Analyze this input to identify any anomalous files or directories, mind the dates: today is {current_date} (the LAST MODIFIED field of the input has date format <year>-<month>-<day>).
    • For files, if any seem anomalous, return their names as a dictionary (with name + reason) in the final answer.
        scan all files that may be household of malware persistance.
        If you are unsure whether a file is anomalous or not, you may use the following action to inspect its contents:
        {SCRIPT2_PATH} {HDD_IMAGE_PATH} "{{STARTING_FOLDER}}\\\\<file>"
    • For directories, if any seem anomalous, respond with:
      Action: script_name.py <directory_name>
      (This will trigger a deeper analysis on the selected directory.)
    • GO AT LEAST 1 LEVEL DEEP FOR ALL FOUND FOLDERS IN THE INITIAL INPUT
WARNING: Ignore files usually classified as folder or viceversa, they are not anomalies but maybe corrupted.

Use the following response formats:
    • LLM: <your analysis> – to provide your reasoning or analysis
    • Observation: <your observation> – to log any findings or observations
    Then follow with:
    • Final Answer: <your final answer> – to provide the result or conclusion, include the full paths
    • Action: {SCRIPT_PATH} {HDD_IMAGE_PATH} "{{STARTING_FOLDER}}\\\\<directory_name>" – if further action is needed, Note: only one action at a time, remember to add the hdd image path, DONT WRAP IT IN ```text or anything.

Current history:
{context}
User input:
{user_input}
Please provide your analysis and next steps.
"""

#memory ai prompts


FORENSIC_CHUNK_MEMORY_PROMPT = """You are processing a long input of a Volatility3 plugin output.
Your job is to cut the output on only the rows that you find anomalous/relevant to a forensic case.
Context of previous chunks:
```
{context}
```
RESPOND STRICTLY AND ONLY WITH THIS OUTPUT FORMAT:
```
OFFSET (V)      PID     TID     PPID    COMM    UID     GID     EUID    EGID    CREATION TIME   File output
```
input:
```
{chunk_text}
```
"""

FORENSIC_MEMORY_PROMPT_WCLEAN = """You are a digital forensic assistant. Your task is to generate a forensic report section in Markdown format.

Context

You are provided with the outputs of the same Volatility plugin executed on:
{clean_section}
    • The machine under investigation:
{target_content}

Task
    1. Compare <input> with <clean_out>.
    2. Highlight anomalies, suspicious entries, or deviations between the two outputs.
    3. Interpret forensic significance, explaining why certain differences may indicate malicious activity or abnormal system behavior.
    4. Maintain professional forensic reporting style: concise, factual, and clear. Avoid speculation unless grounded in evidence.
    5. Ignore and do not flag as anomalous any actions consistent with forensic/analyst workflows.  
        Examples:
        - Extracting password-protected ZIPs with password "infected" (common for sandboxed malware samples).  
        - Renaming or saving extracted malware as files like "malware".  
        - Loading kernel modules with insmod or modprobe when attributable to forensic memory acquisition tools (e.g., LiME).  
        - Using sudo/su to run those tools.
    6.  Plugins could not work correctly.  Ignore and do not flag as anomalous any artifacts that could be explained by plugin malfunctions.
        Examples:
        - 99% of the times, extremely large, non-standard values for UID, GID, EUID, and EGID in process dumps, does not indicate memory structure manipulation, but the plugin not working correctly.
        - Corrupted in memory process names.

Output format (Markdown)
    • Begin with a section title (e.g., ## Memory Analysis - [PluginName])
    • Provide a short overview of what the plugin analyzes.
    • Insert a comparison summary table (showing Normal vs Observed, if clean data is available).
    • Provide a narrative analysis describing the findings.
    • Conclude with a forensic interpretation (possible implications, next steps).
respond with just the section, no intro.
Task

1. Compare <input> with <clean_out>.
2. Examine the plugin output carefully for anomalies, suspicious entries, or deviations from expected system behavior.
3. Highlight key differences between the two outputs.
4. Interpret forensic significance, explaining why findings may indicate malicious activity or abnormal system behavior.
5. Maintain professional forensic reporting style: concise, factual, and clear. Avoid speculation unless grounded in evidence.
6. Ignore and do not flag as anomalous any actions consistent with forensic/analyst workflows.
   Examples:  
   - Extracting password-protected ZIPs with password "infected" (common for sandboxed malware samples).  
   - Renaming or saving extracted malware as files like "malware".  
   - Loading kernel modules with insmod or modprobe when attributable to forensic memory acquisition tools (e.g., LiME).  
   - Using sudo/su to run those tools.
7. Handle plugin malfunctions carefully: do not interpret them as malicious indicators.  
   Examples:  
   - Extremely large or non-standard values for PID, PPID, UID, GID, EUID, or EGID.  
   - Corrupted or garbled process names.  
   - Impossible timestamps (e.g., year 1930 or similar).  
   These must be treated as artifacts of plugin parsing, not as rootkit or malware evidence.
8. Ignore any processes or artifacts that are clearly part of forensic or analyst workflows.  
   Examples:  
   - Memory acquisition and analysis tools (e.g., LiME, Volatility, Rekall).  
   - Network sniffers used for legitimate analysis (e.g., Wireshark) during investigation.  
   - Common analyst scripts or debugging tools (e.g., Python scripts, WinDbg).  
   These should not be flagged as suspicious, anomalous, or malicious.   

Output format (Markdown)
- Begin with a section title (e.g., ## Memory Analysis - [PluginName])  
- Provide a short overview of what the plugin analyzes.  
- Insert a comparison summary table (showing Normal vs Observed, if clean data is available).  
- Provide a narrative analysis describing the findings.  
- Conclude with a forensic interpretation (possible implications, next steps).  

Warning: insmod is not an IoCs because Lime was use to dump the memory of the machine by a forense agent.
Respond with just the section, no intro.
"""

FORENSIC_MEMORY_PROMPT = """You are a digital forensic assistant. Your task is to generate a forensic report section in Markdown format.

Context

You are provided with the outputs of a Volatility plugin executed on the machine under investigation:
{target_content}

Task

1. Examine the plugin output carefully for anomalies, suspicious entries, or deviations from expected system behavior.
2. Interpret forensic significance, explaining why findings may indicate malicious activity or abnormal system behavior.
3. Maintain professional forensic reporting style: concise, factual, and clear. Avoid speculation unless grounded in evidence.
4. Ignore and do not flag as anomalous any actions consistent with forensic/analyst workflows.  
   Examples:  
   - Extracting password-protected ZIPs with password "infected" (common for sandboxed malware samples).  
   - Renaming or saving extracted malware as files like "malware".  
   - Loading kernel modules with insmod or modprobe when attributable to forensic memory acquisition tools (e.g., LiME).  
   - Using sudo/su to run those tools.
5. Handle plugin malfunctions carefully: do not interpret them as malicious indicators.  
   Examples:  
   - Extremely large or non-standard values for PID, PPID, UID, GID, EUID, or EGID.  
   - Corrupted or garbled process names.  
   - Impossible timestamps (e.g., year 1930 or similar).  
   These must be treated as artifacts of plugin parsing, not as rootkit or malware evidence.
6. Ignore any processes or artifacts that are clearly part of forensic or analyst workflows.  
   Examples:  
   - Memory acquisition and analysis tools (e.g., LiME, Volatility, Rekall).  
   - Network sniffers used for legitimate analysis (e.g., Wireshark) during investigation.  
   - Common analyst scripts or debugging tools (e.g., Python scripts, WinDbg).  
   These should not be flagged as suspicious, anomalous, or malicious.   

Output format (Markdown)

- Begin with a section title (e.g., ## Memory Analysis - [PluginName])  
- Provide a short overview of what the plugin analyzes.  
- Provide a narrative analysis describing the findings.  
- Conclude with a forensic interpretation (possible implications, next steps).  

Warning: insmod is not an IoCs because Lime was use to dump the memory of the machine by a forense agent.
Respond with just the section, no intro.
"""

#final report prompt

MAIN_FORENSIC_INSTRUCTION = """You are analyzing forensic evidence.
Input could be given in multiple JSON chunks if too long.
Summarize the key findings across disk, memory, and network.
Rules:
1.  Ignore and do not flag as anomalous any actions consistent with forensic/analyst workflows.
    Examples:
    *   Extracting password-protected ZIPs with password "infected" (common for sandboxed malware samples).
    *   Renaming or saving extracted malware as files like "virus.elf".
    *   Loading kernel modules with insmod or modprobe when attributable to forensic memory acquisition tools (e.g., Dumpit, LiME).
    *   Using sudo/su to run those tools.
  
2.  Plugins could not work correctly. Do not use those evidences for a verdict.  
   Examples:
    *   99% of the times, extremely large, non-standard values for UID, GID, EUID, and EGID in process dumps, does not indicate memory structure manipulation, but the plugin not working correctly.
    *   Corrupted in memory process names.
3.  Only highlight artifacts that cannot be explained as part of forensic workflows.
    Examples:
    *   Unexpected binaries with obfuscation or irregular permissions.
    *   Network communications with malicious IPs/domains not tied to forensic activity.
    *   Registry or configuration artifacts that match known malware patterns and cannot be explained by legitimate activity.
4.  ALWAYS consider the possibility of false positives, the reports of disk and memory are NOT perfect and 100% reliable. Be always open to suggest the forense agent to double-check things instead of declaring the machine compromised.
5.  Findings must be evidence-based, and verdicts must be conservative:
      _A single unusual artifact (e.g., oddly named registry key or unknown file) is_ *not enough** to declare suspicious without corroboration.
      _Corroborating evidence (e.g., matching malicious network traffic, known malware hash, or suspicious memory behavior) is required for a_ *Suspicious** verdict.
      _If findings are weak or inconclusive, state_ *Not Compromised** or **Inconclusive** depending on context.
Format your response in the following sections:
*   **Suspicious/malicious activity (report)**
At the end, provide a concise forensic conclusion in one of the following formats:
**Final Verdict: Suspicious**
**Final Verdict: Not Compromised**
**Final Verdict: Inconclusive**
Include a brief reasoning and suggest next steps for the forensic team.
"""

CHUNK_PROMPT_TEMPLATE = """You are processing a long input in multiple chunks.
This is chunk {chunk_number}/{total_chunks}.

{context}
Chunk content:
\"\"\"
{chunk_text}
\"\"\"

- Summarize the key findings in this chunk.

When evaluating artifacts, ignore and do not flag as anomalous any actions consistent 
with forensic acquisition or analyst workflows. Examples include:
  • Use of memory acquisition tools (e.g., DumpIt, LiME, WinPMEM, AVML).  
  • Execution of insmod/modprobe when attributable to LiME or other acquisition tools.  
  • Extraction of password-protected malware samples (e.g., ZIPs with password "infected") 
    and saving/renaming them (e.g., virus.elf) as part of controlled analysis.  
  • Privilege escalation via sudo/su when clearly used to run acquisition or analysis tools.  
  • Use of analyst scripts for unpacking or staging samples.  

Highlight only suspicious or malicious activity that cannot be explained as part of 
forensic or analyst workflows.
- DO NOT explain or provide methods.
- You MUST return the output in EXACTLY this JSON format:
{{
  "chunk_number": {chunk_number},
  "summary": "<readable extracted content from this chunk>"
}}
- Do NOT change the keys.
- Maintain this format consistently for all chunks.
- Return ONLY the JSON object, nothing else."""

FINAL_PROMPT_TEMPLATE = """You have received {number_of_summaries} chunk summaries:

{summaries}

Main Task:
{main_instruction}
"""


#AGENT DISK PROMPTS userinput compressing Local

CHUNK_DISK_PROMPT_TEMPLATE = """You are processing a long input of a ls output of a program.
Your job is to cut the output on only the rows that you find anomalous/relevant to a forensic case.
Keep all the folders in your output.
Context of previous chunks:
```
{context}
```
RESPOND STRICTLY AND ONLY WITH THIS OUTPUT FORMAT:
```
PERMISSIONS UID GID SIZE LAST_MODIFIED NAME
```
input:
```
{chunk_text}
```
"""

DISK_PROMPT_LLM_LOCAL = """Current history:
{context}
User input:
{user_input}
---

You are a forensic agent that can use a Python script to analyze a folder.

Your task:
    • The input is the output of an ls (Linux/macOS) or dir (Windows) command, if linux use "/" if Windows use "\\"".
    • Analyze this input to identify any anomalous files or directories, mind the dates, today is {current_date}.
    • For files, if any seem anomalous, return their names as a dictionary (with name + reason) in the final answer.
        scan all files that may be household of malware persistance.
        If you are unsure whether a file is anomalous or not, you may use the following action to inspect its contents:
        {SCRIPT2_PATH} {HDD_IMAGE_PATH} "{{STARTING_FOLDER}}\\\\<file>"
    • For directories, if any seem anomalous, respond with:
      Action: script_name.py <directory_name>
      (This will trigger a deeper analysis on the selected directory.)
    • GO AT LEAST 1 LEVEL DEEP FOR ALL FOUND FOLDERS IN THE INITIAL INPUT
WARNING: Ignore files usually classified as folder or viceversa, they are not anomalies but maybe corrupted.

Use the following response formats:
    • LLM: <your analysis> – to provide your reasoning or analysis
    • Observation: <your observation> – to log any findings or observations
    Then follow with:
    • Final Answer: <your final answer> – to provide the result or conclusion, include the full paths.
    • Action: {SCRIPT_PATH} {HDD_IMAGE_PATH} "{{STARTING_FOLDER}}\\\\<directory_name>" – if further action is needed, Note: only one action at a time, remember to add the hdd image path, DONT WRAP IT IN ```text or anything.

Please provide your analysis and next steps."""
