%% Parameters for Battery Electric Vehicle Forward Model

%% Vehicle
% 500e High Range Parameters
% Immatricolazione 500e HR Classe 3b curb 
vehicle.mass = 1250;                 % [kg]   Massa dual
vehicle.wheelbase = 2.322;                  % [m]    wheelbase - Immatricolazione 500e HR Classe 3b
vehicle.aCG = 0.45*vehicle.wheelbase;       % [m]    front axle - CoG distance - Dati 500e LR
vehicle.bCG = 0.55*vehicle.wheelbase;       % [m]    rear axle - CoG distance - Dati 500e LR
vehicle.hCG = 0.3;                          % [m]    height CoG - Dati 500e LR
vehicle.Af = 2.15;                          % [m2]   Frontal area - NEW Coast Down with F1=0
vehicle.Cd = 0.33;                          % [-]    Drag coefficient - NEW Coast Down with F1=0
vehicle.tireRRcoeff = 0.00587;              % [-]    Rolling Resistance Coeff F0 - Immatricolazione 500e HR Claase 3b
vehicle.tireRollingRadius = 0.3;            % [m]    Wheel Radius - 195/55R16
% NEW Coast Down with F1=0
vehicle.roadLoadA_N = 83.1;                 % [N]      F0 - Immatricolazione 500e HR Claase 3b
vehicle.roadLoadB_N_per_kph = 0;            % [N/kph]  F1 - Immatricolazione 500e HR Classe 3b
vehicle.roadLoadC_N_per_kph2 = 0.034;       % [N/kph2] F2 - Immatricolazione 500e HR Classe 3b
% Original Coast Down - Immatricolazione 500e HR Classe 3b
% vehicle.roadLoadA_N = 83.1;                 % [N]      F0 - Immatricolazione 500e HR Claase 3b
% vehicle.roadLoadB_N_per_kph = 0.227;        % [N/kph]  F1 - Immatricolazione 500e HR Classe 3b
% vehicle.roadLoadC_N_per_kph2 = 0.03220;     % [N/kph2] F2 - Immatricolazione 500e HR Classe 3b
% Other
vehicle.roadLoad_gravAccel_m_per_s2 = 9.81;     
smoothing.vehicle_speedThreshold_kph = 1;
smoothing.vehicle_axleSpeedThreshold_rpm = 1;
initial.vehicle_speed_kph = 0;
road_grade = atan(0/100);

%% 350V 500e HR Battery - Samsung SDI 60Ah Cell Data
battery350V.nominalVoltage_V = 48;    
battery350V.internalResistance_Ohm = 0.01;
battery350V.nominalCapacity_kWh =51.8*240/1000;
battery350V.voltagePerCell_V = 3.67;  % Open Circuit Voltage. 3.5V to 3.7V assuming Lithium-ion
battery350V.nominalCharge_Ahr = ...
  battery350V.nominalCapacity_kWh / battery350V.nominalVoltage_V * 1000;
battery350V.mass_kg = battery350V.nominalCapacity_kWh / 0.141; % kWh / (kWh/kg)
% Initial conditions
initial.Battery_SOC_pct = 90;
initial.Battery_Charge_Ahr = battery350V.nominalCharge_Ahr * initial.Battery_SOC_pct/100;

%% Reduction Gear
bevGear.gearRatio = 10.2;
bevGear.efficiency = 0.97;

%% 52V Motor Drive Unit - 
BEV_mot = load("20241002_EM_Polito_Maps.mat");        % Load EM efficeincy map
Speed_max = BEV_mot.Speed(:,1);                   % Maximum Speed [rpm]
Shaft_Torque_max = BEV_mot.Shaft_Torque(:,1);     % Maximum Torque [Nm]
Shaft_Power_max = BEV_mot.Shaft_Power(:,1);       % Maximum Power [W]
for i = 1:length(Shaft_Torque_max)                % Torque Limit
    if Shaft_Torque_max(i) > 85
       Shaft_Torque_max(i) = 85;
    elseif Shaft_Torque_max(i) < -85
       Shaft_Torque_max(i) = -85;
    end
end
BEV_mot.Shaft_Torque(1,21) = 0.05;

eta_inv = 0.90;                                   % CHECK!!!
BEV_mot.Total_Loss = BEV_mot.Total_Loss./eta_inv;

motorDrive.simplePmsmDrv_trqMax_Nm = max(Shaft_Torque_max);
motorDrive.simplePmsmDrv_powMax_W = max(Shaft_Power_max);

PMR=motorDrive.simplePmsmDrv_powMax_W*eta_inv/vehicle.mass;  %PMR

motorDrive.simplePmsmDrv_timeConst_s = 0.02;


motorDrive.simplePmsmDrv_rotorInertia_kg_m2 = 3.93*0.01^2;
motorDrive.simplePmsmDrv_rotorDamping_Nm_per_radps = 1e-5;
motorDrive.simplePmsmDrv_initialRotorSpd_rpm = 0;

motorDrive.spdCtl_trqMax_Nm = motorDrive.simplePmsmDrv_trqMax_Nm;
motorDrive.gearRatioCompensation = 3/bevGear.gearRatio;

%% Controller & Environment
bevControl.MotorSpdRef_tireRadius_m = vehicle.tireRollingRadius;
bevControl.MotorSpdRef_reductionGearRaio = bevGear.gearRatio;

bevControl.MotorSpdRef_Ki = 10; %15;
bevControl.MotorSpdRef_Kp = 0.2; %15;
