import asyncio
import json

async def handle_client(reader, writer):
    addr = writer.get_extra_info('peername')
    print(f"[VERIFIER TCP] Connessione da {addr}")

    try:
        data = await reader.read(65536)
        message = data.decode()
        quote_data = json.loads(message)

        # print(f"\n[VERIFIER TCP] Quote ricevuta:\n{json.dumps(quote_data, indent=2)}")

        # Risposta al master
        response = {"code": 200, "status": "Received"}
        writer.write(json.dumps(response).encode())
        await writer.drain()

    except Exception as e:
        print(f"[VERIFIER TCP] Errore: {e}")
    finally:
        writer.close()
        await writer.wait_closed()
        print(f"[VERIFIER TCP] 🔒 Connessione chiusa")

async def main():
    server = await asyncio.start_server(handle_client, '0.0.0.0', 9999)
    addr = server.sockets[0].getsockname()
    print(f"[VERIFIER TCP] In ascolto su {addr}")

    async with server:
        await server.serve_forever()

if __name__ == '__main__':
    asyncio.run(main())
