import json
import os
import argparse
from datetime import datetime

# Configura l'argparse per accettare il nome del file da linea di comando
parser = argparse.ArgumentParser(description='Popola il file di policy runtime.')
parser.add_argument('runtime_policy_path', type=str, help='Percorso del file runtime_policy.json')
args = parser.parse_args()

# Percorsi dei file
runtime_policy_path = args.runtime_policy_path
ima_measurements_path = '/sys/kernel/security/ima/ascii_runtime_measurements'

# Carica il file runtime_policy.json
with open(runtime_policy_path, 'r') as f:
    runtime_policy = json.load(f)

# Leggi il file /sys/kernel/integrity/ima/ascii_runtime_measurements
with open(ima_measurements_path, 'r') as f:
    ima_measurements = f.read()


# Aggiungi voci al campo digests
with open(ima_measurements_path, 'r') as f:
    for line in f:
        parts = line.strip().split()
        file_data_hash = parts[5]
        name = parts[6]
        hash_parts = file_data_hash.split(':')
        #algo = hash_parts[0]
        digest = hash_parts[1]
        if name not in runtime_policy['digests']:
            runtime_policy['digests'][name] = []
        if digest not in runtime_policy['digests'][name]:
            runtime_policy['digests'][name].append(digest)
        #else:
        #    runtime_policy['digests'][name].append(digest)

# Aggiorna il timestamp
runtime_policy['meta']['timestamp'] = datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')

# Salva il file runtime_policy.json aggiornato
with open(runtime_policy_path, 'w') as f:
    json.dump(runtime_policy, f, indent=4)

print(f"File {runtime_policy_path} updated successfully.")
