#!/usr/bin/python3
# -*- coding: utf-8 -*-
 
import codecs
import sys
import hashlib
import struct
import binascii

START_HASH = (codecs.decode('0'*40, 'hex'))
FF_HASH = (codecs.decode('f'*40, 'hex'))
 
START_HASH_256 = (codecs.decode('0'*64, 'hex'))
FF_HASH_256 = (codecs.decode('f'*64, 'hex'))
 
START_HASH_384 = (codecs.decode('0'*96, 'hex'))
FF_HASH_384 = (codecs.decode('f'*96, 'hex'))
 
START_HASH_512 = (codecs.decode('0'*128, 'hex'))
FF_HASH_512 = (codecs.decode('f'*128, 'hex'))

NULL_BYTE = ord("\0")
COLON_BYTE = ord(":")
 
class Hash:
    SHA1 = 'sha1'
    SHA256 = 'sha256'
    SHA384 = 'sha384'
    SHA512 = 'sha512'
    supported_algorithms = (SHA1, SHA256, SHA384, SHA512)
 
    @staticmethod
    def is_recognized(algorithm):
        return algorithm in Hash.supported_algorithms
 
    @staticmethod
    def compute_hash(algorithm, tohash):
        return {
                Hash.SHA1: lambda h: hashlib.sha1(h).digest(),
                Hash.SHA256: lambda h: hashlib.sha256(h).digest(),
                Hash.SHA384: lambda h: hashlib.sha384(h).digest(),
                Hash.SHA512: lambda h: hashlib.sha512(h).digest(),
            }[algorithm](tohash)
 
start_hash = {
            Hash.SHA1: START_HASH,
            Hash.SHA256: START_HASH_256,
            Hash.SHA384: START_HASH_384,
            Hash.SHA512: START_HASH_512
        }
ff_hash = {
        Hash.SHA1: FF_HASH,
        Hash.SHA256: FF_HASH_256,
        Hash.SHA384: FF_HASH_384,
        Hash.SHA512: FF_HASH_512
    }
 
if __name__ == '__main__':
    if len(sys.argv) != 2:
        print("Required PCR10 value as parameter")
        sys.exit(1)
 
    found_pcr = False
 
    pcr_val = sys.argv[1]
 
    hash_alg = Hash.SHA1
 
    runninghash = start_hash[hash_alg]
 
    with open('/sys/kernel/security/ima/ascii_runtime_measurements', 'r', encoding="utf-8") as ima_log_file:
        ima_data = ima_log_file.read()
        ima_entries_array = ima_data.split("\n")
 
        for line in ima_entries_array:
            line = line.strip()
            if line == '':
                continue
 
            tokens = line.split()
            #print(tokens)
            if len(tokens) < 5:
                print("invalid measurement list file line, number of fields < 5: -%s-" % (line))
                sys.exit(-1)
 
            template_hash = codecs.decode(tokens[1], 'hex')
 
            if template_hash == start_hash[hash_alg]:
                template_hash = ff_hash[hash_alg]
 
            if tokens[2] == "ima-slt":

                # dependencies
                dependencies = tokens[3].encode('utf-8')
                packed_data = struct.pack(f"<I{len(dependencies)}sB", len(dependencies) + 1, dependencies, NULL_BYTE)
                value_to_hash = bytearray(packed_data)

                # cgroup-name
                cg_name = tokens[4].encode('utf-8')
                packed_data = struct.pack(f"<I{len(cg_name)}sB", len(cg_name) + 1, cg_name, NULL_BYTE)
                value_to_hash = value_to_hash + bytearray(packed_data)
                
                # filedata_hash
                filedata_hash = tokens[5].split(':')

                algorithm = filedata_hash[0].encode('utf-8')
                hash = bytes.fromhex(filedata_hash[1])
                byte_value = codecs.decode(filedata_hash[1], 'hex')

                if algorithm is None:
                    packed_data = struct.pack(f"<I{len(hash)}s", len(hash), hash)
                else:
                    packed_data = struct.pack(
                    f"<I{len(algorithm)}sBB{len(hash)}s",
                    len(algorithm) + 2 + len(hash),
                    algorithm,
                    COLON_BYTE,
                    NULL_BYTE,
                    hash,
                )
                value_to_hash = value_to_hash + bytearray(packed_data)

                # filename-hint
                filename = tokens[6].encode('utf-8')
                packed_data = struct.pack(f"<I{len(filename)}sB", len(filename) + 1, filename, NULL_BYTE)
                value_to_hash = value_to_hash + bytearray(packed_data)

                # nonce
                nonce = tokens[7].encode('utf-8')
                print("nonce: ", nonce)
                nonce = "e01016391d7059e9115447c54f013122".encode('utf-8')
                packed_data = struct.pack(f"<I{len(nonce)}sB", len(nonce) + 1, nonce, NULL_BYTE)
                value_to_hash = value_to_hash + bytearray(packed_data)

                print("_____________________________")
                print(value_to_hash)
                print("_____________________________")

                value_hashed = Hash.compute_hash(hash_alg, value_to_hash)
                print("\n TEMPLATE-HASH: ", codecs.encode(value_hashed, 'hex').decode('utf-8').lower()) 
                print("-> DEVE ESSERE: ", tokens[1], " --> del sistema")

                runninghash = Hash.compute_hash(hash_alg, runninghash + value_hashed)
                print("\nrunning_hash: ", runninghash)
                print("running_hash: ", codecs.encode(runninghash, 'hex').decode('utf-8').lower())
                

            runninghash = Hash.compute_hash(hash_alg, runninghash + template_hash)

            print("\npcr: ", runninghash)
            print("pcr: ", codecs.encode(runninghash, 'hex').decode('utf-8').lower())
            found_pcr = (codecs.encode(runninghash, 'hex').decode('utf-8').lower() == pcr_val.lower())
 
            if found_pcr is True:
                print("\nPCR 10 validated correctly!")
                break
 
if not found_pcr:
	print("\nPCR 10 does NOT match!")
