"""Add pod_id to VerfierMain

Revision ID: cff2041568d8
Revises: 57b24ee21dfa
Create Date: 2025-07-09 20:47:22.597032

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'cff2041568d8'
down_revision = '57b24ee21dfa'
branch_labels = None
depends_on = None


def upgrade(engine_name):
    globals()[f"upgrade_{engine_name}"]()


def downgrade(engine_name):
    globals()[f"downgrade_{engine_name}"]()





def upgrade_registrar():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###


def downgrade_registrar():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###

def upgrade_cloud_verifier():
    bind = op.get_bind()
    dialect = bind.dialect.name

    # Controlla se l'indice esiste prima di eliminarlo
    if dialect == "sqlite":
        result = bind.execute("PRAGMA index_list('allowlists')")
        index_names = [row[1] for row in result]
        if 'ix_allowlists_checksum' in index_names:
            op.drop_index('ix_allowlists_checksum', table_name='allowlists')
    else:
        op.drop_index('ix_allowlists_checksum', table_name='allowlists')

    # Evita ALTER COLUMN se SQLite
    if dialect != "sqlite":
        op.alter_column('verifiermain', 'supported_version',
                        existing_type=sa.VARCHAR(length=50),
                        nullable=True)

    op.drop_column('verifiermain', 'tpm_version')
    op.add_column('verifiermain', sa.Column('pod_id', sa.String(length=255), nullable=True))


def downgrade_cloud_verifier():
    bind = op.get_bind()
    dialect = bind.dialect.name

    op.drop_column('verifiermain', 'pod_id')
    op.add_column('verifiermain', sa.Column('tpm_version', sa.INTEGER(), nullable=True))

    if dialect != "sqlite":
        op.alter_column('verifiermain', 'supported_version',
                        existing_type=sa.VARCHAR(length=50),
                        nullable=False)

    op.create_index('ix_allowlists_checksum', 'allowlists', ['checksum'], unique=False)

