! CMD Version:2
! Version 2 enables expanded acceptable characters for object names.
! If unspecified, set to 1 or set to an invalid value, Adams View assumes traditional naming requirements.
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = meter  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = off  &
   grid_visibility = off  &
   size_of_icons = 5.0E-02  &
   spacing_for_grid = 1.0
!
!------------------------------ Adams View Model ------------------------------!
!
!
model create  &
   model_name = MODEL_309394_flexbody  &
   comments =   &
              "Originally created via model copy from petaloide_parte_1.Last_Run at time=75sec with more_results=no and index_time=no."
!
model attributes  &
   model_name = .MODEL_309394_flexbody  &
   color = BLUE
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create spline  &
   spline_name = .MODEL_309394_flexbody.SPLINE_1  &
   adams_id = 1  &
   x = 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3,  &
       1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7,  &
       2.8, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1,  &
       4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5.0, 5.1, 5.2, 5.3, 5.4, 5.5,  &
       5.6, 5.7, 5.8, 5.9, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9,  &
       7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8.0, 8.1, 8.2, 8.3,  &
       8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9.0, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7,  &
       9.8, 9.9, 10.0, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9,  &
       11.0, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12.0,  &
       12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13.0, 13.1,  &
       13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14.0, 14.1, 14.2,  &
       14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15.0, 15.1, 15.2, 15.3,  &
       15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16.0, 16.1, 16.2, 16.3, 16.4,  &
       16.5, 16.6, 16.7, 16.8, 16.9, 17.0, 17.1, 17.2, 17.3  &
   y = 1.3193398472E-03, -6.1239770809E-04, 6.7262131175E-05,  &
       1.3494075074E-03, 1.7947485554E-03, 3.5952099666E-03,  &
       5.7497603231E-03, 8.6721025167E-03, 1.2498031107E-02,  &
       1.7001499289E-02, 2.2223423261E-02, 2.813093764E-02, 3.4691543848E-02,  &
       4.1856221777E-02, 4.956704724E-02, 5.7757526324E-02, 6.6354357735E-02,  &
       7.5278583358E-02, 8.4446817523E-02, 9.3772402579E-02, 0.1031665248,  &
       0.1125392708, 0.1218006246, 0.1308614057, 0.1396341462, 0.1480339085,  &
       0.1559790408, 0.1633918701, 0.1701993297, 0.1763335198, 0.181732194,  &
       0.1863391757, 0.190104692, 0.1929856248, 0.1949456775, 0.195955447,  &
       0.1959924041, 0.195040776, 0.1930913335, 0.1901410832, 0.1861928677,  &
       0.1812548839, 0.1753401262, 0.1684657701, 0.1606525097, 0.1519238738,  &
       0.1423055371, 0.1318246518, 0.1205092322, 0.1083876065,  &
       9.5487973592E-02, 8.1838081491E-02, 6.7465050381E-02,  &
       5.2395362064E-02, 3.6655020639E-02, 2.0269897611E-02,  &
       3.2662561139E-03, -1.4328552535E-02, -3.2485237194E-02,  &
       -5.1171584907E-02, -7.035138176E-02, -8.9983275885E-02, -0.1100196295,  &
       -0.1304054103, -0.151077177, -0.1719622125, -0.1929778609,  &
       -0.2140311164, -0.2350185104, -0.2558263338, -0.2763312209,  &
       -0.2964011113, -0.3158965942, -0.3346726226, -0.3525805772,  &
       -0.3694706406, -0.3851944307, -0.3996078354, -0.4125739712,  &
       -0.4239661872, -0.4336710258, -0.4415910492, -0.447647438,  &
       -0.4517822729, -0.4539604149, -0.4541709088, -0.452427848,  &
       -0.4487706542, -0.4432637433, -0.4359955693, -0.4270770599,  &
       -0.4166394761, -0.4048317503, -0.3918173747, -0.3777709259,  &
       -0.3628743247, -0.3473129364, -0.331271622, -0.3149308485,  &
       -0.2984629643, -0.2820287363, -0.2657742371, -0.2498281567,  &
       -0.2342995997, -0.2192764167, -0.2048240975, -0.1909852463,  &
       -0.1777796358, -0.1652048302, -0.1532373473, -0.1418343211,  &
       -0.130935614, -0.1204663175, -0.110339572, -0.1004596285,  &
       -9.0725078289E-02, -8.1032137768E-02, -7.1278014675E-02,  &
       -6.1363855999E-02, -5.1198759437E-02, -4.0698955283E-02,  &
       -2.9803821576E-02, -1.842759984E-02, -6.6493743087E-03,  &
       5.98801723E-03, 1.7855432431E-02, 3.5020538338E-02, 3.4733470339E-02,  &
       0.1016972512, 5.9605406613E-02, 5.2922453292E-02, 0.1306173175,  &
       0.1120800854, 0.1586211416, 8.7274498953E-02, 0.1055206311,  &
       0.2878117002, 0.224447415, 0.1665644649, 0.2324695512, 0.2335709649,  &
       0.2389834464, 0.2480879435, 0.2601469575, 0.2673163691, 0.2745157612,  &
       0.2804121715, 0.2853669065, 0.2893025382, 0.2922729168, 0.2943093959,  &
       0.2954606866, 0.2957804403, 0.2953286034, 0.2941689924, 0.292367879,  &
       0.289992357, 0.287108861, 0.2837817785, 0.2800722064, 0.2760368715,  &
       0.2717272353, 0.2671887947, 0.2624605892, 0.2575749123, 0.2525572304,  &
       0.2474262819, 0.2421944041, 0.2368678465, 0.2314478829, 0.2259295813,  &
       0.2203098424, 0.2145612495, 0.2087337786  &
   linear_extrapolate = no
!
!--------------------------------- Materials ----------------------------------!
!
!
material create  &
   material_name = .MODEL_309394_flexbody.steel  &
   adams_id = 9  &
   density = 7801.0  &
   youngs_modulus = 2.07E+11  &
   poissons_ratio = 0.29
!
material create  &
   material_name = .MODEL_309394_flexbody.carbon_fiber_0_90_epoxy  &
   adams_id = 2  &
   density = 1510.0  &
   orthotropic_constants = 1.23611E+10, 2.7443E+10, 2.8949E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_UD_230GPa_prepreg  &
   adams_id = 3  &
   density = 1490.0  &
   orthotropic_constants = 1.21E+11, 4.7E+09, 4.7E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_UD_230GPa_wet  &
   adams_id = 4  &
   density = 1518.0  &
   orthotropic_constants = 1.2334E+11, 5.0E+09, 5.0E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_UD_395GPa_prepreg  &
   adams_id = 5  &
   density = 1540.0  &
   orthotropic_constants = 2.09E+11, 5.5E+09, 5.5E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_Woven_230GPa_prepreg  &
   adams_id = 6  &
   density = 1420.0  &
   orthotropic_constants = 6.134E+10, 3.3E+09, 2.7E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_Woven_230GPa_wet  &
   adams_id = 7  &
   density = 1451.0  &
   orthotropic_constants = 5.916E+10, 3.3E+09, 2.7E+09
!
material create  &
   material_name = .MODEL_309394_flexbody.Epoxy_Carbon_Woven_390GPa_prepreg  &
   adams_id = 8  &
   density = 1480.0  &
   orthotropic_constants = 9.182E+10, 3.6E+09, 3.0E+09
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!----------------------------------- ground -----------------------------------!
!
!
! ****** Ground Part ******
!
defaults model  &
   part_name = ground
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_flexbody.ground.MARKER_12  &
   adams_id = 12  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.ground.MARKER_341  &
   adams_id = 341  &
   location = -5.0E-02, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.ground.MARKER_349  &
   adams_id = 349  &
   location = 128.3235337289, 85.2499998051, 0.0  &
   orientation = 114.893372929d, 33.2313103356d, 241.8218914606d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.ground.MARKER_351  &
   adams_id = 351  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.ground.MARKER_354  &
   adams_id = 354  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
! ****** Floating Markers for current part ******
!
floating_marker create  &
   floating_marker_name = .MODEL_309394_flexbody.ground.FMARKER_352  &
   adams_id = 352
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_flexbody.ground  &
   material_type = .MODEL_309394_flexbody.steel
!
part attributes  &
   part_name = .MODEL_309394_flexbody.ground  &
   name_visibility = off
!
!----------------------------------- Target -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_flexbody.Target  &
   adams_id = 34  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body initial_velocity  &
   part_name = .MODEL_309394_flexbody.Target  &
   vx = -0.2  &
   vy = -0.1  &
   vz = 0.5  &
   wx = 10.0  &
   wy = 10.0  &
   wz = 10.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.Target
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_flexbody.Target.MARKER_337  &
   adams_id = 337  &
   location = -1.125, 1.0, 20.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.Target.cm  &
   adams_id = 340  &
   location = -1.0, 1.125, 20.125  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .MODEL_309394_flexbody.Target.cm  &
   color = BLUE
!
marker create  &
   marker_name = .MODEL_309394_flexbody.Target.MARKER_353  &
   adams_id = 353  &
   location = -1.0, 1.125, 20.125  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_flexbody.Target  &
   mass = 20.78125  &
   center_of_mass_marker = .MODEL_309394_flexbody.Target.cm  &
   ixx = 0.2164713542  &
   iyy = 0.2164713542  &
   izz = 0.2164713542  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape block  &
   block_name = .MODEL_309394_flexbody.Target.BOX_33  &
   adams_id = 33  &
   corner_marker = .MODEL_309394_flexbody.Target.MARKER_337  &
   diag_corner_coords = 0.25, 0.25, 0.25
!
part attributes  &
   part_name = .MODEL_309394_flexbody.Target  &
   color = RED  &
   name_visibility = off
!
!------------------------------ Flexible Bodies -------------------------------!
!
! Create flexible bodies and their dependent markers
!
!------------------------------- pentagon1_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   adams_id = 1  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono1_32_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.0, 1.4282605234E-07, 0.0  &
   orientation = 359.9999181667, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   adams_id = 1
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,  &
                    36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon1_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2749  &
   adams_id = 450  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2750  &
   adams_id = 451  &
   node_id = 2750  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2751  &
   adams_id = 452  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2752  &
   adams_id = 453  &
   node_id = 2752  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2753  &
   adams_id = 454  &
   node_id = 2753  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.INT_NODE_2754  &
   adams_id = 455  &
   node_id = 2754  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_1  &
   adams_id = 1  &
   preserve_location = TRUE  &
   location = -0.1, -2.8565210468E-07, -2.0E-03  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_2  &
   adams_id = 2  &
   preserve_location = TRUE  &
   location = 0.1, 0.0, -2.0E-03  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_3  &
   adams_id = 3  &
   preserve_location = TRUE  &
   location = 0.1618031272, 0.1902113916, -2.0E-03  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_4  &
   adams_id = 4  &
   preserve_location = TRUE  &
   location = -4.3957328795E-07, 0.3077682109, -2.0E-03  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_5  &
   adams_id = 5  &
   preserve_location = TRUE  &
   location = -0.1618036706, 0.1902109294, -2.0E-03  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.cm_primo  &
   adams_id = 16  &
   preserve_location = TRUE  &
   location = -1.9658309414E-07, 0.1376380492, -2.0E-03  &
   orientation = 180.0000818333d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_13  &
   adams_id = 13  &
   node_id = 2754  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_14  &
   adams_id = 14  &
   node_id = 2751  &
   orientation = 54.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_114  &
   adams_id = 114  &
   node_id = 2752  &
   orientation = 126.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_172  &
   adams_id = 172  &
   node_id = 2749  &
   orientation = 90.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_244  &
   adams_id = 244  &
   node_id = 2750  &
   orientation = 342.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_318  &
   adams_id = 318  &
   node_id = 2753  &
   orientation = 18.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   adams_id = 330  &
   preserve_location = TRUE  &
   location = -1.9658309429E-07, 0.1376380493, -2.0E-03  &
   orientation = 270.0000818333d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_350  &
   adams_id = 350  &
   node_id = 2749  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_343  &
   adams_id = 343  &
   node_id = 2754  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_344  &
   adams_id = 344  &
   node_id = 2754  &
   orientation = 8.1833300038E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_345  &
   adams_id = 345  &
   node_id = 2754  &
   orientation = 180.0000818333d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_346  &
   adams_id = 346  &
   node_id = 2754  &
   orientation = 180.0000818333d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_347  &
   adams_id = 347  &
   node_id = 2754  &
   orientation = 90.0000818333d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_348  &
   adams_id = 348  &
   node_id = 2754  &
   orientation = 90.0000818333d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_372  &
   adams_id = 372  &
   node_id = 2751  &
   orientation = 54.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_380  &
   adams_id = 380  &
   node_id = 2752  &
   orientation = 126.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_384  &
   adams_id = 384  &
   node_id = 2749  &
   orientation = 90.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_395  &
   adams_id = 395  &
   node_id = 2750  &
   orientation = 342.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_407  &
   adams_id = 407  &
   node_id = 2753  &
   orientation = 18.0000818333d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   color = BLUE_GRAY  &
   name_visibility = off
!
!-------------------------------- exagon1_flex --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   adams_id = 2  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono1_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 1.4457370354E-06, 0.3077703436, 0.0  &
   orientation = 323.9992953847, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   adams_id = 2
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon1_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.INT_NODE_4141  &
   adams_id = 486  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.INT_NODE_4142  &
   adams_id = 487  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.INT_NODE_4143  &
   adams_id = 488  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_6  &
   adams_id = 6  &
   preserve_location = TRUE  &
   location = 2.9272834157E-11, -2.459633413E-06, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_7  &
   adams_id = 7  &
   preserve_location = TRUE  &
   location = 0.2, 0.0, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_8  &
   adams_id = 8  &
   preserve_location = TRUE  &
   location = 0.2999978699, 0.1732063105, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_9  &
   adams_id = 9  &
   preserve_location = TRUE  &
   location = 0.19999574, 0.3464101614, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_10  &
   adams_id = 10  &
   preserve_location = TRUE  &
   location = -4.2600653917E-06, 0.3464077019, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_11  &
   adams_id = 11  &
   preserve_location = TRUE  &
   location = -0.10000213, 0.1732013913, -2.0E-03  &
   orientation = 36.0007046153d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.original_rigid_cm  &
   adams_id = 17  &
   preserve_location = TRUE  &
   location = 0.09999787, 0.1732038509, -2.0E-03  &
   orientation = 306.0007046153d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_15  &
   adams_id = 15  &
   node_id = 4141  &
   orientation = 90.0007046153d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_57  &
   adams_id = 57  &
   node_id = 4142  &
   location = 0.1, 0.3464099999, 2.0E-03  &
   orientation = 90.0007046153d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_59  &
   adams_id = 59  &
   node_id = 4143  &
   location = -5.0000000007E-02, 0.25981, 0.0  &
   orientation = 330.0007046153d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_356  &
   adams_id = 356  &
   node_id = 4142  &
   orientation = 90.0007046153d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_371  &
   adams_id = 371  &
   node_id = 4141  &
   orientation = 90.0007046153d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_374  &
   adams_id = 374  &
   node_id = 4143  &
   orientation = 330.0007046153d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   color = RED  &
   name_visibility = off
!
!------------------------------ exagon1_no_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   adams_id = 3  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono1_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 35.9999999822, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   adams_id = 3
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon1_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.INT_NODE_4141  &
   adams_id = 518  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.INT_NODE_4142  &
   adams_id = 519  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.INT_NODE_4143  &
   adams_id = 520  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_69  &
   adams_id = 69  &
   preserve_location = TRUE  &
   location = 1.4148376914E-11, 0.0, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_70  &
   adams_id = 70  &
   preserve_location = TRUE  &
   location = 0.2, 0.0, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_71  &
   adams_id = 71  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_72  &
   adams_id = 72  &
   preserve_location = TRUE  &
   location = 0.1999999999, 0.3464101615, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_73  &
   adams_id = 73  &
   preserve_location = TRUE  &
   location = -1.6019569005E-10, 0.3464101615, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_74  &
   adams_id = 74  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050807, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.original_rigid_cm  &
   adams_id = 75  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050808, -2.0E-03  &
   orientation = 234.0000000178d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_90  &
   adams_id = 90  &
   preserve_location = TRUE  &
   location = -5.0000000052E-02, 0.259807621, -2.0E-03  &
   orientation = 324.0000000178d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_113  &
   adams_id = 113  &
   node_id = 4141  &
   orientation = 90.0000000178d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_116  &
   adams_id = 116  &
   node_id = 4143  &
   orientation = 330.0000000178d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_122  &
   adams_id = 122  &
   node_id = 4142  &
   location = 0.1, 0.34641, 2.0E-03  &
   orientation = 90.0000000178d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_368  &
   adams_id = 368  &
   node_id = 4142  &
   orientation = 90.0000000178d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_379  &
   adams_id = 379  &
   node_id = 4141  &
   orientation = 90.0000000178d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_382  &
   adams_id = 382  &
   node_id = 4143  &
   orientation = 330.0000000178d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   color = RED  &
   name_visibility = off
!
!------------------------------- exagon1_e_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   adams_id = 4  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono1_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 252.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   adams_id = 4
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon1_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.INT_NODE_4141  &
   adams_id = 549  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.INT_NODE_4142  &
   adams_id = 550  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.INT_NODE_4143  &
   adams_id = 551  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_126  &
   adams_id = 184  &
   preserve_location = TRUE  &
   location = 0.2, -3.580939989E-11, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_127  &
   adams_id = 185  &
   preserve_location = TRUE  &
   location = 1.1125614319E-11, -3.5809422094E-11, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_128  &
   adams_id = 186  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_129  &
   adams_id = 187  &
   preserve_location = TRUE  &
   location = 1.1125572685E-11, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_130  &
   adams_id = 188  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_131  &
   adams_id = 189  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.original_rigid_cm  &
   adams_id = 190  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050807, -2.0E-03  &
   orientation = 90.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_171  &
   adams_id = 191  &
   preserve_location = TRUE  &
   location = 0.1, -3.5809410992E-11, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_174  &
   adams_id = 192  &
   preserve_location = TRUE  &
   location = 0.1, 0.3464101615, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_176  &
   adams_id = 193  &
   preserve_location = TRUE  &
   location = -4.9999999989E-02, 0.2598076212, -2.0E-03  &
   orientation = 150.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_245  &
   adams_id = 245  &
   node_id = 4141  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_247  &
   adams_id = 247  &
   node_id = 4142  &
   location = 0.1, 0.34641, 2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_249  &
   adams_id = 249  &
   node_id = 4143  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_396  &
   adams_id = 396  &
   node_id = 4141  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_398  &
   adams_id = 398  &
   node_id = 4142  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_400  &
   adams_id = 400  &
   node_id = 4143  &
   orientation = 330.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   color = RED  &
   name_visibility = off
!
!------------------------------- exagon1_s_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   adams_id = 5  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono1_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.1, 0.0, 0.0  &
   orientation = 180.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   adams_id = 5
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon1_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.INT_NODE_4141  &
   adams_id = 579  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.INT_NODE_4142  &
   adams_id = 580  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.INT_NODE_4143  &
   adams_id = 581  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_126  &
   adams_id = 126  &
   preserve_location = TRUE  &
   location = 0.2, 0.0, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_127  &
   adams_id = 127  &
   preserve_location = TRUE  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_128  &
   adams_id = 128  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_129  &
   adams_id = 129  &
   preserve_location = TRUE  &
   location = 0.0, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_130  &
   adams_id = 130  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_131  &
   adams_id = 131  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.original_rigid_cm  &
   adams_id = 183  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050808, -2.0E-03  &
   orientation = 90.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_171  &
   adams_id = 171  &
   node_id = 4141  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_174  &
   adams_id = 174  &
   node_id = 4142  &
   location = 0.1, 0.34641, 2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_176  &
   adams_id = 176  &
   node_id = 4143  &
   orientation = 150.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_383  &
   adams_id = 383  &
   node_id = 4141  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_386  &
   adams_id = 386  &
   node_id = 4142  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_388  &
   adams_id = 388  &
   node_id = 4143  &
   orientation = 150.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   color = RED  &
   name_visibility = off
!
!------------------------------ exagon1_so_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   adams_id = 6  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono1_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.0999972095, 3.220036E-06, 0.0  &
   orientation = 108.0007277727, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   adams_id = 6
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon1_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.INT_NODE_4141  &
   adams_id = 608  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.INT_NODE_4142  &
   adams_id = 609  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.INT_NODE_4143  &
   adams_id = 610  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_126  &
   adams_id = 256  &
   preserve_location = TRUE  &
   location = 0.1999977999, 1.1085840856E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_127  &
   adams_id = 257  &
   preserve_location = TRUE  &
   location = -2.2000797175E-06, 3.6489900498E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_128  &
   adams_id = 258  &
   preserve_location = TRUE  &
   location = -0.1, 0.17321, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_129  &
   adams_id = 259  &
   preserve_location = TRUE  &
   location = 2.2000324841E-06, 0.3464138105, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_130  &
   adams_id = 260  &
   preserve_location = TRUE  &
   location = 0.2000022, 0.3464112701, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_131  &
   adams_id = 261  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732049192, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.original_rigid_cm  &
   adams_id = 262  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732074595, -2.0E-03  &
   orientation = 89.9992722273d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_171  &
   adams_id = 263  &
   preserve_location = TRUE  &
   location = 0.0999977999, 2.3787870677E-06, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_174  &
   adams_id = 264  &
   preserve_location = TRUE  &
   location = 0.1000022, 0.3464125403, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_176  &
   adams_id = 265  &
   preserve_location = TRUE  &
   location = -4.9998899992E-02, 0.2598119053, -2.0E-03  &
   orientation = 149.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_319  &
   adams_id = 319  &
   node_id = 4141  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_320  &
   adams_id = 320  &
   node_id = 4142  &
   location = 0.1, 0.34641, 2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_322  &
   adams_id = 322  &
   node_id = 4143  &
   orientation = 329.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_408  &
   adams_id = 408  &
   node_id = 4141  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_409  &
   adams_id = 409  &
   node_id = 4142  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_411  &
   adams_id = 411  &
   node_id = 4143  &
   orientation = 329.9992722273d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   color = RED  &
   name_visibility = off
!
!------------------------------- pentagon2_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   adams_id = 7  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.1122601803, 0.5473465276, 0.0  &
   orientation = 23.9999181667, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   adams_id = 7
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon2_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.INT_NODE_2749  &
   adams_id = 636  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.INT_NODE_2751  &
   adams_id = 637  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_18  &
   adams_id = 18  &
   preserve_location = TRUE  &
   location = -0.1, -2.8563064317E-07, -2.0E-03  &
   orientation = 8.1833300043E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_19  &
   adams_id = 19  &
   preserve_location = TRUE  &
   location = 0.1, 2.1461532551E-11, -2.0E-03  &
   orientation = 8.1833300043E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_20  &
   adams_id = 20  &
   preserve_location = TRUE  &
   location = 0.1618031272, 0.1902113916, -2.0E-03  &
   orientation = 8.1833300043E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_21  &
   adams_id = 21  &
   preserve_location = TRUE  &
   location = -4.3960285491E-07, 0.3077682109, -2.0E-03  &
   orientation = 8.1833300043E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_22  &
   adams_id = 22  &
   preserve_location = TRUE  &
   location = -0.1618036706, 0.1902109294, -2.0E-03  &
   orientation = 8.1833300043E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.original_rigid_cm  &
   adams_id = 51  &
   preserve_location = TRUE  &
   location = -1.9661266115E-07, 0.1376380492, -2.0E-03  &
   orientation = 270.0000818333d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_60  &
   adams_id = 60  &
   node_id = 2749  &
   orientation = 270.0000818333d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_61  &
   adams_id = 61  &
   node_id = 2751  &
   location = 8.0901499979E-02, 0.2489895, -4.0E-03  &
   orientation = 54.0000818333d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_358  &
   adams_id = 358  &
   node_id = 2751  &
   orientation = 54.0000818333d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_373  &
   adams_id = 373  &
   node_id = 2749  &
   orientation = 270.0000818333d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   color = GREEN  &
   name_visibility = off
!
!----------------------------- pentagon1_no_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   adams_id = 8  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.3549653367, 0.3710108214, 0.0  &
   orientation = 96.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   adams_id = 8
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon1_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.INT_NODE_2749  &
   adams_id = 662  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.INT_NODE_2751  &
   adams_id = 663  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_18  &
   adams_id = 82  &
   preserve_location = TRUE  &
   location = -0.1, -2.2769143515E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_19  &
   adams_id = 83  &
   preserve_location = TRUE  &
   location = 0.1, -2.2769096331E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_20  &
   adams_id = 84  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_21  &
   adams_id = 85  &
   preserve_location = TRUE  &
   location = -3.9423315058E-11, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_22  &
   adams_id = 86  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.original_rigid_cm  &
   adams_id = 87  &
   preserve_location = TRUE  &
   location = -3.942329909E-11, 0.137638192, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_60  &
   adams_id = 88  &
   preserve_location = TRUE  &
   location = -5.8580584827E-11, -6.579714551E-11, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_61  &
   adams_id = 89  &
   preserve_location = TRUE  &
   location = 8.0901699397E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_115  &
   adams_id = 115  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_117  &
   adams_id = 117  &
   node_id = 2751  &
   location = 8.0901500082E-02, 0.2489895, -4.0E-03  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_370  &
   adams_id = 370  &
   node_id = 2751  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_381  &
   adams_id = 381  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   color = GREEN  &
   name_visibility = off
!
!------------------------------ pentagon1_s_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   adams_id = 9  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.1499998354, -0.2598081995, 0.0  &
   orientation = 240.0000554891, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   adams_id = 9
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon1_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.INT_NODE_2749  &
   adams_id = 687  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.INT_NODE_2751  &
   adams_id = 688  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_1  &
   adams_id = 139  &
   preserve_location = TRUE  &
   location = -0.1000005831, -4.9748345093E-08, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_2  &
   adams_id = 140  &
   preserve_location = TRUE  &
   location = 0.0999994169, -2.4344184403E-07, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_3  &
   adams_id = 141  &
   preserve_location = TRUE  &
   location = 0.161803, 0.190211, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_4  &
   adams_id = 142  &
   preserve_location = TRUE  &
   location = -2.8503320074E-07, 0.3077682071, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_5  &
   adams_id = 143  &
   preserve_location = TRUE  &
   location = -0.1618037978, 0.1902113134, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.cm_primo  &
   adams_id = 144  &
   preserve_location = TRUE  &
   location = -4.4979873221E-07, 0.1376380454, -2.0E-03  &
   orientation = 179.9999445109d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_13  &
   adams_id = 145  &
   preserve_location = TRUE  &
   location = -4.4979873221E-07, 0.1376380454, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_14  &
   adams_id = 146  &
   preserve_location = TRUE  &
   location = 8.090135748E-02, 0.2489896036, -2.0E-03  &
   orientation = 53.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_114  &
   adams_id = 147  &
   preserve_location = TRUE  &
   location = -8.0902041388E-02, 0.2489897603, -2.0E-03  &
   orientation = 125.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_175  &
   adams_id = 175  &
   node_id = 2749  &
   orientation = 89.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_178  &
   adams_id = 178  &
   node_id = 2751  &
   location = 8.0901499958E-02, 0.2489895, -4.0E-03  &
   orientation = 233.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.original_rigid_cm  &
   adams_id = 331  &
   preserve_location = TRUE  &
   location = -4.4979873217E-07, 0.1376380455, -2.0E-03  &
   orientation = 269.9999445109d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_387  &
   adams_id = 387  &
   node_id = 2749  &
   orientation = 89.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_390  &
   adams_id = 390  &
   node_id = 2751  &
   orientation = 233.9999445109d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   color = GREEN  &
   name_visibility = off
!
!------------------------------ pentagon1_e_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   adams_id = 10  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.4243459797, 0.1574791589, 0.0  &
   orientation = 312.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   adams_id = 10
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon1_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.INT_NODE_2749  &
   adams_id = 711  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.INT_NODE_2751  &
   adams_id = 712  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_1  &
   adams_id = 204  &
   preserve_location = TRUE  &
   location = -0.1, 2.6842583711E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_2  &
   adams_id = 205  &
   preserve_location = TRUE  &
   location = 0.1, 2.6842583711E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_3  &
   adams_id = 206  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_4  &
   adams_id = 207  &
   preserve_location = TRUE  &
   location = 2.3818641504E-11, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_5  &
   adams_id = 208  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.cm_primo  &
   adams_id = 209  &
   preserve_location = TRUE  &
   location = 2.3818641504E-11, 0.137638192, -2.0E-03  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_13  &
   adams_id = 210  &
   preserve_location = TRUE  &
   location = 2.3818641504E-11, 0.137638192, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_14  &
   adams_id = 211  &
   preserve_location = TRUE  &
   location = 8.0901699461E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_114  &
   adams_id = 212  &
   preserve_location = TRUE  &
   location = -8.0901699406E-02, 0.2489898285, -2.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_172  &
   adams_id = 213  &
   preserve_location = TRUE  &
   location = 2.3818641504E-11, 2.6842583711E-11, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_248  &
   adams_id = 248  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_251  &
   adams_id = 251  &
   node_id = 2751  &
   location = 8.0901500028E-02, 0.2489895, -4.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.original_rigid_cm  &
   adams_id = 333  &
   preserve_location = TRUE  &
   location = 2.3818660186E-11, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_399  &
   adams_id = 399  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_402  &
   adams_id = 402  &
   node_id = 2751  &
   orientation = 54.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   color = GREEN  &
   name_visibility = off
!
!----------------------------- pentagon1_so_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   adams_id = 11  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.3316412465, -0.12783808, 0.0  &
   orientation = 168.0000554891, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   adams_id = 11
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon1_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.INT_NODE_2749  &
   adams_id = 734  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.INT_NODE_2751  &
   adams_id = 735  &
   node_id = 2751  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_1  &
   adams_id = 276  &
   preserve_location = TRUE  &
   location = -0.1000002981, -2.5689906382E-07, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_2  &
   adams_id = 277  &
   preserve_location = TRUE  &
   location = 0.0999997019, -4.5059256275E-07, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_3  &
   adams_id = 278  &
   preserve_location = TRUE  &
   location = 0.1618032851, 0.1902107929, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_4  &
   adams_id = 279  &
   preserve_location = TRUE  &
   location = 0.0, 0.307768, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_5  &
   adams_id = 280  &
   preserve_location = TRUE  &
   location = -0.1618035127, 0.1902111063, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.cm_primo  &
   adams_id = 281  &
   preserve_location = TRUE  &
   location = -1.6475784327E-07, 0.1376378383, -2.0E-03  &
   orientation = 179.9999445109d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_13  &
   adams_id = 282  &
   preserve_location = TRUE  &
   location = -1.6475784327E-07, 0.1376378383, -2.0E-03  &
   orientation = 359.9999445109d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_14  &
   adams_id = 283  &
   preserve_location = TRUE  &
   location = 8.0901642521E-02, 0.2489893964, -2.0E-03  &
   orientation = 53.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_114  &
   adams_id = 284  &
   preserve_location = TRUE  &
   location = -8.0901756347E-02, 0.2489895531, -2.0E-03  &
   orientation = 125.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_172  &
   adams_id = 285  &
   preserve_location = TRUE  &
   location = -2.9805595825E-07, -3.5374581328E-07, -2.0E-03  &
   orientation = 89.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_244  &
   adams_id = 286  &
   preserve_location = TRUE  &
   location = 0.1309014935, 9.510517111E-02, -2.0E-03  &
   orientation = 341.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_323  &
   adams_id = 323  &
   node_id = 2749  &
   orientation = 269.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_324  &
   adams_id = 324  &
   node_id = 2751  &
   location = 8.0901500028E-02, 0.2489895, -4.0E-03  &
   orientation = 233.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.original_rigid_cm  &
   adams_id = 335  &
   preserve_location = TRUE  &
   location = -1.6475784323E-07, 0.1376378383, -2.0E-03  &
   orientation = 269.9999445109d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_412  &
   adams_id = 412  &
   node_id = 2749  &
   orientation = 269.9999445109d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_413  &
   adams_id = 413  &
   node_id = 2751  &
   orientation = 233.9999445109d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   color = GREEN  &
   name_visibility = off
!
!-------------------------------- exagon2_flex --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   adams_id = 12  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.365418183, 0.4704630109, 4.0E-03  &
   orientation = 143.9999999822, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   adams_id = 12
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon2_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.INT_NODE_4141  &
   adams_id = 737  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_23  &
   adams_id = 23  &
   preserve_location = TRUE  &
   location = 0.2, 1.7038065403E-11, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_24  &
   adams_id = 24  &
   preserve_location = TRUE  &
   location = 0.0, 1.6928292101E-11, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_25  &
   adams_id = 25  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050807, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_26  &
   adams_id = 26  &
   preserve_location = TRUE  &
   location = -1.7774531846E-10, 0.3464101615, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_27  &
   adams_id = 27  &
   preserve_location = TRUE  &
   location = 0.1999999999, 0.3464101616, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_28  &
   adams_id = 28  &
   preserve_location = TRUE  &
   location = 0.2999999999, 0.1732050808, 2.0E-03  &
   orientation = 144.0000000178d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.original_rigid_cm  &
   adams_id = 52  &
   preserve_location = TRUE  &
   location = 0.0999999999, 0.1732050808, 2.0E-03  &
   orientation = 54.0000000178d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_58  &
   adams_id = 58  &
   node_id = 4141  &
   location = 0.0999957399, -1.068294378E-06, -2.0E-03  &
   orientation = 270.0000000178d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_355  &
   adams_id = 355  &
   node_id = 4141  &
   orientation = 270.0000000178d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   color = WHITE  &
   name_visibility = off
!
!------------------------------ exagon2_no_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   adams_id = 13  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.2036147842, 0.5880200613, 4.0E-03  &
   orientation = 215.9999999946, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   adams_id = 13
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon2_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.INT_NODE_4141  &
   adams_id = 739  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_76  &
   adams_id = 76  &
   preserve_location = TRUE  &
   location = 0.2, -2.0717538796E-11, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_77  &
   adams_id = 77  &
   preserve_location = TRUE  &
   location = -1.1186995774E-11, -2.0689561175E-11, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_78  &
   adams_id = 78  &
   preserve_location = TRUE  &
   location = -0.1000000001, 0.1732050807, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_79  &
   adams_id = 79  &
   preserve_location = TRUE  &
   location = -3.5888930716E-11, 0.3464101615, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_80  &
   adams_id = 80  &
   preserve_location = TRUE  &
   location = 0.1999999999, 0.3464101615, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_81  &
   adams_id = 81  &
   preserve_location = TRUE  &
   location = 0.2999999999, 0.1732050808, 2.0E-03  &
   orientation = 216.0000000054d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.original_rigid_cm  &
   adams_id = 125  &
   preserve_location = TRUE  &
   location = 0.0999999999, 0.1732050807, 2.0E-03  &
   orientation = 216.0000000054d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_121  &
   adams_id = 121  &
   node_id = 4141  &
   location = 0.0999999998, 1.6142411874E-07, -2.0E-03  &
   orientation = 270.0000000054d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_367  &
   adams_id = 367  &
   node_id = 4141  &
   orientation = 270.0000000054d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   color = WHITE  &
   name_visibility = off
!
!------------------------------- exagon2_s_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   adams_id = 14  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.1, -0.346407702, 4.0E-03  &
   orientation = 359.9992953915, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   adams_id = 14
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon2_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.INT_NODE_4141  &
   adams_id = 741  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_126  &
   adams_id = 132  &
   preserve_location = TRUE  &
   location = 1.5123416408E-11, -2.4595476528E-06, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_127  &
   adams_id = 133  &
   preserve_location = TRUE  &
   location = 0.2, 0.0, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_128  &
   adams_id = 134  &
   preserve_location = TRUE  &
   location = 0.29999787, 0.1732063106, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_129  &
   adams_id = 135  &
   preserve_location = TRUE  &
   location = 0.1999957399, 0.3464101615, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_130  &
   adams_id = 136  &
   preserve_location = TRUE  &
   location = -4.2600463747E-06, 0.3464077019, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_131  &
   adams_id = 137  &
   preserve_location = TRUE  &
   location = -0.10000213, 0.1732013915, 2.0E-03  &
   orientation = 7.0460850011E-04d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.original_rigid_cm  &
   adams_id = 138  &
   preserve_location = TRUE  &
   location = 0.09999787, 0.173203851, 2.0E-03  &
   orientation = 270.0007046085d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_173  &
   adams_id = 173  &
   node_id = 4141  &
   location = 0.1, -1.0682738265E-06, -2.0E-03  &
   orientation = 90.0007046085d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_385  &
   adams_id = 385  &
   node_id = 4141  &
   orientation = 90.0007046085d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   color = WHITE  &
   name_visibility = off
!
!------------------------------- exagon2_e_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   adams_id = 15  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.4294556414, -0.1070466269, 4.0E-03  &
   orientation = 72.0007046085, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   adams_id = 15
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon2_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.INT_NODE_4141  &
   adams_id = 743  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_126  &
   adams_id = 194  &
   preserve_location = TRUE  &
   location = -3.775484092E-11, 2.7157365245E-11, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_127  &
   adams_id = 195  &
   preserve_location = TRUE  &
   location = 0.1999999999, -2.4595204949E-06, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_128  &
   adams_id = 196  &
   preserve_location = TRUE  &
   location = 0.30000213, 0.1732013915, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_129  &
   adams_id = 197  &
   preserve_location = TRUE  &
   location = 0.20000426, 0.346407702, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_130  &
   adams_id = 198  &
   preserve_location = TRUE  &
   location = 4.2600237424E-06, 0.3464101615, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_131  &
   adams_id = 199  &
   preserve_location = TRUE  &
   location = -0.09999787, 0.1732063106, 2.0E-03  &
   orientation = 359.9992953915d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.original_rigid_cm  &
   adams_id = 200  &
   preserve_location = TRUE  &
   location = 0.10000213, 0.173203851, 2.0E-03  &
   orientation = 269.9992953915d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_171  &
   adams_id = 201  &
   preserve_location = TRUE  &
   location = 0.1, -1.2297466688E-06, 2.0E-03  &
   orientation = 89.9992953915d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_174  &
   adams_id = 202  &
   preserve_location = TRUE  &
   location = 0.10000426, 0.3464089317, 2.0E-03  &
   orientation = 89.9992953915d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_176  &
   adams_id = 203  &
   preserve_location = TRUE  &
   location = 0.250003195, 0.2598045468, 2.0E-03  &
   orientation = 209.9992953915d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_246  &
   adams_id = 246  &
   node_id = 4141  &
   location = 0.1, -1.0683250226E-06, -2.0E-03  &
   orientation = 269.9992953915d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_397  &
   adams_id = 397  &
   node_id = 4141  &
   orientation = 269.9992953915d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   color = WHITE  &
   name_visibility = off
!
!------------------------------ exagon2_so_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   adams_id = 16  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_2_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.4912590402, 8.3164676332E-02, 4.0E-03  &
   orientation = 288.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   adams_id = 16
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon2_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.INT_NODE_4141  &
   adams_id = 745  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_126  &
   adams_id = 266  &
   preserve_location = TRUE  &
   location = -1.1125600441E-11, -3.5809355481E-11, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_127  &
   adams_id = 267  &
   preserve_location = TRUE  &
   location = 0.2, -3.5809355481E-11, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_128  &
   adams_id = 268  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_129  &
   adams_id = 269  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_130  &
   adams_id = 270  &
   preserve_location = TRUE  &
   location = -1.1125600441E-11, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_131  &
   adams_id = 271  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.original_rigid_cm  &
   adams_id = 272  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050807, 2.0E-03  &
   orientation = 270.0d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_171  &
   adams_id = 273  &
   preserve_location = TRUE  &
   location = 0.1, -3.5809355481E-11, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_174  &
   adams_id = 274  &
   preserve_location = TRUE  &
   location = 0.1, 0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_176  &
   adams_id = 275  &
   preserve_location = TRUE  &
   location = 0.25, 0.2598076212, 2.0E-03  &
   orientation = 210.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_321  &
   adams_id = 321  &
   node_id = 4141  &
   location = 0.1000022, 2.5402593116E-06, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_410  &
   adams_id = 410  &
   node_id = 4141  &
   orientation = 90.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   color = WHITE  &
   name_visibility = off
!
!-------------------------------- exagon3_flex --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   adams_id = 17  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -1.292094E-02, 0.8285043728, -8.0E-03  &
   orientation = 348.0007046198, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   adams_id = 17
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon3_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.INT_NODE_4141  &
   adams_id = 747  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.INT_NODE_4143  &
   adams_id = 748  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.INT_NODE_4144  &
   adams_id = 749  &
   node_id = 4144  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_29  &
   adams_id = 29  &
   preserve_location = TRUE  &
   location = 3.6328828834E-11, -2.4595910586E-06, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_30  &
   adams_id = 30  &
   preserve_location = TRUE  &
   location = 0.2, -4.1850634069E-11, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_31  &
   adams_id = 31  &
   preserve_location = TRUE  &
   location = 0.29999787, 0.1732063105, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_32  &
   adams_id = 32  &
   preserve_location = TRUE  &
   location = 0.1999957399, 0.3464101616, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_33  &
   adams_id = 33  &
   preserve_location = TRUE  &
   location = -4.2413612239E-06, 0.3464077058, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_34  &
   adams_id = 34  &
   preserve_location = TRUE  &
   location = -0.10000213, 0.1732013914, -2.0E-03  &
   orientation = 12.0007046198d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.original_rigid_cm  &
   adams_id = 53  &
   preserve_location = TRUE  &
   location = 0.0999978717, 0.17320385, -2.0E-03  &
   orientation = 326.3862815079d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_62  &
   adams_id = 62  &
   node_id = 4141  &
   location = 0.1000003034, -1.0778894808E-06, -4.0E-03  &
   orientation = 90.0007046198d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_63  &
   adams_id = 63  &
   node_id = 4144  &
   location = 0.1, 0.34641, 3.0E-03  &
   orientation = 90.0007046198d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_65  &
   adams_id = 65  &
   node_id = 4143  &
   location = -5.000000003E-02, 0.2598100001, -3.0E-03  &
   orientation = 330.0007046198d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_357  &
   adams_id = 357  &
   node_id = 4141  &
   orientation = 90.0007046198d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_360  &
   adams_id = 360  &
   node_id = 4143  &
   orientation = 330.0007046198d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_366  &
   adams_id = 366  &
   node_id = 4144  &
   orientation = 90.0007046198d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   color = MAIZE  &
   name_visibility = off
!
!------------------------------ exagon3_no_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   adams_id = 18  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.6610477032, 0.3388402683, -8.0E-03  &
   orientation = 59.9992954108, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   adams_id = 18
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon3_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.INT_NODE_4141  &
   adams_id = 751  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.INT_NODE_4143  &
   adams_id = 752  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.INT_NODE_4144  &
   adams_id = 753  &
   node_id = 4144  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_76  &
   adams_id = 91  &
   preserve_location = TRUE  &
   location = 1.0893730362E-11, 2.8852142897E-11, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_77  &
   adams_id = 92  &
   preserve_location = TRUE  &
   location = 0.2, -2.4594325535E-06, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_78  &
   adams_id = 93  &
   preserve_location = TRUE  &
   location = 0.3000021301, 0.1732013916, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_79  &
   adams_id = 94  &
   preserve_location = TRUE  &
   location = 0.20000426, 0.3464077021, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_80  &
   adams_id = 95  &
   preserve_location = TRUE  &
   location = 4.2600286583E-06, 0.3464101615, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_81  &
   adams_id = 96  &
   preserve_location = TRUE  &
   location = -0.0999978699, 0.1732063106, -2.0E-03  &
   orientation = 323.9992954108d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.original_rigid_cm  &
   adams_id = 97  &
   preserve_location = TRUE  &
   location = 0.10000213, 0.173203851, -2.0E-03  &
   orientation = 143.9992954108d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_118  &
   adams_id = 118  &
   node_id = 4141  &
   location = 0.1, 1.6135537351E-11, -4.0E-03  &
   orientation = 269.9992954108d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_120  &
   adams_id = 120  &
   node_id = 4143  &
   location = -4.9999999993E-02, 0.25981, -3.0E-03  &
   orientation = 329.9992954108d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_124  &
   adams_id = 124  &
   node_id = 4144  &
   location = 0.1, 0.34641, 3.0E-03  &
   orientation = 269.9992954108d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_369  &
   adams_id = 369  &
   node_id = 4141  &
   orientation = 269.9992954108d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_376  &
   adams_id = 376  &
   node_id = 4144  &
   orientation = 269.9992954108d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_378  &
   adams_id = 378  &
   node_id = 4143  &
   orientation = 329.9992954108d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   color = MAIZE  &
   name_visibility = off
!
!------------------------------- exagon3_s_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   adams_id = 19  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.416534687, -0.4136960264, -8.0E-03  &
   orientation = 203.9992722273, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   adams_id = 19
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon3_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.INT_NODE_4141  &
   adams_id = 755  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.INT_NODE_4143  &
   adams_id = 756  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.INT_NODE_4144  &
   adams_id = 757  &
   node_id = 4144  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_126  &
   adams_id = 148  &
   preserve_location = TRUE  &
   location = 0.1999977999, 1.1086237593E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_127  &
   adams_id = 149  &
   preserve_location = TRUE  &
   location = -2.2000727886E-06, 3.6490297237E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_128  &
   adams_id = 150  &
   preserve_location = TRUE  &
   location = -0.1, 0.17321, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_129  &
   adams_id = 151  &
   preserve_location = TRUE  &
   location = 2.2000394134E-06, 0.3464138105, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_130  &
   adams_id = 152  &
   preserve_location = TRUE  &
   location = 0.2000022, 0.3464112701, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_131  &
   adams_id = 153  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732049192, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.original_rigid_cm  &
   adams_id = 154  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732074596, -2.0E-03  &
   orientation = 89.9992722273d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_177  &
   adams_id = 177  &
   node_id = 4141  &
   location = 0.1, 2.3098190027E-11, -4.0E-03  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_180  &
   adams_id = 180  &
   node_id = 4144  &
   location = 0.1, 0.34641, 3.0E-03  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_182  &
   adams_id = 182  &
   node_id = 4143  &
   location = -5.0000000038E-02, 0.25981, -3.0E-03  &
   orientation = 149.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_389  &
   adams_id = 389  &
   node_id = 4141  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_392  &
   adams_id = 392  &
   node_id = 4144  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_394  &
   adams_id = 394  &
   node_id = 4143  &
   orientation = 149.9992722273d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   color = MAIZE  &
   name_visibility = off
!
!------------------------------- exagon3_e_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   adams_id = 20  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.6530662981, 0.3634145774, -8.0E-03  &
   orientation = 275.9992722273, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   adams_id = 20
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon3_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.INT_NODE_4141  &
   adams_id = 759  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.INT_NODE_4143  &
   adams_id = 760  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.INT_NODE_4144  &
   adams_id = 761  &
   node_id = 4144  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_126  &
   adams_id = 214  &
   preserve_location = TRUE  &
   location = 0.1999977999, 1.1085982351E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_127  &
   adams_id = 215  &
   preserve_location = TRUE  &
   location = -2.2001111975E-06, 3.6490041995E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_128  &
   adams_id = 216  &
   preserve_location = TRUE  &
   location = -0.1, 0.17321, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_129  &
   adams_id = 217  &
   preserve_location = TRUE  &
   location = 2.2000010045E-06, 0.3464138105, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_130  &
   adams_id = 218  &
   preserve_location = TRUE  &
   location = 0.2000022, 0.3464112701, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_131  &
   adams_id = 219  &
   preserve_location = TRUE  &
   location = 0.2999999999, 0.1732049192, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.original_rigid_cm  &
   adams_id = 220  &
   preserve_location = TRUE  &
   location = 0.0999999999, 0.1732074595, -2.0E-03  &
   orientation = 89.9992722273d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_171  &
   adams_id = 221  &
   preserve_location = TRUE  &
   location = 0.0999977999, 2.3788012173E-06, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_174  &
   adams_id = 222  &
   preserve_location = TRUE  &
   location = 0.1000022, 0.3464125403, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_176  &
   adams_id = 223  &
   preserve_location = TRUE  &
   location = -4.9998900023E-02, 0.2598119053, -2.0E-03  &
   orientation = 149.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_250  &
   adams_id = 250  &
   node_id = 4141  &
   location = 0.1, 1.5204171255E-11, -4.0E-03  &
   orientation = 89.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_253  &
   adams_id = 253  &
   node_id = 4144  &
   location = 0.1, 0.34641, 3.0E-03  &
   orientation = 89.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_255  &
   adams_id = 255  &
   node_id = 4143  &
   location = -4.9999999952E-02, 0.25981, -3.0E-03  &
   orientation = 329.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_401  &
   adams_id = 401  &
   node_id = 4141  &
   orientation = 89.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_404  &
   adams_id = 404  &
   node_id = 4144  &
   orientation = 89.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_406  &
   adams_id = 406  &
   node_id = 4143  &
   orientation = 329.9992722273d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   color = MAIZE  &
   name_visibility = off
!
!------------------------------ exagon3_so_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   adams_id = 21  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/esagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.3956337041, -0.4288814794, -8.0E-03  &
   orientation = 131.9992722273, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   adams_id = 21
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26, 27, 28, 29, 30, 31
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon3_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.INT_NODE_4141  &
   adams_id = 763  &
   node_id = 4141  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.INT_NODE_4143  &
   adams_id = 764  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.INT_NODE_4144  &
   adams_id = 765  &
   node_id = 4144  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_126  &
   adams_id = 287  &
   preserve_location = TRUE  &
   location = 0.1999977999, 1.1086458232E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_127  &
   adams_id = 288  &
   preserve_location = TRUE  &
   location = -2.2000408056E-06, 3.6490517872E-06, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_128  &
   adams_id = 289  &
   preserve_location = TRUE  &
   location = -0.1, 0.17321, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_129  &
   adams_id = 290  &
   preserve_location = TRUE  &
   location = 2.2000713957E-06, 0.3464138105, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_130  &
   adams_id = 291  &
   preserve_location = TRUE  &
   location = 0.2000022001, 0.3464112701, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_131  &
   adams_id = 292  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732049192, -2.0E-03  &
   orientation = 179.9992722273d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.original_rigid_cm  &
   adams_id = 293  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732074596, -2.0E-03  &
   orientation = 89.9992722273d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_171  &
   adams_id = 294  &
   preserve_location = TRUE  &
   location = 0.0999978, 2.3788488052E-06, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_174  &
   adams_id = 295  &
   preserve_location = TRUE  &
   location = 0.1000022001, 0.3464125403, -2.0E-03  &
   orientation = 269.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_176  &
   adams_id = 296  &
   preserve_location = TRUE  &
   location = -4.9998899953E-02, 0.2598119053, -2.0E-03  &
   orientation = 149.9992722273d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325  &
   adams_id = 325  &
   node_id = 4141  &
   location = 0.0999999999, 1.2491452317E-11, -4.0E-03  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_326  &
   adams_id = 326  &
   node_id = 4144  &
   location = 0.0999999999, 0.34641, 3.0E-03  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_328  &
   adams_id = 328  &
   node_id = 4143  &
   location = -4.999999999E-02, 0.25981, -3.0E-03  &
   orientation = 329.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_414  &
   adams_id = 414  &
   node_id = 4141  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_415  &
   adams_id = 415  &
   node_id = 4144  &
   orientation = 269.9992722273d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_417  &
   adams_id = 417  &
   node_id = 4143  &
   orientation = 329.9992722273d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   color = MAIZE  &
   name_visibility = off
!
!------------------------------- pentagon3_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   adams_id = 22  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.1158447149, 0.5847722057, -4.0E-03  &
   orientation = 287.9999181699, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   adams_id = 22
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon3_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.INT_NODE_2749  &
   adams_id = 767  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_35  &
   adams_id = 35  &
   preserve_location = TRUE  &
   location = -0.1, -2.8564958474E-07, -2.0E-03  &
   orientation = 8.1830100029E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_36  &
   adams_id = 36  &
   preserve_location = TRUE  &
   location = 0.1, 0.0, -2.0E-03  &
   orientation = 8.1830100029E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_37  &
   adams_id = 37  &
   preserve_location = TRUE  &
   location = 0.1618031273, 0.1902113916, -2.0E-03  &
   orientation = 8.1830100029E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_38  &
   adams_id = 38  &
   preserve_location = TRUE  &
   location = -4.3952787509E-07, 0.3077682109, -2.0E-03  &
   orientation = 8.1830100029E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_39  &
   adams_id = 39  &
   preserve_location = TRUE  &
   location = -0.1618036705, 0.1902109294, -2.0E-03  &
   orientation = 8.1830100029E-05d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.original_rigid_cm  &
   adams_id = 54  &
   preserve_location = TRUE  &
   location = -1.9654718336E-07, 0.1376380492, -2.0E-03  &
   orientation = 270.0000818301d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_66  &
   adams_id = 66  &
   node_id = 2749  &
   location = -4.4068415583E-11, -1.7091536519E-11, -1.0E-03  &
   orientation = 270.0000818301d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_359  &
   adams_id = 359  &
   node_id = 2749  &
   orientation = 270.0000818301d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   color = CYAN  &
   name_visibility = off
!
!----------------------------- pentagon2_no_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   adams_id = 23  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.4610476918, 0.1656351943, -4.0E-03  &
   orientation = 0.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   adams_id = 23
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon2_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.INT_NODE_2749  &
   adams_id = 769  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_18  &
   adams_id = 105  &
   preserve_location = TRUE  &
   location = -0.1, 0.0, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_19  &
   adams_id = 106  &
   preserve_location = TRUE  &
   location = 0.1, 0.0, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_20  &
   adams_id = 107  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_21  &
   adams_id = 108  &
   preserve_location = TRUE  &
   location = 0.0, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_22  &
   adams_id = 109  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.original_rigid_cm  &
   adams_id = 110  &
   preserve_location = TRUE  &
   location = 0.0, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_60  &
   adams_id = 111  &
   preserve_location = TRUE  &
   location = -1.9157286868E-11, -4.3028025587E-11, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_61  &
   adams_id = 112  &
   preserve_location = TRUE  &
   location = 8.0901699436E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_119  &
   adams_id = 119  &
   node_id = 2749  &
   location = 0.0, 0.0, -1.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_377  &
   adams_id = 377  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   color = CYAN  &
   name_visibility = off
!
!------------------------------ pentagon2_s_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   adams_id = 24  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.356539206, -0.1560088937, -4.0E-03  &
   orientation = 144.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   adams_id = 24
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon2_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.INT_NODE_2749  &
   adams_id = 771  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_1  &
   adams_id = 162  &
   preserve_location = TRUE  &
   location = -0.1, 2.1838780784E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_2  &
   adams_id = 163  &
   preserve_location = TRUE  &
   location = 0.1, 2.1838780784E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_3  &
   adams_id = 164  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_4  &
   adams_id = 165  &
   preserve_location = TRUE  &
   location = 3.0479285762E-11, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_5  &
   adams_id = 166  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.cm_primo  &
   adams_id = 167  &
   preserve_location = TRUE  &
   location = 3.0479285762E-11, 0.137638192, -2.0E-03  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_13  &
   adams_id = 168  &
   preserve_location = TRUE  &
   location = 3.0479285762E-11, 0.137638192, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_14  &
   adams_id = 169  &
   preserve_location = TRUE  &
   location = 8.0901699468E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_114  &
   adams_id = 170  &
   preserve_location = TRUE  &
   location = -8.09016994E-02, 0.2489898285, -2.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_181  &
   adams_id = 181  &
   node_id = 2749  &
   location = 3.0333957568E-11, 2.2038870728E-11, -1.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.original_rigid_cm  &
   adams_id = 332  &
   preserve_location = TRUE  &
   location = 3.0479224488E-11, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_393  &
   adams_id = 393  &
   node_id = 2749  &
   orientation = 90.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   color = CYAN  &
   name_visibility = off
!
!------------------------------ pentagon2_e_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   adams_id = 25  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.3894516482, 0.3859851874, -4.0E-03  &
   orientation = 216.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   adams_id = 25
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon2_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.INT_NODE_2749  &
   adams_id = 773  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_1  &
   adams_id = 234  &
   preserve_location = TRUE  &
   location = -0.1, 0.0, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_2  &
   adams_id = 235  &
   preserve_location = TRUE  &
   location = 0.1, 0.0, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_3  &
   adams_id = 236  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_4  &
   adams_id = 237  &
   preserve_location = TRUE  &
   location = 4.7525094971E-11, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_5  &
   adams_id = 238  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.cm_primo  &
   adams_id = 239  &
   preserve_location = TRUE  &
   location = 4.7525094971E-11, 0.137638192, -2.0E-03  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_13  &
   adams_id = 240  &
   preserve_location = TRUE  &
   location = 4.7525094971E-11, 0.137638192, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_14  &
   adams_id = 241  &
   preserve_location = TRUE  &
   location = 8.0901699486E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_114  &
   adams_id = 242  &
   preserve_location = TRUE  &
   location = -8.0901699382E-02, 0.2489898285, -2.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_172  &
   adams_id = 243  &
   preserve_location = TRUE  &
   location = 4.7525094971E-11, 0.0, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_254  &
   adams_id = 254  &
   node_id = 2749  &
   location = 4.7525094971E-11, 0.0, -1.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.original_rigid_cm  &
   adams_id = 334  &
   preserve_location = TRUE  &
   location = 4.7525117973E-11, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_405  &
   adams_id = 405  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   color = CYAN  &
   name_visibility = off
!
!----------------------------- pentagon2_so_flex ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   adams_id = 26  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.1690983006, -0.292192683, -4.0E-03  &
   orientation = 72.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   adams_id = 26
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon2_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.INT_NODE_2749  &
   adams_id = 775  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_1  &
   adams_id = 307  &
   preserve_location = TRUE  &
   location = -0.1, 2.6538882203E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_2  &
   adams_id = 308  &
   preserve_location = TRUE  &
   location = 0.1, 2.6538882203E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_3  &
   adams_id = 309  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_4  &
   adams_id = 310  &
   preserve_location = TRUE  &
   location = -3.9657277462E-11, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_5  &
   adams_id = 311  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.cm_primo  &
   adams_id = 312  &
   preserve_location = TRUE  &
   location = -3.9657277462E-11, 0.137638192, -2.0E-03  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_13  &
   adams_id = 313  &
   preserve_location = TRUE  &
   location = -3.9657277462E-11, 0.137638192, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_14  &
   adams_id = 314  &
   preserve_location = TRUE  &
   location = 8.0901699397E-02, 0.2489898285, -2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_114  &
   adams_id = 315  &
   preserve_location = TRUE  &
   location = -8.090169947E-02, 0.2489898285, -2.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_172  &
   adams_id = 316  &
   preserve_location = TRUE  &
   location = -3.9657277462E-11, 2.6538882203E-11, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_244  &
   adams_id = 317  &
   preserve_location = TRUE  &
   location = 0.1309016994, 9.5105651657E-02, -2.0E-03  &
   orientation = 342.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_329  &
   adams_id = 329  &
   node_id = 2749  &
   location = -3.9657277462E-11, 2.6538882203E-11, -1.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.original_rigid_cm  &
   adams_id = 336  &
   preserve_location = TRUE  &
   location = -3.9657280642E-11, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_418  &
   adams_id = 418  &
   node_id = 2749  &
   orientation = 270.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   color = CYAN  &
   name_visibility = off
!
!-------------------------------- exagon4_flex --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   adams_id = 27  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/exagon4_0_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -8.49431319E-02, 0.4896665102, -1.2E-02  &
   orientation = 347.9999989054, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   adams_id = 27
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,  &
                    22, 23, 24, 25, 26
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon4_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.INT_NODE_4142  &
   adams_id = 777  &
   node_id = 4142  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.INT_NODE_4143  &
   adams_id = 778  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_40  &
   adams_id = 40  &
   preserve_location = TRUE  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_41  &
   adams_id = 41  &
   preserve_location = TRUE  &
   location = 0.1999999812, 0.0, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_42  &
   adams_id = 42  &
   preserve_location = TRUE  &
   location = 0.299999978, 0.1732050826, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_43  &
   adams_id = 43  &
   preserve_location = TRUE  &
   location = 0.1999999747, 0.3464101612, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_44  &
   adams_id = 44  &
   preserve_location = TRUE  &
   location = -6.7490070199E-09, 0.3464101621, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_45  &
   adams_id = 45  &
   preserve_location = TRUE  &
   location = -9.471588175E-02, 0.1743282534, -2.0E-03  &
   orientation = 12.0000010946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.original_rigid_cm  &
   adams_id = 55  &
   preserve_location = TRUE  &
   location = 0.1014658558, 0.1732645125, -2.0E-03  &
   orientation = 182.4738582784d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_64  &
   adams_id = 64  &
   node_id = 4143  &
   location = 0.1, -4.8488935089E-11, 1.0E-03  &
   orientation = 90.0000010946d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_67  &
   adams_id = 67  &
   node_id = 4142  &
   location = 0.1, 0.3464102, -2.0E-03  &
   orientation = 90.0000010946d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_365  &
   adams_id = 365  &
   node_id = 4143  &
   orientation = 90.0000010946d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_364  &
   adams_id = 364  &
   node_id = 4142  &
   orientation = 90.0000010946d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   color = YELLOW  &
   name_visibility = off
!
!------------------------------ exagon4_no_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   adams_id = 28  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/exagon_4_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.3610476862, 0.1656351875, -1.2E-02  &
   orientation = 60.0000000054, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   adams_id = 28
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon4_no_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.INT_NODE_4143  &
   adams_id = 779  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_76  &
   adams_id = 98  &
   preserve_location = TRUE  &
   location = 0.0, -4.6461612335E-11, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_77  &
   adams_id = 99  &
   preserve_location = TRUE  &
   location = 0.2000000001, -4.6433523693E-11, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_78  &
   adams_id = 100  &
   preserve_location = TRUE  &
   location = 0.3000000001, 0.1732050807, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_79  &
   adams_id = 101  &
   preserve_location = TRUE  &
   location = 0.2000000001, 0.3464101615, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_80  &
   adams_id = 102  &
   preserve_location = TRUE  &
   location = 1.1349605977E-10, 0.3464101614, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_81  &
   adams_id = 103  &
   preserve_location = TRUE  &
   location = -0.0999999999, 0.1732050808, -2.0E-03  &
   orientation = 323.9999999946d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.original_rigid_cm  &
   adams_id = 104  &
   preserve_location = TRUE  &
   location = 0.1000000001, 0.1732050807, -2.0E-03  &
   orientation = 143.9999999946d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_123  &
   adams_id = 123  &
   node_id = 4143  &
   location = 0.1, 0.0, 1.0E-03  &
   orientation = 269.9999999946d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_375  &
   adams_id = 375  &
   node_id = 4143  &
   orientation = 269.9999999946d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   color = YELLOW  &
   name_visibility = off
!
!------------------------------- exagon4_s_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   adams_id = 29  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/exagon_4_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 9.2928415036E-02, -0.1785776971, -1.2E-02  &
   orientation = 24.0, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   adams_id = 29
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon4_s_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.INT_NODE_4143  &
   adams_id = 780  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_126  &
   adams_id = 155  &
   preserve_location = TRUE  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_127  &
   adams_id = 156  &
   preserve_location = TRUE  &
   location = 0.2, 0.0, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_128  &
   adams_id = 157  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_129  &
   adams_id = 158  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_130  &
   adams_id = 159  &
   preserve_location = TRUE  &
   location = 0.0, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_131  &
   adams_id = 160  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.original_rigid_cm  &
   adams_id = 161  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050808, 2.0E-03  &
   orientation = 270.0d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_179  &
   adams_id = 179  &
   node_id = 4143  &
   location = 0.1, 0.0, -1.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_391  &
   adams_id = 391  &
   node_id = 4143  &
   orientation = 90.0d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   color = YELLOW  &
   name_visibility = off
!
!------------------------------- exagon4_e_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   adams_id = 30  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/exagon_4_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 0.3085499488, 0.3272066622, -1.2E-02  &
   orientation = 276.0, 0.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   adams_id = 30
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon4_e_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.INT_NODE_4143  &
   adams_id = 781  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_126  &
   adams_id = 224  &
   preserve_location = TRUE  &
   location = 0.2, 2.2769287844E-11, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_127  &
   adams_id = 225  &
   preserve_location = TRUE  &
   location = 3.9423339593E-11, 2.2769174046E-11, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_128  &
   adams_id = 226  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_129  &
   adams_id = 227  &
   preserve_location = TRUE  &
   location = 3.9423145304E-11, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_130  &
   adams_id = 228  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_131  &
   adams_id = 229  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, -2.0E-03  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.original_rigid_cm  &
   adams_id = 230  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050808, -2.0E-03  &
   orientation = 90.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_171  &
   adams_id = 231  &
   preserve_location = TRUE  &
   location = 0.1, 2.2769230945E-11, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_174  &
   adams_id = 232  &
   preserve_location = TRUE  &
   location = 0.1, 0.3464101615, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_176  &
   adams_id = 233  &
   preserve_location = TRUE  &
   location = -4.9999999961E-02, 0.2598076212, -2.0E-03  &
   orientation = 150.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_252  &
   adams_id = 252  &
   node_id = 4143  &
   location = 0.1, 2.3199941968E-11, 1.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_403  &
   adams_id = 403  &
   node_id = 4143  &
   orientation = 90.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   color = YELLOW  &
   name_visibility = off
!
!------------------------------ exagon4_so_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   adams_id = 31  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/esagono_flexible/exagon_4_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = -0.2720227224, -4.8458066252E-02, -1.2E-02  &
   orientation = 312.0, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   adams_id = 31
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.exagon4_so_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.INT_NODE_4143  &
   adams_id = 782  &
   node_id = 4143  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_126  &
   adams_id = 297  &
   preserve_location = TRUE  &
   location = -2.3818627626E-11, 2.6842639222E-11, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_127  &
   adams_id = 298  &
   preserve_location = TRUE  &
   location = 0.2, 2.6842639222E-11, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_128  &
   adams_id = 299  &
   preserve_location = TRUE  &
   location = 0.3, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_129  &
   adams_id = 300  &
   preserve_location = TRUE  &
   location = 0.2, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_130  &
   adams_id = 301  &
   preserve_location = TRUE  &
   location = -2.3818627626E-11, 0.3464101615, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_131  &
   adams_id = 302  &
   preserve_location = TRUE  &
   location = -0.1, 0.1732050808, 2.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.original_rigid_cm  &
   adams_id = 303  &
   preserve_location = TRUE  &
   location = 0.1, 0.1732050808, 2.0E-03  &
   orientation = 270.0d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_171  &
   adams_id = 304  &
   preserve_location = TRUE  &
   location = 0.1, 2.6842639222E-11, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_174  &
   adams_id = 305  &
   preserve_location = TRUE  &
   location = 0.1, 0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_176  &
   adams_id = 306  &
   preserve_location = TRUE  &
   location = 0.25, 0.2598076212, 2.0E-03  &
   orientation = 210.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_327  &
   adams_id = 327  &
   node_id = 4143  &
   location = 0.1, 2.6842639222E-11, -1.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_416  &
   adams_id = 416  &
   node_id = 4143  &
   orientation = 90.0d, 90.0d, 180.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   color = YELLOW  &
   name_visibility = off
!
!------------------------------- pentagon4_flex -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
part create flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   adams_id = 32  &
   modal_neutral_file_name =   &
                             "P:/Flexible_body/pentagono_flexible/pentagono_3_0.mnf"  &
   invariants = yes, yes, no, no, no, no, yes, no, no  &
   location = 8.4894350591E-02, 0.8077156102, -1.6E-02  &
   orientation = 348.0, 180.0, 0.0
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   adams_id = 32
!
part create flexible_body modal_ics  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   selected_modes = 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
!
part modify flexible_body deformed_mode_display  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   deformed_mode_number = 0  &
   display_only_deformed = yes
!
part modify flexible_body visual_representation  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   scale_factor = 1.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.pentagon4_flex
!
! ****** Markers for current flexible body ******
!
undo begin_block suppress = yes
!
! IMPORTANT: Flexible body marker creation is grouped
! inside the same undo block for greater efficiency
!
marker modify  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.INT_NODE_2749  &
   adams_id = 783  &
   node_id = 2749  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_46  &
   adams_id = 46  &
   preserve_location = TRUE  &
   location = -0.1, 1.7904899785E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_47  &
   adams_id = 47  &
   preserve_location = TRUE  &
   location = 0.1, 1.7904899785E-11, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_48  &
   adams_id = 48  &
   preserve_location = TRUE  &
   location = 0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_49  &
   adams_id = 49  &
   preserve_location = TRUE  &
   location = 0.0, 0.3077683537, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_50  &
   adams_id = 50  &
   preserve_location = TRUE  &
   location = -0.1618033989, 0.1902113033, -2.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.original_rigid_cm  &
   adams_id = 56  &
   preserve_location = TRUE  &
   location = 0.0, 0.1376381921, -2.0E-03  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_68  &
   adams_id = 68  &
   node_id = 2749  &
   location = 0.0, 1.7825851906E-11, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_363  &
   adams_id = 363  &
   node_id = 2749  &
   orientation = 90.0d, 90.0d, 0.0d
!
undo end_block
!
part attributes  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   color = DARK_GRAY  &
   name_visibility = off
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint fixed  &
   joint_name = .MODEL_309394_flexbody.JOINT_1  &
   adams_id = 1  &
   i_marker_name = .MODEL_309394_flexbody.ground.MARKER_12  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_13
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_1  &
   active = off  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1  &
   adams_id = 2  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_14  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_15
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1_e1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_e2  &
   adams_id = 3  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_57  &
   j_marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_58
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1_e2  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_p2  &
   adams_id = 4  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_59  &
   j_marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_60
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1_p2  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2_e3  &
   adams_id = 5  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_61  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_62
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p2_e3  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_e4  &
   adams_id = 6  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_63  &
   j_marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_64
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3_e4  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_p3  &
   adams_id = 7  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_65  &
   j_marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_66
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3_p3  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4_p4  &
   adams_id = 8  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_67  &
   j_marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_68
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e4_p4  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   adams_id = 9  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_113  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_114
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   adams_id = 10  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_115  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_116
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   adams_id = 11  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_117  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_118
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   adams_id = 12  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_119  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_120
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   adams_id = 13  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_121  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_122
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   adams_id = 14  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_123  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_124
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   adams_id = 15  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_171  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_172
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   adams_id = 16  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_173  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_174
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   adams_id = 17  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_175  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_176
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   adams_id = 18  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_177  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_178
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   adams_id = 19  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_179  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_180
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   adams_id = 20  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_181  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_182
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   adams_id = 21  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_244  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_245
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   adams_id = 22  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_246  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_247
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   adams_id = 23  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_248  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_249
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   adams_id = 24  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_250  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_251
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   adams_id = 25  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_252  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_253
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   adams_id = 26  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_254  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_255
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   adams_id = 27  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_318  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_319
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   adams_id = 28  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_320  &
   j_marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_321
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   adams_id = 29  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_322  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_323
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   adams_id = 30  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_324  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   adams_id = 31  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_326  &
   j_marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_327
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   adams_id = 32  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_328  &
   j_marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_329
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_32_e1_e2  &
   adams_id = 32  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_e2  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_32_e1_e2  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_2_p1_e1  &
   adams_id = 2  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_2_p1_e1  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_3_e1_p2  &
   adams_id = 3  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_p2  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_3_e1_p2  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_4_p2_e3  &
   adams_id = 4  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2_e3  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_4_p2_e3  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_5_e3_e4  &
   adams_id = 5  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_e4  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_5_e3_e4  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_6_e3_p3  &
   adams_id = 6  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_p3  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_6_e3_p3  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_7_e4_p4  &
   adams_id = 7  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4_p4  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_7_e4_p4  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_8_e1no_p1  &
   adams_id = 8  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_8_e1no_p1  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_9_p1no_e1no  &
   adams_id = 9  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_9_p1no_e1no  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_10_p1no_e3no  &
   adams_id = 10  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_10_p1no_e3no  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_11_p2no_e3no  &
   adams_id = 11  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_11_p2no_e3no  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_12_e2no_e1no  &
   adams_id = 12  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_12_e2no_e1no  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_13_e4no_e3no  &
   adams_id = 13  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_13_e4no_e3no  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_14_e1s_p1  &
   adams_id = 14  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_14_e1s_p1  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_15_e2s_e1s  &
   adams_id = 15  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_15_e2s_e1s  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_16_p1s_e1s  &
   adams_id = 16  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_16_p1s_e1s  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_17_e3s_p1s  &
   adams_id = 17  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_17_e3s_p1s  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_18_e4s_e3s  &
   adams_id = 18  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_18_e4s_e3s  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_19_p2s_e3s  &
   adams_id = 19  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_19_p2s_e3s  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_20_p1_e1e  &
   adams_id = 20  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_20_p1_e1e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_21_e2e_e1e  &
   adams_id = 21  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_21_e2e_e1e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_22_p1e_e1e  &
   adams_id = 22  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_22_p1e_e1e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_23_e3e_p1e  &
   adams_id = 23  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_23_e3e_p1e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_24_e4e_e3e  &
   adams_id = 24  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_24_e4e_e3e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_25_p2e_e3e  &
   adams_id = 25  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_25_p2e_e3e  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_26_p1_e1so  &
   adams_id = 26  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_26_p1_e1so  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_27_e1so_e2so  &
   adams_id = 27  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_27_e1so_e2so  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_28_e1so_p1so  &
   adams_id = 28  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_28_e1so_p1so  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_29_p1so_e3so  &
   adams_id = 29  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_29_p1so_e3so  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_30_e3so_e4so  &
   adams_id = 30  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_30_e3so_e4so  &
   active = off  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_31_e3so_p2so  &
   adams_id = 31  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_flexbody.FRICTION_31_e3so_p2so  &
   active = off  &
   visibility = off
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_z  &
   adams_id = 1  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_343  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_344  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_y  &
   adams_id = 2  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_345  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_346  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_x  &
   adams_id = 3  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_347  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_348  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1_e2  &
   adams_id = 4  &
   comments = "CORREGGERE CATTURA"  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_355  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_356  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2_e3  &
   adams_id = 5  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_357  &
   j_marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_358  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3_p3  &
   adams_id = 6  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_359  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_360  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3_e4  &
   adams_id = 9  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_365  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_366  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4_p4  &
   adams_id = 8  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_363  &
   j_marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_364  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2no_e1no  &
   adams_id = 10  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_no_flex.MARKER_367  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_368  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1no_e3no  &
   adams_id = 11  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_369  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_370  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1  &
   adams_id = 12  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_371  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_372  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1_p2  &
   adams_id = 13  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_373  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_374  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4no_e3no  &
   adams_id = 14  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_375  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_376  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2no_e3no  &
   adams_id = 15  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_377  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_378  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1no_p1  &
   adams_id = 16  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_379  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_380  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1no_e1no  &
   adams_id = 17  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_381  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_382  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1s_p1  &
   adams_id = 18  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_383  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_384  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2s_e1s  &
   adams_id = 19  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_385  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_386  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1s_e1s  &
   adams_id = 20  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_387  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_388  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3s_p1s  &
   adams_id = 21  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_389  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_390  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4s_e3s  &
   adams_id = 22  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_391  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_392  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2s_e3s  &
   adams_id = 23  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_393  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_394  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1e  &
   adams_id = 24  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_395  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_396  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2e_e1e  &
   adams_id = 25  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_397  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_398  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1e_e1e  &
   adams_id = 26  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_399  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_400  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3e_p1e  &
   adams_id = 27  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_401  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_402  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4e_e3e  &
   adams_id = 28  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_403  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_404  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2e_e3e  &
   adams_id = 29  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_405  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_406  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1so  &
   adams_id = 30  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_407  &
   j_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_408  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1so_e2so  &
   adams_id = 31  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_409  &
   j_marker_name = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_410  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1so_p1so  &
   adams_id = 32  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_411  &
   j_marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_412  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1so_e3so  &
   adams_id = 33  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_413  &
   j_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_414  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3so_e4so  &
   adams_id = 34  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_415  &
   j_marker_name = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_416  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3so_p2so  &
   adams_id = 35  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_417  &
   j_marker_name = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_418  &
   action_only = off  &
   function = ""
!
force create direct torque_vector  &
   torque_vector_name = .MODEL_309394_flexbody.VTORQUE_1  &
   adams_id = 1  &
   i_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_350  &
   j_floating_marker_name = .MODEL_309394_flexbody.ground.FMARKER_352  &
   ref_marker_name = .MODEL_309394_flexbody.ground.MARKER_351  &
   x_torque_function = ""  &
   y_torque_function = ""  &
   z_torque_function = ""
!
!---------------------------------- Sensors -----------------------------------!
!
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_z  &
   adams_id = 1  &
   compare = le  &
   value = 0.7  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_avv  &
   adams_id = 2  &
   compare = le  &
   value = 10.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp1  &
   adams_id = 3  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp2  &
   adams_id = 4  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_x_rel  &
   adams_id = 5  &
   compare = le  &
   value = 0.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_y_rel  &
   adams_id = 6  &
   compare = ge  &
   value = 0.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_z_rel  &
   adams_id = 7  &
   compare = le  &
   value = 2.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt1  &
   adams_id = 8  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt2  &
   adams_id = 9  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_e4  &
   adams_id = 10  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4no_e3no  &
   adams_id = 11  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4s_e3s  &
   adams_id = 12  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4e_e3e  &
   adams_id = 13  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_e4so  &
   adams_id = 14  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_p3  &
   adams_id = 15  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2no_e3no  &
   adams_id = 16  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2s_e3s  &
   adams_id = 17  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2e_e3e  &
   adams_id = 18  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_p2so  &
   adams_id = 19  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4_p4  &
   adams_id = 20  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1_e2_c  &
   adams_id = 21  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2no_e1no_c  &
   adams_id = 22  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2s_e1s_c  &
   adams_id = 23  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2e_e1e_c  &
   adams_id = 24  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1so_e2so_c  &
   adams_id = 25  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2_e3_c  &
   adams_id = 26  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1no_e3no_c  &
   adams_id = 27  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3s_p1s_c  &
   adams_id = 28  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3e_p1e_c  &
   adams_id = 29  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1so_e3so_c  &
   adams_id = 30  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp0  &
   adams_id = 31  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp3  &
   adams_id = 32  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt0  &
   adams_id = 33  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1_p2_c  &
   adams_id = 34  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1no_e1no_c  &
   adams_id = 35  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1s_e1s_c  &
   adams_id = 36  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1e_e1e_c  &
   adams_id = 37  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1so_p1so_c  &
   adams_id = 38  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_e4_c  &
   adams_id = 39  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4no_e3no_c  &
   adams_id = 40  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4s_e3s_c  &
   adams_id = 41  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4e_e3e_c  &
   adams_id = 42  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_e4so_c  &
   adams_id = 43  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_p3_c  &
   adams_id = 44  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2no_e3no_c  &
   adams_id = 45  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2s_e3s_c  &
   adams_id = 46  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2e_e3e_c  &
   adams_id = 47  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_p2so_c  &
   adams_id = 48  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt2_1  &
   adams_id = 49  &
   compare = ge  &
   value = 138.19  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt3  &
   adams_id = 50  &
   compare = ge  &
   value = 41.81  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4_p4_c  &
   adams_id = 51  &
   compare = ge  &
   value = 41.81  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt4  &
   adams_id = 52  &
   compare = ge  &
   value = 217.4  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
!----------------------------- Simulation Scripts -----------------------------!
!
!
simulation script create  &
   sim_script_name = .MODEL_309394_flexbody.Last_Sim  &
   commands =   &
              "simulation single_run scripted sim_script_name=.MODEL_309394_flexbody.SIM_SCRIPT_1 reset_before_and_after=yes model_name=.MODEL_309394_flexbody"
!
simulation script create  &
   sim_script_name = .MODEL_309394_flexbody.SIM_SCRIPT_1  &
   solver_commands = "! Insert ACF commands here:",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=6",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=5",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=2",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=31",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=3,10,11,12,13,14,15,16,17,18,19",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=4,20",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=32",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=7",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=1",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=33,34,35,36,37,38",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=21,22,23,24,25",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=8,26,27,28,29,30",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=9,39,40,41,42,43,44,45,46,47,48",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=49",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=50,51",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=52",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02"
!
!------------------------------ Dynamic Graphics ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_flexbody.ground
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.JOINT_30_force_graphic_1  &
   adams_id = 1  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_324
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.JOINT_30_force_graphic_2  &
   adams_id = 2  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_z_force_graphic_1  &
   adams_id = 72  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_z  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_343
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.VTORQUE_1_force_graphic_1  &
   adams_id = 71  &
   force_element_name = .MODEL_309394_flexbody.VTORQUE_1  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_350
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_4_force_graphic_1  &
   adams_id = 73  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1_e2  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon2_flex.MARKER_355
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_5_force_graphic_1  &
   adams_id = 74  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p2_e3  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon3_flex.MARKER_357
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_6_force_graphic_1  &
   adams_id = 75  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3_p3  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon3_flex.MARKER_359
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_9_force_graphic_1  &
   adams_id = 78  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3_e4  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon4_flex.MARKER_365
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_7_force_graphic_2  &
   adams_id = 77  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e4_p4  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon4_flex.MARKER_363
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_10_force_graphic_1  &
   adams_id = 79  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e2no_e1no  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon2_no_flex.MARKER_367
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_11_force_graphic_1  &
   adams_id = 80  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1no_e3no  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon3_no_flex.MARKER_369
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_12_force_graphic_1  &
   adams_id = 81  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon1_flex.MARKER_371
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_12_force_graphic_2  &
   adams_id = 82  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1_p2  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon2_flex.MARKER_373
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_14_force_graphic_1  &
   adams_id = 83  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e4no_e3no  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon4_no_flex.MARKER_375
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_15_force_graphic_1  &
   adams_id = 84  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p2no_e3no  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon2_no_flex.MARKER_377
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_16_force_graphic_1  &
   adams_id = 85  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1no_p1  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon1_no_flex.MARKER_379
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_16_force_graphic_2  &
   adams_id = 86  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1no_e1no  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_381
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_1  &
   adams_id = 87  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1s_p1  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_383
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_2  &
   adams_id = 88  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e2s_e1s  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon2_s_flex.MARKER_385
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_3  &
   adams_id = 89  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1s_e1s  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_387
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_4  &
   adams_id = 90  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3s_p1s  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_389
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_5  &
   adams_id = 91  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e4s_e3s  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_391
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_6  &
   adams_id = 92  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p2s_e3s  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon2_s_flex.MARKER_393
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_7  &
   adams_id = 93  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1e  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_395
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_8  &
   adams_id = 94  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e2e_e1e  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon2_e_flex.MARKER_397
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_9  &
   adams_id = 95  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1e_e1e  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_399
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_10  &
   adams_id = 96  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3e_p1e  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_401
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_11  &
   adams_id = 97  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e4e_e3e  &
   applied_at_marker_name = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_403
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_12  &
   adams_id = 98  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p2e_e3e  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon2_e_flex.MARKER_405
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_13  &
   adams_id = 99  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1so  &
   applied_at_marker_name = .MODEL_309394_flexbody.pentagon1_flex.MARKER_407
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_14  &
   adams_id = 100  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1so_e2so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon1_so_flex.MARKER_409
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_15  &
   adams_id = 101  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e1so_p1so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon1_so_flex.MARKER_411
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_16  &
   adams_id = 102  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_p1so_e3so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_413
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_17  &
   adams_id = 103  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3so_e4so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon3_so_flex.MARKER_415
!
geometry create shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_18  &
   adams_id = 104  &
   force_element_name = .MODEL_309394_flexbody.SFORCE_e3so_p2so  &
   applied_at_marker_name =   &
                            .MODEL_309394_flexbody.exagon3_so_flex.MARKER_417
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1  &
   adams_id = 1  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1_e1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1_e2  &
   adams_id = 2  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_e2  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1_e2  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1_p2  &
   adams_id = 3  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1_p2  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1_p2  &
   active = off  &
   visibility = on  &
   name_visibility = on
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2_e3  &
   adams_id = 4  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2_e3  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p2_e3  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3_e4  &
   adams_id = 5  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_e4  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3_e4  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3_p3  &
   adams_id = 6  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3_p3  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3_p3  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4_p4  &
   adams_id = 7  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4_p4  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e4_p4  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1no_p1  &
   adams_id = 8  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1no_p1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1no_e1no  &
   adams_id = 9  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1no_e1no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2no_e1no  &
   adams_id = 10  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e2no_e1no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1no_e3no  &
   adams_id = 11  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2no_e3no  &
   adams_id = 12  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p2no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4no_e3no  &
   adams_id = 13  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e4no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1s_p1  &
   adams_id = 14  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1s_p1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2s_e1s  &
   adams_id = 15  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e2s_e1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1s_e1s  &
   adams_id = 16  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1s_e1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3s_p1s  &
   adams_id = 17  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3s_p1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4s_e3s  &
   adams_id = 18  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e4s_e3s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2s_e3s  &
   adams_id = 19  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p2s_e3s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1e  &
   adams_id = 20  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2e_e1e  &
   adams_id = 21  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e2e_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1e_e1e  &
   adams_id = 22  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1e_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3e_p1e  &
   adams_id = 23  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3e_p1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4e_e3e  &
   adams_id = 24  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e4e_e3e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2e_e3e  &
   adams_id = 25  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p2e_e3e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1so  &
   adams_id = 26  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1_e1so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1so_e2so  &
   adams_id = 27  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1so_e2so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1so_p1so  &
   adams_id = 28  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e1so_p1so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1so_e3so  &
   adams_id = 29  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_p1so_e3so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3so_e4so  &
   adams_id = 30  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3so_e4so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3so_p2so  &
   adams_id = 31  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_flexbody.MOTION_e3so_p2so  &
   active = off  &
   name_visibility = off
!
!----------------------------- Analysis settings ------------------------------!
!
!
!---------------------------------- Measures ----------------------------------!
!
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_x_fx  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_x  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_x_fx  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_y_fy  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_y  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_y_fy  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_z_fz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_z  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_z_fz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.VTORQUE_1_tq_x  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.VTORQUE_1  &
   characteristic = element_torque  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.VTORQUE_1_tq_x  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.VTORQUE_1_tq_y  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.VTORQUE_1  &
   characteristic = element_torque  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.VTORQUE_1_tq_y  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.VTORQUE_1_tq_z  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.VTORQUE_1  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.VTORQUE_1_tq_z  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.Target_acc  &
   from_first = no  &
   object = .MODEL_309394_flexbody.Target  &
   characteristic = cm_acceleration  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.Target_acc  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1_e2_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1_e2  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_flex.MARKER_58  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1_e2_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1_e2_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1_e2  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_flex.MARKER_58  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1_e2_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2_e3_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2_e3  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_flex.MARKER_62  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2_e3_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2_e3_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2_e3  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_flex.MARKER_62  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2_e3_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3_e4_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3_e4  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_flex.MARKER_64  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3_e4_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3_e4_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3_e4  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_flex.MARKER_64  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3_e4_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3_p3_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3_p3  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon3_flex.MARKER_66  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3_p3_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3_p3_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3_p3  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon3_flex.MARKER_66  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3_p3_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4_p4_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4_p4  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon4_flex.MARKER_68  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4_p4_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4_p4_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4_p4  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon4_flex.MARKER_68  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4_p4_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_15  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_15  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1_p2_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1_p2  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_flex.MARKER_60  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1_p2_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1_p2_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1_p2  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_flex.MARKER_60  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1_p2_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1_e1_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1_e1  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_15  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1_e1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1_e2_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.MOTION_e1_e2  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_57  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1_e2_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1_p2_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e1_p2  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_flex.MARKER_60  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1_p2_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p2_e3_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p2_e3  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_flex.MARKER_62  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p2_e3_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3_e4_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3_e4  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_flex.MARKER_64  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3_e4_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3_p3_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3_p3  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon3_flex.MARKER_66  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3_p3_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e4_p4_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e4_p4  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon4_flex.MARKER_68  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e4_p4_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1_e2_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e1_e2  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_356  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1_e2_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p2_e3_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_p2_e3  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_flex.MARKER_357  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p2_e3_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3_e4_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_e3_e4  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_flex.MARKER_365  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3_e4_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1no_e1no_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_116  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1no_e1no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1no_e1no_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_116  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1no_e1no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_120  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_120  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2no_e1no_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_122  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2no_e1no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2no_e1no_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_122  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2no_e1no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_124  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_124  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2s_e1s_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_174  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2s_e1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2s_e1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_174  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2s_e1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3s_p1s_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_178  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3s_p1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3s_p1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_178  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3s_p1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4s_e3s_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_180  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4s_e3s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4s_e3s_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_180  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4s_e3s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2s_e3s_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_182  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2s_e3s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2s_e3s_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_182  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2s_e3s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2e_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_247  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2e_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e2e_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_247  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e2e_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3e_p1e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_251  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3e_p1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3e_p1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_251  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3e_p1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4e_e3e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_253  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4e_e3e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e4e_e3e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_253  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e4e_e3e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2e_e3e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_255  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2e_e3e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p2e_e3e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_255  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p2e_e3e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1so_e2so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_321  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1so_e2so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1so_e2so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_321  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1so_e2so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1so_e3so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1so_e3so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1so_e3so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1so_e3so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3so_e4so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_327  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3so_e4so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3so_e4so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_327  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3so_e4so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3so_p2so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_329  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3so_p2so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e3so_p2so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_329  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e3so_p2so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e2no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_122  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e2no_e1no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e2no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_368  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e2no_e1no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_118  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_118  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_118  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1no_e3no_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_369  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3_p3_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_e3_p3  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon3_flex.MARKER_359  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3_p3_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e4_p4_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_e4_p4  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon4_flex.MARKER_363  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e4_p4_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1_e1_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_p1_e1  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_flex.MARKER_371  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1no_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e1no_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_114  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1no_p1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_116  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1no_e1no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p2no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_120  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p2no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e4no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_124  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e4no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1s_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e1s_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_172  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1s_p1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e2s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_174  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e2s_e1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_176  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1s_e1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3s_p1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_178  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3s_p1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e4s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_180  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e4s_e3s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p2s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_182  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p2s_e3s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_245  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e2e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_247  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e2e_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_249  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1e_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3e_p1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_251  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3e_p1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e4e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_253  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e4e_e3e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p2e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_255  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p2e_e3e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1_e1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1_e1so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_319  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1_e1so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1so_e2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_321  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1so_e2so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e1so_p1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_323  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e1so_p1so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_p1so_e3so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_325  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_p1so_e3so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3so_e4so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_327  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3so_e4so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.MOTION_e3so_p2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.MOTION_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_329  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MOTION_e3so_p2so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1no_p1_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_114  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1no_p1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1no_p1_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1no_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_114  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1no_p1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1no_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e1no_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_380  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1no_p1_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_no_flex.MARKER_382  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1no_e1no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1s_p1_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_172  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1s_p1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1s_p1_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1s_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_172  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1s_p1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1s_e1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_176  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1s_e1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1s_e1s_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_176  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1s_e1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_245  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_245  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1e_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_249  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1e_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1e_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_249  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1e_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_319  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_p1_e1so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_p1_e1so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_319  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_p1_e1so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1so_p1so_az  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_323  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1so_p1so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.JOINT_e1so_p1so_wz  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.JOINT_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_323  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.JOINT_e1so_p1so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e4no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_376  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e4no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1_p2_torque  &
   from_first = no  &
   object = .MODEL_309394_flexbody.SFORCE_e1_p2  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_flex.MARKER_373  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1_p2_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_400  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1e_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1so_p1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_so_flex.MARKER_412  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1so_p1so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_388  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1s_e1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p2no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_no_flex.MARKER_378  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p2no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3so_p2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon2_so_flex.MARKER_418  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3so_p2so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p2e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_406  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p2e_e3e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p2s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_394  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p2s_e3s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e2s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_s_flex.MARKER_386  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e2s_e1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e2e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_398  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e2e_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1so_e2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon2_so_flex.MARKER_410  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1so_e2so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1_e1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1_e1so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_so_flex.MARKER_408  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3e_p1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_402  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3e_p1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3so_e4so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon4_so_flex.MARKER_416  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3so_e4so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e3s_p1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_390  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e3s_p1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e4e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_e_flex.MARKER_404  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e4e_e3e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e4s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_s_flex.MARKER_392  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e4s_e3s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1so_e3so_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon3_so_flex.MARKER_414  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1so_e3so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_p1_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_p1_e1e  &
   coordinate_rframe = .MODEL_309394_flexbody.exagon1_e_flex.MARKER_396  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_p1_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_flexbody.SFORCE_e1s_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_flexbody.SFORCE_e1s_p1  &
   coordinate_rframe = .MODEL_309394_flexbody.pentagon1_flex.MARKER_384  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.SFORCE_e1s_p1_torque  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_vz  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_vz  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tg_x  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tg_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tg_y  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tg_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tg_z  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tg_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tgv_x  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tgv_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tgv_y  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tgv_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_tgv_z  &
   point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_tgv_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_x  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_y  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_z  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_vx  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_vx  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_flexbody.cm_vy  &
   point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.cm_vy  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_L3  &
   from_point = .MODEL_309394_flexbody.pentagon4_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_L3  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_cm_tg  &
   from_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_cm_tg  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_L2  &
   from_point = .MODEL_309394_flexbody.exagon3_s_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.exagon2_no_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_L2  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_L1  &
   from_point = .MODEL_309394_flexbody.exagon3_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.exagon2_s_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_L1  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_closed_h  &
   from_point = .MODEL_309394_flexbody.pentagon1_s_flex.MARKER_3  &
   to_point = .MODEL_309394_flexbody.pentagon2_flex.MARKER_21  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_closed_h  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_cm_tg_x  &
   from_point = .MODEL_309394_flexbody.Target.cm  &
   to_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_cm_tg_x  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_cm_tg_y  &
   from_point = .MODEL_309394_flexbody.Target.cm  &
   to_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_cm_tg_y  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_cm_tg_z  &
   from_point = .MODEL_309394_flexbody.Target.cm  &
   to_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_cm_tg_z  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_closed_b  &
   from_point = .MODEL_309394_flexbody.pentagon1_e_flex.MARKER_3  &
   to_point = .MODEL_309394_flexbody.pentagon1_no_flex.MARKER_21  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_closed_b  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_deployed_b  &
   from_point = .MODEL_309394_flexbody.exagon4_no_flex.MARKER_80  &
   to_point = .MODEL_309394_flexbody.exagon4_e_flex.MARKER_130  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_deployed_b  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_deployed_h  &
   from_point = .MODEL_309394_flexbody.exagon4_s_flex.MARKER_130  &
   to_point = .MODEL_309394_flexbody.pentagon4_flex.MARKER_49  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_deployed_h  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_z  &
   from_point = .MODEL_309394_flexbody.Target.cm  &
   to_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_z  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_x  &
   from_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_x  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_y  &
   from_point = .MODEL_309394_flexbody.pentagon1_flex.original_rigid_cm  &
   to_point = .MODEL_309394_flexbody.Target.cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.MEA_vel_cm_tg_y  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_e1_e2  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_e1_e2  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_p2_e3  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_p2_e3  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_e4_p4  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_e4_p4  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_e3_e4  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_e3_e4  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.z_rel  &
   function = ""  &
   units = "no_units"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.z_rel  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.z  &
   function = ""  &
   units = "no_units"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.z  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_e2_e1_c  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_e2_e1_c  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_flexbody.angle_e3_e4_c  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_flexbody.angle_e3_e4_c  &
   color = WHITE
!
!---------------------------- Adams View Variables ----------------------------!
!
!
variable create  &
   variable_name = .MODEL_309394_flexbody.layout_config  &
   integer_value = 1
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdi0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 25.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 50.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdiiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 75.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 25.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tdiii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 50.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tci0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 75.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tcif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tcii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tciif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 10.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tciii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 10.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tciiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 15.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tciv0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 15.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.tcivf  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 20.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.Mass  &
   units = "mass"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 44.3860004977
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.1
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0tg_x  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = -0.2
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0tg_y  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = -0.1
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0tg_z  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0s_x  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0s_y  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.v0s_z  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.mu_s  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.25
!
variable create  &
   variable_name = .MODEL_309394_flexbody.mu_d  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.2
!
variable create  &
   variable_name = .MODEL_309394_flexbody.STV  &
   units = "no_units"  &
   range = -10.0, 10.0  &
   use_allowed_values = no  &
   delta_type = percent_relative  &
   real_value = 1.0E-04
!
variable create  &
   variable_name = .MODEL_309394_flexbody.TVC  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.5
!
variable create  &
   variable_name = .MODEL_309394_flexbody.max_st_def  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-05
!
variable create  &
   variable_name = .MODEL_309394_flexbody.fr_arm  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_flexbody.bend_arm  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_flexbody.pin_r  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_flexbody.fr_tq_prload  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.stif  &
   units = "stiffness"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 3.5E+07
!
variable create  &
   variable_name = .MODEL_309394_flexbody.force_exp  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.5
!
variable create  &
   variable_name = .MODEL_309394_flexbody.Damp  &
   units = "damping"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.8E+04
!
variable create  &
   variable_name = .MODEL_309394_flexbody._pen_dep  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-04
!
variable create  &
   variable_name = .MODEL_309394_flexbody.dlgs  &
   integer_value = 1
!
variable create  &
   variable_name = .MODEL_309394_flexbody.KT  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.CT  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 6.0
!
variable create  &
   variable_name = .MODEL_309394_flexbody.vx_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.0E-02
!
variable create  &
   variable_name = .MODEL_309394_flexbody.vy_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.0E-02
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1_e2  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1_p2  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2_e3  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3_e4  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3_p3  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4_p4  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+75, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+10, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1no_p1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1s_p1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3s_p1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e2e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3e_p1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e4e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p2e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1_e1so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1so_e2so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e1so_p1so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_p1so_e3so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3so_e4so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_flexbody.MOTION_e3so_p2so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5, 180.0d+37.38d))"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_e1_e2  &
   function = "AZ(.MODEL_309394_flexbody.exagon2_flex.MARKER_58, .MODEL_309394_flexbody.exagon1_flex.MARKER_57)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_p2_e3  &
   function = "AZ(.MODEL_309394_flexbody.exagon3_flex.MARKER_62, .MODEL_309394_flexbody.pentagon2_flex.MARKER_61)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_e4_p4  &
   function = "AZ(.MODEL_309394_flexbody.pentagon4_flex.MARKER_68, .MODEL_309394_flexbody.exagon4_flex.MARKER_67)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_e3_e4  &
   function = "AZ(.MODEL_309394_flexbody.exagon4_flex.MARKER_64, .MODEL_309394_flexbody.exagon3_flex.MARKER_63)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.z_rel  &
   function = "SENVAL(.MODEL_309394_flexbody.SENSOR_z_rel)"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.z  &
   function = "SENVAL(.MODEL_309394_flexbody.SENSOR_z)"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_e2_e1_c  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,0,ABS(.MODEL_309394_flexbody.JOINT_e1_e2_az))"
!
measure modify function  &
   measure_name = .MODEL_309394_flexbody.angle_e3_e4_c  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,0,ABS(ABS(.MODEL_309394_flexbody.angle_e3_e4)-180))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_z  &
   function = "STEP5(time,0,0,10,-(.MODEL_309394_flexbody.Mass)*(.MODEL_309394_flexbody.cm_vz-(.MODEL_309394_flexbody.cm_tgv_z+",  &
              "IF(.MODEL_309394_flexbody.MEA_cm_tg_z+2:.MODEL_309394_flexbody.v_lim,.MODEL_309394_flexbody.v_lim,STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z_rel),.MODEL_309394_flexbody.v_lim,SENVAL(.MODEL_309394_flexbody.SENSOR_z_rel)+30,0)))))+",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+50,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+150,-.MODEL_309394_flexbody.Mass*(.MODEL_309394_flexbody.cm_vz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_y  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,1,0)*STEP5(time,0,0,10,(-(.MODEL_309394_flexbody.Mass)*(.MODEL_309394_flexbody.cm_vy-(.MODEL_309394_flexbody.cm_tgv_y+",  &
              "IF(.MODEL_309394_flexbody.MEA_cm_tg_y+0.0692:.MODEL_309394_flexbody.vy_lim,.MODEL_309394_flexbody.vy_lim,STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_y_rel),.MODEL_309394_flexbody.vy_lim,SENVAL(.MODEL_309394_flexbody.SENSOR_y_rel)+5,0))))))+",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+50, 0 , SENVAL(.MODEL_309394_flexbody.SENSOR_z)+150, -.MODEL_309394_flexbody.Mass*(.MODEL_309394_flexbody.cm_vy)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_x  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,1,0)*STEP5(time,0,0,10,(-(.MODEL_309394_flexbody.Mass)*(.MODEL_309394_flexbody.cm_vx-(.MODEL_309394_flexbody.cm_tgv_x-",  &
              "IF(.MODEL_309394_flexbody.MEA_cm_tg_x-0.069:STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_x_rel),.MODEL_309394_flexbody.vx_lim,SENVAL(.MODEL_309394_flexbody.SENSOR_x_rel)+5,0),.MODEL_309394_flexbody.vx_lim,.MODEL_309394_flexbody.vx_lim)))))+",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_flexbody.SENSOR_z)+50, 0 , SENVAL(.MODEL_309394_flexbody.SENSOR_z)+150, -.MODEL_309394_flexbody.Mass*(.MODEL_309394_flexbody.cm_vx)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1_e2  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_e1_e2_az)-0.4*.MODEL_309394_flexbody.JOINT_e1_e2_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,(0.00077+0.000665))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.000665),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e1_e2_az+180)-0.02*(.MODEL_309394_flexbody.JOINT_e1_e2_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e1_e2_az+180)-0.02*.MODEL_309394_flexbody.JOINT_e1_e2_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1_e2_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e1_e2_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0.0036)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4,-(0.0036+0.0046))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.0046),",  &
              "0,",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e1_e2_az+138.19)-0.4*.MODEL_309394_flexbody.JOINT_e1_e2_wz),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e1_e2_az+138.19)-0.1*.MODEL_309394_flexbody.JOINT_e1_e2_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2_e3  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_p2_e3_az)-0.4*(.MODEL_309394_flexbody.JOINT_p2_e3_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0.00232)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,-(0.00232+0.0023))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,0.0023),",  &
              "-0.0002*(.MODEL_309394_flexbody.JOINT_p2_e3_az-180)-0.05*(.MODEL_309394_flexbody.JOINT_p2_e3_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "-0.02*(.MODEL_309394_flexbody.JOINT_p2_e3_az-180)-0.2*.MODEL_309394_flexbody.JOINT_p2_e3_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "-0.02*(.MODEL_309394_flexbody.JOINT_p2_e3_az-180)-0.2*.MODEL_309394_flexbody.JOINT_p2_e3_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),-SENVAL(.MODEL_309394_flexbody.SENSOR_p2_e3_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0.0985)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,-(0.0985+0.07))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.07),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_p2_e3_az-217.38)-0.4*.MODEL_309394_flexbody.JOINT_p2_e3_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3_p3  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_e3_p3_az)-0.4*(.MODEL_309394_flexbody.JOINT_e3_p3_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3_p3_az+180:",  &
              "-0.0002*(.MODEL_309394_flexbody.JOINT_e3_p3_az+180)-0.03*(.MODEL_309394_flexbody.JOINT_e3_p3_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),-SENVAL(.MODEL_309394_flexbody.SENSOR_e3_p3),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.000335)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.000335+0.00028))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.00028))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_e3_p3_az+180)-0.4*(.MODEL_309394_flexbody.JOINT_e3_p3_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e3_p3_az+180)-0.1*(.MODEL_309394_flexbody.JOINT_e3_p3_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3_p3_az+217.38:",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e3_p3_az+217.38)-0.4*.MODEL_309394_flexbody.JOINT_e3_p3_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),-SENVAL(.MODEL_309394_flexbody.SENSOR_e3_p3_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,-0.00082)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4.1,(0.00082+0.0031))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,-0.0031)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3_e4  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "-0.1*(.MODEL_309394_flexbody.angle_e3_e4)-0.4*(.MODEL_309394_flexbody.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),-SENVAL(.MODEL_309394_flexbody.SENSOR_e3_e4),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.00132)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.00132+0.00125))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.00125),",  &
              "-0.00001*(.MODEL_309394_flexbody.JOINT_e3_e4_az+180)-0.02*(.MODEL_309394_flexbody.JOINT_e3_e4_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_e3_e4_az+180)-0.1*(.MODEL_309394_flexbody.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_e3_e4_az+180)-0.1*(.MODEL_309394_flexbody.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt3):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),-SENVAL(.MODEL_309394_flexbody.SENSOR_e3_e4_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.3,0.01146)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4.1,-(0.01146+0.02842))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,0.02842),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e3_e4_az+138.19)-0.1*.MODEL_309394_flexbody.JOINT_e3_e4_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4_p4  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "-0.02*(.MODEL_309394_flexbody.JOINT_e4_p4_az)-0.005*(.MODEL_309394_flexbody.JOINT_e4_p4_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp3):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp2),-SENVAL(.MODEL_309394_flexbody.SENSOR_e4_p4),SENVAL(.MODEL_309394_flexbody.SENSOR_disp2)+6,0.000315)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp2)+6,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp2)+20,-(0.000315+0.000318))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp2)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp2)+25,0.000318),",  &
              "-0.0002*(.MODEL_309394_flexbody.JOINT_e4_p4_az-180)-0.001*(.MODEL_309394_flexbody.JOINT_e4_p4_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_e4_p4_az-180)-0.1*(.MODEL_309394_flexbody.JOINT_e4_p4_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt3):0,",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_e4_p4_az-180)-0.1*(.MODEL_309394_flexbody.JOINT_e4_p4_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4_p4_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt3),-SENVAL(.MODEL_309394_flexbody.SENSOR_e4_p4_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt3)+1.2,0.0039)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt3)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt3)+4,-(0.0039+0.0018))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt3)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt3)+5,0.0018),",  &
              "0,",  &
              "-0.0001*(.MODEL_309394_flexbody.JOINT_e4_p4_az-217.38)-0.01*(.MODEL_309394_flexbody.JOINT_e4_p4_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az)+0.4*.MODEL_309394_flexbody.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,(0.00077+0.00064))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.00064),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_e2no_e1no_wz)),",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_e2no_e1no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-180)+0.1*.MODEL_309394_flexbody.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-180)+0.02*.MODEL_309394_flexbody.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-138.19:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-138.19)+0.01*.MODEL_309394_flexbody.JOINT_e2no_e1no_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e2no_e1no_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0.00356)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4,-(0.00356+0.0043))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.0043)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e2no_e1no_az-138.19)+0.01*.MODEL_309394_flexbody.JOINT_e2no_e1no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "-0.2*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az)-0.8*(.MODEL_309394_flexbody.JOINT_p1no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+180:",  &
              "-0.0001*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+180)-0.05*(.MODEL_309394_flexbody.JOINT_p1no_e3no_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,-0.00205)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,(0.00205+0.00205))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.00205)),",  &
              "-0.0001*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+180)-0.05*(.MODEL_309394_flexbody.JOINT_p1no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+180)-0.1*.MODEL_309394_flexbody.JOINT_p1no_e3no_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+180)-0.1*.MODEL_309394_flexbody.JOINT_p1no_e3no_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+217.38:",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+217.38)-0.4*.MODEL_309394_flexbody.JOINT_p1no_e3no_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),-SENVAL(.MODEL_309394_flexbody.SENSOR_p1no_e3no_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,-0.0491)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,(0.0491+0.0343))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,-0.0343)),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_p1no_e3no_az+217.38)-0.4*.MODEL_309394_flexbody.JOINT_p1no_e3no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_p1_e1_az)-0.4*(.MODEL_309394_flexbody.JOINT_p1_e1_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1_e1_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z),-0.0154,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0.2448)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.3,-(0.2448+0.25))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5,0.25),",  &
              "0,",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_p1_e1_az-37.38)-0.4*.MODEL_309394_flexbody.JOINT_p1_e1_wz),",  &
              "-0.001*(.MODEL_309394_flexbody.JOINT_p1_e1_az-37.38)-0.5*.MODEL_309394_flexbody.JOINT_p1_e1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1_p2  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_e1_p2_az)-1.2*(.MODEL_309394_flexbody.JOINT_e1_p2_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "-0.1*(.MODEL_309394_flexbody.JOINT_e1_p2_az)-0.8*(.MODEL_309394_flexbody.JOINT_e1_p2_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0),-SENVAL(.MODEL_309394_flexbody.SENSOR_e1_p2_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,-0.0959)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.2,(0.0959+0.1449))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5,-0.1449),",  &
              "-0.01*(.MODEL_309394_flexbody.JOINT_e1_p2_az+37.38)-0.4*(.MODEL_309394_flexbody.JOINT_e1_p2_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az)+0.4*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+180:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_e4no_e3no),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,-(0.00077+0.00074))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,0.00074)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+180)+0.1*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+180)+0.01*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_e4no_e3no_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,-0.0013)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,(0.0013+0.00522))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,-0.00522),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4no_e3no_az+138.19)+0.4*(.MODEL_309394_flexbody.JOINT_e4no_e3no_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p2no_e3no_az)+0.4*(.MODEL_309394_flexbody.JOINT_p2no_e3no_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_p2no_e3no),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.000335)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.000335+0.000315))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.000315),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-180)+0.005*(.MODEL_309394_flexbody.JOINT_p2no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-180)+0.5*(.MODEL_309394_flexbody.JOINT_p2no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-180)+0.03*(.MODEL_309394_flexbody.JOINT_p2no_e3no_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_p2no_e3no_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,-0.001)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,(0.001+0.0034))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,-0.0034),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p2no_e3no_az-217.38)+0.4*.MODEL_309394_flexbody.JOINT_p2no_e3no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1no_p1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e1no_p1_az)+0.4*(.MODEL_309394_flexbody.JOINT_e1no_p1_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1no_p1_az+37.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1no_p1_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1no_p1_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z),-0.012,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0.1667)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.2,-(0.1667+0.169))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5,0.169)),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1no_p1_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1no_p1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1no_e1no_az)+1.2*(.MODEL_309394_flexbody.JOINT_p1no_e1no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1no_e1no_az)+0.4*(.MODEL_309394_flexbody.JOINT_p1no_e1no_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1no_e1no_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0),SENVAL(.MODEL_309394_flexbody.SENSOR_p1no_e1no_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.1,-0.0653)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4,(0.0653+0.095))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5,-0.095),",  &
              "0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1no_e1no_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1no_e1no_wz),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1no_e1no_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1no_e1no_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1s_p1  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e1s_p1_az)+0.4*(.MODEL_309394_flexbody.JOINT_e1s_p1_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1s_p1_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z),0.0119,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,-0.181)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.1,(0.181+0.188))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5,-0.188),",  &
              "0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1s_p1_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1s_p1_wz),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1s_p1_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1s_p1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az)+0.4*.MODEL_309394_flexbody.JOINT_e2s_e1s_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+180:",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+180)+0.01*(.MODEL_309394_flexbody.JOINT_e2s_e1s_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,0.000772)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,-(0.000772+0.00064))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,0.00064)),",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+180)+0.01*(.MODEL_309394_flexbody.JOINT_e2s_e1s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+180)+0.02*.MODEL_309394_flexbody.JOINT_e2s_e1s_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e2s_e1s_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,-0.00429)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,(0.00429+0.005))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,-0.005),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+138.19)+0.4*.MODEL_309394_flexbody.JOINT_e2s_e1s_wz),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e2s_e1s_az+138.19)+0.4*.MODEL_309394_flexbody.JOINT_e2s_e1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.04*(.MODEL_309394_flexbody.JOINT_p1s_e1s_az)+1.2*(.MODEL_309394_flexbody.JOINT_p1s_e1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1s_e1s_az)+0.8*(.MODEL_309394_flexbody.JOINT_p1s_e1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1s_e1s_az+37.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1s_e1s_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1s_e1s_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0),SENVAL(.MODEL_309394_flexbody.SENSOR_p1s_e1s_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,0.078)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.0,-(0.078+0.109))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.0,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5,0.109)),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1s_e1s_az+37.38)+0.2*.MODEL_309394_flexbody.JOINT_p1s_e1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3s_p1s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az)+0.4*(.MODEL_309394_flexbody.JOINT_e3s_p1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,-0.00203)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,(0.00203+0.00205))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.00205),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-180)+0.05*(.MODEL_309394_flexbody.JOINT_e3s_p1s_wz)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-180)+0.05*(.MODEL_309394_flexbody.JOINT_e3s_p1s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-180)+0.1*(.MODEL_309394_flexbody.JOINT_e3s_p1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e3s_p1s_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,-0.0545)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,(0.0545+0.03328))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,-0.03328),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-217.38)+0.4*.MODEL_309394_flexbody.JOINT_e3s_p1s_wz),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3s_p1s_az-217.38)+0.4*.MODEL_309394_flexbody.JOINT_e3s_p1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az)+0.4*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+180:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_e4s_e3s),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,-(0.00077+0.00074))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,0.00074)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+180)+0.1*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+180)+0.01*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_e4s_e3s_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,-0.001)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,(0.001+0.0098))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,-0.0098),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4s_e3s_az+138.19)+0.02*(.MODEL_309394_flexbody.JOINT_e4s_e3s_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p2s_e3s_az)+0.4*(.MODEL_309394_flexbody.JOINT_p2s_e3s_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+180:",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+180)+0.005*(.MODEL_309394_flexbody.JOINT_p2s_e3s_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_p2s_e3s),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0.000335)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,-(0.000335+0.000315))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,0.000315))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+180)+0.5*(.MODEL_309394_flexbody.JOINT_p2s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_p2s_e3s_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+217.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p2s_e3s_az+217.38)+0.04*.MODEL_309394_flexbody.JOINT_p2s_e3s_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_p2s_e3s_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0.0008)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,-(0.0008+0.0045))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,0.0045)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1_e1e_az)+0.4*(.MODEL_309394_flexbody.JOINT_p1_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1_e1e_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z),0.012,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,-0.171)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.2,(0.171+0.178))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5,-0.178),",  &
              "0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1_e1e_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1_e1e_wz),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1_e1e_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1_e1e_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e2e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az)+0.4*.MODEL_309394_flexbody.JOINT_e2e_e1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,(0.00077+0.00064))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.00064),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_e2e_e1e_wz)),",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_e2e_e1e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-180)+0.02*.MODEL_309394_flexbody.JOINT_e2e_e1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-138.19:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-138.2)+0.01*.MODEL_309394_flexbody.JOINT_e2e_e1e_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e2e_e1e_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0.00397)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,-(0.00397+0.0045))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.0045)),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e2e_e1e_az-138.19)+0.4*.MODEL_309394_flexbody.JOINT_e2e_e1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1e_e1e_az)+1.2*(.MODEL_309394_flexbody.JOINT_p1e_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1e_e1e_az)+0.8*(.MODEL_309394_flexbody.JOINT_p1e_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1e_e1e_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0),SENVAL(.MODEL_309394_flexbody.SENSOR_p1e_e1e_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,-0.0692)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4,(0.0692+0.0941))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5,-0.0941),",  &
              "0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1e_e1e_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1e_e1e_wz),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1e_e1e_az-37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1e_e1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3e_p1e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az)+0.4*(.MODEL_309394_flexbody.JOINT_e3e_p1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+180:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+180)+0.05*(.MODEL_309394_flexbody.JOINT_e3e_p1e_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0.00205)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,-(0.00205+0.00205))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,0.00205)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+180)+0.05*(.MODEL_309394_flexbody.JOINT_e3e_p1e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+180)+0.2*.MODEL_309394_flexbody.JOINT_e3e_p1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+217.38:",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+217.38)+0.4*.MODEL_309394_flexbody.JOINT_e3e_p1e_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e3e_p1e_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0.047)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,-(0.047+0.034))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.034)),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3e_p1e_az+217.38)+0.4*.MODEL_309394_flexbody.JOINT_e3e_p1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e4e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az)+0.4*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_e4e_e3e),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.00077+0.00074))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.00074),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-180)+0.2*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-138.19:",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e4e_e3e_az-138.19)+0.1*(.MODEL_309394_flexbody.JOINT_e4e_e3e_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_e4e_e3e_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.1,0.00119)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,-(0.00119+0.0039))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,0.0039)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p2e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p2e_e3e_az)+0.4*(.MODEL_309394_flexbody.JOINT_p2e_e3e_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_p2e_e3e),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.000335)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.000335+0.000315))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.000315),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_p2e_e3e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-180)+0.1*(.MODEL_309394_flexbody.JOINT_p2e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-180)+0.01*(.MODEL_309394_flexbody.JOINT_p2e_e3e_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_p2e_e3e_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,-0.001)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,(0.001+0.00335))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,-0.00335),",  &
              "0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p2e_e3e_az-217.38)+0.4*.MODEL_309394_flexbody.JOINT_p2e_e3e_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1_e1so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1_e1so_az)+0.4*(.MODEL_309394_flexbody.JOINT_p1_e1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1_e1so_az+37.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1_e1so_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1_e1so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z),-0.0119,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.3,0.1817)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.1,-(0.1817+0.192))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_z)+5,0.192)),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_p1_e1so_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_p1_e1so_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1so_e2so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az)+0.4*.MODEL_309394_flexbody.JOINT_e1so_e2so_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp0):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,(0.00077+0.00064))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,-0.00064),",  &
              "0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e1so_e2so_wz)),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e1so_e2so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-180)+0.02*.MODEL_309394_flexbody.JOINT_e1so_e2so_wz,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-138.19:",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-138.19)+0.01*.MODEL_309394_flexbody.JOINT_e1so_e2so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_e1so_e2so_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0.00377)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,-(0.00377+0.0047))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.0047)),",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e1so_e2so_az-138.19)+0.01*.MODEL_309394_flexbody.JOINT_e1so_e2so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e1so_p1so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e1so_p1so_az)+1.2*(.MODEL_309394_flexbody.JOINT_e1so_p1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e1so_p1so_az)+0.8*(.MODEL_309394_flexbody.JOINT_e1so_p1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e1so_p1so_az+37.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1so_p1so_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1so_p1so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0),SENVAL(.MODEL_309394_flexbody.SENSOR_e1so_p1so_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.1,0.074)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+1.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.1,-(0.074+0.11))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt0)+5,0.11)),",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e1so_p1so_az+37.38)+0.4*.MODEL_309394_flexbody.JOINT_e1so_p1so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_p1so_e3so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az)+0.4*(.MODEL_309394_flexbody.JOINT_p1so_e3so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+180:",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+180)+0.05*(.MODEL_309394_flexbody.JOINT_p1so_e3so_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv),0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0.00205)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,-(0.00205+0.00205))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_flexbody.SENSOR_avv)+25,0.00205)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+180)+0.05*(.MODEL_309394_flexbody.JOINT_p1so_e3so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+180)+0.2*(.MODEL_309394_flexbody.JOINT_p1so_e3so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+217.38:",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+217.38)+0.4*.MODEL_309394_flexbody.JOINT_p1so_e3so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1),SENVAL(.MODEL_309394_flexbody.SENSOR_p1so_e3so_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0.056)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+1.2,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,-(0.056+0.029))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt1)+5,0.029)),",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_p1so_e3so_az+217.38)+0.4*.MODEL_309394_flexbody.JOINT_p1so_e3so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3so_e4so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az)+0.4*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp2):0,",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_e3so_e4so),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,-0.00077)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,(0.00077+0.00073))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,-0.00073),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz)),",  &
              "0.0001*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-180)+0.2*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-180)+0.02*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-138.19:",  &
              "0.001*(.MODEL_309394_flexbody.JOINT_e3so_e4so_az-138.19)+0.01*(.MODEL_309394_flexbody.JOINT_e3so_e4so_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_e3so_e4so_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1,0.0001)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,-(0.0001+0.01))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,0.01)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_flexbody.SFORCE_e3so_p2so  &
   function = "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_flexbody.JOINT_e3so_p2so_az)+0.4*(.MODEL_309394_flexbody.JOINT_e3so_p2so_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+180:",  &
              "0.0002*(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+180)+0.01*(.MODEL_309394_flexbody.JOINT_e3so_p2so_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1),SENVAL(.MODEL_309394_flexbody.SENSOR_e3so_p2so),SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0.000335)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,-(0.000335+0.000315))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_flexbody.SENSOR_disp1)+25,0.000315))),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+180)+0.2*(.MODEL_309394_flexbody.JOINT_e3so_p2so_wz),",  &
              "IF(SENVAL(.MODEL_309394_flexbody.SENSOR_capt2):0,",  &
              "0.002*(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+180)+0.02*(.MODEL_309394_flexbody.JOINT_e3so_p2so_wz),",  &
              "IF(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+217.38:",  &
              "0.01*(.MODEL_309394_flexbody.JOINT_e3so_p2so_az+217.38)+0.04*.MODEL_309394_flexbody.JOINT_e3so_p2so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2),SENVAL(.MODEL_309394_flexbody.SENSOR_e3so_p2so_c),SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1,0.00044)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+1,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,-(0.00044+0.0039))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_flexbody.SENSOR_capt2)+5,0.0039)))))"
!
force modify direct torque_vector  &
   torque_vector_name = .MODEL_309394_flexbody.VTORQUE_1  &
   x_torque_function = "-.MODEL_309394_flexbody.KT*AX(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351)-.MODEL_309394_flexbody.CT*WX(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351,.MODEL_309394_flexbody.ground.MARKER_351)"  &
   y_torque_function = "-.MODEL_309394_flexbody.KT*AY(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351)-.MODEL_309394_flexbody.CT*WY(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351,.MODEL_309394_flexbody.ground.MARKER_351)"  &
   z_torque_function = "-.MODEL_309394_flexbody.KT*AZ(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351)-.MODEL_309394_flexbody.CT*WZ(.MODEL_309394_flexbody.pentagon1_flex.MARKER_350,.MODEL_309394_flexbody.ground.MARKER_351,.MODEL_309394_flexbody.ground.MARKER_351)"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_z  &
   function = "ABS(.MODEL_309394_flexbody.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_avv  &
   function = "ABS(.MODEL_309394_flexbody.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp1  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp2  &
   function = "ABS(.MODEL_309394_flexbody.angle_e3_e4)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_x_rel  &
   function = ".MODEL_309394_flexbody.MEA_cm_tg_x - 0.069"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_y_rel  &
   function = ".MODEL_309394_flexbody.MEA_cm_tg_y + 0.0692"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_z_rel  &
   function = "ABS(.MODEL_309394_flexbody.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt1  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt2  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_e4  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3_e4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4no_e3no  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4s_e3s  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4e_e3e  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_e4so  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3so_e4so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_p3  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3_p3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2no_e3no  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2s_e3s  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2e_e3e  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_p2so  &
   function = ".MODEL_309394_flexbody.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3so_p2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4_p4  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e3_e4_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4_p4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1_e2_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e1_e2_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2no_e1no_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e2no_e1no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2s_e1s_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e2s_e1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e2e_e1e_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e2e_e1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1so_e2so_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e1so_e2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2_e3_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2_e3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1no_e3no_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p1no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3s_p1s_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3s_p1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3e_p1e_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3e_p1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1so_e3so_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p1so_e3so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp0  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e1_e2_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_disp3  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e4_p4_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt0  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1_p2_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e1_p2_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1no_e1no_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p1no_e1no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1s_e1s_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p1s_e1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p1e_e1e_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p1e_e1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e1so_p1so_c  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e1so_p1so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_e4_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3_e4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4no_e3no_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4s_e3s_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4e_e3e_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_e4so_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3so_e4so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3_p3_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3_p3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2no_e3no_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2s_e3s_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_p2e_e3e_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_p2e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e3so_p2so_c  &
   function = ".MODEL_309394_flexbody.angle_p2_e3"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e3so_p2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt2_1  &
   function = ".MODEL_309394_flexbody.angle_e2_e1_c"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt3  &
   function = ".MODEL_309394_flexbody.angle_e3_e4_c"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_e4_p4_c  &
   function = ".MODEL_309394_flexbody.angle_e3_e4_c"  &
   evaluate = ".MODEL_309394_flexbody.SFORCE_e4_p4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_flexbody.SENSOR_capt4  &
   function = "ABS(.MODEL_309394_flexbody.JOINT_e4_p4_az)"  &
   evaluate = "time"
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ground
!
material modify  &
   material_name = .MODEL_309394_flexbody.steel  &
   density = (7801.0(kg/meter**3))  &
   youngs_modulus = (2.07E+11(Newton/meter**2))
!
material modify  &
   material_name = .MODEL_309394_flexbody.carbon_fiber_0_90_epoxy  &
   density = (1510(kg/meter**3))  &
   orthotropic_constants =   &
      (1.23611E+10(Newton/meter**2)),  &
      (2.7443E+10(Newton/meter**2)),  &
      (2.8949E+09(Newton/meter**2))
!
geometry modify shape block  &
   block_name = .MODEL_309394_flexbody.Target.BOX_33  &
   diag_corner_coords =   &
      (25.0cm),  &
      (25.0cm),  &
      (25.0cm)
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {359.9999181667deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {323.9992953847deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_no_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {35.9999999822deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_e_flex  &
   orientation =   &
      ({72.0, 0.0, 0.0} + {180.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_s_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {180.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon1_so_flex  &
   orientation =   &
      ({288.0, 0.0, 0.0} + {-179.9992722273deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_flex  &
   orientation =   &
      ({24.0, 0.0, 0.0} + {-8.183330004E-05deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_no_flex  &
   orientation =   &
      ({96.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_s_flex  &
   orientation =   &
      ({240.0, 0.0, 0.0} + {5.5489100049E-05deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_e_flex  &
   orientation =   &
      ({312.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon1_so_flex  &
   orientation =   &
      ({168.0, 0.0, 0.0} + {5.5489100049E-05deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_flex  &
   orientation =   &
      ({288.0, 180.0, 0.0} + {-144.0000000178deg, -180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_no_flex  &
   orientation =   &
      ({72.0, 180.0, 0.0} + {143.9999999946deg, -180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_s_flex  &
   orientation =   &
      ({0.0, 180.0, 0.0} + {359.9992953915deg, -180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_e_flex  &
   orientation =   &
      ({72.0, 180.0, 0.0} + {7.0460849996E-04deg, -180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon2_so_flex  &
   orientation =   &
      ({288.0, 180.0, 0.0} + {0.0deg, -180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_flex  &
   orientation =   &
      ({336.0, 180.0, 0.0} + {12.0007046198deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_no_flex  &
   orientation =   &
      ({96.0, 180.0, 0.0} + {-36.0007045892deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_s_flex  &
   orientation =   &
      ({24.0, 180.0, 0.0} + {179.9992722273deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_e_flex  &
   orientation =   &
      ({96.0, 180.0, 0.0} + {179.9992722273deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon3_so_flex  &
   orientation =   &
      ({312.0, 180.0, 0.0} + {-180.0007277727deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon3_flex  &
   orientation =   &
      ({288.0, 0.0, 0.0} + {-8.1830100044E-05deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_no_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_s_flex  &
   orientation =   &
      ({144.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_e_flex  &
   orientation =   &
      ({216.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon2_so_flex  &
   orientation =   &
      ({72.0, 0.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_flex  &
   orientation =   &
      ({0.0, 0.0, 0.0} + {347.9999989054deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_no_flex  &
   orientation =   &
      ({24.0, 0.0, 0.0} + {36.0000000054deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_s_flex  &
   orientation =   &
      ({24.0, 0.0, 0.0} + {0.0deg, 180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_e_flex  &
   orientation =   &
      ({96.0, 0.0, 0.0} + {180.0deg, 0.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.exagon4_so_flex  &
   orientation =   &
      ({312.0, 0.0, 0.0} + {0.0deg, 180.0deg, 0.0deg})
!
part modify flexible_body name_and_position  &
   flexible_body_name = .MODEL_309394_flexbody.pentagon4_flex  &
   orientation =   &
      ({348.0, 180.0, 0.0} + {0.0deg, 0.0deg, 0.0deg})
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_32_e1_e2  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_2_p1_e1  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_3_e1_p2  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_4_p2_e3  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_5_e3_e4  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_6_e3_p3  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_7_e4_p4  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_8_e1no_p1  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_9_p1no_e1no  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_10_p1no_e3no  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_11_p2no_e3no  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_12_e2no_e1no  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_13_e4no_e3no  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_14_e1s_p1  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_15_e2s_e1s  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_16_p1s_e1s  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_17_e3s_p1s  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_18_e4s_e3s  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_19_p2s_e3s  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_20_p1_e1e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_21_e2e_e1e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_22_p1e_e1e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_23_e3e_p1e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_24_e4e_e3e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_25_p2e_e3e  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_26_p1_e1so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_27_e1so_e2so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_28_e1so_p1so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_29_p1so_e3so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_30_e3so_e4so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_flexbody.FRICTION_31_e3so_p2so  &
   mu_static = (.MODEL_309394_flexbody.mu_s)  &
   mu_dynamic = (.MODEL_309394_flexbody.mu_d)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.JOINT_30_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.JOINT_p1so_e3so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.JOINT_30_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_flexbody.JOINT_p1so_e3so.j)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_z_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_z.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.VTORQUE_1_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.VTORQUE_1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_4_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1_e2.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_5_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p2_e3.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_6_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3_p3.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_9_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3_e4.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_7_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e4_p4.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_10_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e2no_e1no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_11_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_12_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1_e1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_12_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1_p2.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_14_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e4no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_15_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p2no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_16_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1no_p1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_16_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1no_e1no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1s_p1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e2s_e1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_3  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1s_e1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_4  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3s_p1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_5  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e4s_e3s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_6  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p2s_e3s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_7  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_8  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e2e_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_9  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1e_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_10  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3e_p1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_11  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e4e_e3e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_12  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p2e_e3e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_13  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1_e1so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_14  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1so_e2so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_15  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e1so_p1so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_16  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_p1so_e3so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_17  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3so_e4so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_flexbody.SFORCE_18_force_graphic_18  &
   applied_at_marker_name = (.MODEL_309394_flexbody.SFORCE_e3so_p2so.i)
!
variable modify  &
   variable_name = .MODEL_309394_flexbody.Mass  &
   real_value = (.MODEL_309394_flexbody.Mass)
!
model display  &
   model_name = MODEL_309394_flexbody
