! CMD Version:2
! Version 2 enables expanded acceptable characters for object names.
! If unspecified, set to 1 or set to an invalid value, Adams View assumes traditional naming requirements.
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = meter  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = off  &
   grid_visibility = off  &
   size_of_icons = 5.0E-02  &
   spacing_for_grid = 1.0
!
!------------------------------ Adams View Model ------------------------------!
!
!
model create  &
   model_name = MODEL_309394_4mm  &
   comments =   &
              "Originally created via model copy from petaloide_parte_1.Last_Run at time=75sec with more_results=no and index_time=no."
!
model attributes  &
   model_name = .MODEL_309394_4mm  &
   color = BLUE  &
   visibility = on
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create spline  &
   spline_name = .MODEL_309394_4mm.SPLINE_1  &
   adams_id = 1  &
   x = 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3,  &
       1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7,  &
       2.8, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1,  &
       4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5.0, 5.1, 5.2, 5.3, 5.4, 5.5,  &
       5.6, 5.7, 5.8, 5.9, 6.0, 6.1, 6.2, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9,  &
       7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.8, 7.9, 8.0, 8.1, 8.2, 8.3,  &
       8.4, 8.5, 8.6, 8.7, 8.8, 8.9, 9.0, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7,  &
       9.8, 9.9, 10.0, 10.1, 10.2, 10.3, 10.4, 10.5, 10.6, 10.7, 10.8, 10.9,  &
       11.0, 11.1, 11.2, 11.3, 11.4, 11.5, 11.6, 11.7, 11.8, 11.9, 12.0,  &
       12.1, 12.2, 12.3, 12.4, 12.5, 12.6, 12.7, 12.8, 12.9, 13.0, 13.1,  &
       13.2, 13.3, 13.4, 13.5, 13.6, 13.7, 13.8, 13.9, 14.0, 14.1, 14.2,  &
       14.3, 14.4, 14.5, 14.6, 14.7, 14.8, 14.9, 15.0, 15.1, 15.2, 15.3,  &
       15.4, 15.5, 15.6, 15.7, 15.8, 15.9, 16.0, 16.1, 16.2, 16.3, 16.4,  &
       16.5, 16.6, 16.7, 16.8, 16.9, 17.0, 17.1, 17.2, 17.3  &
   y = 1.3193398472E-03, -6.1239770809E-04, 6.7262131175E-05,  &
       1.3494075074E-03, 1.7947485554E-03, 3.5952099666E-03,  &
       5.7497603231E-03, 8.6721025167E-03, 1.2498031107E-02,  &
       1.7001499289E-02, 2.2223423261E-02, 2.813093764E-02, 3.4691543848E-02,  &
       4.1856221777E-02, 4.956704724E-02, 5.7757526324E-02, 6.6354357735E-02,  &
       7.5278583358E-02, 8.4446817523E-02, 9.3772402579E-02, 0.1031665248,  &
       0.1125392708, 0.1218006246, 0.1308614057, 0.1396341462, 0.1480339085,  &
       0.1559790408, 0.1633918701, 0.1701993297, 0.1763335198, 0.181732194,  &
       0.1863391757, 0.190104692, 0.1929856248, 0.1949456775, 0.195955447,  &
       0.1959924041, 0.195040776, 0.1930913335, 0.1901410832, 0.1861928677,  &
       0.1812548839, 0.1753401262, 0.1684657701, 0.1606525097, 0.1519238738,  &
       0.1423055371, 0.1318246518, 0.1205092322, 0.1083876065,  &
       9.5487973592E-02, 8.1838081491E-02, 6.7465050381E-02,  &
       5.2395362064E-02, 3.6655020639E-02, 2.0269897611E-02,  &
       3.2662561139E-03, -1.4328552535E-02, -3.2485237194E-02,  &
       -5.1171584907E-02, -7.035138176E-02, -8.9983275885E-02, -0.1100196295,  &
       -0.1304054103, -0.151077177, -0.1719622125, -0.1929778609,  &
       -0.2140311164, -0.2350185104, -0.2558263338, -0.2763312209,  &
       -0.2964011113, -0.3158965942, -0.3346726226, -0.3525805772,  &
       -0.3694706406, -0.3851944307, -0.3996078354, -0.4125739712,  &
       -0.4239661872, -0.4336710258, -0.4415910492, -0.447647438,  &
       -0.4517822729, -0.4539604149, -0.4541709088, -0.452427848,  &
       -0.4487706542, -0.4432637433, -0.4359955693, -0.4270770599,  &
       -0.4166394761, -0.4048317503, -0.3918173747, -0.3777709259,  &
       -0.3628743247, -0.3473129364, -0.331271622, -0.3149308485,  &
       -0.2984629643, -0.2820287363, -0.2657742371, -0.2498281567,  &
       -0.2342995997, -0.2192764167, -0.2048240975, -0.1909852463,  &
       -0.1777796358, -0.1652048302, -0.1532373473, -0.1418343211,  &
       -0.130935614, -0.1204663175, -0.110339572, -0.1004596285,  &
       -9.0725078289E-02, -8.1032137768E-02, -7.1278014675E-02,  &
       -6.1363855999E-02, -5.1198759437E-02, -4.0698955283E-02,  &
       -2.9803821576E-02, -1.842759984E-02, -6.6493743087E-03,  &
       5.98801723E-03, 1.7855432431E-02, 3.5020538338E-02, 3.4733470339E-02,  &
       0.1016972512, 5.9605406613E-02, 5.2922453292E-02, 0.1306173175,  &
       0.1120800854, 0.1586211416, 8.7274498953E-02, 0.1055206311,  &
       0.2878117002, 0.224447415, 0.1665644649, 0.2324695512, 0.2335709649,  &
       0.2389834464, 0.2480879435, 0.2601469575, 0.2673163691, 0.2745157612,  &
       0.2804121715, 0.2853669065, 0.2893025382, 0.2922729168, 0.2943093959,  &
       0.2954606866, 0.2957804403, 0.2953286034, 0.2941689924, 0.292367879,  &
       0.289992357, 0.287108861, 0.2837817785, 0.2800722064, 0.2760368715,  &
       0.2717272353, 0.2671887947, 0.2624605892, 0.2575749123, 0.2525572304,  &
       0.2474262819, 0.2421944041, 0.2368678465, 0.2314478829, 0.2259295813,  &
       0.2203098424, 0.2145612495, 0.2087337786  &
   linear_extrapolate = no
!
!--------------------------------- Materials ----------------------------------!
!
!
material create  &
   material_name = .MODEL_309394_4mm.steel  &
   adams_id = 9  &
   density = 7801.0  &
   youngs_modulus = 2.07E+11  &
   poissons_ratio = 0.29
!
material create  &
   material_name = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy  &
   adams_id = 2  &
   density = 1510.0  &
   orthotropic_constants = 1.23611E+10, 2.7443E+10, 2.8949E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_UD_230GPa_prepreg  &
   adams_id = 3  &
   density = 1490.0  &
   orthotropic_constants = 1.21E+11, 4.7E+09, 4.7E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_UD_230GPa_wet  &
   adams_id = 4  &
   density = 1518.0  &
   orthotropic_constants = 1.2334E+11, 5.0E+09, 5.0E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_UD_395GPa_prepreg  &
   adams_id = 5  &
   density = 1540.0  &
   orthotropic_constants = 2.09E+11, 5.5E+09, 5.5E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_Woven_230GPa_prepreg  &
   adams_id = 6  &
   density = 1420.0  &
   orthotropic_constants = 6.134E+10, 3.3E+09, 2.7E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_Woven_230GPa_wet  &
   adams_id = 7  &
   density = 1451.0  &
   orthotropic_constants = 5.916E+10, 3.3E+09, 2.7E+09
!
material create  &
   material_name = .MODEL_309394_4mm.Epoxy_Carbon_Woven_390GPa_prepreg  &
   adams_id = 8  &
   density = 1480.0  &
   orthotropic_constants = 9.182E+10, 3.6E+09, 3.0E+09
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!----------------------------------- ground -----------------------------------!
!
!
! ****** Ground Part ******
!
defaults model  &
   part_name = ground
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.ground.MARKER_12  &
   adams_id = 12  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.ground.MARKER_341  &
   adams_id = 341  &
   location = -5.0E-02, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.ground.MARKER_349  &
   adams_id = 349  &
   location = 128.3235337289, 85.2499998051, 0.0  &
   orientation = 114.893372929d, 33.2313103356d, 241.8218914606d
!
marker create  &
   marker_name = .MODEL_309394_4mm.ground.MARKER_351  &
   adams_id = 351  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.ground.MARKER_354  &
   adams_id = 354  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
! ****** Floating Markers for current part ******
!
floating_marker create  &
   floating_marker_name = .MODEL_309394_4mm.ground.FMARKER_352  &
   adams_id = 352
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.ground  &
   material_type = .MODEL_309394_4mm.steel
!
part attributes  &
   part_name = .MODEL_309394_4mm.ground  &
   name_visibility = off
!
!--------------------------------- pentagon1 ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon1  &
   adams_id = 2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon1
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_1  &
   adams_id = 1  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_2  &
   adams_id = 2  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_3  &
   adams_id = 3  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_4  &
   adams_id = 4  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_5  &
   adams_id = 5  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.cm_primo  &
   adams_id = 16  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_13  &
   adams_id = 13  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_14  &
   adams_id = 14  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_114  &
   adams_id = 114  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_172  &
   adams_id = 172  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_244  &
   adams_id = 244  &
   location = 0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 342.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_318  &
   adams_id = 318  &
   location = -0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 18.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.cm  &
   adams_id = 330  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_350  &
   adams_id = 350  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_343  &
   adams_id = 343  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_344  &
   adams_id = 344  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_345  &
   adams_id = 345  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_346  &
   adams_id = 346  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_347  &
   adams_id = 347  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 90.0d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_348  &
   adams_id = 348  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 90.0d, 90.0d, 270.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_372  &
   adams_id = 372  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_380  &
   adams_id = 380  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_384  &
   adams_id = 384  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_395  &
   adams_id = 395  &
   location = 0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 342.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_407  &
   adams_id = 407  &
   location = -0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 18.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon1  &
   mass = 1.0543157881  &
   center_of_mass_marker = .MODEL_309394_4mm.pentagon1.cm  &
   ixx = 1.1914949503E-02  &
   iyy = 5.9662607175E-03  &
   izz = 5.9662607157E-03  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon1.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon1.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon1.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon1.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon1.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon1  &
   color = BLUE_GRAY  &
   name_visibility = off
!
!---------------------------------- exagon1 -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon1  &
   adams_id = 3  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon1
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_6  &
   adams_id = 6  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_7  &
   adams_id = 7  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_8  &
   adams_id = 8  &
   location = 0.3445124904, 0.2715586319, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_9  &
   adams_id = 9  &
   location = 0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_10  &
   adams_id = 10  &
   location = 0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_11  &
   adams_id = 11  &
   location = 2.0905692654E-02, 0.5066727328, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.cm  &
   adams_id = 17  &
   location = 0.1827090915, 0.3891156823, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_15  &
   adams_id = 15  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_57  &
   adams_id = 57  &
   location = 0.2845164836, 0.5292415362, 2.0E-03  &
   orientation = 54.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_59  &
   adams_id = 59  &
   location = 0.1122602384, 0.5473463971, 5.0E-03  &
   orientation = 294.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_356  &
   adams_id = 356  &
   location = 0.2845164836, 0.5292415362, 5.0E-03  &
   orientation = 54.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_371  &
   adams_id = 371  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_374  &
   adams_id = 374  &
   location = 0.1122602384, 0.5473463971, 5.0E-03  &
   orientation = 294.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon1  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1.PLATE_2  &
   marker_name = .MODEL_309394_4mm.exagon1.MARKER_6,  &
                 .MODEL_309394_4mm.exagon1.MARKER_7,  &
                 .MODEL_309394_4mm.exagon1.MARKER_8,  &
                 .MODEL_309394_4mm.exagon1.MARKER_9,  &
                 .MODEL_309394_4mm.exagon1.MARKER_10,  &
                 .MODEL_309394_4mm.exagon1.MARKER_11  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon1  &
   color = RED  &
   name_visibility = off
!
!--------------------------------- pentagon2 ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon2  &
   adams_id = 4  &
   location = 0.1122602384, 0.5473463971, 0.0  &
   orientation = 24.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon2
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_18  &
   adams_id = 18  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_19  &
   adams_id = 19  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_20  &
   adams_id = 20  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_21  &
   adams_id = 21  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_22  &
   adams_id = 22  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.cm  &
   adams_id = 51  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_60  &
   adams_id = 60  &
   location = -1.9157342379E-11, -4.3028025587E-11, 5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_61  &
   adams_id = 61  &
   location = 8.0901699456E-02, 0.2489898285, -4.0E-03  &
   orientation = 54.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_358  &
   adams_id = 358  &
   location = 8.0901699456E-02, 0.2489898285, -1.0E-02  &
   orientation = 54.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_373  &
   adams_id = 373  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon2  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2.PLATE_3  &
   marker_name = .MODEL_309394_4mm.pentagon2.MARKER_18,  &
                 .MODEL_309394_4mm.pentagon2.MARKER_19,  &
                 .MODEL_309394_4mm.pentagon2.MARKER_20,  &
                 .MODEL_309394_4mm.pentagon2.MARKER_21,  &
                 .MODEL_309394_4mm.pentagon2.MARKER_22  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon2  &
   color = GREEN  &
   name_visibility = off
!
!---------------------------------- exagon2 -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon2  &
   adams_id = 5  &
   location = 0.4963198825, 0.683125713, 4.0E-03  &
   orientation = 288.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon2
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_23  &
   adams_id = 23  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_24  &
   adams_id = 24  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_25  &
   adams_id = 25  &
   location = 0.3445124904, 0.2715586319, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_26  &
   adams_id = 26  &
   location = 0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_27  &
   adams_id = 27  &
   location = 0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_28  &
   adams_id = 28  &
   location = 2.0905692654E-02, 0.5066727328, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.cm  &
   adams_id = 52  &
   location = 0.1827090915, 0.3891156823, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_58  &
   adams_id = 58  &
   location = 8.0901699374E-02, 0.2489898285, 2.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_355  &
   adams_id = 355  &
   location = 8.0901699374E-02, 0.2489898285, 5.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon2  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2.PLATE_4  &
   marker_name = .MODEL_309394_4mm.exagon2.MARKER_23,  &
                 .MODEL_309394_4mm.exagon2.MARKER_24,  &
                 .MODEL_309394_4mm.exagon2.MARKER_25,  &
                 .MODEL_309394_4mm.exagon2.MARKER_26,  &
                 .MODEL_309394_4mm.exagon2.MARKER_27,  &
                 .MODEL_309394_4mm.exagon2.MARKER_28  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon2  &
   color = WHITE  &
   name_visibility = off
!
!---------------------------------- exagon3 -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon3  &
   adams_id = 6  &
   location = 0.3358670362, 1.5801301712, -8.0E-03  &
   orientation = 336.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon3
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_29  &
   adams_id = 29  &
   location = -1.2920428636E-02, 0.8285067787, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_30  &
   adams_id = 30  &
   location = 0.1827090915, 0.7869244405, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_31  &
   adams_id = 31  &
   location = 0.3165352128, 0.9355534056, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_32  &
   adams_id = 32  &
   location = 0.2547318139, 1.125764709, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_33  &
   adams_id = 33  &
   location = 5.91023129E-02, 1.167347047, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_34  &
   adams_id = 34  &
   location = -7.472382751E-02, 1.018718082, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.cm  &
   adams_id = 53  &
   location = 0.1209056941, 0.9771357425, 0.0  &
   orientation = 314.3855768881d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_62  &
   adams_id = 62  &
   location = 8.4894331438E-02, 0.8077156096, -4.0E-03  &
   orientation = 78.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_63  &
   adams_id = 63  &
   location = 0.1569170538, 1.146555878, 2.0E-03  &
   orientation = 78.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_65  &
   adams_id = 65  &
   location = -7.8107669167E-03, 1.093032565, -2.0E-03  &
   orientation = 318.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_357  &
   adams_id = 357  &
   location = 8.4894331438E-02, 0.8077156096, -1.0E-02  &
   orientation = 78.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_360  &
   adams_id = 360  &
   location = -7.8107669167E-03, 1.093032565, -5.0E-03  &
   orientation = 318.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_366  &
   adams_id = 366  &
   location = 0.1569170538, 1.146555878, 5.0E-03  &
   orientation = 78.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon3  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3.PLATE_5  &
   marker_name = .MODEL_309394_4mm.exagon3.MARKER_29,  &
                 .MODEL_309394_4mm.exagon3.MARKER_30,  &
                 .MODEL_309394_4mm.exagon3.MARKER_31,  &
                 .MODEL_309394_4mm.exagon3.MARKER_32,  &
                 .MODEL_309394_4mm.exagon3.MARKER_33,  &
                 .MODEL_309394_4mm.exagon3.MARKER_34  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon3  &
   color = MAIZE  &
   name_visibility = off
!
!--------------------------------- pentagon3 ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon3  &
   adams_id = 7  &
   location = -0.1158448507, 0.5847721615, -4.0E-03  &
   orientation = 288.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon3
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_35  &
   adams_id = 35  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_36  &
   adams_id = 36  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_37  &
   adams_id = 37  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_38  &
   adams_id = 38  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_39  &
   adams_id = 39  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.cm  &
   adams_id = 54  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_66  &
   adams_id = 66  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_359  &
   adams_id = 359  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon3  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon3.PLATE_6  &
   marker_name = .MODEL_309394_4mm.pentagon3.MARKER_35,  &
                 .MODEL_309394_4mm.pentagon3.MARKER_36,  &
                 .MODEL_309394_4mm.pentagon3.MARKER_37,  &
                 .MODEL_309394_4mm.pentagon3.MARKER_38,  &
                 .MODEL_309394_4mm.pentagon3.MARKER_39  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon3  &
   color = CYAN  &
   name_visibility = off
!
!---------------------------------- exagon4 -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon4  &
   adams_id = 8  &
   location = -0.1440454448, -0.6776805368, -1.2E-02  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon4
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_40  &
   adams_id = 40  &
   location = 5.91023129E-02, 1.167347047, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_41  &
   adams_id = 41  &
   location = 0.2547318139, 1.125764709, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_42  &
   adams_id = 42  &
   location = 0.3885579352, 1.274393674, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_43  &
   adams_id = 43  &
   location = 0.3267545363, 1.464604977, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_44  &
   adams_id = 44  &
   location = 0.1311250353, 1.506187316, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_45  &
   adams_id = 45  &
   location = 2.70108597E-03, 1.35755835, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.cm  &
   adams_id = 55  &
   location = 0.1943746169, 1.315729374, 0.0  &
   orientation = 170.4738571838d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_64  &
   adams_id = 64  &
   location = 0.1569170538, 1.146555878, 2.0E-03  &
   orientation = 78.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_67  &
   adams_id = 67  &
   location = 0.2289397954, 1.485396147, -2.0E-03  &
   orientation = 78.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_365  &
   adams_id = 365  &
   location = 0.1569170538, 1.146555878, 5.0E-03  &
   orientation = 78.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_364  &
   adams_id = 364  &
   location = 0.2289397954, 1.485396147, -5.0E-03  &
   orientation = 78.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon4  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4.PLATE_7  &
   marker_name = .MODEL_309394_4mm.exagon4.MARKER_40,  &
                 .MODEL_309394_4mm.exagon4.MARKER_41,  &
                 .MODEL_309394_4mm.exagon4.MARKER_42,  &
                 .MODEL_309394_4mm.exagon4.MARKER_43,  &
                 .MODEL_309394_4mm.exagon4.MARKER_44,  &
                 .MODEL_309394_4mm.exagon4.MARKER_45  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon4  &
   color = YELLOW  &
   name_visibility = off
!
!--------------------------------- pentagon4 ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon4  &
   adams_id = 9  &
   location = 8.4894350591E-02, 0.8077156102, -1.6E-02  &
   orientation = 348.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon4
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_46  &
   adams_id = 46  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_47  &
   adams_id = 47  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_48  &
   adams_id = 48  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_49  &
   adams_id = 49  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_50  &
   adams_id = 50  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.cm  &
   adams_id = 56  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_68  &
   adams_id = 68  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_363  &
   adams_id = 363  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon4  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon4.PLATE_8  &
   marker_name = .MODEL_309394_4mm.pentagon4.MARKER_46,  &
                 .MODEL_309394_4mm.pentagon4.MARKER_47,  &
                 .MODEL_309394_4mm.pentagon4.MARKER_48,  &
                 .MODEL_309394_4mm.pentagon4.MARKER_49,  &
                 .MODEL_309394_4mm.pentagon4.MARKER_50  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon4  &
   color = DARK_GRAY  &
   name_visibility = off
!
!--------------------------------- exagon1_no ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon1_no  &
   adams_id = 10  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon1_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_69  &
   adams_id = 69  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_70  &
   adams_id = 70  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_71  &
   adams_id = 71  &
   location = -2.0905692654E-02, 0.5066727328, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_72  &
   adams_id = 72  &
   location = -0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_73  &
   adams_id = 73  &
   location = -0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_74  &
   adams_id = 74  &
   location = -0.3445124904, 0.2715586319, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.cm  &
   adams_id = 75  &
   location = -0.1827090915, 0.3891156823, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_90  &
   adams_id = 90  &
   location = -0.3549653367, 0.3710108214, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_113  &
   adams_id = 113  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_116  &
   adams_id = 116  &
   location = -0.3549653367, 0.3710108214, 0.0  &
   orientation = 6.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_122  &
   adams_id = 122  &
   location = -0.2845164836, 0.5292415362, 2.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_368  &
   adams_id = 368  &
   location = -0.2845164836, 0.5292415362, 5.0E-03  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_379  &
   adams_id = 379  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_382  &
   adams_id = 382  &
   location = -0.3549653367, 0.3710108214, 0.0  &
   orientation = 6.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon1_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_no.PLATE_9  &
   marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_69,  &
                 .MODEL_309394_4mm.exagon1_no.MARKER_70,  &
                 .MODEL_309394_4mm.exagon1_no.MARKER_71,  &
                 .MODEL_309394_4mm.exagon1_no.MARKER_72,  &
                 .MODEL_309394_4mm.exagon1_no.MARKER_73,  &
                 .MODEL_309394_4mm.exagon1_no.MARKER_74  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon1_no  &
   color = RED  &
   name_visibility = off
!
!--------------------------------- exagon2_no ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon2_no  &
   adams_id = 11  &
   location = -0.6999346667, 0.9633774207, 4.0E-03  &
   orientation = 72.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon2_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_76  &
   adams_id = 76  &
   location = -0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_77  &
   adams_id = 77  &
   location = -0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_78  &
   adams_id = 78  &
   location = -0.2245204768, 0.7869244405, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_79  &
   adams_id = 79  &
   location = -0.4072295684, 0.8682717691, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_80  &
   adams_id = 80  &
   location = -0.5690329672, 0.7507147186, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_81  &
   adams_id = 81  &
   location = -0.5481272746, 0.5518103396, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.cm  &
   adams_id = 125  &
   location = -0.3863238757, 0.66936739, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_121  &
   adams_id = 121  &
   location = -0.2845164836, 0.5292415362, 2.0E-03  &
   orientation = 126.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_367  &
   adams_id = 367  &
   location = -0.2845164836, 0.5292415362, 5.0E-03  &
   orientation = 126.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon2_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_no.PLATE_10  &
   marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_76,  &
                 .MODEL_309394_4mm.exagon2_no.MARKER_77,  &
                 .MODEL_309394_4mm.exagon2_no.MARKER_78,  &
                 .MODEL_309394_4mm.exagon2_no.MARKER_79,  &
                 .MODEL_309394_4mm.exagon2_no.MARKER_80,  &
                 .MODEL_309394_4mm.exagon2_no.MARKER_81  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon2_no  &
   color = WHITE  &
   name_visibility = off
!
!-------------------------------- pentagon1_no --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon1_no  &
   adams_id = 12  &
   location = -0.3549653367, 0.3710108214, 0.0  &
   orientation = 96.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon1_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_18  &
   adams_id = 82  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_19  &
   adams_id = 83  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_20  &
   adams_id = 84  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_21  &
   adams_id = 85  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_22  &
   adams_id = 86  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.cm  &
   adams_id = 87  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_60  &
   adams_id = 88  &
   location = -1.9157342379E-11, -4.3028025587E-11, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_61  &
   adams_id = 89  &
   location = 8.0901699436E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_115  &
   adams_id = 115  &
   location = -1.9202861523E-11, -4.3028469676E-11, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_117  &
   adams_id = 117  &
   location = 8.0901699418E-02, 0.2489898285, -4.0E-03  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_370  &
   adams_id = 370  &
   location = 8.0901699418E-02, 0.2489898285, -1.0E-02  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_381  &
   adams_id = 381  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon1_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_no.PLATE_3  &
   marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_18,  &
                 .MODEL_309394_4mm.pentagon1_no.MARKER_19,  &
                 .MODEL_309394_4mm.pentagon1_no.MARKER_20,  &
                 .MODEL_309394_4mm.pentagon1_no.MARKER_21,  &
                 .MODEL_309394_4mm.pentagon1_no.MARKER_22  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon1_no  &
   color = GREEN  &
   name_visibility = off
!
!--------------------------------- exagon3_no ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon3_no  &
   adams_id = 13  &
   location = -1.1671300696, 0.6530798768, -8.0E-03  &
   orientation = 96.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon3_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_76  &
   adams_id = 91  &
   location = -0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_77  &
   adams_id = 92  &
   location = -0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_78  &
   adams_id = 93  &
   location = -0.2245204768, 0.7869244405, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_79  &
   adams_id = 94  &
   location = -0.4072295684, 0.8682717691, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_80  &
   adams_id = 95  &
   location = -0.5690329672, 0.7507147186, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_81  &
   adams_id = 96  &
   location = -0.5481272746, 0.5518103396, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.cm  &
   adams_id = 97  &
   location = -0.3863238757, 0.66936739, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_118  &
   adams_id = 118  &
   location = -0.2845164836, 0.5292415362, -4.0E-03  &
   orientation = 306.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_120  &
   adams_id = 120  &
   location = -0.5585801155, 0.6512625411, -2.0E-03  &
   orientation = 6.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_124  &
   adams_id = 124  &
   location = -0.4881312678, 0.8094932439, 2.0E-03  &
   orientation = 306.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_369  &
   adams_id = 369  &
   location = -0.2845164836, 0.5292415362, -1.0E-02  &
   orientation = 306.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_376  &
   adams_id = 376  &
   location = -0.4881312678, 0.8094932439, 5.0E-03  &
   orientation = 306.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_378  &
   adams_id = 378  &
   location = -0.5585801155, 0.6512625411, -5.0E-03  &
   orientation = 6.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon3_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_no.PLATE_10  &
   marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_76,  &
                 .MODEL_309394_4mm.exagon3_no.MARKER_77,  &
                 .MODEL_309394_4mm.exagon3_no.MARKER_78,  &
                 .MODEL_309394_4mm.exagon3_no.MARKER_79,  &
                 .MODEL_309394_4mm.exagon3_no.MARKER_80,  &
                 .MODEL_309394_4mm.exagon3_no.MARKER_81  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon3_no  &
   color = MAIZE  &
   name_visibility = off
!
!--------------------------------- exagon4_no ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon4_no  &
   adams_id = 14  &
   location = 0.1641329809, -0.115525194, -1.2E-02  &
   orientation = 24.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon4_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_76  &
   adams_id = 98  &
   location = -0.3654181831, 0.4704630109, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_77  &
   adams_id = 99  &
   location = -0.2036147842, 0.5880200614, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_78  &
   adams_id = 100  &
   location = -0.2245204768, 0.7869244405, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_79  &
   adams_id = 101  &
   location = -0.4072295684, 0.8682717691, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_80  &
   adams_id = 102  &
   location = -0.5690329672, 0.7507147186, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_81  &
   adams_id = 103  &
   location = -0.5481272746, 0.5518103396, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.cm  &
   adams_id = 104  &
   location = -0.3863238757, 0.66936739, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_123  &
   adams_id = 123  &
   location = -0.2845164992, 0.5292415431, 2.0E-03  &
   orientation = 306.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_375  &
   adams_id = 375  &
   location = -0.2845164992, 0.5292415431, 5.0E-03  &
   orientation = 306.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon4_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_no.PLATE_10  &
   marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_76,  &
                 .MODEL_309394_4mm.exagon4_no.MARKER_77,  &
                 .MODEL_309394_4mm.exagon4_no.MARKER_78,  &
                 .MODEL_309394_4mm.exagon4_no.MARKER_79,  &
                 .MODEL_309394_4mm.exagon4_no.MARKER_80,  &
                 .MODEL_309394_4mm.exagon4_no.MARKER_81  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon4_no  &
   color = YELLOW  &
   name_visibility = off
!
!-------------------------------- pentagon2_no --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon2_no  &
   adams_id = 15  &
   location = -0.4610476918, 0.1656351943, -4.0E-03  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon2_no
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_18  &
   adams_id = 105  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_19  &
   adams_id = 106  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_20  &
   adams_id = 107  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_21  &
   adams_id = 108  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_22  &
   adams_id = 109  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.cm  &
   adams_id = 110  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_60  &
   adams_id = 111  &
   location = -1.9157342379E-11, -4.3028025587E-11, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_61  &
   adams_id = 112  &
   location = 8.0901699436E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_119  &
   adams_id = 119  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_377  &
   adams_id = 377  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon2_no  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_no.PLATE_3  &
   marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_18,  &
                 .MODEL_309394_4mm.pentagon2_no.MARKER_19,  &
                 .MODEL_309394_4mm.pentagon2_no.MARKER_20,  &
                 .MODEL_309394_4mm.pentagon2_no.MARKER_21,  &
                 .MODEL_309394_4mm.pentagon2_no.MARKER_22  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon2_no  &
   color = CYAN  &
   name_visibility = off
!
!--------------------------------- exagon1_s ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon1_s  &
   adams_id = 16  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon1_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_126  &
   adams_id = 126  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_127  &
   adams_id = 127  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_128  &
   adams_id = 128  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_129  &
   adams_id = 129  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_130  &
   adams_id = 130  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_131  &
   adams_id = 131  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.cm  &
   adams_id = 183  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_171  &
   adams_id = 171  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_174  &
   adams_id = 174  &
   location = 0.0, -0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_176  &
   adams_id = 176  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_383  &
   adams_id = 383  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_386  &
   adams_id = 386  &
   location = 0.0, -0.3464101615, 5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_388  &
   adams_id = 388  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon1_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_s.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_126,  &
                 .MODEL_309394_4mm.exagon1_s.MARKER_127,  &
                 .MODEL_309394_4mm.exagon1_s.MARKER_128,  &
                 .MODEL_309394_4mm.exagon1_s.MARKER_129,  &
                 .MODEL_309394_4mm.exagon1_s.MARKER_130,  &
                 .MODEL_309394_4mm.exagon1_s.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon1_s  &
   color = RED  &
   name_visibility = off
!
!--------------------------------- exagon2_s ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon2_s  &
   adams_id = 17  &
   location = 0.0, -0.3464101615, 4.0E-03  &
   orientation = 0.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon2_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_126  &
   adams_id = 132  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_127  &
   adams_id = 133  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_128  &
   adams_id = 134  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_129  &
   adams_id = 135  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_130  &
   adams_id = 136  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_131  &
   adams_id = 137  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.cm  &
   adams_id = 138  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_173  &
   adams_id = 173  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_385  &
   adams_id = 385  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon2_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_s.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_126,  &
                 .MODEL_309394_4mm.exagon2_s.MARKER_127,  &
                 .MODEL_309394_4mm.exagon2_s.MARKER_128,  &
                 .MODEL_309394_4mm.exagon2_s.MARKER_129,  &
                 .MODEL_309394_4mm.exagon2_s.MARKER_130,  &
                 .MODEL_309394_4mm.exagon2_s.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon2_s  &
   color = WHITE  &
   name_visibility = off
!
!-------------------------------- pentagon1_s ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon1_s  &
   adams_id = 18  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 240.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon1_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_1  &
   adams_id = 139  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_2  &
   adams_id = 140  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_3  &
   adams_id = 141  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_4  &
   adams_id = 142  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_5  &
   adams_id = 143  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.cm_primo  &
   adams_id = 144  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_13  &
   adams_id = 145  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_14  &
   adams_id = 146  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_114  &
   adams_id = 147  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_175  &
   adams_id = 175  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_178  &
   adams_id = 178  &
   location = 8.0901699485E-02, 0.2489898285, -4.0E-03  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.cm  &
   adams_id = 331  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_387  &
   adams_id = 387  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_390  &
   adams_id = 390  &
   location = 8.0901699485E-02, 0.2489898285, -1.0E-02  &
   orientation = 234.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon1_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_s.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon1_s.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon1_s.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon1_s.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon1_s.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon1_s  &
   color = GREEN  &
   name_visibility = off
!
!--------------------------------- exagon3_s ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon3_s  &
   adams_id = 19  &
   location = 0.325180667, -0.4543654623, -8.0E-03  &
   orientation = 24.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon3_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_126  &
   adams_id = 148  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_127  &
   adams_id = 149  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_128  &
   adams_id = 150  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_129  &
   adams_id = 151  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_130  &
   adams_id = 152  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_131  &
   adams_id = 153  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.cm  &
   adams_id = 154  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_177  &
   adams_id = 177  &
   location = 0.0, 0.0, -4.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_180  &
   adams_id = 180  &
   location = 0.0, -0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_182  &
   adams_id = 182  &
   location = 0.1500000001, -0.2598076212, -2.0E-03  &
   orientation = 330.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_389  &
   adams_id = 389  &
   location = 0.0, 0.0, -1.0E-02  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_392  &
   adams_id = 392  &
   location = 0.0, -0.3464101615, 5.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_394  &
   adams_id = 394  &
   location = 0.1500000001, -0.2598076212, -5.0E-03  &
   orientation = 330.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon3_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_s.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_126,  &
                 .MODEL_309394_4mm.exagon3_s.MARKER_127,  &
                 .MODEL_309394_4mm.exagon3_s.MARKER_128,  &
                 .MODEL_309394_4mm.exagon3_s.MARKER_129,  &
                 .MODEL_309394_4mm.exagon3_s.MARKER_130,  &
                 .MODEL_309394_4mm.exagon3_s.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon3_s  &
   color = MAIZE  &
   name_visibility = off
!
!--------------------------------- exagon4_s ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon4_s  &
   adams_id = 20  &
   location = 0.1842829608, -0.1379040328, -1.2E-02  &
   orientation = 24.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon4_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_126  &
   adams_id = 155  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_127  &
   adams_id = 156  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_128  &
   adams_id = 157  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_129  &
   adams_id = 158  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_130  &
   adams_id = 159  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_131  &
   adams_id = 160  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.cm  &
   adams_id = 161  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_179  &
   adams_id = 179  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_391  &
   adams_id = 391  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon4_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_s.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_126,  &
                 .MODEL_309394_4mm.exagon4_s.MARKER_127,  &
                 .MODEL_309394_4mm.exagon4_s.MARKER_128,  &
                 .MODEL_309394_4mm.exagon4_s.MARKER_129,  &
                 .MODEL_309394_4mm.exagon4_s.MARKER_130,  &
                 .MODEL_309394_4mm.exagon4_s.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon4_s  &
   color = YELLOW  &
   name_visibility = off
!
!-------------------------------- pentagon2_s ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon2_s  &
   adams_id = 21  &
   location = 0.356539206, -0.1560088937, -4.0E-03  &
   orientation = 144.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon2_s
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_1  &
   adams_id = 162  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_2  &
   adams_id = 163  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_3  &
   adams_id = 164  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_4  &
   adams_id = 165  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_5  &
   adams_id = 166  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.cm_primo  &
   adams_id = 167  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_13  &
   adams_id = 168  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_14  &
   adams_id = 169  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_114  &
   adams_id = 170  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_181  &
   adams_id = 181  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.cm  &
   adams_id = 332  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_393  &
   adams_id = 393  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon2_s  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_s.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon2_s.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon2_s.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon2_s.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon2_s.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon2_s  &
   color = CYAN  &
   name_visibility = off
!
!--------------------------------- exagon1_e ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon1_e  &
   adams_id = 22  &
   location = 0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 72.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon1_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_126  &
   adams_id = 184  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_127  &
   adams_id = 185  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_128  &
   adams_id = 186  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_129  &
   adams_id = 187  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_130  &
   adams_id = 188  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_131  &
   adams_id = 189  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.cm  &
   adams_id = 190  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_171  &
   adams_id = 191  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_174  &
   adams_id = 192  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_176  &
   adams_id = 193  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_245  &
   adams_id = 245  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_247  &
   adams_id = 247  &
   location = 0.0, -0.3464101615, 2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_249  &
   adams_id = 249  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 150.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_396  &
   adams_id = 396  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_398  &
   adams_id = 398  &
   location = 0.0, -0.3464101615, 5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_400  &
   adams_id = 400  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 150.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon1_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_e.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_126,  &
                 .MODEL_309394_4mm.exagon1_e.MARKER_127,  &
                 .MODEL_309394_4mm.exagon1_e.MARKER_128,  &
                 .MODEL_309394_4mm.exagon1_e.MARKER_129,  &
                 .MODEL_309394_4mm.exagon1_e.MARKER_130,  &
                 .MODEL_309394_4mm.exagon1_e.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon1_e  &
   color = RED  &
   name_visibility = off
!
!--------------------------------- exagon2_e ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon2_e  &
   adams_id = 23  &
   location = 0.4603573408, -1.1940975298E-02, 4.0E-03  &
   orientation = 72.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon2_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_126  &
   adams_id = 194  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_127  &
   adams_id = 195  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_128  &
   adams_id = 196  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_129  &
   adams_id = 197  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_130  &
   adams_id = 198  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_131  &
   adams_id = 199  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.cm  &
   adams_id = 200  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_171  &
   adams_id = 201  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_174  &
   adams_id = 202  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_176  &
   adams_id = 203  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_246  &
   adams_id = 246  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 270.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_397  &
   adams_id = 397  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 270.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon2_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_e.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_126,  &
                 .MODEL_309394_4mm.exagon2_e.MARKER_127,  &
                 .MODEL_309394_4mm.exagon2_e.MARKER_128,  &
                 .MODEL_309394_4mm.exagon2_e.MARKER_129,  &
                 .MODEL_309394_4mm.exagon2_e.MARKER_130,  &
                 .MODEL_309394_4mm.exagon2_e.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon2_e  &
   color = WHITE  &
   name_visibility = off
!
!-------------------------------- pentagon1_e ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon1_e  &
   adams_id = 24  &
   location = 0.4243459797, 0.1574791589, 0.0  &
   orientation = 312.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon1_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_1  &
   adams_id = 204  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_2  &
   adams_id = 205  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_3  &
   adams_id = 206  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_4  &
   adams_id = 207  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_5  &
   adams_id = 208  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.cm_primo  &
   adams_id = 209  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_13  &
   adams_id = 210  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_14  &
   adams_id = 211  &
   location = 8.0901699437E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_114  &
   adams_id = 212  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_172  &
   adams_id = 213  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_248  &
   adams_id = 248  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_251  &
   adams_id = 251  &
   location = 8.0901699415E-02, 0.2489898285, -4.0E-03  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.cm  &
   adams_id = 333  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_399  &
   adams_id = 399  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_402  &
   adams_id = 402  &
   location = 8.0901699415E-02, 0.2489898285, -1.0E-02  &
   orientation = 54.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon1_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_e.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon1_e.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon1_e.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon1_e.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon1_e.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon1_e  &
   color = GREEN  &
   name_visibility = off
!
!--------------------------------- exagon3_e ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon3_e  &
   adams_id = 25  &
   location = 0.6635152855, 0.2639641945, -8.0E-03  &
   orientation = 96.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon3_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_126  &
   adams_id = 214  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_127  &
   adams_id = 215  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_128  &
   adams_id = 216  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_129  &
   adams_id = 217  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_130  &
   adams_id = 218  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_131  &
   adams_id = 219  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.cm  &
   adams_id = 220  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_171  &
   adams_id = 221  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_174  &
   adams_id = 222  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_176  &
   adams_id = 223  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_250  &
   adams_id = 250  &
   location = 0.0, 0.0, -4.0E-03  &
   orientation = 270.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_253  &
   adams_id = 253  &
   location = 4.2730347038E-11, -0.3464101615, 2.0E-03  &
   orientation = 270.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_255  &
   adams_id = 255  &
   location = 0.15, -0.2598076212, -2.0E-03  &
   orientation = 150.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_401  &
   adams_id = 401  &
   location = 0.0, 0.0, -1.0E-02  &
   orientation = 270.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_404  &
   adams_id = 404  &
   location = 4.2730347038E-11, -0.3464101615, 5.0E-03  &
   orientation = 270.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_406  &
   adams_id = 406  &
   location = 0.15, -0.2598076212, -5.0E-03  &
   orientation = 150.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon3_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_e.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_126,  &
                 .MODEL_309394_4mm.exagon3_e.MARKER_127,  &
                 .MODEL_309394_4mm.exagon3_e.MARKER_128,  &
                 .MODEL_309394_4mm.exagon3_e.MARKER_129,  &
                 .MODEL_309394_4mm.exagon3_e.MARKER_130,  &
                 .MODEL_309394_4mm.exagon3_e.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon3_e  &
   color = MAIZE  &
   name_visibility = off
!
!--------------------------------- exagon4_e ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon4_e  &
   adams_id = 26  &
   location = 0.3190027952, 0.2277544726, -1.2E-02  &
   orientation = 96.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon4_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_126  &
   adams_id = 224  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_127  &
   adams_id = 225  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_128  &
   adams_id = 226  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_129  &
   adams_id = 227  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_130  &
   adams_id = 228  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_131  &
   adams_id = 229  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.cm  &
   adams_id = 230  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_171  &
   adams_id = 231  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_174  &
   adams_id = 232  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_176  &
   adams_id = 233  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_252  &
   adams_id = 252  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_403  &
   adams_id = 403  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon4_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_e.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_126,  &
                 .MODEL_309394_4mm.exagon4_e.MARKER_127,  &
                 .MODEL_309394_4mm.exagon4_e.MARKER_128,  &
                 .MODEL_309394_4mm.exagon4_e.MARKER_129,  &
                 .MODEL_309394_4mm.exagon4_e.MARKER_130,  &
                 .MODEL_309394_4mm.exagon4_e.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon4_e  &
   color = YELLOW  &
   name_visibility = off
!
!-------------------------------- pentagon2_e ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon2_e  &
   adams_id = 27  &
   location = 0.3894516482, 0.3859851874, -4.0E-03  &
   orientation = 216.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon2_e
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_1  &
   adams_id = 234  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_2  &
   adams_id = 235  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_3  &
   adams_id = 236  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_4  &
   adams_id = 237  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_5  &
   adams_id = 238  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.cm_primo  &
   adams_id = 239  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_13  &
   adams_id = 240  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_14  &
   adams_id = 241  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_114  &
   adams_id = 242  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_172  &
   adams_id = 243  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_254  &
   adams_id = 254  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.cm  &
   adams_id = 334  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_405  &
   adams_id = 405  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon2_e  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_e.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon2_e.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon2_e.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon2_e.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon2_e.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon2_e  &
   color = CYAN  &
   name_visibility = off
!
!--------------------------------- exagon1_so ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon1_so  &
   adams_id = 28  &
   location = -0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 288.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon1_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_126  &
   adams_id = 256  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_127  &
   adams_id = 257  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_128  &
   adams_id = 258  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_129  &
   adams_id = 259  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_130  &
   adams_id = 260  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_131  &
   adams_id = 261  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.cm  &
   adams_id = 262  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_171  &
   adams_id = 263  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_174  &
   adams_id = 264  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_176  &
   adams_id = 265  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_319  &
   adams_id = 319  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_320  &
   adams_id = 320  &
   location = 0.0, -0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_322  &
   adams_id = 322  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 150.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_408  &
   adams_id = 408  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_409  &
   adams_id = 409  &
   location = 0.0, -0.3464101615, 5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_411  &
   adams_id = 411  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 150.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon1_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_so.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_126,  &
                 .MODEL_309394_4mm.exagon1_so.MARKER_127,  &
                 .MODEL_309394_4mm.exagon1_so.MARKER_128,  &
                 .MODEL_309394_4mm.exagon1_so.MARKER_129,  &
                 .MODEL_309394_4mm.exagon1_so.MARKER_130,  &
                 .MODEL_309394_4mm.exagon1_so.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon1_so  &
   color = RED  &
   name_visibility = off
!
!--------------------------------- exagon2_so ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon2_so  &
   adams_id = 29  &
   location = -0.4603573408, -1.1940975298E-02, 4.0E-03  &
   orientation = 288.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon2_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_126  &
   adams_id = 266  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_127  &
   adams_id = 267  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_128  &
   adams_id = 268  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_129  &
   adams_id = 269  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_130  &
   adams_id = 270  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_131  &
   adams_id = 271  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.cm  &
   adams_id = 272  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_171  &
   adams_id = 273  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_174  &
   adams_id = 274  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_176  &
   adams_id = 275  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_321  &
   adams_id = 321  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_410  &
   adams_id = 410  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon2_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_so.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_126,  &
                 .MODEL_309394_4mm.exagon2_so.MARKER_127,  &
                 .MODEL_309394_4mm.exagon2_so.MARKER_128,  &
                 .MODEL_309394_4mm.exagon2_so.MARKER_129,  &
                 .MODEL_309394_4mm.exagon2_so.MARKER_130,  &
                 .MODEL_309394_4mm.exagon2_so.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon2_so  &
   color = WHITE  &
   name_visibility = off
!
!-------------------------------- pentagon1_so --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon1_so  &
   adams_id = 30  &
   location = -0.3316408814, -0.127837796, 0.0  &
   orientation = 168.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon1_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_1  &
   adams_id = 276  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_2  &
   adams_id = 277  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_3  &
   adams_id = 278  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_4  &
   adams_id = 279  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_5  &
   adams_id = 280  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.cm_primo  &
   adams_id = 281  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_13  &
   adams_id = 282  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_14  &
   adams_id = 283  &
   location = 8.0901699438E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_114  &
   adams_id = 284  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_172  &
   adams_id = 285  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_244  &
   adams_id = 286  &
   location = 0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 342.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_323  &
   adams_id = 323  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_324  &
   adams_id = 324  &
   location = 8.0901699406E-02, 0.2489898285, -4.0E-03  &
   orientation = 234.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.cm  &
   adams_id = 335  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_412  &
   adams_id = 412  &
   location = 0.0, 0.0, 0.0  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_413  &
   adams_id = 413  &
   location = 8.0901699406E-02, 0.2489898285, -1.0E-02  &
   orientation = 234.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon1_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_so.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon1_so.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon1_so.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon1_so.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon1_so.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon1_so  &
   color = GREEN  &
   name_visibility = off
!
!--------------------------------- exagon3_so ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon3_so  &
   adams_id = 31  &
   location = -0.4625425808, -0.3545661902, -8.0E-03  &
   orientation = 312.0d, 180.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon3_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_126  &
   adams_id = 287  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_127  &
   adams_id = 288  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_128  &
   adams_id = 289  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_129  &
   adams_id = 290  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_130  &
   adams_id = 291  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_131  &
   adams_id = 292  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.cm  &
   adams_id = 293  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_171  &
   adams_id = 294  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_174  &
   adams_id = 295  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_176  &
   adams_id = 296  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_325  &
   adams_id = 325  &
   location = 0.0, 0.0, -4.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_326  &
   adams_id = 326  &
   location = 0.0, -0.3464101615, 2.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_328  &
   adams_id = 328  &
   location = 0.15, -0.2598076212, -2.0E-03  &
   orientation = 150.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_414  &
   adams_id = 414  &
   location = 0.0, 0.0, -1.0E-02  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_415  &
   adams_id = 415  &
   location = 0.0, -0.3464101615, 5.0E-03  &
   orientation = 90.0d, 90.0d, 180.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_417  &
   adams_id = 417  &
   location = 0.15, -0.2598076212, -5.0E-03  &
   orientation = 150.0d, 90.0d, 180.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon3_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_so.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_126,  &
                 .MODEL_309394_4mm.exagon3_so.MARKER_127,  &
                 .MODEL_309394_4mm.exagon3_so.MARKER_128,  &
                 .MODEL_309394_4mm.exagon3_so.MARKER_129,  &
                 .MODEL_309394_4mm.exagon3_so.MARKER_130,  &
                 .MODEL_309394_4mm.exagon3_so.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon3_so  &
   color = MAIZE  &
   name_visibility = off
!
!--------------------------------- exagon4_so ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.exagon4_so  &
   adams_id = 32  &
   location = -0.2051096618, -0.1227725488, -1.2E-02  &
   orientation = 312.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.exagon4_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_126  &
   adams_id = 297  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_127  &
   adams_id = 298  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_128  &
   adams_id = 299  &
   location = 0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_129  &
   adams_id = 300  &
   location = 0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_130  &
   adams_id = 301  &
   location = -0.1, -0.3464101615, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_131  &
   adams_id = 302  &
   location = -0.2, -0.1732050808, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.cm  &
   adams_id = 303  &
   location = 0.0, -0.1732050808, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_171  &
   adams_id = 304  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_174  &
   adams_id = 305  &
   location = 0.0, -0.3464101615, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_176  &
   adams_id = 306  &
   location = 0.15, -0.2598076212, 0.0  &
   orientation = 330.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_327  &
   adams_id = 327  &
   location = 0.0, 0.0, 2.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_416  &
   adams_id = 416  &
   location = 0.0, 0.0, 5.0E-03  &
   orientation = 90.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.exagon4_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_so.PLATE_17  &
   marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_126,  &
                 .MODEL_309394_4mm.exagon4_so.MARKER_127,  &
                 .MODEL_309394_4mm.exagon4_so.MARKER_128,  &
                 .MODEL_309394_4mm.exagon4_so.MARKER_129,  &
                 .MODEL_309394_4mm.exagon4_so.MARKER_130,  &
                 .MODEL_309394_4mm.exagon4_so.MARKER_131  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.exagon4_so  &
   color = YELLOW  &
   name_visibility = off
!
!-------------------------------- pentagon2_so --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.pentagon2_so  &
   adams_id = 33  &
   location = -0.1690983006, -0.292192683, -4.0E-03  &
   orientation = 72.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.pentagon2_so
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_1  &
   adams_id = 307  &
   location = -0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_2  &
   adams_id = 308  &
   location = 0.1, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_3  &
   adams_id = 309  &
   location = 0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_4  &
   adams_id = 310  &
   location = 0.0, 0.3077683537, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_5  &
   adams_id = 311  &
   location = -0.1618033989, 0.1902113033, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.cm_primo  &
   adams_id = 312  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_13  &
   adams_id = 313  &
   location = 0.0, 0.137638192, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_14  &
   adams_id = 314  &
   location = 8.0901699437E-02, 0.2489898285, 0.0  &
   orientation = 54.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_114  &
   adams_id = 315  &
   location = -8.090169943E-02, 0.2489898285, 0.0  &
   orientation = 126.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_172  &
   adams_id = 316  &
   location = 0.0, 0.0, 0.0  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_244  &
   adams_id = 317  &
   location = 0.1309016994, 9.510565163E-02, 0.0  &
   orientation = 342.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_329  &
   adams_id = 329  &
   location = 0.0, 0.0, -2.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.cm  &
   adams_id = 336  &
   location = 0.0, 0.1376381921, 0.0  &
   orientation = 270.0d, 90.0d, 90.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_418  &
   adams_id = 418  &
   location = 0.0, 0.0, -5.0E-03  &
   orientation = 270.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.pentagon2_so  &
   material_type = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy
!
! ****** Graphics for current part ******
!
geometry create shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_so.PLATE_1  &
   marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_1,  &
                 .MODEL_309394_4mm.pentagon2_so.MARKER_2,  &
                 .MODEL_309394_4mm.pentagon2_so.MARKER_3,  &
                 .MODEL_309394_4mm.pentagon2_so.MARKER_4,  &
                 .MODEL_309394_4mm.pentagon2_so.MARKER_5  &
   width = 4.0E-03  &
   radius = 1.0E-03
!
part attributes  &
   part_name = .MODEL_309394_4mm.pentagon2_so  &
   color = CYAN  &
   name_visibility = off
!
!----------------------------------- Target -----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
part create rigid_body name_and_position  &
   part_name = .MODEL_309394_4mm.Target  &
   adams_id = 34  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body initial_velocity  &
   part_name = .MODEL_309394_4mm.Target  &
   vx = -0.2  &
   vy = -0.1  &
   vz = 0.5  &
   wx = 10.0  &
   wy = 10.0  &
   wz = 10.0
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.Target
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .MODEL_309394_4mm.Target.MARKER_337  &
   adams_id = 337  &
   location = -1.125, 1.0, 20.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .MODEL_309394_4mm.Target.cm  &
   adams_id = 340  &
   location = -1.0, 1.125, 20.125  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .MODEL_309394_4mm.Target.cm  &
   color = BLUE
!
marker create  &
   marker_name = .MODEL_309394_4mm.Target.MARKER_353  &
   adams_id = 353  &
   location = -1.0, 1.125, 20.125  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .MODEL_309394_4mm.Target  &
   mass = 20.78125  &
   center_of_mass_marker = .MODEL_309394_4mm.Target.cm  &
   ixx = 0.2164713542  &
   iyy = 0.2164713542  &
   izz = 0.2164713542  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape block  &
   block_name = .MODEL_309394_4mm.Target.BOX_33  &
   adams_id = 33  &
   corner_marker = .MODEL_309394_4mm.Target.MARKER_337  &
   diag_corner_coords = 0.25, 0.25, 0.25
!
part attributes  &
   part_name = .MODEL_309394_4mm.Target  &
   color = RED  &
   name_visibility = off
!
!---------------------------------- Contacts ----------------------------------!
!
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_1  &
   adams_id = 1  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon1.PLATE_2  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_1  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_2  &
   adams_id = 2  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon1_e.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_2  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_3  &
   adams_id = 3  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon1_no.PLATE_9  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_3  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_4  &
   adams_id = 4  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon1_s.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_4  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_5  &
   adams_id = 5  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon1_so.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_5  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_6  &
   adams_id = 6  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon2.PLATE_4  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_6  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_7  &
   adams_id = 7  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon2_e.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_7  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_8  &
   adams_id = 8  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon2_no.PLATE_10  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_8  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_9  &
   adams_id = 9  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon2_s.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_9  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_10  &
   adams_id = 10  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon2_so.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_10  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_11  &
   adams_id = 11  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon3.PLATE_5  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_11  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_12  &
   adams_id = 12  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon3_e.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_12  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_13  &
   adams_id = 13  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon3_no.PLATE_10  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_13  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_14  &
   adams_id = 14  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon3_s.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_14  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_15  &
   adams_id = 15  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon3_so.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_15  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_16  &
   adams_id = 16  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon4.PLATE_7  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_16  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_17  &
   adams_id = 17  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon4_e.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_17  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_18  &
   adams_id = 18  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon4_no.PLATE_10  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_18  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_19  &
   adams_id = 19  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon4_s.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_19  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_20  &
   adams_id = 20  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.exagon4_so.PLATE_17  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_20  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_21  &
   adams_id = 21  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon1.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_21  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_22  &
   adams_id = 22  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon1_e.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_22  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_23  &
   adams_id = 23  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon1_no.PLATE_3  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_23  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_24  &
   adams_id = 24  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon1_s.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_24  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_25  &
   adams_id = 25  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon1_so.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_25  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_26  &
   adams_id = 26  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon2.PLATE_3  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_26  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_27  &
   adams_id = 27  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon2_e.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_27  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_28  &
   adams_id = 28  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon2_no.PLATE_3  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_28  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_29  &
   adams_id = 29  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon2_s.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_29  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_30  &
   adams_id = 30  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon2_so.PLATE_1  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_30  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_31  &
   adams_id = 31  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon3.PLATE_6  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_31  &
   visibility = off
!
contact create  &
   contact_name = .MODEL_309394_4mm.CONTACT_32  &
   adams_id = 32  &
   type = solid_to_solid  &
   i_geometry_name = .MODEL_309394_4mm.Target.BOX_33  &
   j_geometry_name = .MODEL_309394_4mm.pentagon4.PLATE_8  &
   stiffness = 3.5E+07  &
   damping = 2.8E+04  &
   exponent = 1.5  &
   dmax = 1.0E-04  &
   coulomb_friction = off  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   stiction_transition_velocity = 1.0E-04  &
   friction_transition_velocity = 1.0E-02
!
force attributes  &
   force_name = .MODEL_309394_4mm.CONTACT_32  &
   visibility = off
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint fixed  &
   joint_name = .MODEL_309394_4mm.JOINT_1  &
   adams_id = 1  &
   i_marker_name = .MODEL_309394_4mm.ground.MARKER_12  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_13
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_1  &
   active = off  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1  &
   adams_id = 2  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_14  &
   j_marker_name = .MODEL_309394_4mm.exagon1.MARKER_15
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1_e1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_e2  &
   adams_id = 3  &
   i_marker_name = .MODEL_309394_4mm.exagon1.MARKER_57  &
   j_marker_name = .MODEL_309394_4mm.exagon2.MARKER_58
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1_e2  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_p2  &
   adams_id = 4  &
   i_marker_name = .MODEL_309394_4mm.exagon1.MARKER_59  &
   j_marker_name = .MODEL_309394_4mm.pentagon2.MARKER_60
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1_p2  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p2_e3  &
   adams_id = 5  &
   i_marker_name = .MODEL_309394_4mm.pentagon2.MARKER_61  &
   j_marker_name = .MODEL_309394_4mm.exagon3.MARKER_62
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p2_e3  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_e4  &
   adams_id = 6  &
   i_marker_name = .MODEL_309394_4mm.exagon3.MARKER_63  &
   j_marker_name = .MODEL_309394_4mm.exagon4.MARKER_64
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3_e4  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_p3  &
   adams_id = 7  &
   i_marker_name = .MODEL_309394_4mm.exagon3.MARKER_65  &
   j_marker_name = .MODEL_309394_4mm.pentagon3.MARKER_66
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3_p3  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e4_p4  &
   adams_id = 8  &
   i_marker_name = .MODEL_309394_4mm.exagon4.MARKER_67  &
   j_marker_name = .MODEL_309394_4mm.pentagon4.MARKER_68
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e4_p4  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1no_p1  &
   adams_id = 9  &
   i_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_113  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_114
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1no_p1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   adams_id = 10  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_115  &
   j_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_116
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   adams_id = 11  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_117  &
   j_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_118
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   adams_id = 12  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_119  &
   j_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_120
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   adams_id = 13  &
   i_marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_121  &
   j_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_122
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   adams_id = 14  &
   i_marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_123  &
   j_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_124
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1s_p1  &
   adams_id = 15  &
   i_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_171  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_172
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1s_p1  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   adams_id = 16  &
   i_marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_173  &
   j_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_174
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   adams_id = 17  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_175  &
   j_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_176
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   adams_id = 18  &
   i_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_177  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_178
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   adams_id = 19  &
   i_marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_179  &
   j_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_180
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   adams_id = 20  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_181  &
   j_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_182
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1e  &
   adams_id = 21  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_244  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_245
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   adams_id = 22  &
   i_marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_246  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_247
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   adams_id = 23  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_248  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_249
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   adams_id = 24  &
   i_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_250  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_251
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   adams_id = 25  &
   i_marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_252  &
   j_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_253
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   adams_id = 26  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_254  &
   j_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_255
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1so  &
   adams_id = 27  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_318  &
   j_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_319
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1_e1so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   adams_id = 28  &
   i_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_320  &
   j_marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_321
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   adams_id = 29  &
   i_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_322  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_323
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   adams_id = 30  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_324  &
   j_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_325
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   adams_id = 31  &
   i_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_326  &
   j_marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_327
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   adams_id = 32  &
   i_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_328  &
   j_marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_329
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_32  &
   adams_id = 32  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_e2  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_32  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_2  &
   adams_id = 2  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_2  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_3  &
   adams_id = 3  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_p2  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_3  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_4  &
   adams_id = 4  &
   joint_name = .MODEL_309394_4mm.JOINT_p2_e3  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_4  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_5  &
   adams_id = 5  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_e4  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_5  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_6  &
   adams_id = 6  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_p3  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_6  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_7  &
   adams_id = 7  &
   joint_name = .MODEL_309394_4mm.JOINT_e4_p4  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_7  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_8  &
   adams_id = 8  &
   joint_name = .MODEL_309394_4mm.JOINT_e1no_p1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_8  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_9  &
   adams_id = 9  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_9  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_10  &
   adams_id = 10  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_10  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_11  &
   adams_id = 11  &
   joint_name = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_11  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_12  &
   adams_id = 12  &
   joint_name = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_12  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_13  &
   adams_id = 13  &
   joint_name = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_13  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_14  &
   adams_id = 14  &
   joint_name = .MODEL_309394_4mm.JOINT_e1s_p1  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_14  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_15  &
   adams_id = 15  &
   joint_name = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_15  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_16  &
   adams_id = 16  &
   joint_name = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_16  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_17  &
   adams_id = 17  &
   joint_name = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_17  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_18  &
   adams_id = 18  &
   joint_name = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_18  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_19  &
   adams_id = 19  &
   joint_name = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_19  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_20  &
   adams_id = 20  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_20  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_21  &
   adams_id = 21  &
   joint_name = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_21  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_22  &
   adams_id = 22  &
   joint_name = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_22  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_23  &
   adams_id = 23  &
   joint_name = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_23  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_24  &
   adams_id = 24  &
   joint_name = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_24  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_25  &
   adams_id = 25  &
   joint_name = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_25  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_26  &
   adams_id = 26  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_26  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_27  &
   adams_id = 27  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_27  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_28  &
   adams_id = 28  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_28  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_29  &
   adams_id = 29  &
   joint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_29  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_30  &
   adams_id = 30  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_30  &
   visibility = off
!
force create element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_31  &
   adams_id = 31  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   mu_static = 0.25  &
   mu_dynamic = 0.2  &
   friction_arm = 1.0E-03  &
   bending_reaction_arm = 1.0E-03  &
   pin_radius = 1.0E-03  &
   formulation = original  &
   stiction_transition_velocity = 1.0E-04  &
   transition_velocity_coefficient = 1.5  &
   max_stiction_deformation = 1.0E-05  &
   friction_torque_preload = 0.0  &
   effect = all  &
   inactive_during_static = off
!
force attributes  &
   force_name = .MODEL_309394_4mm.FRICTION_31  &
   visibility = off
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_z  &
   adams_id = 1  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_343  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_344  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_y  &
   adams_id = 2  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_345  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_346  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_x  &
   adams_id = 3  &
   type_of_freedom = translational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_347  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_348  &
   action_only = on  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1_e2  &
   adams_id = 4  &
   comments = "CORREGGERE CATTURA"  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon2.MARKER_355  &
   j_marker_name = .MODEL_309394_4mm.exagon1.MARKER_356  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2_e3  &
   adams_id = 5  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3.MARKER_357  &
   j_marker_name = .MODEL_309394_4mm.pentagon2.MARKER_358  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3_p3  &
   adams_id = 6  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon3.MARKER_359  &
   j_marker_name = .MODEL_309394_4mm.exagon3.MARKER_360  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3_e4  &
   adams_id = 9  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon4.MARKER_365  &
   j_marker_name = .MODEL_309394_4mm.exagon3.MARKER_366  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4_p4  &
   adams_id = 8  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon4.MARKER_363  &
   j_marker_name = .MODEL_309394_4mm.exagon4.MARKER_364  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2no_e1no  &
   adams_id = 10  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_367  &
   j_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_368  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1no_e3no  &
   adams_id = 11  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_369  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_370  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1  &
   adams_id = 12  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon1.MARKER_371  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_372  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1_p2  &
   adams_id = 13  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon2.MARKER_373  &
   j_marker_name = .MODEL_309394_4mm.exagon1.MARKER_374  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4no_e3no  &
   adams_id = 14  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_375  &
   j_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_376  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2no_e3no  &
   adams_id = 15  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_377  &
   j_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_378  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1no_p1  &
   adams_id = 16  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_379  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_380  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1no_e1no  &
   adams_id = 17  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_381  &
   j_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_382  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1s_p1  &
   adams_id = 18  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_383  &
   j_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_384  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2s_e1s  &
   adams_id = 19  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_385  &
   j_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_386  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1s_e1s  &
   adams_id = 20  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_387  &
   j_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_388  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3s_p1s  &
   adams_id = 21  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_389  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_390  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4s_e3s  &
   adams_id = 22  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_391  &
   j_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_392  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2s_e3s  &
   adams_id = 23  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_393  &
   j_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_394  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1e  &
   adams_id = 24  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_395  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_396  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2e_e1e  &
   adams_id = 25  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_397  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_398  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1e_e1e  &
   adams_id = 26  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_399  &
   j_marker_name = .MODEL_309394_4mm.exagon1_e.MARKER_400  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3e_p1e  &
   adams_id = 27  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_401  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_402  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4e_e3e  &
   adams_id = 28  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_403  &
   j_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_404  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2e_e3e  &
   adams_id = 29  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_405  &
   j_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_406  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1so  &
   adams_id = 30  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_407  &
   j_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_408  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1so_e2so  &
   adams_id = 31  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_409  &
   j_marker_name = .MODEL_309394_4mm.exagon2_so.MARKER_410  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1so_p1so  &
   adams_id = 32  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_411  &
   j_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_412  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1so_e3so  &
   adams_id = 33  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_413  &
   j_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_414  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3so_e4so  &
   adams_id = 34  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_415  &
   j_marker_name = .MODEL_309394_4mm.exagon4_so.MARKER_416  &
   action_only = off  &
   function = ""
!
force create direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3so_p2so  &
   adams_id = 35  &
   type_of_freedom = rotational  &
   i_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_417  &
   j_marker_name = .MODEL_309394_4mm.pentagon2_so.MARKER_418  &
   action_only = off  &
   function = ""
!
force create direct torque_vector  &
   torque_vector_name = .MODEL_309394_4mm.VTORQUE_1  &
   adams_id = 1  &
   i_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_350  &
   j_floating_marker_name = .MODEL_309394_4mm.ground.FMARKER_352  &
   ref_marker_name = .MODEL_309394_4mm.ground.MARKER_351  &
   x_torque_function = ""  &
   y_torque_function = ""  &
   z_torque_function = ""
!
!---------------------------------- Sensors -----------------------------------!
!
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_z  &
   adams_id = 1  &
   compare = le  &
   value = 0.7  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_avv  &
   adams_id = 2  &
   compare = le  &
   value = 10.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp1  &
   adams_id = 3  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp2  &
   adams_id = 4  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_x_rel  &
   adams_id = 5  &
   compare = le  &
   value = 0.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_y_rel  &
   adams_id = 6  &
   compare = ge  &
   value = 0.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_z_rel  &
   adams_id = 7  &
   compare = le  &
   value = 2.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt1  &
   adams_id = 8  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt2  &
   adams_id = 9  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_e4  &
   adams_id = 10  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4no_e3no  &
   adams_id = 11  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4s_e3s  &
   adams_id = 12  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4e_e3e  &
   adams_id = 13  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_e4so  &
   adams_id = 14  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_p3  &
   adams_id = 15  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2no_e3no  &
   adams_id = 16  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2s_e3s  &
   adams_id = 17  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2e_e3e  &
   adams_id = 18  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_p2so  &
   adams_id = 19  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4_p4  &
   adams_id = 20  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1_e2_c  &
   adams_id = 21  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2no_e1no_c  &
   adams_id = 22  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2s_e1s_c  &
   adams_id = 23  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2e_e1e_c  &
   adams_id = 24  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1so_e2so_c  &
   adams_id = 25  &
   compare = ge  &
   value = 37.3  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2_e3_c  &
   adams_id = 26  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1no_e3no_c  &
   adams_id = 27  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3s_p1s_c  &
   adams_id = 28  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3e_p1e_c  &
   adams_id = 29  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1so_e3so_c  &
   adams_id = 30  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp0  &
   adams_id = 31  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp3  &
   adams_id = 32  &
   compare = ge  &
   value = 180.0  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt0  &
   adams_id = 33  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1_p2_c  &
   adams_id = 34  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1no_e1no_c  &
   adams_id = 35  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1s_e1s_c  &
   adams_id = 36  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1e_e1e_c  &
   adams_id = 37  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1so_p1so_c  &
   adams_id = 38  &
   compare = ge  &
   value = 37.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_e4_c  &
   adams_id = 39  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4no_e3no_c  &
   adams_id = 40  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4s_e3s_c  &
   adams_id = 41  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4e_e3e_c  &
   adams_id = 42  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_e4so_c  &
   adams_id = 43  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_p3_c  &
   adams_id = 44  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2no_e3no_c  &
   adams_id = 45  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2s_e3s_c  &
   adams_id = 46  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2e_e3e_c  &
   adams_id = 47  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_p2so_c  &
   adams_id = 48  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt2_1  &
   adams_id = 49  &
   compare = ge  &
   value = 138.19  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt3  &
   adams_id = 50  &
   compare = ge  &
   value = 41.81  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4_p4_c  &
   adams_id = 51  &
   compare = ge  &
   value = 41.81  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
executive_control create sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt4  &
   adams_id = 52  &
   compare = ge  &
   value = 217.38  &
   error = 0.001  &
   codgen = off  &
   halt = off  &
   print = on  &
   restart = off  &
   return = on  &
   yydump = off  &
   function = ""  &
   evaluate = ""
!
!----------------------------- Simulation Scripts -----------------------------!
!
!
simulation script create  &
   sim_script_name = .MODEL_309394_4mm.Last_Sim  &
   commands =   &
              "simulation single_run scripted sim_script_name=.MODEL_309394_4mm.SIM_SCRIPT_1 reset_before_and_after=yes model_name=.MODEL_309394_4mm"
!
simulation script create  &
   sim_script_name = .MODEL_309394_4mm.SIM_SCRIPT_1  &
   solver_commands = "! Insert ACF commands here:",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=6",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=5",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=2",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=31",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=3,10,11,12,13,14,15,16,17,18,19",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=4,20",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=32",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=7",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=1",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=33,34,35,36,37,38",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=21,22,23,24,25",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=8,26,27,28,29,30",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=9,39,40,41,42,43,44,45,46,47,48",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=49",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=50,51",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02",  &
                     "DEACTIVATE/SENSOR, ID=52",  &
                     "SIMULATE/DYNAMIC, END=250.0, DTOUT=1.0E-02"
!
!------------------------------ Dynamic Graphics ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .MODEL_309394_4mm.ground
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.JOINT_30_force_graphic_1  &
   adams_id = 1  &
   joint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_324
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.JOINT_30_force_graphic_2  &
   adams_id = 2  &
   joint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_325
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_z_force_graphic_1  &
   adams_id = 72  &
   force_element_name = .MODEL_309394_4mm.SFORCE_z  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_343
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.VTORQUE_1_force_graphic_1  &
   adams_id = 71  &
   force_element_name = .MODEL_309394_4mm.VTORQUE_1  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_350
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_4_force_graphic_1  &
   adams_id = 73  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1_e2  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon2.MARKER_355
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_5_force_graphic_1  &
   adams_id = 74  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p2_e3  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3.MARKER_357
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_6_force_graphic_1  &
   adams_id = 75  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3_p3  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon3.MARKER_359
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_9_force_graphic_1  &
   adams_id = 78  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3_e4  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon4.MARKER_365
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_7_force_graphic_2  &
   adams_id = 77  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e4_p4  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon4.MARKER_363
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_10_force_graphic_1  &
   adams_id = 79  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e2no_e1no  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon2_no.MARKER_367
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_11_force_graphic_1  &
   adams_id = 80  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1no_e3no  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_no.MARKER_369
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_12_force_graphic_1  &
   adams_id = 81  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1_e1  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon1.MARKER_371
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_12_force_graphic_2  &
   adams_id = 82  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1_p2  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon2.MARKER_373
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_14_force_graphic_1  &
   adams_id = 83  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e4no_e3no  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon4_no.MARKER_375
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_15_force_graphic_1  &
   adams_id = 84  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p2no_e3no  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon2_no.MARKER_377
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_16_force_graphic_1  &
   adams_id = 85  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1no_p1  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon1_no.MARKER_379
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_16_force_graphic_2  &
   adams_id = 86  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1no_e1no  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1_no.MARKER_381
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_1  &
   adams_id = 87  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1s_p1  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon1_s.MARKER_383
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_2  &
   adams_id = 88  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e2s_e1s  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon2_s.MARKER_385
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_3  &
   adams_id = 89  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1s_e1s  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1_s.MARKER_387
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_4  &
   adams_id = 90  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3s_p1s  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_s.MARKER_389
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_5  &
   adams_id = 91  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e4s_e3s  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon4_s.MARKER_391
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_6  &
   adams_id = 92  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p2s_e3s  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon2_s.MARKER_393
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_7  &
   adams_id = 93  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1_e1e  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_395
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_8  &
   adams_id = 94  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e2e_e1e  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon2_e.MARKER_397
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_9  &
   adams_id = 95  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1e_e1e  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1_e.MARKER_399
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_10  &
   adams_id = 96  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3e_p1e  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_e.MARKER_401
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_11  &
   adams_id = 97  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e4e_e3e  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon4_e.MARKER_403
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_12  &
   adams_id = 98  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p2e_e3e  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon2_e.MARKER_405
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_13  &
   adams_id = 99  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1_e1so  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1.MARKER_407
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_14  &
   adams_id = 100  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1so_e2so  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_409
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_15  &
   adams_id = 101  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e1so_p1so  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon1_so.MARKER_411
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_16  &
   adams_id = 102  &
   force_element_name = .MODEL_309394_4mm.SFORCE_p1so_e3so  &
   applied_at_marker_name = .MODEL_309394_4mm.pentagon1_so.MARKER_413
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_17  &
   adams_id = 103  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3so_e4so  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_415
!
geometry create shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_18  &
   adams_id = 104  &
   force_element_name = .MODEL_309394_4mm.SFORCE_e3so_p2so  &
   applied_at_marker_name = .MODEL_309394_4mm.exagon3_so.MARKER_417
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_36  &
   adams_id = 36  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_1  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_36  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_37  &
   adams_id = 37  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_2  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_37  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_38  &
   adams_id = 38  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_3  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_38  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_39  &
   adams_id = 39  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_4  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_39  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_40  &
   adams_id = 40  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_5  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_40  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_41  &
   adams_id = 41  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_6  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_41  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_42  &
   adams_id = 42  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_7  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_42  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_43  &
   adams_id = 43  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_8  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_43  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_44  &
   adams_id = 44  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_9  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_44  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_45  &
   adams_id = 45  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_10  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_45  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_46  &
   adams_id = 46  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_11  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_46  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_47  &
   adams_id = 47  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_12  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_47  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_48  &
   adams_id = 48  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_13  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_48  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_49  &
   adams_id = 49  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_14  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_49  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_50  &
   adams_id = 50  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_15  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_50  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_51  &
   adams_id = 51  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_16  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_51  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_52  &
   adams_id = 52  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_17  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_52  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_53  &
   adams_id = 53  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_18  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_53  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_54  &
   adams_id = 54  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_19  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_54  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_55  &
   adams_id = 55  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_20  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_55  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_56  &
   adams_id = 56  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_21  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_56  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_57  &
   adams_id = 57  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_22  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_57  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_58  &
   adams_id = 58  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_23  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_58  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_59  &
   adams_id = 59  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_24  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_59  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_60  &
   adams_id = 60  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_25  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_60  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_61  &
   adams_id = 61  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_26  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_61  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_62  &
   adams_id = 62  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_27  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_62  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_63  &
   adams_id = 63  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_28  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_63  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_64  &
   adams_id = 64  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_29  &
   force_display = none
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_64  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_65  &
   adams_id = 65  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_30  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_65  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_66  &
   adams_id = 66  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_31  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_66  &
   color = RED
!
geometry create shape gcontact  &
   contact_force_name = .MODEL_309394_4mm.GCONTACT_67  &
   adams_id = 67  &
   contact_element_name = .MODEL_309394_4mm.CONTACT_32  &
   force_display = components
!
geometry attributes  &
   geometry_name = .MODEL_309394_4mm.GCONTACT_67  &
   color = RED
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1  &
   adams_id = 1  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1_e1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1_e2  &
   adams_id = 2  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_e2  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1_e2  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1_p2  &
   adams_id = 3  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1_p2  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1_p2  &
   active = off  &
   visibility = on  &
   name_visibility = on
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2_e3  &
   adams_id = 4  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p2_e3  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p2_e3  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3_e4  &
   adams_id = 5  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_e4  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3_e4  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3_p3  &
   adams_id = 6  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3_p3  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3_p3  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4_p4  &
   adams_id = 7  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e4_p4  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e4_p4  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1no_p1  &
   adams_id = 8  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1no_p1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1no_p1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1no_e1no  &
   adams_id = 9  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1no_e1no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2no_e1no  &
   adams_id = 10  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e2no_e1no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1no_e3no  &
   adams_id = 11  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2no_e3no  &
   adams_id = 12  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p2no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4no_e3no  &
   adams_id = 13  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e4no_e3no  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1s_p1  &
   adams_id = 14  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1s_p1  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1s_p1  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2s_e1s  &
   adams_id = 15  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e2s_e1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1s_e1s  &
   adams_id = 16  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1s_e1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3s_p1s  &
   adams_id = 17  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3s_p1s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4s_e3s  &
   adams_id = 18  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e4s_e3s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2s_e3s  &
   adams_id = 19  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p2s_e3s  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1e  &
   adams_id = 20  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2e_e1e  &
   adams_id = 21  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e2e_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1e_e1e  &
   adams_id = 22  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1e_e1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3e_p1e  &
   adams_id = 23  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3e_p1e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4e_e3e  &
   adams_id = 24  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e4e_e3e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2e_e3e  &
   adams_id = 25  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p2e_e3e  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1so  &
   adams_id = 26  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1_e1so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1_e1so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1so_e2so  &
   adams_id = 27  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1so_e2so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1so_p1so  &
   adams_id = 28  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e1so_p1so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1so_e3so  &
   adams_id = 29  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_p1so_e3so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3so_e4so  &
   adams_id = 30  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3so_e4so  &
   active = off  &
   name_visibility = off
!
constraint create motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3so_p2so  &
   adams_id = 31  &
   type_of_freedom = rotational  &
   joint_name = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   function = ""
!
constraint attributes  &
   constraint_name = .MODEL_309394_4mm.MOTION_e3so_p2so  &
   active = off  &
   name_visibility = off
!
!----------------------------- Analysis settings ------------------------------!
!
!
!---------------------------------- Measures ----------------------------------!
!
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_x_fx  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_x  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_x_fx  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_y_fy  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_y  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_y_fy  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_z_fz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_z  &
   characteristic = element_force  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_z_fz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.VTORQUE_1_tq_x  &
   from_first = yes  &
   object = .MODEL_309394_4mm.VTORQUE_1  &
   characteristic = element_torque  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.VTORQUE_1_tq_x  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.VTORQUE_1_tq_y  &
   from_first = yes  &
   object = .MODEL_309394_4mm.VTORQUE_1  &
   characteristic = element_torque  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.VTORQUE_1_tq_y  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.VTORQUE_1_tq_z  &
   from_first = yes  &
   object = .MODEL_309394_4mm.VTORQUE_1  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.VTORQUE_1_tq_z  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.Target_acc  &
   from_first = no  &
   object = .MODEL_309394_4mm.Target  &
   characteristic = cm_acceleration  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.Target_acc  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1_e2_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1_e2  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2.MARKER_58  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1_e2_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1_e2_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1_e2  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2.MARKER_58  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1_e2_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2_e3_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2_e3  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3.MARKER_62  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2_e3_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2_e3_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2_e3  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3.MARKER_62  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2_e3_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3_e4_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3_e4  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4.MARKER_64  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3_e4_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3_e4_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3_e4  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4.MARKER_64  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3_e4_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3_p3_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3_p3  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon3.MARKER_66  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3_p3_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3_p3_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3_p3  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon3.MARKER_66  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3_p3_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4_p4_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4_p4  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon4.MARKER_68  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4_p4_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4_p4_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4_p4  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon4.MARKER_68  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4_p4_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_15  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_15  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1_p2_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1_p2  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2.MARKER_60  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1_p2_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1_p2_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1_p2  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2.MARKER_60  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1_p2_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1_e1_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1_e1  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_15  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1_e1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1_e2_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.MOTION_e1_e2  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_57  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1_e2_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1_p2_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e1_p2  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2.MARKER_60  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1_p2_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p2_e3_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p2_e3  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3.MARKER_62  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p2_e3_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3_e4_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3_e4  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4.MARKER_64  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3_e4_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3_p3_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3_p3  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon3.MARKER_66  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3_p3_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e4_p4_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e4_p4  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon4.MARKER_68  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e4_p4_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1_e2_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e1_e2  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_356  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1_e2_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p2_e3_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_p2_e3  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3.MARKER_357  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p2_e3_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3_e4_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_e3_e4  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4.MARKER_365  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3_e4_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1no_e1no_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_116  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1no_e1no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1no_e1no_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_116  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1no_e1no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_120  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_120  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2no_e1no_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_122  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2no_e1no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2no_e1no_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_122  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2no_e1no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_124  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_124  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2s_e1s_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_174  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2s_e1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2s_e1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_174  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2s_e1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3s_p1s_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_s.MARKER_178  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3s_p1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3s_p1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_s.MARKER_178  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3s_p1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4s_e3s_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_180  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4s_e3s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4s_e3s_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_180  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4s_e3s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2s_e3s_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_182  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2s_e3s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2s_e3s_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_182  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2s_e3s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2e_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_247  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2e_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e2e_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_247  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e2e_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3e_p1e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_e.MARKER_251  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3e_p1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3e_p1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_e.MARKER_251  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3e_p1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4e_e3e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_253  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4e_e3e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e4e_e3e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_253  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e4e_e3e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2e_e3e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_255  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2e_e3e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p2e_e3e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_255  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p2e_e3e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1so_e2so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2_so.MARKER_321  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1so_e2so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1so_e2so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2_so.MARKER_321  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1so_e2so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1so_e3so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_so.MARKER_325  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1so_e3so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1so_e3so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_so.MARKER_325  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1so_e3so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3so_e4so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4_so.MARKER_327  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3so_e4so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3so_e4so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4_so.MARKER_327  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3so_e4so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3so_p2so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2_so.MARKER_329  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3so_p2so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e3so_p2so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2_so.MARKER_329  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e3so_p2so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e2no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_122  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e2no_e1no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e2no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e2no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_368  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e2no_e1no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_118  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1no_e3no_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_118  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1no_e3no_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1no_e3no_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_118  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1no_e3no_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1no_e3no_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_p1no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_369  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3_p3_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_e3_p3  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon3.MARKER_359  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3_p3_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e4_p4_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_e4_p4  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon4.MARKER_363  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e4_p4_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1_e1_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_p1_e1  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1.MARKER_371  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1_e1_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1no_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e1no_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_114  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1no_p1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_116  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1no_e1no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p2no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_120  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p2no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e4no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_124  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e4no_e3no_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1s_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e1s_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_172  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1s_p1_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e2s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_174  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e2s_e1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_176  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1s_e1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3s_p1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_s.MARKER_178  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3s_p1s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e4s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_180  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e4s_e3s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p2s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_182  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p2s_e3s_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_245  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e2e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_247  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e2e_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_249  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1e_e1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3e_p1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_e.MARKER_251  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3e_p1e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e4e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_253  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e4e_e3e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p2e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_255  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p2e_e3e_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1_e1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1_e1so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_so.MARKER_319  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1_e1so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1so_e2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2_so.MARKER_321  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1so_e2so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e1so_p1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_so.MARKER_323  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e1so_p1so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_p1so_e3so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_so.MARKER_325  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_p1so_e3so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3so_e4so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4_so.MARKER_327  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3so_e4so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.MOTION_e3so_p2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.MOTION_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2_so.MARKER_329  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MOTION_e3so_p2so_torque  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1no_p1_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1no_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_114  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1no_p1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1no_p1_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1no_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_114  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1no_p1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1no_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e1no_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_380  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1no_p1_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1no_e1no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1no_e1no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_no.MARKER_382  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1no_e1no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1s_p1_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1s_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_172  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1s_p1_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1s_p1_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1s_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_172  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1s_p1_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1s_e1s_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_176  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1s_e1s_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1s_e1s_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_176  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1s_e1s_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_245  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_245  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1e_e1e_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_249  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1e_e1e_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1e_e1e_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_249  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1e_e1e_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_so.MARKER_319  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_p1_e1so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_p1_e1so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_so.MARKER_319  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_p1_e1so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1so_p1so_az  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_so.MARKER_323  &
   characteristic = ax_ay_az_projection_angles  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1so_p1so_az  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.JOINT_e1so_p1so_wz  &
   from_first = yes  &
   object = .MODEL_309394_4mm.JOINT_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_so.MARKER_323  &
   characteristic = angular_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.JOINT_e1so_p1so_wz  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e4no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e4no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_376  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e4no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1_p2_torque  &
   from_first = no  &
   object = .MODEL_309394_4mm.SFORCE_e1_p2  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2.MARKER_373  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1_p2_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_400  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1e_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1so_p1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e1so_p1so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_so.MARKER_412  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1so_p1so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_388  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1s_e1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p2no_e3no_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p2no_e3no  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_no.MARKER_378  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p2no_e3no_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3so_p2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e3so_p2so  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon2_so.MARKER_418  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3so_p2so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p2e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p2e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_406  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p2e_e3e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p2s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p2s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_394  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p2s_e3s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e2s_e1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e2s_e1s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_s.MARKER_386  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e2s_e1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e2e_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e2e_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_398  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e2e_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1so_e2so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e1so_e2so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon2_so.MARKER_410  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1so_e2so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1_e1so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1_e1so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_so.MARKER_408  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1_e1so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3e_p1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e3e_p1e  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_e.MARKER_402  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3e_p1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3so_e4so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e3so_e4so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon4_so.MARKER_416  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3so_e4so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e3s_p1s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e3s_p1s  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1_s.MARKER_390  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e3s_p1s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e4e_e3e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e4e_e3e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_e.MARKER_404  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e4e_e3e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e4s_e3s_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e4s_e3s  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_s.MARKER_392  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e4s_e3s_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1so_e3so_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1so_e3so  &
   coordinate_rframe = .MODEL_309394_4mm.exagon3_so.MARKER_414  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1so_e3so_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_p1_e1e_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_p1_e1e  &
   coordinate_rframe = .MODEL_309394_4mm.exagon1_e.MARKER_396  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_p1_e1e_torque  &
   color = WHITE
!
measure create object  &
   measure_name = .MODEL_309394_4mm.SFORCE_e1s_p1_torque  &
   from_first = yes  &
   object = .MODEL_309394_4mm.SFORCE_e1s_p1  &
   coordinate_rframe = .MODEL_309394_4mm.pentagon1.MARKER_384  &
   characteristic = element_torque  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.SFORCE_e1s_p1_torque  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_vz  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_vz  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tg_x  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tg_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tg_y  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tg_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tg_z  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tg_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tgv_x  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tgv_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tgv_y  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tgv_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_tgv_z  &
   point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_tgv_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_x  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_x  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_y  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_y  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_z  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_z  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_vx  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_vx  &
   color = WHITE
!
measure create point  &
   measure_name = .MODEL_309394_4mm.cm_vy  &
   point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.cm_vy  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_L3  &
   from_point = .MODEL_309394_4mm.pentagon4.cm  &
   to_point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_L3  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_cm_tg  &
   from_point = .MODEL_309394_4mm.pentagon1.cm  &
   to_point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_cm_tg  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_L2  &
   from_point = .MODEL_309394_4mm.exagon3_s.cm  &
   to_point = .MODEL_309394_4mm.exagon2_no.cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_L2  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_L1  &
   from_point = .MODEL_309394_4mm.exagon3.cm  &
   to_point = .MODEL_309394_4mm.exagon2_s.cm  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_L1  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_closed_h  &
   from_point = .MODEL_309394_4mm.pentagon1_s.MARKER_3  &
   to_point = .MODEL_309394_4mm.pentagon2.MARKER_21  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_closed_h  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_cm_tg_x  &
   from_point = .MODEL_309394_4mm.Target.cm  &
   to_point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_cm_tg_x  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_cm_tg_y  &
   from_point = .MODEL_309394_4mm.Target.cm  &
   to_point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_cm_tg_y  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_cm_tg_z  &
   from_point = .MODEL_309394_4mm.Target.cm  &
   to_point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_cm_tg_z  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_closed_b  &
   from_point = .MODEL_309394_4mm.pentagon1_e.MARKER_3  &
   to_point = .MODEL_309394_4mm.pentagon1_no.MARKER_21  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_closed_b  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_deployed_b  &
   from_point = .MODEL_309394_4mm.exagon4_no.MARKER_80  &
   to_point = .MODEL_309394_4mm.exagon4_e.MARKER_130  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_deployed_b  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_deployed_h  &
   from_point = .MODEL_309394_4mm.exagon4_s.MARKER_130  &
   to_point = .MODEL_309394_4mm.pentagon4.MARKER_49  &
   characteristic = translational_displacement  &
   component = mag_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_deployed_h  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_vel_cm_tg_z  &
   from_point = .MODEL_309394_4mm.Target.cm  &
   to_point = .MODEL_309394_4mm.pentagon1.cm  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_vel_cm_tg_z  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_vel_cm_tg_x  &
   from_point = .MODEL_309394_4mm.pentagon1.cm  &
   to_point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_velocity  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_vel_cm_tg_x  &
   color = WHITE
!
measure create pt2pt  &
   measure_name = .MODEL_309394_4mm.MEA_vel_cm_tg_y  &
   from_point = .MODEL_309394_4mm.pentagon1.cm  &
   to_point = .MODEL_309394_4mm.Target.cm  &
   characteristic = translational_velocity  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.MEA_vel_cm_tg_y  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_e1_e2  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_e1_e2  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_p2_e3  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_p2_e3  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_e4_p4  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_e4_p4  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_e3_e4  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_e3_e4  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.z_rel  &
   function = ""  &
   units = "no_units"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.z_rel  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.z  &
   function = ""  &
   units = "no_units"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.z  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_e2_e1_c  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_e2_e1_c  &
   color = WHITE
!
measure create function  &
   measure_name = .MODEL_309394_4mm.angle_e3_e4_c  &
   function = ""  &
   units = "angle"  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .MODEL_309394_4mm.angle_e3_e4_c  &
   color = WHITE
!
!---------------------------- Adams View Variables ----------------------------!
!
!
variable create  &
   variable_name = .MODEL_309394_4mm.layout_config  &
   integer_value = 1
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdi0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 25.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 50.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdiiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 75.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 25.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tdiii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 50.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tci0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 75.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tcif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tcii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tciif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 10.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tciii0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 10.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tciiif  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 15.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tciv0  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 15.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.tcivf  &
   units = "time"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 20.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.Mass  &
   units = "mass"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 44.3860004977
!
variable create  &
   variable_name = .MODEL_309394_4mm.v_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.1
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0tg_x  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = -0.2
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0tg_y  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = -0.1
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0tg_z  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 5.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0s_x  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0s_y  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.v0s_z  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.mu_s  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.25
!
variable create  &
   variable_name = .MODEL_309394_4mm.mu_d  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.2
!
variable create  &
   variable_name = .MODEL_309394_4mm.STV  &
   units = "no_units"  &
   range = -10.0, 10.0  &
   use_allowed_values = no  &
   delta_type = percent_relative  &
   real_value = 1.0E-04
!
variable create  &
   variable_name = .MODEL_309394_4mm.TVC  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.5
!
variable create  &
   variable_name = .MODEL_309394_4mm.max_st_def  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-05
!
variable create  &
   variable_name = .MODEL_309394_4mm.fr_arm  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_4mm.bend_arm  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_4mm.pin_r  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-03
!
variable create  &
   variable_name = .MODEL_309394_4mm.fr_tq_prload  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.stif  &
   units = "stiffness"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 3.5E+07
!
variable create  &
   variable_name = .MODEL_309394_4mm.force_exp  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.5
!
variable create  &
   variable_name = .MODEL_309394_4mm.Damp  &
   units = "damping"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.8E+04
!
variable create  &
   variable_name = .MODEL_309394_4mm._pen_dep  &
   units = "length"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0E-04
!
variable create  &
   variable_name = .MODEL_309394_4mm.dlgs  &
   integer_value = 1
!
variable create  &
   variable_name = .MODEL_309394_4mm.KT  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 1.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.CT  &
   units = "no_units"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 6.0
!
variable create  &
   variable_name = .MODEL_309394_4mm.vx_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.0E-02
!
variable create  &
   variable_name = .MODEL_309394_4mm.vy_lim  &
   units = "velocity"  &
   range = -1.0, 1.0  &
   use_allowed_values = no  &
   delta_type = relative  &
   real_value = 2.0E-02
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1_e2  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1_p2  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2_e3  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3_e4  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3_p3  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4_p4  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+75, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+10, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1no_p1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_z)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1s_p1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3s_p1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d-41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_z)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e2e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5, -37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3e_p1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e4e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p2e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, -180.0d-37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1_e1so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_z)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1so_e2so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e1so_p1so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt0), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5, 37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_p1so_e3so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv), 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt1), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5, 180.0d+37.38d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3so_e4so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, -180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), -180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, -180.0d+41.81d))"
!
constraint modify motion_generator  &
   motion_name = .MODEL_309394_4mm.MOTION_e3so_p2so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,0,",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25, 0.0d, SENVAL(.MODEL_309394_4mm.SENSOR_avv)+50, 180.0d)),",  &
              "STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_capt2), 180.0d, SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5, 180.0d+37.38d))"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_e1_e2  &
   function = "AZ(.MODEL_309394_4mm.exagon2.MARKER_58, .MODEL_309394_4mm.exagon1.MARKER_57)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_p2_e3  &
   function = "AZ(.MODEL_309394_4mm.exagon3.MARKER_62, .MODEL_309394_4mm.pentagon2.MARKER_61)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_e4_p4  &
   function = "AZ(.MODEL_309394_4mm.pentagon4.MARKER_68, .MODEL_309394_4mm.exagon4.MARKER_67)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_e3_e4  &
   function = "AZ(.MODEL_309394_4mm.exagon4.MARKER_64, .MODEL_309394_4mm.exagon3.MARKER_63)*RTOD"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.z_rel  &
   function = "SENVAL(.MODEL_309394_4mm.SENSOR_z_rel)"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.z  &
   function = "SENVAL(.MODEL_309394_4mm.SENSOR_z)"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_e2_e1_c  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,0,ABS(.MODEL_309394_4mm.JOINT_e1_e2_az))"
!
measure modify function  &
   measure_name = .MODEL_309394_4mm.angle_e3_e4_c  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,0,ABS(ABS(.MODEL_309394_4mm.angle_e3_e4)-180))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_z  &
   function = "STEP5(time,0,0,10,-(.MODEL_309394_4mm.Mass)*(.MODEL_309394_4mm.cm_vz-(.MODEL_309394_4mm.cm_tgv_z+",  &
              "IF(.MODEL_309394_4mm.MEA_cm_tg_z+2:.MODEL_309394_4mm.v_lim,.MODEL_309394_4mm.v_lim,STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z_rel),.MODEL_309394_4mm.v_lim,SENVAL(.MODEL_309394_4mm.SENSOR_z_rel)+30,0)))))+",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+50,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+150,-.MODEL_309394_4mm.Mass*(.MODEL_309394_4mm.cm_vz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_y  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,1,0)*STEP5(time,0,0,10,(-(.MODEL_309394_4mm.Mass)*(.MODEL_309394_4mm.cm_vy-(.MODEL_309394_4mm.cm_tgv_y+",  &
              "IF(.MODEL_309394_4mm.MEA_cm_tg_y+0.0692:.MODEL_309394_4mm.vy_lim,.MODEL_309394_4mm.vy_lim,STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_y_rel),.MODEL_309394_4mm.vy_lim,SENVAL(.MODEL_309394_4mm.SENSOR_y_rel)+5,0))))))+",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z)+50, 0 , SENVAL(.MODEL_309394_4mm.SENSOR_z)+150, -.MODEL_309394_4mm.Mass*(.MODEL_309394_4mm.cm_vy)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_x  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,1,0)*STEP5(time,0,0,10,(-(.MODEL_309394_4mm.Mass)*(.MODEL_309394_4mm.cm_vx-(.MODEL_309394_4mm.cm_tgv_x-",  &
              "IF(.MODEL_309394_4mm.MEA_cm_tg_x-0.069:STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_x_rel),.MODEL_309394_4mm.vx_lim,SENVAL(.MODEL_309394_4mm.SENSOR_x_rel)+5,0),.MODEL_309394_4mm.vx_lim,.MODEL_309394_4mm.vx_lim)))))+",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,0,STEP5(time, SENVAL(.MODEL_309394_4mm.SENSOR_z)+50, 0 , SENVAL(.MODEL_309394_4mm.SENSOR_z)+150, -.MODEL_309394_4mm.Mass*(.MODEL_309394_4mm.cm_vx)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1_e2  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_e1_e2_az)-0.4*.MODEL_309394_4mm.JOINT_e1_e2_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.00075)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0.00141)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00066),",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e1_e2_az+180)-0.02*(.MODEL_309394_4mm.JOINT_e1_e2_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e1_e2_az+180)-0.02*.MODEL_309394_4mm.JOINT_e1_e2_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e1_e2_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e1_e2_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.0035)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,-(0.0035+0.00453))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.0043),",  &
              "0,",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e1_e2_az+138.19)-0.01*.MODEL_309394_4mm.JOINT_e1_e2_wz),",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e1_e2_az+138.19)-0.1*.MODEL_309394_4mm.JOINT_e1_e2_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2_e3  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_p2_e3_az)-0.4*(.MODEL_309394_4mm.JOINT_p2_e3_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0.0023)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,-0.00463)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,0.00233),",  &
              "-0.0002*(.MODEL_309394_4mm.JOINT_p2_e3_az-180)-0.05*(.MODEL_309394_4mm.JOINT_p2_e3_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "-0.02*(.MODEL_309394_4mm.JOINT_p2_e3_az-180)-0.2*.MODEL_309394_4mm.JOINT_p2_e3_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "-0.02*(.MODEL_309394_4mm.JOINT_p2_e3_az-180)-0.2*.MODEL_309394_4mm.JOINT_p2_e3_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),-SENVAL(.MODEL_309394_4mm.SENSOR_p2_e3_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.1)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,-(0.1+0.069))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.069),",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_p2_e3_az-217.38)-0.4*.MODEL_309394_4mm.JOINT_p2_e3_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3_p3  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_e3_p3_az)-0.4*(.MODEL_309394_4mm.JOINT_e3_p3_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_e3_p3_az+180:",  &
              "-0.0002*(.MODEL_309394_4mm.JOINT_e3_p3_az+180)-0.03*(.MODEL_309394_4mm.JOINT_e3_p3_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),-SENVAL(.MODEL_309394_4mm.SENSOR_e3_p3),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.00032)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.000618)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.000298))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_e3_p3_az+180)-0.4*(.MODEL_309394_4mm.JOINT_e3_p3_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e3_p3_az+180)-0.1*(.MODEL_309394_4mm.JOINT_e3_p3_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e3_p3_az+217.38:",  &
              "-0.0001*(.MODEL_309394_4mm.JOINT_e3_p3_az+217.38)-0.001*.MODEL_309394_4mm.JOINT_e3_p3_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e3_p3_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,-0.0008)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,(0.0008+0.00225))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,-0.00225)),",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e3_p3_az+217.38)-0.01*.MODEL_309394_4mm.JOINT_e3_p3_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3_e4  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "-0.1*(.MODEL_309394_4mm.angle_e3_e4)-0.4*(.MODEL_309394_4mm.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),-SENVAL(.MODEL_309394_4mm.SENSOR_e3_e4),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.00133)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.0026)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.00127),",  &
              "-0.00001*(.MODEL_309394_4mm.JOINT_e3_e4_az+180)-0.02*(.MODEL_309394_4mm.JOINT_e3_e4_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_e3_e4_az+180)-0.1*(.MODEL_309394_4mm.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_e3_e4_az+180)-0.1*(.MODEL_309394_4mm.JOINT_e3_e4_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),-SENVAL(.MODEL_309394_4mm.SENSOR_e3_e4_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1,0.011412)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4.1,-(0.011412+0.0259))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,0.0259),",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e3_e4_az+138.19)-0.02*.MODEL_309394_4mm.JOINT_e3_e4_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4_p4  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "-0.02*(.MODEL_309394_4mm.JOINT_e4_p4_az)-0.005*(.MODEL_309394_4mm.JOINT_e4_p4_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp3):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp2),-SENVAL(.MODEL_309394_4mm.SENSOR_e4_p4),SENVAL(.MODEL_309394_4mm.SENSOR_disp2)+5,0.00032)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp2)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp2)+20,-0.0006)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp2)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp2)+25,0.00028),",  &
              "-0.0002*(.MODEL_309394_4mm.JOINT_e4_p4_az-180)-0.001*(.MODEL_309394_4mm.JOINT_e4_p4_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_e4_p4_az-180)-0.1*(.MODEL_309394_4mm.JOINT_e4_p4_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_e4_p4_az-180)-0.1*(.MODEL_309394_4mm.JOINT_e4_p4_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_e4_p4_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt3),-SENVAL(.MODEL_309394_4mm.SENSOR_e4_p4_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt3)+1.2,0.0039)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt3)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt3)+4,-(0.0039+0.0018))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt3)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt3)+5,0.0018),",  &
              "0,",  &
              "-0.0001*(.MODEL_309394_4mm.JOINT_e4_p4_az-217.38)-0.01*(.MODEL_309394_4mm.JOINT_e4_p4_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e2no_e1no_az)+0.4*.MODEL_309394_4mm.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.00075)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0.00141)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00066),",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e2no_e1no_az-180)+0.01*(.MODEL_309394_4mm.JOINT_e2no_e1no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e2no_e1no_az-180)+0.1*.MODEL_309394_4mm.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_4mm.JOINT_e2no_e1no_az-180)+0.02*.MODEL_309394_4mm.JOINT_e2no_e1no_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e2no_e1no_az-138.19:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e2no_e1no_az-138.19)+0.01*.MODEL_309394_4mm.JOINT_e2no_e1no_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e2no_e1no_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.003425)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,-(0.003425+0.0042))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.0042)),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e2no_e1no_az-138.19)+0.04*.MODEL_309394_4mm.JOINT_e2no_e1no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "-0.2*(.MODEL_309394_4mm.JOINT_p1no_e3no_az)-0.8*(.MODEL_309394_4mm.JOINT_p1no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.002)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0.00404)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00204),",  &
              "-0.0001*(.MODEL_309394_4mm.JOINT_p1no_e3no_az+180)-0.05*(.MODEL_309394_4mm.JOINT_p1no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_p1no_e3no_az+180)-0.1*.MODEL_309394_4mm.JOINT_p1no_e3no_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_p1no_e3no_az+180)-0.1*.MODEL_309394_4mm.JOINT_p1no_e3no_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1no_e3no_az+217.38:",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_p1no_e3no_az+217.38)-0.4*.MODEL_309394_4mm.JOINT_p1no_e3no_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),-SENVAL(.MODEL_309394_4mm.SENSOR_p1no_e3no_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,-0.0558)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,(0.0558+0.0331))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,-0.0331)),",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_p1no_e3no_az+217.38)-0.4*.MODEL_309394_4mm.JOINT_p1no_e3no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_p1_e1_az)-0.4*(.MODEL_309394_4mm.JOINT_p1_e1_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1_e1_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z),-0.0133,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0.251)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.3,-(0.251+0.205))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+5,0.205),",  &
              "0,",  &
              "-0.001*(.MODEL_309394_4mm.JOINT_p1_e1_az-37.38)-0.4*.MODEL_309394_4mm.JOINT_p1_e1_wz),",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_p1_e1_az-37.38)-0.4*.MODEL_309394_4mm.JOINT_p1_e1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1_p2  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_e1_p2_az)-1.2*(.MODEL_309394_4mm.JOINT_e1_p2_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "-0.1*(.MODEL_309394_4mm.JOINT_e1_p2_az)-0.8*(.MODEL_309394_4mm.JOINT_e1_p2_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0),-SENVAL(.MODEL_309394_4mm.SENSOR_e1_p2_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,-0.10647)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4,(0.10647+0.127))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5,-0.127),",  &
              "-0.01*(.MODEL_309394_4mm.JOINT_e1_p2_az+37.38)-0.4*(.MODEL_309394_4mm.JOINT_e1_p2_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e4no_e3no_az)+0.4*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_e4no_e3no),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0.000735)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,-0.001475)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,0.00074),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4no_e3no_az+180)+0.02*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e4no_e3no_az+180)+0.1*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4no_e3no_az+180)+0.01*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e4no_e3no_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e4no_e3no_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,-0.00095)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,(0.00095+0.0051))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,-0.0051),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4no_e3no_az+138.19)+0.001*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz)),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4no_e3no_az+138.19)+0.01*(.MODEL_309394_4mm.JOINT_e4no_e3no_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2no_e3no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p2no_e3no_az)+0.4*(.MODEL_309394_4mm.JOINT_p2no_e3no_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_p2no_e3no_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_p2no_e3no),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.00031)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.000585)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.000275),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_p2no_e3no_az-180)+0.005*(.MODEL_309394_4mm.JOINT_p2no_e3no_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_4mm.JOINT_p2no_e3no_az-180)+0.5*(.MODEL_309394_4mm.JOINT_p2no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2no_e3no_az-180)+0.03*(.MODEL_309394_4mm.JOINT_p2no_e3no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p2no_e3no_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_p2no_e3no_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,-0.00063)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,(0.00063+0.00189))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,-0.00189),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_p2no_e3no_az-217.38)+0.001*.MODEL_309394_4mm.JOINT_p2no_e3no_wz),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2no_e3no_az-217.38)+0.01*.MODEL_309394_4mm.JOINT_p2no_e3no_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1no_p1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e1no_p1_az)+0.4*(.MODEL_309394_4mm.JOINT_e1no_p1_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e1no_p1_az+37.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1no_p1_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_e1no_p1_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z),-0.0107,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0.1733)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.2,-(0.1733+0.1407))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+5,0.1407)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1no_p1_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_e1no_p1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1no_e1no  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1no_e1no_az)+1.2*(.MODEL_309394_4mm.JOINT_p1no_e1no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1no_e1no_az)+0.8*(.MODEL_309394_4mm.JOINT_p1no_e1no_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1no_e1no_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0),SENVAL(.MODEL_309394_4mm.SENSOR_p1no_e1no_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,-0.06887)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.1,(0.06887+0.09))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5,-0.09),",  &
              "0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1no_e1no_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_p1no_e1no_wz),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1no_e1no_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_p1no_e1no_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1s_p1  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e1s_p1_az)+0.4*(.MODEL_309394_4mm.JOINT_e1s_p1_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e1s_p1_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z),0.0107,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,-0.1864)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.1,(0.1535+0.1864))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+5,-0.1535),",  &
              "0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1s_p1_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_e1s_p1_wz),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1s_p1_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_e1s_p1_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e2s_e1s_az)+0.4*.MODEL_309394_4mm.JOINT_e2s_e1s_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0.00075)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,-0.00141)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,0.00066),",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e2s_e1s_az+180)+0.01*(.MODEL_309394_4mm.JOINT_e2s_e1s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_4mm.JOINT_e2s_e1s_az+180)+0.02*.MODEL_309394_4mm.JOINT_e2s_e1s_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e2s_e1s_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e2s_e1s_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,-0.00427)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,(0.00427+0.0047))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,-0.0047),",  &
              "0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e2s_e1s_az+138.19)+0.4*.MODEL_309394_4mm.JOINT_e2s_e1s_wz),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e2s_e1s_az+138.19)+0.1*.MODEL_309394_4mm.JOINT_e2s_e1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1s_e1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.04*(.MODEL_309394_4mm.JOINT_p1s_e1s_az)+1.2*(.MODEL_309394_4mm.JOINT_p1s_e1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1s_e1s_az)+0.8*(.MODEL_309394_4mm.JOINT_p1s_e1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1s_e1s_az+37.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1s_e1s_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_p1s_e1s_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0),SENVAL(.MODEL_309394_4mm.SENSOR_p1s_e1s_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0.0774)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.0,-(0.0774+0.0928))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.0,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5,0.0928)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1s_e1s_az+37.38)+0.2*.MODEL_309394_4mm.JOINT_p1s_e1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3s_p1s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e3s_p1s_az)+0.4*(.MODEL_309394_4mm.JOINT_e3s_p1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.002)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0.00406)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00206),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3s_p1s_az-180)+0.05*(.MODEL_309394_4mm.JOINT_e3s_p1s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3s_p1s_az-180)+0.1*(.MODEL_309394_4mm.JOINT_e3s_p1s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e3s_p1s_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e3s_p1s_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,-0.0561)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,(0.0561+0.033))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,-0.033),",  &
              "0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3s_p1s_az-217.38)+0.4*.MODEL_309394_4mm.JOINT_e3s_p1s_wz),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3s_p1s_az-217.38)+0.4*.MODEL_309394_4mm.JOINT_e3s_p1s_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e4s_e3s_az)+0.4*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_e4s_e3s),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0.000725)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,-0.001455)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,0.00073),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4s_e3s_az+180)+0.02*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e4s_e3s_az+180)+0.1*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4s_e3s_az+180)+0.01*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e4s_e3s_az+138.19:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e4s_e3s),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,-0.00055)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,(0.00055+0.005))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,-0.005),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4s_e3s_az+138.19)+0.001*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz)),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4s_e3s_az+138.19)+0.01*(.MODEL_309394_4mm.JOINT_e4s_e3s_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2s_e3s  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p2s_e3s_az)+0.4*(.MODEL_309394_4mm.JOINT_p2s_e3s_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_p2s_e3s_az+180:",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_p2s_e3s_az+180)+0.005*(.MODEL_309394_4mm.JOINT_p2s_e3s_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_p2s_e3s),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0.00032)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,-0.0006)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,0.00028))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_4mm.JOINT_p2s_e3s_az+180)+0.5*(.MODEL_309394_4mm.JOINT_p2s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2s_e3s_az+180)+0.02*(.MODEL_309394_4mm.JOINT_p2s_e3s_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p2s_e3s_az+217.38:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_p2s_e3s_az+217.38)+0.001*.MODEL_309394_4mm.JOINT_p2s_e3s_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_p2s_e3s),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0.00066)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,-(0.00066+0.00249))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,0.00249)),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2s_e3s_az+217.38)+0.01*.MODEL_309394_4mm.JOINT_p2s_e3s_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1_e1e_az)+0.4*(.MODEL_309394_4mm.JOINT_p1_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1_e1e_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z),0.0107,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,-0.1734)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.2,(0.1437+0.1734))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+5,-0.1437),",  &
              "0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1_e1e_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_p1_e1e_wz),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1_e1e_az-37.38)+0.6*.MODEL_309394_4mm.JOINT_p1_e1e_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e2e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e2e_e1e_az)+0.4*.MODEL_309394_4mm.JOINT_e2e_e1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.00075)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0.00141)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00066),",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e2e_e1e_az-180)+0.01*(.MODEL_309394_4mm.JOINT_e2e_e1e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.002*(.MODEL_309394_4mm.JOINT_e2e_e1e_az-180)+0.02*.MODEL_309394_4mm.JOINT_e2e_e1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e2e_e1e_az-138.19:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e2e_e1e_az-138.19)+0.01*.MODEL_309394_4mm.JOINT_e2e_e1e_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e2e_e1e_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.00388)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,-(0.00388+0.00442))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.00442)),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e2e_e1e_az-138.19)+0.04*.MODEL_309394_4mm.JOINT_e2e_e1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1e_e1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1e_e1e_az)+1.2*(.MODEL_309394_4mm.JOINT_p1e_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1e_e1e_az)+0.8*(.MODEL_309394_4mm.JOINT_p1e_e1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1e_e1e_az-37.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0),SENVAL(.MODEL_309394_4mm.SENSOR_p1e_e1e_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,-0.07105)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.1,(0.07105+0.0908))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5,-0.0908),",  &
              "0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1e_e1e_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_p1e_e1e_wz),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1e_e1e_az-37.38)+0.4*.MODEL_309394_4mm.JOINT_p1e_e1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3e_p1e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e3e_p1e_az)+0.4*(.MODEL_309394_4mm.JOINT_e3e_p1e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0.002)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,-0.00404)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,0.00204),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3e_p1e_az+180)+0.05*(.MODEL_309394_4mm.JOINT_e3e_p1e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_4mm.JOINT_e3e_p1e_az+180)+0.2*.MODEL_309394_4mm.JOINT_e3e_p1e_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e3e_p1e_az+217.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3e_p1e_az+217.38)+0.1*.MODEL_309394_4mm.JOINT_e3e_p1e_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e3e_p1e_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.0555)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,-(0.0555+0.0313))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.0313)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3e_p1e_az+217.38)+0.4*.MODEL_309394_4mm.JOINT_e3e_p1e_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e4e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e4e_e3e_az)+0.4*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_e4e_e3e),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.000735)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.001465)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.00073),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4e_e3e_az-180)+0.02*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e4e_e3e_az-180)+0.2*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4e_e3e_az-180)+0.01*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e4e_e3e_az-138.19:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e4e_e3e_az-138.19)+0.001*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e4e_e3e_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0.00043)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,-(0.00043+0.0058))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,0.0058)),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e4e_e3e_az-138.19)+0.01*(.MODEL_309394_4mm.JOINT_e4e_e3e_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p2e_e3e  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p2e_e3e_az)+0.4*(.MODEL_309394_4mm.JOINT_p2e_e3e_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_p2e_e3e_az-180:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_p2e_e3e),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.00031)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.00059)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.00028),",  &
              "0,",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_p2e_e3e_az-180)+0.01*(.MODEL_309394_4mm.JOINT_p2e_e3e_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p2e_e3e_az-180)+0.1*(.MODEL_309394_4mm.JOINT_p2e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2e_e3e_az-180)+0.01*(.MODEL_309394_4mm.JOINT_p2e_e3e_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p2e_e3e_az-217.38:",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_p2e_e3e_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,-0.00053)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,(0.00053+0.002495))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,-0.002495),",  &
              "0,",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_p2e_e3e_az-217.38)+0.001*.MODEL_309394_4mm.JOINT_p2e_e3e_wz),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_p2e_e3e_az-217.38)+0.01*.MODEL_309394_4mm.JOINT_p2e_e3e_wz))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1_e1so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1_e1so_az)+0.4*(.MODEL_309394_4mm.JOINT_p1_e1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1_e1so_az+37.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1_e1so_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_p1_e1so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z),-0.0107,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0.1864)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+1.2,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.1,-(0.1864+0.1514))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_z)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_z)+5,0.1514)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1_e1so_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_p1_e1so_wz))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1so_e2so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e1so_e2so_az)+0.4*.MODEL_309394_4mm.JOINT_e1so_e2so_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp0):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,-0.00075)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0.00141)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+20,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,-0.00066),",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e1so_e2so_az-180)+0.02*(.MODEL_309394_4mm.JOINT_e1so_e2so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e1so_e2so_az-180)+0.02*.MODEL_309394_4mm.JOINT_e1so_e2so_wz,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2_1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e1so_e2so_az-138.19:",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e1so_e2so_az-138.19)+0.01*.MODEL_309394_4mm.JOINT_e1so_e2so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_e1so_e2so_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.004)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,-(0.004+0.0046))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.0046)),",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e1so_e2so_az-138.19)+0.01*.MODEL_309394_4mm.JOINT_e1so_e2so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e1so_p1so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e1so_p1so_az)+1.2*(.MODEL_309394_4mm.JOINT_e1so_p1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt0):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e1so_p1so_az)+0.8*(.MODEL_309394_4mm.JOINT_e1so_p1so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e1so_p1so_az+37.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1so_p1so_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_e1so_p1so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0),SENVAL(.MODEL_309394_4mm.SENSOR_e1so_p1so_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0.0795)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4,-(0.0795+0.0985))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt0)+5,0.0985)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e1so_p1so_az+37.38)+0.4*.MODEL_309394_4mm.JOINT_e1so_p1so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_p1so_e3so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_avv):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_p1so_e3so_az)+0.4*(.MODEL_309394_4mm.JOINT_p1so_e3so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv),0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0.002)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,-0.00406)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+22,0,SENVAL(.MODEL_309394_4mm.SENSOR_avv)+25,0.00206),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_p1so_e3so_az+180)+0.05*(.MODEL_309394_4mm.JOINT_p1so_e3so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_4mm.JOINT_p1so_e3so_az+180)+0.2*(.MODEL_309394_4mm.JOINT_p1so_e3so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_p1so_e3so_az+217.38:",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1so_e3so_az+217.38)+0.4*.MODEL_309394_4mm.JOINT_p1so_e3so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1),SENVAL(.MODEL_309394_4mm.SENSOR_p1so_e3so_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0.06)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+1.3,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,-(0.06+0.033))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt1)+5,0.033)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_p1so_e3so_az+217.38)+0.4*.MODEL_309394_4mm.JOINT_p1so_e3so_wz)))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3so_e4so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e3so_e4so_az)+0.4*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp2):0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_e3so_e4so),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,-0.00072)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0.00144)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,-0.00072),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3so_e4so_az-180)+0.02*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3so_e4so_az-180)+0.2*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.001*(.MODEL_309394_4mm.JOINT_e3so_e4so_az-180)+0.02*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e3so_e4so_az-138.19:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3so_e4so_az-138.19)+0.001*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e3so_e4so_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0.00057)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,-(0.00057+0.0068))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,0.0068)),",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3so_e4so_az-138.19)+0.01*(.MODEL_309394_4mm.JOINT_e3so_e4so_wz)))))"
!
force modify direct single_component_force  &
   single_component_force_name = .MODEL_309394_4mm.SFORCE_e3so_p2so  &
   function = "IF(SENVAL(.MODEL_309394_4mm.SENSOR_z):0,",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_disp1):0,",  &
              "0.1*(.MODEL_309394_4mm.JOINT_e3so_p2so_az)+0.4*(.MODEL_309394_4mm.JOINT_e3so_p2so_wz),",  &
              "IF(.MODEL_309394_4mm.JOINT_e3so_p2so_az+180:",  &
              "0.0002*(.MODEL_309394_4mm.JOINT_e3so_p2so_az+180)+0.01*(.MODEL_309394_4mm.JOINT_e3so_p2so_wz),",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1),SENVAL(.MODEL_309394_4mm.SENSOR_e3so_p2so),SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0.00032)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+5,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,-0.00061)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+21,0,SENVAL(.MODEL_309394_4mm.SENSOR_disp1)+25,0.00029))),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt1):0,",  &
              "0.02*(.MODEL_309394_4mm.JOINT_e3so_p2so_az+180)+0.2*(.MODEL_309394_4mm.JOINT_e3so_p2so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt2):0,",  &
              "0.002*(.MODEL_309394_4mm.JOINT_e3so_p2so_az+180)+0.02*(.MODEL_309394_4mm.JOINT_e3so_p2so_wz),",  &
              "IF(SENVAL(.MODEL_309394_4mm.SENSOR_capt3):0,",  &
              "IF(.MODEL_309394_4mm.JOINT_e3so_p2so_az+217.38:",  &
              "0.0001*(.MODEL_309394_4mm.JOINT_e3so_p2so_az+217.38)+0.001*.MODEL_309394_4mm.JOINT_e3so_p2so_wz,",  &
              "0,",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2),SENVAL(.MODEL_309394_4mm.SENSOR_e3so_p2so_c),SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0.00062)+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+1.1,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,-(0.00062+0.00245))+",  &
              "STEP5(time,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+4,0,SENVAL(.MODEL_309394_4mm.SENSOR_capt2)+5,0.00245)),",  &
              "0.01*(.MODEL_309394_4mm.JOINT_e3so_p2so_az+217.38)+0.04*.MODEL_309394_4mm.JOINT_e3so_p2so_wz))))"
!
force modify direct torque_vector  &
   torque_vector_name = .MODEL_309394_4mm.VTORQUE_1  &
   x_torque_function = "-.MODEL_309394_4mm.KT*AX(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351)-.MODEL_309394_4mm.CT*WX(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351,.MODEL_309394_4mm.ground.MARKER_351)"  &
   y_torque_function = "-.MODEL_309394_4mm.KT*AY(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351)-.MODEL_309394_4mm.CT*WY(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351,.MODEL_309394_4mm.ground.MARKER_351)"  &
   z_torque_function = "-.MODEL_309394_4mm.KT*AZ(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351)-.MODEL_309394_4mm.CT*WZ(.MODEL_309394_4mm.pentagon1.MARKER_350,.MODEL_309394_4mm.ground.MARKER_351,.MODEL_309394_4mm.ground.MARKER_351)"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_z  &
   function = "ABS(.MODEL_309394_4mm.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_avv  &
   function = "ABS(.MODEL_309394_4mm.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp1  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp2  &
   function = "ABS(.MODEL_309394_4mm.angle_e3_e4)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_x_rel  &
   function = ".MODEL_309394_4mm.MEA_cm_tg_x - 0.069"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_y_rel  &
   function = ".MODEL_309394_4mm.MEA_cm_tg_y + 0.0692"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_z_rel  &
   function = "ABS(.MODEL_309394_4mm.MEA_cm_tg_z)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt1  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt2  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_e4  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3_e4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4no_e3no  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4s_e3s  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4e_e3e  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_e4so  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3so_e4so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_p3  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3_p3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2no_e3no  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2s_e3s  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2e_e3e  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_p2so  &
   function = ".MODEL_309394_4mm.JOINT_p2_e3_az"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3so_p2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4_p4  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e3_e4_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4_p4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1_e2_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e1_e2_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2no_e1no_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e2no_e1no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2s_e1s_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e2s_e1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e2e_e1e_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e2e_e1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1so_e2so_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e1so_e2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2_e3_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2_e3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1no_e3no_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p1no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3s_p1s_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3s_p1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3e_p1e_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3e_p1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1so_e3so_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_p2_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p1so_e3so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp0  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e1_e2_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_disp3  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e4_p4_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt0  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1_p2_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e1_p2_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1no_e1no_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p1no_e1no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1s_e1s_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p1s_e1s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p1e_e1e_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p1e_e1e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e1so_p1so_c  &
   function = "ABS(.MODEL_309394_4mm.JOINT_p1_e1_az)"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e1so_p1so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_e4_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3_e4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4no_e3no_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4s_e3s_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4e_e3e_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_e4so_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3so_e4so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3_p3_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3_p3_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2no_e3no_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2no_e3no_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2s_e3s_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2s_e3s_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_p2e_e3e_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_p2e_e3e_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e3so_p2so_c  &
   function = ".MODEL_309394_4mm.angle_p2_e3"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e3so_p2so_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt2_1  &
   function = ".MODEL_309394_4mm.angle_e2_e1_c"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt3  &
   function = ".MODEL_309394_4mm.angle_e3_e4_c"  &
   evaluate = "time"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_e4_p4_c  &
   function = ".MODEL_309394_4mm.angle_e3_e4_c"  &
   evaluate = ".MODEL_309394_4mm.SFORCE_e4_p4_torque"
!
executive_control modify sensor  &
   sensor_name = .MODEL_309394_4mm.SENSOR_capt4  &
   function = "ABS(.MODEL_309394_4mm.JOINT_e4_p4_az)"  &
   evaluate = "time"
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ground
!
material modify  &
   material_name = .MODEL_309394_4mm.steel  &
   density = (7801.0(kg/meter**3))  &
   youngs_modulus = (2.07E+11(Newton/meter**2))
!
material modify  &
   material_name = .MODEL_309394_4mm.carbon_fiber_0_90_epoxy  &
   density = (1510(kg/meter**3))  &
   orthotropic_constants =   &
      (1.23611E+10(Newton/meter**2)),  &
      (2.7443E+10(Newton/meter**2)),  &
      (2.8949E+09(Newton/meter**2))
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1.PLATE_2  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2.PLATE_3  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2.PLATE_4  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3.PLATE_5  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon3.PLATE_6  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4.PLATE_7  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon4.PLATE_8  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_no.PLATE_9  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_no.PLATE_10  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_no.PLATE_3  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_no.PLATE_10  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_no.PLATE_10  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_no.PLATE_3  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_s.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_s.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_s.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_s.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_s.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_s.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_e.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_e.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_e.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_e.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_e.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_e.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon1_so.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon2_so.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon1_so.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon3_so.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.exagon4_so.PLATE_17  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape plate  &
   plate_name = .MODEL_309394_4mm.pentagon2_so.PLATE_1  &
   width = (0.4cm)  &
   radius = (0.1cm)
!
geometry modify shape block  &
   block_name = .MODEL_309394_4mm.Target.BOX_33  &
   diag_corner_coords =   &
      (25.0cm),  &
      (25.0cm),  &
      (25.0cm)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_1  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_2  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_3  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_4  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_5  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_6  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_7  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_8  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_9  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_10  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_11  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_12  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_13  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_14  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_15  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_16  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_17  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_18  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_19  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_20  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_21  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_22  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_23  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_24  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_25  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_26  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_27  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_28  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_29  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_30  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_31  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
contact modify  &
   contact_name = .MODEL_309394_4mm.CONTACT_32  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_32  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_2  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_3  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_4  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_5  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_6  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_7  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_8  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_9  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_10  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_11  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_12  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_13  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_14  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_15  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_16  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_17  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_18  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_19  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_20  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_21  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_22  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_23  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_24  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_25  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_26  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_27  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_28  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_29  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_30  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
force modify element_like friction  &
   friction_name = .MODEL_309394_4mm.FRICTION_31  &
   mu_static = (.MODEL_309394_4mm.mu_s)  &
   mu_dynamic = (.MODEL_309394_4mm.mu_d)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.JOINT_30_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.JOINT_p1so_e3so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.JOINT_30_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_4mm.JOINT_p1so_e3so.j)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_z_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_z.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.VTORQUE_1_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.VTORQUE_1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_4_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1_e2.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_5_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p2_e3.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_6_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3_p3.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_9_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3_e4.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_7_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e4_p4.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_10_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e2no_e1no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_11_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_12_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1_e1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_12_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1_p2.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_14_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e4no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_15_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p2no_e3no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_16_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1no_p1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_16_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1no_e1no.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_1  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1s_p1.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_2  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e2s_e1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_3  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1s_e1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_4  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3s_p1s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_5  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e4s_e3s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_6  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p2s_e3s.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_7  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_8  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e2e_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_9  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1e_e1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_10  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3e_p1e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_11  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e4e_e3e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_12  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p2e_e3e.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_13  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1_e1so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_14  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1so_e2so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_15  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e1so_p1so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_16  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_p1so_e3so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_17  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3so_e4so.i)
!
geometry modify shape force  &
   force_name = .MODEL_309394_4mm.SFORCE_18_force_graphic_18  &
   applied_at_marker_name = (.MODEL_309394_4mm.SFORCE_e3so_p2so.i)
!
variable modify  &
   variable_name = .MODEL_309394_4mm.Mass  &
   real_value = (.MODEL_309394_4mm.Mass)
!
model display  &
   model_name = MODEL_309394_4mm
