clc
clear
close all
%% Dati Gas (cp, cv @298K, p = 1atm)
RH2 = 4125.5; %[J/(kgK)]
kH2 = 1.407;

RCH4 = 518.3; %[J/(kgK)]
kCH4 = 1.31;

RN2 = 296.7;
kN2 = 1.4;

RHe = 2077.7;
kHe = 1.66;

%% Inserimento Dati di Input

% Selezione gas in esame
gas = input('Selezione gas analizzato: ',"s");
switch gas
    case 'H2'
        R = RH2;
        k = kH2;
    case 'CH4'
        R = RCH4;
        k = kCH4;
    case 'N2'
        R = RN2;
        k = kN2;
    case 'He'
        R = RHe;
        k = kHe;
end

% Scelta delle combinazioni di calcolo
comb = input('Scelta parametri modello: ',"s");
% A -> var p1, par d2, cost p2
% B -> var p1, par p2, cost d2
% C -> var d2, par p1, cost p2
% D -> var d2, par p2, cost p1
% E -> var p2, par p1, cost d2
% F -> var p2, par d2, cost p1

% Scelta del caso in esame (per il salvataggio dei risultati)
caso = input('Indicazione caso: ',"s");
% Dati di riferimento
%TI     p2 [bar]    PI  p1 [bar]   T1 [K] 
%PFI    0.88 ÷ 0.92 BP    1 ÷ 15   298    
%PFI    0.88 ÷ 0.92 HP   10 ÷ 40   298    
%DI     0.92 ÷ 10   BP   10 ÷ 40   353   
%DI       10 ÷ 40   MP   40 ÷ 150  353   
%DI       40 ÷ 80   HP  150 ÷ 300  353    
%       d2 [mm]         0.5 ÷ 3.5        

% Inizializzazione costanti:
indvar = 100;                                                  
% # di valori per variabile indipendente (fisso)
parvar = input ('Numero di valori per parametro: ');
% # di valori per parametro variabile
T1 = input ('Temperatura di iniezione [K]: ');
% [K] temperatura di iniezione

% Inizializzazione variabili:
switch comb
    case 'A'                                      % var p1, par d2, cost p2 
        p1 = linspace(input('p1 [Pa], min = '), ...
            input('p1 [Pa], max = '),indvar);     % var
        if parvar > 1
        d2 = linspace(input('d2 [m], min = '), ...
            input('d2 [m], max = '),parvar);      % par
        else
        d2 = input('d2 [m] = ');
        end
        p2 = input('p2 [Pa] = ');                 % cost
    case 'B'                                      % var p1, par p2, cost d2
        p1 = linspace(input('p1 [Pa], min = '), ...
            input('p1 [Pa], max = '),indvar);     % var
        d2 = input('d2 [m] = ');                  % cost
        if parvar > 1
        p2 = linspace(input('p2 [Pa], min = '), ...
            input('p2 [Pa], max = '),parvar);     % par
        else
        p2 = input('p2 [Pa] = ');                 % cost
        end
    case 'C'                                      % var d2, par p1, cost p2
        if parvar > 1
        p1 = linspace(input('p1 [Pa], min = '), ...
            input('p1 [Pa], max = '),parvar);     % par
        else
        p1 = input('p1 [Pa] = ');
        end
        d2 = linspace(input('d2 [m], min = '), ...
            input('d2 [m], max = '),indvar);      % var
        p2 = input('p2 [Pa] = ');                 % cost
    case 'D'                                      % var d2, par p2, cost p1
        p1 = input('p1 [Pa] = ');                 % cost
        d2 = linspace(input('d2 [m], min = '), ...
            input('d2 [m], max = '),indvar);      % var
        if parvar > 1
        p2 = linspace(input('p2 [Pa], min = '), ...
            input('p2 [Pa], max = '),parvar);     % par
        else
        p2 = input('p2 [Pa] = ');
        end
    case 'E'                                      % var p2, par p1, cost d2
        if parvar > 1
        p1 = linspace(input('p1 [Pa], min = '), ...
            input('p1 [Pa], max = '),parvar);     % par
        else
        p1 = input('p1 [Pa] = ');
        end
        d2 = input('d2 [m] = ');                  % cost
        p2 = linspace(input('p2 [Pa], min = '), ...
            input('p2 [Pa], max = '),indvar);     % var
    case 'F'                                      % var p2, par d2, cost p1
        p1 = input('p1 [Pa] = ');                 % cost
        if parvar > 1
        d2 = linspace(input('d2 [m], min = '), ...
            input('d2 [m], max = '),parvar);      % par
        else
        d2 = input('d2 [m] = ');
        end
        p2 = linspace(input('p2 [Pa], min = '), ...
            input('p2 [Pa], max = '),indvar);     % var
end

% Calcoli preliminari
A2 = pi/4 .* d2.^2;                 % [m^2] area iniettore
rc = (2/(k+1))^(k/(k-1));           % rapporto critico per gas
K1 = sqrt((2*k)/((k-1)*R*T1));
K2 = sqrt((k/(R*T1))*(2/(k+1))^((k+1)/(k-1)));

% Calcoli principali per portata a seconda di combinazione e caso
switch comb
    case 'A'                                      % var p1, par d2, cost p2 
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,indvar);
        for i = 1:indvar
        if (p2 <= p1(i))
            r(i) = p2/p1(i);
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(i)<=rc)
                    mdot(j,i) = A2(j)*p1(i)*K2;
                else
                    mdot(j,i) = A2(j)*p1(i)^(1/2)*...
                        sqrt(r(i)^(2/k)-r(i)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
    case 'B'                                      % var p1, par p2, cost d2
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(parvar,indvar);
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (p2(j) <= p1(i))
                r(j,i) = p2(j)/p1(i);
                else
                    disp('Errore p2 > p1')
                    return
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(j,i)<=rc)
                    mdot(j,i) = A2*p1(i)*K2;
                else
                    mdot(j,i) = A2*p1(i)^(1/2)*...
                        sqrt(r(j,i)^(2/k)-r(j,i)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
    case 'C'                                      % var d2, par p1, cost p2
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,parvar);
        for i = 1:parvar
        if (p2 <= p1(i))
            r(i) = p2/p1(i);
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(j)<=rc)
                    mdot(j,i) = A2(i)*p1(j)*K2;
                else
                    mdot(j,i) = A2(i)*p1(j)^(1/2)*...
                    sqrt(r(j)^(2/k)-r(j)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
    case 'D'                                      % var d2, par p2, cost p1
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,parvar);
        for i = 1:parvar
        if (p2(i) <= p1)
            r(i) = p2(i)/p1;
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata 
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(j)<=rc)
                    mdot(j,i) = A2(i)*p1*K2;
                else
                    mdot(j,i) = A2(i)*p1^(1/2)*...
                    sqrt(r(j)^(2/k)-r(j)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
    case 'E'                                      % var p2, par p1, cost d2
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(parvar,indvar);
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (p2(i) <= p1(j))
                r(j,i) = p2(i)/p1(j);
                else
                    disp('Errore p2 > p1')
                    return
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(j,i)<=rc)
                    mdot(j,i) = A2*p1(j)*K2;
                else
                    mdot(j,i) = A2*p1(j)^(1/2)*...
                        sqrt(r(j,i)^(2/k)-r(j,i)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
    case 'F'                                      % var p2, par d2, cost p1
        % Preallocazione di mdot
        mdot = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,indvar);
        for i = 1:indvar
        if (p2(i) <= p1)
            r(i) = p2(i)/p1;
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                if (r(i)<=rc)
                    mdot(j,i) = A2(j)*p1*K2;
                else
                    mdot(j,i) = A2(j)*p1^(1/2)*...
                    sqrt(r(i)^(2/k)-r(i)^((k+1)/k))*K1;
                end
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
end

%% Salvataggio dei risultati
switch comb
    case 'A'                        % var p1, par d2, cost p2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = p1/10^5;           % I riga: 0, variabile -> p1 [bar]
    M(2:end,1) = d2*10^3;           % I colonna: 0, parametro -> d2 [mm]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_p2_=_', ...
        num2str(p2/10^5),'_bar_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('p2 =',32,num2str(p2/10^5),' bar')); % esportare file *.xlsx
    case 'B'                        % var p1, par p2  , cost d2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = p1/10^5;           % I riga: 0, variabile -> p1 [bar]
    M(2:end,1) = p2/10^5;           % I colonna: 0, parametro -> p2 [bar]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_d2_=_', ...
        num2str(d2*10^3),'_mm_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('d2 =',32,num2str(d2*10^3),' mm'));   
    case 'C'                        % var d2, par p1, cost p2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = d2*10^3;           % I riga: 0, variabile -> d2 [mm]
    M(2:end,1) = p1/10^5;           % I colonna: 0, parametro -> p1 [bar]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_p2_=_', ...
        num2str(p2/10^5),'_bar_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('p2 =',32,num2str(p2/10^5),' bar'));  
    case 'D'                        % var d2, par p2, cost p1
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = d2*10^3;           % I riga: 0, variabile -> d2 [mm]
    M(2:end,1) = p2/10^5;           % I colonna: 0, parametro -> p2 [bar]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_p1_=_', ...
        num2str(p1/10^5),'_bar_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet',strcat('p1 =',32,num2str(p1/10^5),' bar')); 
    case 'E'                        % var p2  , par p1, cost d2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = p2/10^5;           % I riga: 0, variabile -> p2 [bar]
    M(2:end,1) = p1/10^5;           % I colonna: 0, parametro -> p1 [bar]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_d2_=_', ...
        num2str(d2*10^3),'_mm_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('d2 =',num2str(d2*10^3),' mm')); 
    case 'F'                        % var p2  , par d2, cost p1
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = p2/10^5;           % I riga: 0, variabile -> p2 [bar]
    M(2:end,1) = d2*10^3;           % I colonna: 0, parametro -> d2 [mm]
    M(2:end,2:end) = mdot*10^3;     % resto della matrice -> portata [g/s]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_p1_=_', ...
        num2str(p1/10^5),'_bar_','T1_=_',num2str(T1),'_K_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('p1 =',32,num2str(p1/10^5),' bar'));  
end