clc
clear
close all
%% Dati Gas (cp, cv @298K, p = 1atm)
RH2 = 4125.5; %[J/(kgK)]
kH2 = 1.407;
RCH4 = 518.3; %[J/(kgK)]
kCH4 = 1.31;
RA = 287; %[J/(kgK)]
kA = 1.4; %
%% Inserimento Dati di Input

% Selezione gas in esame
gas = input('Selezione gas analizzato: ',"s");
switch gas
    case 'H2'
        R1 = RH2;
        k1 = kH2;
    case 'CH4'
        R1 = RCH4;
        k1 = kCH4;
end

% Scelta delle combinazioni di calcolo
comb = input('Scelta parametri modello: ',"s");
% I  -> var t, par p1, cost d2, p2
% II -> var t, par d2, cost p1, p2

% Scelta del caso in esame (per il salvataggio dei risultati)
caso = input('Indicazione caso: ',"s");
% Dati di riferimento
%TI     p2 [bar]    PI  p1 [bar]
%DI     0.92 ÷ 10   BP   10 ÷ 40    
%DI       10 ÷ 40   MP   40 ÷ 150   
%DI       40 ÷ 80   HP  150 ÷ 300    
%       d2 [mm]         0.5 ÷ 3.5        

% Inizializzazione costanti:
indvar = 100;                                                  
% # di valori per variabile indipendente (fisso)
parvar = input ('Numero di valori per parametro: ');
% # di valori per parametro variabile
tMax = input ('Durata iniezione [s]: ');
% [s] durata iniezione
R2 = RA;
k2 = kA;
p2amb = input('Pressione Ambiente [Pa]: '); %[Pa] pressione ambiente di partenza per adiabatica
T2amb = input('Temperatura Ambiente [K]: '); %[K] temperatura ambiente
% p2amb = p2 -> T2 = T2amb per calcoli
costadi = T2amb*p2amb^((1-k2)/k2); %[K Pa^((1-k)/k)] costante per adiabatica
Gamma = 3;

% Inizializzazione variabili:
t = linspace(0,tMax,indvar);
switch comb
    case 'I'                                   % var t, par p1, cost d2, p2
        if parvar > 1
        p1 = linspace(input('p1 [Pa], min = '), ...
            input('p1 [Pa], max = '),parvar);  % par
        else
        p1 = input('p1 [Pa] = ');
        end
        d2 = input('d2 [m] = ');               % cost 1
        p2 = input('p2 [Pa] = ');              % cost 2
    case 'II'                                  % var t, par d2, cost p1, p2
        p1 = input('p1 [Pa] = ');              % cost 1
        if parvar > 1
        d2 = linspace(input('d2 [m], min = '), ...
            input('d2 [m], max = '),parvar);      % par
        else
        d2 = input('d2 [m] = ');
        end
        p2 = input('p2 [Pa] = ');              % cost 2
end
% Calcoli preliminari

T2 = costadi./p2^((1-k2)/k2);             % calcolo di T2
rho2 = p2./(R2.*T2);                        % calcolo di rho2
A = (k1*pi)/4;
B = 2/(k1+1);
C = k1/(k1-1);
K = (A*(B^C))^(1/4); % costanti di calcolo

% Calcoli principali per portata a seconda di combinazione e caso
switch comb
    case 'I'                                   % var t, par p1, cost d2, p2 
        % Preallocazione di Zt
        Zt = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,parvar);
        for i = 1:parvar
        if (p2 <= p1(i))
            r(i) = p2/p1(i);
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                Zt(j,i) = Gamma*d2^(1/2)*(p1(j)/rho2)^(1/4)*K*t(i)^(1/2);
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
 case 'II'                                   % var t, par d2, cost p1, p2 
        % Preallocazione di Zt
        Zt = zeros(parvar,indvar);
        % Calcolo di r con verifica p2 <= p1
        r = zeros(1,parvar);
        for i = 1:parvar
        if (p2 <= p1)
            r = p2/p1;
        else
            disp('Errore p2 > p1')
            return
        end
        end
        % Calcolo della portata
        i = 1;
        j = 1;
        while (j<=parvar)
            while (i<=indvar)
                Zt(j,i) = Gamma*d2(j)^(1/2)*(p1/rho2)^(1/4)*K*t(i)^(1/2);
                i = i + 1;
            end
            i = 1;
            j = j + 1;
        end
end
%% Salvataggio dei risultati
switch comb
    case 'I'                        % var t, par p1, cost d2, p2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = t*10^3;           % I riga: 0, variabile -> t [ms]
    M(2:end,1) = p1/10^5;          % I colonna: 0, parametro -> p1 [bar]
    M(2:end,2:end) = Zt*10^3;     % resto della matrice -> Zt [mm]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_d2_=_', ...
        num2str(d2*10^3),'_mm_','p2_=_',num2str(p2/10^5),'_bar_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('@',num2str(d2*10^3),' mm,',32,num2str(p2/10^5),' bar')); % esportare file *.xlsx
    case 'II'                        % var t, par d2  , cost p1, p2
    M = zeros(parvar+1,indvar+1);   % inizializzazione matrice da esportare
    M(1,2:end) = t*10^3;           % I riga: 0, variabile -> t [ms]
    M(2:end,1) = d2*10^3;           % I colonna: 0, parametro -> d2 [mm]
    M(2:end,2:end) = Zt*10^3;     % resto della matrice -> Zt [mm]
    writematrix(M,strcat('Res_',gas,'_',comb,'_',caso,'_p1_=_', ...
        num2str(p1/10^5),'_bar_','p2_=_',num2str(p2/10^5),'_bar_', ...
        num2str(parvar),'N.xlsx'),'Sheet', ...
        strcat('@',num2str(p1/10^5),' bar,',32,num2str(p2/10^5),' bar'));   
end