close all, clc

%% Latex
% Setup iniziale
set(0,'defaultTextInterpreter','latex'); % imposta l'interprete latex per i testi
set(0, 'defaultAxesTickLabelInterpreter','latex'); % imposta l'interprete latex per i testi degli 
set(0, 'defaultLegendInterpreter','latex'); % imposta l'interprete latex per le legende

FONT = 'Times'; % font dei testi
FontSize = 18; % dimensione dei testi in pt
set(0,'DefaultaxesFontSize', FontSize,'defaultAxesFontName',FONT,...
    'defaultTextFontSize',FontSize,'defaultTextFontName',FONT,...
    'defaultUicontrolFontSize',FontSize,'defaultUicontrolFontName',FONT,...
    'defaultUitableFontSize',FontSize,'defaultUitableFontName',FONT); %imposta font e dimensione 

set(0,'defaultLineLineWidth',1.5); % imposta lo spessore di default delle curve rappresentate

set(0,'DefaultaxesLineWidth', 0.5) % imposta lo spessore delle linee degli assi
set( 0, 'defaultAxesTickDir', 'out' ,'defaultAxesTickDirMode', 'manual',...
    'defaultAxesXMinorTick','on','defaultAxesYMinorTick','on','defaultAxesZMinorTick','on',...
    'defaultAxesBox', 'off'); % imposta la formattazione degli assi
set(0,'defaultLegendBox' , 'on');

% setting figure deafult size in centimiters.
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*9/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);

%% Reshape

p_e = reshape(p_e, 3, length(tout));
quat_e = reshape(quat_e, 4, length(tout));
baseForce = reshape(baseForce, 3, length(tout));
baseTorque = reshape(baseTorque, 3, length(tout));

%% Plot velocità End Effector
figure(1) %Velocità lineare
plot(tout,v_e(:, 4:6))
grid on
legend('$V_x$','$V_y$','$V_z$')
xlabel('Tempo [$s$]')
ylabel('Vel. [$m/s$]')
title('Vel. lineare End Effector')

figure(2) %Velocità lineare
plot(tout,v_e(:, 1:3))
grid on
legend('$\Omega_x$','$\Omega_y$','$\Omega_z$')
xlabel('Tempo [$s$]')
ylabel('$\Omega$ [$rad/s$]')
title('Vel. angolare End Effector')

%% Plot posizione End Effector
figure(3)

subplot(3,1,1) %Posizione x
plot(tout, p_d(1)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(1,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('x [$m$]')
title('Posizione End Effector')
% ylim([min(0, min(p_e(1,:))) max(p_e(1,:))])
% ylim([0.95*min(p_e(1,:)) 1.05*max(p_e(1,:))])

subplot(3,1,2) %Posizione y
plot(tout, p_d(2)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(2,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('y [$m$]')
% ylim([min(0, min(p_e(2,:))) max(p_e(2,:))])
% ylim([0.95*min(p_e(2,:)) 1.05*max(p_e(2,:))])

subplot(3,1,3) %Posizione y
plot(tout, p_d(3)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(3,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('z [$m$]')
% ylim([min(0, min(p_e(3,:))) max(p_e(3,:))])
% ylim([0.95*min(p_e(3,:)) 1.05*max(p_e(3,:))])

%% Plot Forze alla base
figure(4)

subplot(3,1,1) %Forza lungo x
plot(tout, baseForce(1,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('$F_x$ [$N$]')
title('Forze alla base')

subplot(3,1,2) %Forza lungo y
plot(tout, baseForce(2,:),'r')
grid minor
xlabel('Tempo [$s$]')
ylabel('$F_y$ [$N$]')

subplot(3,1,3) %Forza lungo z
plot(tout, baseForce(3,:),'g')
grid minor
xlabel('Tempo [$s$]')
ylabel('$F_z$ [$N$]')

%% Plot Coppie alla base
figure(5)

subplot(3,1,1) %Coppia lungo asse x
plot(tout, baseTorque(1,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('$T_x$ [$Nm$]')
title('Coppie alla base')

subplot(3,1,2) %Coppia lungo asse y
plot(tout, baseTorque(2,:),'r')
grid minor
xlabel('Tempo [$s$]')
ylabel('$T_y$ [$Nm$]')

subplot(3,1,3) %Coppia lungo asse z
plot(tout, baseTorque(3,:),'g')
grid minor
xlabel('Tempo [$s$]')
ylabel('$T_z$ [$Nm$]')

%% Plot coordinate dei giunti
figure (6)

plot(tout, qmConfig(:,1), LineWidth=2) %Giunto 1
xlabel('Tempo [$s$]')
ylabel('$q_n$ [$rad$]')
title('Coordinate dei giunti')
hold on

plot(tout, qmConfig(:,2), LineWidth=2) %Giunto 2
plot(tout, qmConfig(:,3), LineWidth=2) %Giunto 3
plot(tout, qmConfig(:,4), LineWidth=2) %Giunto 4
plot(tout, qmConfig(:,5), LineWidth=2) %Giunto 5
plot(tout, qmConfig(:,6), LineWidth=2) %Giunto 6
plot(tout, qmConfig(:,7), LineWidth=2) %Giunto 7

%limiti giunti assiali
plot(tout, 1.5*pi*ones(size(tout)), 'r--', LineWidth=0.7)
plot(tout, -1.5*pi*ones(size(tout)), 'r--', LineWidth=0.7)

grid minor
yticks([-2*pi, -1.5*pi, -pi, -0.5*pi, 0, 0.5*pi, pi, 1.5*pi, 2*pi]);
yticklabels({'$-2\pi$' '$-1.5\pi$' '$-\pi$' '$-0.5\pi$' '$0$' ...
            '$0.5\pi$' '$\pi$' '$1.5\pi$' '$2\pi$'})

legend('$q_1$', '$q_2$', '$q_3$', '$q_4$','$q_5$','$q_6$', '$q_7$', Location='southwest');










