function w0 = optimization_wrapper(M, J, invJ, wmConfig, v_d)
    w_start = zeros(7,1);
    
    % Precompute constant terms to avoid function handles
    A = invJ * v_d;
    Z_term = eye(7) - invJ*J;
    const_term = wmConfig - A;
    
    % Define objective using matrix operations
    fun = @(w) 0.5 * (A - Z_term*w)' * M * (A - Z_term*w);
    
    % Nonlinear constraints as matrix equation
    nonlcon = @(w) deal([], const_term - Z_term*w);
    
    % Fixed solver configuration
    opts = optimoptions('fmincon',...
        'Algorithm','sqp',...
        'MaxIterations',100,...
        'Display','none');
    
    % Execute optimization
    w0 = fmincon(fun, w_start, [], [], [], [], [], [], nonlcon, opts);
end