function [robot]=buildrobot()
robot.parts.ee_support=300-115;
robot.parts.ee_TCP=115;

link1=450;  
link2=300;
link3=1200;
link4=150;
link5=1000;
link6=150;
%link7=300;
link7=robot.parts.ee_support+robot.parts.ee_TCP;

robot.DH.a=[0,0,0,0,0,0,0];
robot.DH.d=[link1 link2 link3 link4 link5 link6 link7]*1e-3;
robot.DH.alpha=[pi/2 -pi/2 -pi/2 -pi/2 pi/2 pi/2 0];
robot.DH.offset=0;

robot.parts.m=54*1e-3;      %[m] lunghezza del motore
robot.parts.l=robot.DH.d-robot.parts.m;         %[m] lunghezza dei tubi costituenti i link
robot.parts.l(end)=robot.parts.l(end)-robot.parts.ee_TCP*1e-3;

robot.parts.thickness=3*1e-3;    %[m] spessore del tubo costituente il robot
robot.rho=2740; %[kg/m3]
robot.r=[0.05,0.05,.05,.05,.05,.05,.05];   %[m]

robot.parts.l_mass=pi*(robot.r.^2-(robot.r-robot.parts.thickness).^2).*robot.parts.l*robot.rho;

%% GNC parameters
robot.GNC.stiff_lin=[0,1e2]; %[N/m]
robot.GNC.damp_lin=[0,1e2]; %[Ns/m]

robot.GNC.stiff_rot=[0,1e1]; %[Nm/deg]
robot.GNC.damp_rot=[0,1e1]; %[Nms/deg]

% robot.GNC.stiff_lin=0; %[N/m]
% robot.GNC.damp_lin=0; %[Ns/m]
% 
% robot.GNC.stiff_rot=0; %[Nm/deg]
% robot.GNC.damp_rot=0; %[Nms/deg]

%% Contact parameters

robot.contact.proximity_radius=1*1e-3;      %[m] contact sphere radius
%robot.contact.stiffness=[1.28e5,3.7e5,4.28e3,4.86e4];
robot.contact.stiffness=[1e3,1e4,1e5,1e6];%[N/m] contact stiffness
robot.contact.damping=robot.contact.stiffness*1e-3*5;                  %[Ns/m] contact damping
robot.contact.penetration=[1,1,1,1]*1e-4;             %[m] contact penetration depth

robot.contact.mud=0.15;
robot.contact.mus=0.5;
robot.contact.Vc=5*1e-4;                   %[m/s] critical transition velocity

%% friction parameters
robot.friction.joint_vsc=2; %[Nms/deg]

%% PI position loop control

% PWM Control
%  T_switch =  1e-4;                           %[s] PWM carrier period


% PI motor velocity loop control
%kp_v = 10*10000;                           %[A*s/m]
kp_v = 5*10;
ki_v = 5;                                  %[A*s^2/m]


% Driver 1
% robot.driver1.pos.P = kp_p;
% robot.driver1.pos.I = ki_p;
robot.driver1.vel.P = kp_v;     
robot.driver1.vel.I = ki_v;   
robot.driver1.cur.P = 50;  
robot.driver1.cur.I = 10; 
% robot.driver1.PWM_t= T_switch;         

% Driver 2
% robot.driver2.pos.P = kp_p;
% robot.driver2.pos.I = ki_p;
robot.driver2.vel.P = kp_v;     
robot.driver2.vel.I = ki_v;   
robot.driver2.cur.P = 50;  
robot.driver2.cur.I = 10; 
% robot.driver2.PWM_t= T_switch;  

% Driver 3
% robot.driver3.pos.P = kp_p;
% robot.driver3.pos.I = ki_p;
robot.driver3.vel.P = kp_v;     
robot.driver3.vel.I = ki_v;   
robot.driver3.cur.P = 50;  
robot.driver3.cur.I = 10; 
% robot.driver3.PWM_t= T_switch;  

% Driver 4
% robot.driver1.pos.P = kp_p;
% robot.driver1.pos.I = ki_p;
robot.driver4.vel.P =  kp_v;     
robot.driver4.vel.I = ki_v;   
robot.driver4.cur.P = 50;  
robot.driver4.cur.I = 10; 
% robot.driver1.PWM_t= T_switch;         

% Driver 5
% robot.driver2.pos.P = kp_p;
% robot.driver2.pos.I = ki_p;
robot.driver5.vel.P =  kp_v;     
robot.driver5.vel.I = ki_v;   
robot.driver5.cur.P = 50;  
robot.driver5.cur.I = 10; 
% robot.driver5.PWM_t= T_switch;  

% Driver 6
% robot.driver3.pos.P = kp_p;
% robot.driver3.pos.I = ki_p;
robot.driver6.vel.P =  kp_v;     
robot.driver6.vel.I = ki_v;   
robot.driver6.cur.P = 50;  
robot.driver6.cur.I = 10; 
% robot.driver3.PWM_t= T_switch;  

%% Motor and Driver Parameters

%Simple DC Motor
robot.motor1.mass = 790e-3;                     %[kg] Motor Mass
robot.motor1.V  = 24;                           %[V] DC monophase equivalent supply voltage
robot.motor1.R  = 161e-3;                       %[Ohm] DC motor resistance                      DA STIMARE
robot.motor1.Im = 400e-06;                      %[kg*m^2] motors rotor inertia                   DA STIMARE
robot.motor1.L  = 73e-6;                        %[H] DC motor inductance                        DA STIMARE
robot.motor1.kc = 0.095;                        %[Nm/A] DC motor torque constant
robot.motor1.kv = 1/(100*.1047);                %[V*s/rad] DC motor electrical constant
robot.motor1.Tmax = 120;                        %[N*m] Max motoreducer torque
robot.motor1.imax = robot.motor1.Tmax/robot.motor1.kc;  %[A] Max current

robot.motor2.mass = robot.motor1.mass;          %[kg] Motor Mass
robot.motor2.V  = robot.motor1.V;               %[V] DC monophase equivalent supply voltage
robot.motor2.R  = robot.motor1.R;               %[Ohm] DC motor resistance
robot.motor2.Im = robot.motor1.Im;              %[kg*m^2] motors rotor inertia
robot.motor2.L  = robot.motor1.L;               %[H] DC motor inductance
robot.motor2.kc = robot.motor1.kc;              %[Nm/A] DC motor torque constant
robot.motor2.kv = robot.motor1.kv;              %[V*s/rad] DC motor electrical constant
robot.motor2.Tmax = robot.motor1.Tmax;          %[N*m] Max motor torque
robot.motor2.imax = robot.motor1.imax;          %[A] Max current

robot.motor3.mass = robot.motor1.mass;          %[kg] Motor Mass
robot.motor3.V  = robot.motor1.V;               %[V] DC monophase equivalent supply voltage
robot.motor3.R  = robot.motor1.R;               %[Ohm] DC motor resistance
robot.motor3.Im = 187.740e-06;                  %[kg*m^2] motors rotor inertia
robot.motor3.L  = robot.motor1.L;               %[H] DC motor inductance
robot.motor3.kc = robot.motor1.kc;              %[Nm/A] DC motor torque constant
robot.motor3.kv = robot.motor1.kv;              %[V*s/rad] DC motor electrical constant
robot.motor3.Tmax = robot.motor1.Tmax;          %[N*m] Max motor torque
robot.motor3.imax = robot.motor1.imax;          %[A] Max current

%Simple DC Motor
robot.motor4.mass = 790e-3;                     %[kg] Motor Mass
robot.motor4.V  = 24;                           %[V] DC monophase equivalent supply voltage
robot.motor4.R  = 1.2;                           %[Ohm] DC motor resistance                      
robot.motor4.Im = 300e-06;                      %[kg*m^2] motors rotor inertia                   
robot.motor4.L  = 1.2e-3;                        %[H] DC motor inductance                        
robot.motor4.kc = 0.7;                          %[Nm/A] DC motor torque constant
robot.motor4.kv = 1/(100*.1047);                %[V*s/rad] DC motor electrical constant
robot.motor4.Tmax = 3;                         %[N*m] Max motoreducer torque
robot.motor4.imax = robot.motor4.Tmax/robot.motor4.kc;  %[A] Max current

robot.motor5.mass = robot.motor4.mass;          %[kg] Motor Mass
robot.motor5.V  = robot.motor4.V;               %[V] DC monophase equivalent supply voltage
robot.motor5.R  = robot.motor4.R;               %[Ohm] DC motor resistance
robot.motor5.Im = robot.motor4.Im;              %[kg*m^2] motors rotor inertia
robot.motor5.L  = robot.motor4.L;               %[H] DC motor inductance
robot.motor5.kc = robot.motor4.kc;              %[Nm/A] DC motor torque constant
robot.motor5.kv = robot.motor4.kv;              %[V*s/rad] DC motor electrical constant
robot.motor5.Tmax = robot.motor4.Tmax;          %[N*m] Max motor torque
robot.motor5.imax = robot.motor4.imax;          %[A] Max current

robot.motor6.mass = robot.motor4.mass;          %[kg] Motor Mass
robot.motor6.V  = robot.motor4.V;               %[V] DC monophase equivalent supply voltage
robot.motor6.R  = robot.motor4.R;               %[Ohm] DC motor resistance
robot.motor6.Im = robot.motor4.Im;              %[kg*m^2] motors rotor inertia
robot.motor6.L  = robot.motor4.L;               %[H] DC motor inductance
robot.motor6.kc = robot.motor4.kc;              %[Nm/A] DC motor torque constant
robot.motor6.kv = robot.motor4.kv;              %[V*s/rad] DC motor electrical constant
robot.motor6.Tmax = robot.motor4.Tmax;          %[N*m] Max motor torque
robot.motor6.imax = robot.motor4.imax;          %[A] Max current

%% Motor contact force
robot.motor1.Ks = 1e6;                           %[Nm/rad] Ks_shaft 
robot.motor1.Cs = 1e2;                           %[Nm/(rad/s)] Cs_shaft

robot.motor2.Ks = robot.motor1.Ks;                           %[Nm/rad] Ks_shaft 
robot.motor2.Cs = robot.motor1.Cs;                           %[Nm/(rad/s)] Cs_shaft

robot.motor3.Ks = robot.motor1.Ks;                           %[Nm/rad] Ks_shaft 
robot.motor3.Cs = robot.motor1.Cs;                           %[Nm/(rad/s)] Cs_shaft

robot.motor4.Ks = robot.motor1.Ks;                           %[Nm/rad] Ks_shaft 
robot.motor4.Cs = robot.motor1.Cs;                           %[Nm/(rad/s)] Cs_shaft

robot.motor5.Ks = robot.motor1.Ks;                           %[Nm/rad] Ks_shaft 
robot.motor5.Cs = robot.motor1.Cs;                           %[Nm/(rad/s)] Cs_shaft

robot.motor6.Ks = robot.motor1.Ks;                           %[Nm/rad] Ks_shaft 
robot.motor6.Cs = robot.motor1.Cs;                           %[Nm/(rad/s)] Cs_shaft
%% Gearbox Parameters

robot.motor1.eta = 0.85;                              %[/] gear box efficiency
robot.motor2.eta = 0.85;                              %[/] gear box efficiency
robot.motor3.eta = 0.85;                              %[/] gear box efficiency

robot.motor4.eta = 0.85;                              %[/] gear box efficiency
robot.motor5.eta = 0.85;                              %[/] gear box efficiency
robot.motor6.eta = 0.85;                              %[/] gear box efficiency

robot.motor1.tau = 64;                             %[/] ratio
robot.motor2.tau = 64;                             %[/] ratio
robot.motor3.tau = 64;                             %[/] ratio

robot.motor4.tau = 64;                             %[/] ratio
robot.motor5.tau = 64;                             %[/] ratio
robot.motor6.tau = 64;                             %[/] ratio

%% Sensors Parameters
%Current Sensor
robot.current_sensor.tau_i = 1/(2000*2*pi);                      %[s] Current sensor time constant
robot.current_sensor.Hi = 1;                                     %[V/A] Current sensor static gain

end