function [Jx, Jtau] = dynJacobian(x, tau)
    persistent robot
    if isempty(robot)
        robot = rbtFcn();
        robot.DataFormat = 'column';
    end

    l = length(x)/2;
    q = x(1:l);
    v = x(l+1:end);

    M = massMatrix(robot, q);
    Cv = velocityProduct(robot, q, v);
    G = gravityTorque(robot, q);

    % Calcolo delle derivate
    % Derivata rispetto a x
    dM_dq = compute_dM_dq(robot, q); % Funzione da definire per calcolare la derivata di M
    dCv_dq = compute_dCv_dq(robot, q, v); % Funzione da definire per calcolare la derivata di Cv
    dG_dq = compute_dG_dq(robot, q); % Funzione da definire per calcolare la derivata di G

    % Derivata delle accelerazioni
    dxdot_dx = [eye(l); M\(-dCv_dq - dG_dq + zeros(size(tau)))]; % Derivata della velocità
    dxdot_dtau = M\eye(length(tau)); % Derivata delle accelerazioni rispetto a tau

    Jx = [[eye(l); zeros(l)], dxdot_dx];
    Jtau = [zeros(l); dxdot_dtau];

    % J = [dxdot_dx, dxdot_dtau]; % Concatenazione delle Jacobiane
end
