function [dCv_dq, dCv_dv] = compute_dCv_dq(robot, q, v)
    % Calcola le derivate numeriche del termine Coriolis rispetto a q e v
    numJoints = length(q);
    dCv_dq = zeros(numJoints, numJoints); % Matrice 2D
    dCv_dv = zeros(numJoints, numJoints); % Matrice 2D

    delta = 1e-6; % Piccola variazione per differenze finite

    % Derivata rispetto a q
    for i = 1:numJoints
        qPerturbPlus = q;
        qPerturbMinus = q;
        qPerturbPlus(i) = qPerturbPlus(i) + delta;
        qPerturbMinus(i) = qPerturbMinus(i) - delta;

        CvPlus = velocityProduct(robot, qPerturbPlus, v);
        CvMinus = velocityProduct(robot, qPerturbMinus, v);

        dCv_dq(:, i) = (CvPlus - CvMinus) / (2 * delta); % Differenze finite
    end

    % Derivata rispetto a v
    for i = 1:numJoints
        vPerturbPlus = v;
        vPerturbMinus = v;
        vPerturbPlus(i) = vPerturbPlus(i) + delta;
        vPerturbMinus(i) = vPerturbMinus(i) - delta;

        CvPlus = velocityProduct(robot, q, vPerturbPlus);
        CvMinus = velocityProduct(robot, q, vPerturbMinus);

        dCv_dv(:, i) = (CvPlus - CvMinus) / (2 * delta); % Differenze finite
    end
end
