clc
clear
close all

%%

v0 = 0.01; %velocita massima m/s
a0 = 0.005; %accelerazione massima m/s2
a1 = 0.0005;

robot=buildrobot();
spacecraft=buildspace();

%%
mt=500;
cs=5;
b=0.1;
Mt=mt*a0*b*cs/(2*robot.contact.mud);
F=2*Mt/(8*b);
%%

v_s_0=-1; %[mm/s]
w_s_0=-0.05*pi/180; %[rad/s]


t_sim=600;
t_int_max=1e-2;
abs_toll=1e-3;
t0=5;
sim_name=["video\BTH_NO_GNC","video\NO_BTH_NO_GNC";"video\BTH_GNC","video\NO_BTH_GNC"];

i=1;
j=1;
for k=1:4
    target_pos=spacecraft.target_pos(i,:);
    target_rot=spacecraft.target_rot(i,:);
    place_pos=spacecraft.place_pos(i,:);
    place_rot=spacecraft.place_rot(i,:);
    q0=spacecraft.robot_ic(i,:);
    
    out(k)=sim("ROBOT7DOF_simulink.slx");
end
