function setupLatexPlot()
%% Latex
% Setup iniziale
set(0,'defaultTextInterpreter','latex'); % imposta l'interprete latex per i testi
set(0, 'defaultAxesTickLabelInterpreter','latex'); % imposta l'interprete latex per i testi degli 
set(0, 'defaultLegendInterpreter','latex'); % imposta l'interprete latex per le legende

FONT = 'Times'; % font dei testi
FontSize = 18; % dimensione dei testi in pt
set(0,'DefaultaxesFontSize', FontSize,'defaultAxesFontName',FONT,...
    'defaultTextFontSize',FontSize,'defaultTextFontName',FONT,...
    'defaultUicontrolFontSize',FontSize,'defaultUicontrolFontName',FONT,...
    'defaultUitableFontSize',FontSize,'defaultUitableFontName',FONT); %imposta font e dimensione 

set(0,'defaultLineLineWidth',1.5); % imposta lo spessore di default delle curve rappresentate

set(0,'DefaultaxesLineWidth', 0.5) % imposta lo spessore delle linee degli assi
set( 0, 'defaultAxesTickDir', 'out' ,'defaultAxesTickDirMode', 'manual',...
    'defaultAxesXMinorTick','on','defaultAxesYMinorTick','on','defaultAxesZMinorTick','on',...
    'defaultAxesBox', 'off'); % imposta la formattazione degli assi
set(0,'defaultLegendBox' , 'on');

% setting figure deafult size in centimiters.
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*9/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);
end