clc
%% Conversion angle
l = length(tout);
angeul = zeros(3,l); %preallocazione
for i=1:l
 angeul(:,i) = quat2eul(quat_e(:,:,i)'); %conversione in angoli di eulero ZYX
end
theta = angeul(2,:)*180/pi; %conversione in gradi dell'angolo theta (tr.2)
angeul = angeul*180/pi; %conversione intero vettore in gradi
% clear angeul

%% Standard
% tout_standard = tout;
% theta_standard = theta;
% save('errang_standard', "tout_standard", "theta_standard");

%% Pesata
% tout_weight = tout;
% theta_weight = theta;
% save('errang_weight', "tout_weight", "theta_weight");

%% Null-space
% tout_nullsp = tout;
% theta_nullsp = theta;
% save('errang_nullsp', "tout_nullsp", "theta_nullsp");

%% MPC
% tout_mpc = tout;
% theta_mpc = theta;
% save('errang_mpc', "tout_mpc", "theta_mpc");
% 

%% Inserimento forza
figure
load('external_force.mat');
plot(tstep, -zforce)
grid on
ylim([min(-zforce)-1 max(-zforce)+1])
xlabel('Tempo [$s$]')
ylabel('$F$ [$N$]')
% title('Forza applicata su End Effector')
xline([6 8],'r--', LineWidth=1.2)

%%
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*6/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);




