close all, clc

%% Latex
% Setup iniziale
set(0,'defaultTextInterpreter','latex'); % imposta l'interprete latex per i testi
set(0, 'defaultAxesTickLabelInterpreter','latex'); % imposta l'interprete latex per i testi degli 
set(0, 'defaultLegendInterpreter','latex'); % imposta l'interprete latex per le legende

FONT = 'Times'; % font dei testi
FontSize = 18; % dimensione dei testi in pt
set(0,'DefaultaxesFontSize', FontSize,'defaultAxesFontName',FONT,...
    'defaultTextFontSize',FontSize,'defaultTextFontName',FONT,...
    'defaultUicontrolFontSize',FontSize,'defaultUicontrolFontName',FONT,...
    'defaultUitableFontSize',FontSize,'defaultUitableFontName',FONT); %imposta font e dimensione 

set(0,'defaultLineLineWidth',1.5); % imposta lo spessore di default delle curve rappresentate

set(0,'DefaultaxesLineWidth', 0.5) % imposta lo spessore delle linee degli assi
set( 0, 'defaultAxesTickDir', 'out' ,'defaultAxesTickDirMode', 'manual',...
    'defaultAxesXMinorTick','on','defaultAxesYMinorTick','on','defaultAxesZMinorTick','on',...
    'defaultAxesBox', 'off'); % imposta la formattazione degli assi
set(0,'defaultLegendBox' , 'on');

% setting figure deafult size in centimiters.
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*9/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);

%% Plot velocità End Effector
l = length(tout);
%preallocazione
v_lin = zeros(1, l);
v_ang = zeros(1, l);
%calcolo norma velocità angolare e lineare
for i=1:l
    v_lin(i) = norm([v_e(i,4) v_e(i,5) v_e(i,6)]); %vel. lineare
    v_ang(i) = norm([v_e(i,1) v_e(i,2) v_e(i,3)]); %vel. angolare
end
figure(1) %Velocità lineare
plot(tout,v_lin)
grid on
hold on
xlabel('Tempo [$s$]')
ylabel('Vel. [$m/s$]')
title('Vel. lineare End Effector')
yline(v0,'--', LineWidth=1.2)
ylim([0 1.1*v0])
yyaxis right
plot(tstep, -zforce, '--')
ylim([0 14])
ylabel('F [$N$]')


figure(2) %Velocità angolare
plot(tout,v_ang)
grid on
% legend('$\Omega_x$','$\Omega_y$','$\Omega_z$')
xlabel('Tempo [$s$]')
ylabel('$\Omega$ [$rad/s$]')
title('Vel. angolare End Effector')
yline(omega0,'--', LineWidth=1.2)
ylim([0 1.1*omega0])
yyaxis right
plot(tstep, -zforce, '--')
ylim([0 14])
ylabel('F [$N$]')

%% Plot norma errore di posizione

%Carico traiettoria
switch traiettoria
    case 1
        dataConfig = load("reference_traiettorie\traiettoria1.mat");
    case 2
        dataConfig = load("reference_traiettorie\traiettoria2.mat");
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end

%Inizializzazione
pos_ee = zeros(length(dataConfig.tout),3);
err = zeros(length(tout),3);
norm_err = zeros(length(tout),1);

%Calcolo traiettoria come posizione dell'End-Effector (cin. diretta)
for i=1:length(dataConfig.tout)
    htform = getTransform(DOF7_Arm, dataConfig.qmConfig(i,:), 'Body9', 'Base');
    pos_ee(i,:) = tform2trvec(htform);
end
clear htform

%Calcolo norma errore di posizione
for i=1:l
    err(i,1) = interp1(dataConfig.tout, pos_ee(:,1), tout(i)) - p_e(1,i);
    err(i,2) = interp1(dataConfig.tout, pos_ee(:,2), tout(i)) - p_e(2,i);
    err(i,3) = interp1(dataConfig.tout, pos_ee(:,3), tout(i)) - p_e(3,i);
    norm_err(i) = norm([err(i,1) err(i,2) err(i,3)]);
end
clear err

%Plot
figure(3)
plot(tout, 1000*norm_err)
grid minor
xlabel('Tempo [$s$]')
ylabel('Err. [$mm$]')
title('Errore di posizione End-Effector')

%% Salvataggio dati

% tout_weight = tout;
% norm_err_weight = norm_err;
% save('error_weight','tout_weight','norm_err_weight');








