close all, clc

%% Latex
% Setup iniziale
set(0,'defaultTextInterpreter','latex'); % imposta l'interprete latex per i testi
set(0, 'defaultAxesTickLabelInterpreter','latex'); % imposta l'interprete latex per i testi degli 
set(0, 'defaultLegendInterpreter','latex'); % imposta l'interprete latex per le legende

FONT = 'Times'; % font dei testi
FontSize = 18; % dimensione dei testi in pt
set(0,'DefaultaxesFontSize', FontSize,'defaultAxesFontName',FONT,...
    'defaultTextFontSize',FontSize,'defaultTextFontName',FONT,...
    'defaultUicontrolFontSize',FontSize,'defaultUicontrolFontName',FONT,...
    'defaultUitableFontSize',FontSize,'defaultUitableFontName',FONT); %imposta font e dimensione 

set(0,'defaultLineLineWidth',1.5); % imposta lo spessore di default delle curve rappresentate

set(0,'DefaultaxesLineWidth', 0.5) % imposta lo spessore delle linee degli assi
set( 0, 'defaultAxesTickDir', 'out' ,'defaultAxesTickDirMode', 'manual',...
    'defaultAxesXMinorTick','on','defaultAxesYMinorTick','on','defaultAxesZMinorTick','on',...
    'defaultAxesBox', 'off'); % imposta la formattazione degli assi
set(0,'defaultLegendBox' , 'on');

% setting figure deafult size in centimiters.
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*9/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);

%% Reshape

p_e = reshape(p_e, 3, length(tout));
% quat_e = reshape(quat_e, 4, length(tout));
baseForce = reshape(baseForce, 3, length(tout));
baseTorque = reshape(baseTorque, 3, length(tout));

%% Plot velocità End Effector
figure(1) %Velocità lineare
plot(tout,v_e(:, 4:6))
grid on
legend('$V_x$','$V_y$','$V_z$')
xlabel('Tempo [$s$]')
ylabel('Vel. [$m/s$]')
title('Vel. lineare End Effector')

figure(2) %Velocità angolare
plot(tout,v_e(:, 1:3))
grid on
legend('$\Omega_x$','$\Omega_y$','$\Omega_z$')
xlabel('Tempo [$s$]')
ylabel('$\Omega$ [$rad/s$]')
title('Vel. angolare End Effector')

%% Plot posizione End Effector
figure(3)

subplot(3,1,1) %Posizione x
plot(tout, p_d(1)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(1,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('x [$m$]')
title('Posizione End Effector')
% ylim([min(0, min(p_e(1,:))) max(p_e(1,:))])
% ylim([0.95*min(p_e(1,:)) 1.05*max(p_e(1,:))])

subplot(3,1,2) %Posizione y
plot(tout, p_d(2)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(2,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('y [$m$]')
% ylim([min(0, min(p_e(2,:))) max(p_e(2,:))])
% ylim([0.95*min(p_e(2,:)) 1.05*max(p_e(2,:))])

subplot(3,1,3) %Posizione y
plot(tout, p_d(3)*ones(length(tout)), 'r--', 'LineWidth',0.5)
hold on
plot(tout, p_e(3,:),'b')
grid minor
xlabel('Tempo [$s$]')
ylabel('z [$m$]')
% ylim([min(0, min(p_e(3,:))) max(p_e(3,:))])
% ylim([0.95*min(p_e(3,:)) 1.05*max(p_e(3,:))])

%% Plot Forze alla base
figure(4)

%Plot su 3 grafici
% subplot(3,1,1) %Forza lungo x
% plot(tout, baseForce(1,:),'b')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$F_x$ [$N$]')
% title('Forze alla base')
% 
% subplot(3,1,2) %Forza lungo y
% plot(tout, baseForce(2,:),'r')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$F_y$ [$N$]')
% 
% subplot(3,1,3) %Forza lungo z
% plot(tout, baseForce(3,:),'g')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$F_z$ [$N$]')

%Plot su 1 grafico unito
plot(tout, baseForce(1,:))
grid minor
xlabel('Tempo [$s$]')
ylabel('$F$ [$N$]')
title('Forze alla base')
hold on
plot(tout, baseForce(2,:))
plot(tout, baseForce(3,:))
legend('$F_x$','$F_y$','$F_z$')

%% Plot Coppie alla base
figure(5)

%Plot su 3 grafici
% subplot(3,1,1) %Coppia lungo asse x
% plot(tout, baseTorque(1,:),'b')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$T_x$ [$Nm$]')
% title('Coppie alla base')
% 
% subplot(3,1,2) %Coppia lungo asse y
% plot(tout, baseTorque(2,:),'r')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$T_y$ [$Nm$]')
% 
% subplot(3,1,3) %Coppia lungo asse z
% plot(tout, baseTorque(3,:),'g')
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$T_z$ [$Nm$]')

%Plot su 1 grafico unito
plot(tout, baseTorque(1,:))
grid minor
xlabel('Tempo [$s$]')
ylabel('$T$ [$N$]')
title('Coppie alla base')
hold on
plot(tout, baseTorque(2,:))
plot(tout, baseTorque(3,:))
legend('$T_x$','$T_y$','$T_z$')

%% Plot coordinate dei giunti
figure (6)

plot(tout, qmConfig(:,1), LineWidth=2) %Giunto 1
xlabel('Tempo [$s$]')
ylabel('$q_n$ [$rad$]')
title('Coordinate dei giunti')
hold on

plot(tout, qmConfig(:,2), LineWidth=2) %Giunto 2
plot(tout, qmConfig(:,3), LineWidth=2) %Giunto 3
plot(tout, qmConfig(:,4), LineWidth=2) %Giunto 4
plot(tout, qmConfig(:,5), LineWidth=2) %Giunto 5
plot(tout, qmConfig(:,6), LineWidth=2) %Giunto 6
plot(tout, qmConfig(:,7), LineWidth=2) %Giunto 7

%limiti giunti assiali
plot(tout, 1*pi*ones(size(tout)), 'r--', LineWidth=0.7)
plot(tout, -1*pi*ones(size(tout)), 'r--', LineWidth=0.7)

grid minor
yticks([-2*pi, -1.5*pi, -pi, -0.5*pi, 0, 0.5*pi, pi, 1.5*pi, 2*pi]);
yticklabels({'$-2\pi$' '$-1.5\pi$' '$-\pi$' '$-0.5\pi$' '$0$' ...
            '$0.5\pi$' '$\pi$' '$1.5\pi$' '$2\pi$'})

legend('$q_1$', '$q_2$', '$q_3$', '$q_4$','$q_5$','$q_6$', '$q_7$', Location='southwest');

%% Plot velocità giunti
figure (7)

plot(tout, wmConfig(:,1), LineWidth=2) %Giunto 1
xlabel('Tempo [$s$]')
ylabel('$\dot{q_n}$ [$rad/s$]')
title('Vel. dei giunti')
hold on
grid minor

for i = 2:7
    plot(tout, wmConfig(:,i), LineWidth=2);
end
clear i
legend('$\dot{q_1}$', '$\dot{q_2}$', '$\dot{q_3}$', '$\dot{q_4}$','$\dot{q_5}$','$\dot{q_6}$', '$\dot{q_7}$', Location='northeast');

%% Plot confronto coppie e forze
% %Coppie
% figure(8)
% 
% plot(MPC_tout, MPC_Torque)
% hold on
% plot(standard_tout, standard_Torque)
% plot(weighted_tout, weighted_Torque)
% plot(nullspace_tout, nullspace_Torque)
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$T$ [$Nm$]')
% title('Modulo coppia risultante')
% legend('MPC', 'Pseudoinversa', 'Ps. pesata', 'Ps. null-space')
% 
% %Forze
% figure(9)
% 
% plot(MPC_tout, MPC_Force)
% hold on
% plot(standard_tout, standard_Force)
% plot(weighted_tout, weighted_Force)
% plot(nullspace_tout, nullspace_Force)
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$F$ [$N$]')
% title('Modulo forza risultante')
% legend('MPC', 'Pseudoinversa', 'Ps. pesata', 'Ps. null-space')

%% Plot Energia cinetica nel tempo

%Calcolo energia cinetica del manipolatore durante la simulazione
%Preallocazione
Ek = zeros(length(tout), 1);
DOF7_Arm.DataFormat = 'row';

for i = 1:length(tout)
    M = massMatrix(DOF7_Arm, qmConfig(i,:));
    Ek(i) = 0.5 * wmConfig(i,:) * M * wmConfig(i,:)';
end
clear i M

%Plot
figure(10)
plot(tout, 1000*Ek)
grid on
xlabel('Tempo [$s$]')
ylabel('$E_k$ [$mJ$]')
title('Energia Cinetica manipolatore')

%% Save data
% tout_weight = tout;
% Ek_weight = Ek;
% save('ekData_weight','tout_weight','Ek_weight');

% tConfig_weight = tConfig;
% tout_weight = tout;
% save('T_weight', 'tout_weight','tConfig_weight');

%% Plot confronto posizioni giunti rispetto a valore desiderato (solo MPC)
if exist('qDes','var')
    figure(11)
    plot(tout, qmConfig)
    hold on
    grid minor
    xlabel('Tempo [$s$]')
    ylabel('$q$ [$rad$]')
    title('Confronto posizione giunti')
    plot(tout, qDes, '--', LineWidth=0.5)

    %limiti giunti assiali
    plot(tout, 1*pi*ones(size(tout)), 'r--', LineWidth=0.7)
    plot(tout, -1*pi*ones(size(tout)), 'r--', LineWidth=0.7)

    yticks([-2*pi, -1.5*pi, -pi, -0.5*pi, 0, 0.5*pi, pi, 1.5*pi, 2*pi]);
    yticklabels({'$-2\pi$' '$-1.5\pi$' '$-\pi$' '$-0.5\pi$' '$0$' ...
                '$0.5\pi$' '$\pi$' '$1.5\pi$' '$2\pi$'})

    legend('$q_1$', '$q_2$', '$q_3$', '$q_4$','$q_5$','$q_6$', '$q_7$', Location='southwest');
end

%% Plot confronto velocità giunti rispetto a valore desiderato (solo MPC)
if exist('wDes','var')
    figure(12)
    plot(tout, wmConfig)
    hold on
    grid minor
    xlabel('Tempo [$s$]')
    ylabel('$w$ [$rad$]')
    title('Confronto vel. giunti')
    plot(tout, wDes, '--', LineWidth=0.5)
    legend('$\dot{q_1}$', '$\dot{q_2}$', '$\dot{q_3}$', '$\dot{q_4}$','$\dot{q_5}$','$\dot{q_6}$', '$\dot{q_7}$', Location='northeast');

end

%% Plot coppie ai giunti
if exist('tConfig','var')
    figure(13)
    plot(tout, tConfig)
    % plot(linspace(0,tout(end),length(tConfig(:,1))), tConfig)
    hold on
    grid on
    xlabel('Tempo [$s$]')
    ylabel('$T$ [$Nm$]')
    title('Coppie ai giunti')
    xline([6 8],'r--', LineWidth=1.2)
    legend('$T_1$','$T_2$','$T_3$','$T_4$','$T_5$','$T_6$','$T_7$')

end

%% Plot forza esterna applicata
figure(14)
% plot(tstep, xforce)
% hold on
% plot(tstep, yforce)
plot(tstep, -zforce)
grid on
ylim([min(-zforce)-1 max(-zforce)+1])
xlabel('Tempo [$s$]')
ylabel('$F$ [$N$]')
title('Forza applicata su End Effector')
xline([6 8],'r--', LineWidth=1.2)

%% Rigidezza del sistema (non funziona come vorrei, a causa del denominatore piccolo)
force = zeros(1, length(tout));
displace = zeros(1, length(tout));
for i = 1:length(tout)
    force(i) = interp1(tstep,zforce, tout(i));
    displace(i) = norm([p_d(1)-p_e(1,i) p_d(2)-p_e(2,i) p_d(3)-p_e(3,i)]);
end
stiffness = abs(force)./displace;

figure(15)
plot(tout, stiffness)
grid on
xlabel('Tempo [$s$]')
ylabel('$F/\Delta_X$ [$N/m$]')
title('Rigidezza del sistema')

c = find(tout>6);
max_disp = max(displace(c:end)); %[m], Scostamento max con forza applicata
rigidezza = max(abs(force))/max_disp
clear i force displace c





