function robot = rbtFcn(dataFormat)
%rbtFcn Create rigidBodyTree for the robot model
%   ROBOT = rbtFcn(DATAFORMAT) constructs a rigidBodyTree, ROBOT, and sets the
%   data format to DATAFORMAT. The possible values of DATAFORMAT are 
%   'struct', 'column' and 'row'. The default value is 'row', which 
%   matches the data format of the rigidbodytree object used to generate 
%   this function.

%   Auto-generated by MATLAB on 15-Jul-2025 09:53:50

%#codegen

narginchk(0,1);
if ~nargin==1
dataFormat='row';
end
robot = rigidBodyTree('MaxNumBodies', 9, 'DataFormat', dataFormat);
robot.Gravity = [                     0,                      0,                     -0];
robot.BaseName = 'Base';


% Add body, 'Body1', and joint, 'Joint1'
bodyName = 'Body1';
bodyMass =      1.549433496750486;
bodyCoM = [                    -0,                     -0,                     -0];
bodyInertia = [  0.001717288792231788,   0.001717288792231788,   0.002788980294150874,                      0,                      0,                      0];
parentName = 'Base';
jointName = 'Joint1';
jointType = 'fixed';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,                      1,                      0,                      0; ...
                                         -0,                      0,                      1,                 -0.025; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body2', and joint, 'Joint2'
bodyName = 'Body2';
bodyMass =                0.04384;
bodyCoM = [                    -0,                     -0,                   0.02];
bodyInertia = [ 2.484266666666667e-05,  2.484266666666667e-05,  2.922666666666668e-06,                      0,                      0,                      0];
parentName = 'Body1';
jointName = 'Joint2';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,                      1,                      0,                      0; ...
                                         -0,                      0,                      1,                  0.025; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =     0.1745329251994329;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body3', and joint, 'Joint3'
bodyName = 'Body3';
bodyMass =                 0.1096;
bodyCoM = [                    -0,   -0.05000000000000001,                     -0];
bodyInertia = [ 0.0003689866666666668,   7.30666666666666e-06,  0.0003689866666666668,  5.368851567461998e-21,                      0,                      0];
parentName = 'Body2';
jointName = 'Joint3';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                     -0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                      1,                      0; ...
                                         -0,                     -1,  6.123233995736766e-17,                   0.04; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =    -0.2617993877991494;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body4', and joint, 'Joint4'
bodyName = 'Body4';
bodyMass =                 0.1096;
bodyCoM = [                    -0,                     -0,                   0.05];
bodyInertia = [ 0.0003689866666666667,  0.0003689866666666667,   7.30666666666666e-06,                      0,                      0,                      0];
parentName = 'Body3';
jointName = 'Joint4';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                     -1,                   -0.1; ...
                                         -0,                      1,  6.123233995736766e-17, -1.387778780781446e-17; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =                      0;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body5', and joint, 'Joint5'
bodyName = 'Body5';
bodyMass =                 0.1918;
bodyCoM = [                    -0,   -0.08750000000000004, -1.387778780781446e-17];
bodyInertia = [  0.001964351666666668,  1.278666666666664e-05,   0.001964351666666668, -2.033228600725168e-19,                      0,                      0];
parentName = 'Body4';
jointName = 'Joint5';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                     -0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                      1,                      0; ...
                                         -0,                     -1,  6.123233995736766e-17,                    0.1; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =       1.74532925199433;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body6', and joint, 'Joint6'
bodyName = 'Body6';
bodyMass =                0.00548;
bodyCoM = [                    -0,                     -0,                   0.01];
bodyInertia = [ 7.763333333333335e-07,  7.763333333333335e-07,  9.133333333333337e-08,                      0,                      0,                      0];
parentName = 'Body5';
jointName = 'Joint6';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                     -1,    -0.1750000000000001; ...
                                         -0,                      1,  6.123233995736766e-17, -2.775557561562891e-17; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =                      0;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body7', and joint, 'Joint7'
bodyName = 'Body7';
bodyMass =                0.00822;
bodyCoM = [                    -0,                 -0.015, -3.469446951953614e-18];
bodyInertia = [ 2.534500000000001e-06,  1.369999999999999e-07,  2.534500000000001e-06, -3.942274868792433e-22,                      0,                      0];
parentName = 'Body6';
jointName = 'Joint7';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                     -0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                      1,                      0; ...
                                         -0,                     -1,  6.123233995736766e-17,                   0.02; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =      1.658062789394613;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body8', and joint, 'Joint8'
bodyName = 'Body8';
bodyMass =                0.00548;
bodyCoM = [                    -0,                     -0,                   0.01];
bodyInertia = [ 7.763333333333335e-07,  7.763333333333335e-07,  9.133333333333337e-08,                      0,                      0,                      0];
parentName = 'Body7';
jointName = 'Joint8';
jointType = 'revolute';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,  6.123233995736766e-17,                     -1,                  -0.03; ...
                                         -0,                      1,  6.123233995736766e-17, -3.469446951953614e-18; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
jointAxis = [                     0,                      0,                      1];
jointPositionLimits = [    -3.141592653589793,      3.141592653589793];
jointHomePosition =                      0;
joint.PositionLimits = jointPositionLimits;
joint.JointAxis = jointAxis;
joint.HomePosition = jointHomePosition;
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


% Add body, 'Body9', and joint, 'Joint9'
bodyName = 'Body9';
bodyMass =                     10;
bodyCoM = [                    -0,                     -0,                     -0];
bodyInertia = [               6.4e-05,                6.4e-05,                6.4e-05,                      0,                      0,                      0];
parentName = 'Body8';
jointName = 'Joint9';
jointType = 'fixed';
T_Joint_to_Parent = [                     1,                      0,                      0,                      0; ...
                                          0,                      1,                      0,                      0; ...
                                         -0,                      0,                      1,                   0.02; ...
                                          0,                      0,                      0,                      1];

joint = rigidBodyJoint(jointName, jointType);
joint.setFixedTransform(T_Joint_to_Parent);
body = rigidBody(bodyName, "MaxNumCollisions", 0);

body.Joint = joint;
body.Mass = bodyMass;
body.CenterOfMass = bodyCoM;
body.Inertia = bodyInertia;
robot.addBody(body, parentName);


