clear; clc; close all

dhparams = [0 -pi/2 20 0;
            0 pi/2 0 0;
            0 -pi/2 100 0;
            0 pi/2 0 0;
            0 -pi/2 10 0;
            0 pi/2 0 0;
            0 0 0 10];

robot = rigidBodyTree;
bodies = cell(6,1);
joints = cell(6,1);

for i = 1:6
    bodies{i} = rigidBody(['body' num2str(i)]);
    joints{i} = rigidBodyJoint(['jnt' num2str(i)],"revolute");
    setFixedTransform(joints{i},dhparams(i,:),"dh");
    bodies{i}.Joint = joints{i};
    if i == 1 % Add first body to base
        addBody(robot,bodies{i},"base")
    else % Add current body to previous body by name
        addBody(robot,bodies{i},bodies{i-1}.Name)
    end
end
showdetails(robot)

figure(Name="Robotto")
show(robot);