close all, clc

%% Latex
setupLatexPlot

%% Plot Energia cinetica nel tempo. Confronto metodi

switch traiettoria
    case 1
%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Energia cinetica\ekData_std.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Energia cinetica\ekData_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Energia cinetica\ekData_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Energia cinetica\ekData_mpc.mat");

%Plot
figure(1)
plot(tout_std, 1000*Ek_std)         %standard
grid on
xlabel('Tempo [$s$]')
ylabel('$E_k$ [$mJ$]')
title('Confronto Energia Cinetica manipolatore - Traiettoria 1')
hold on
plot(tout_weight, 1000*Ek_weight)   %pesata
plot(tout_nullsp, 1000*Ek_nullsp)   %nullspace
plot(tout_mpc, 1000*Ek_mpc)         %MPC
legend('Pseudoinv. standard','Pseudoinv. pesata','Pseudoinv. nullspace', 'MPC')

    case 2
%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Energia cinetica\ekData_std.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Energia cinetica\ekData_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Energia cinetica\ekData_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Energia cinetica\ekData_mpc.mat");

%Plot
figure(1)
plot(tout_std, 1000*Ek_std)         %standard
grid on
xlabel('Tempo [$s$]')
ylabel('$E_k$ [$mJ$]')
title('Confronto Energia Cinetica manipolatore - Traiettoria 2')
hold on
plot(tout_weight, 1000*Ek_weight)   %pesata
plot(tout_nullsp, 1000*Ek_nullsp)   %nullspace
plot(tout_mpc, 1000*Ek_mpc)         %MPC
legend('Pseudoinv. standard','Pseudoinv. pesata','Pseudoinv. nullspace', 'MPC')

    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end

%% Plot Coppie ai giunti. Confronto

switch traiettoria
    case 1
%pseudoinversa standard
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Coppie ai giunti\T_standard.mat");
%pseudoinversa pesata
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Coppie ai giunti\T_weight.mat");
%pseudoinversa nullspace
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Coppie ai giunti\T_nullsp.mat");
%mpc
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Coppie ai giunti\T_mpc.mat");

for i=1:7
    figure(i+1)
    plot(tout_standard,tConfig_standard(:,i))
    hold on
    grid minor
    plot(tout_weight,tConfig_weight(:,i))
    plot(tout_nullsp,tConfig_nullsp(:,i))
    plot(linspace(0,tout_mpc(end),length(tConfig_mpc(:,1))), tConfig_mpc(:,i))
    xline([6 8],'r--', LineWidth=1.2)
    legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    xlabel('Tempo [$s$]')
    str = ['$T_', num2str(i), '$ [$Nm$]'];
    ylabel(str)
    % ylabel('$T_n$ [$mJ$]')
    str = ['Confronto Coppie giunto ', num2str(i), ' - Traiettoria 1'];
    title(str)
    % xlim([6 10])
end
    case 2
%pseudoinversa standard
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Coppie ai giunti\T_standard.mat");
%pseudoinversa pesata
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Coppie ai giunti\T_weight.mat");
%pseudoinversa nullspace
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Coppie ai giunti\T_nullsp.mat");
%mpc
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Coppie ai giunti\T_mpc.mat");

for i=1:7
    figure(i+1)
    plot(tout_standard,tConfig_standard(:,i))
    hold on
    grid minor
    plot(tout_weight,tConfig_weight(:,i))
    plot(tout_nullsp,tConfig_nullsp(:,i))
    plot(linspace(0,tout_mpc(end),length(tConfig_mpc(:,1))), tConfig_mpc(:,i))
    xline([6 8],'r--', LineWidth=1.2)
    legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    xlabel('Tempo [$s$]')
    str = ['$T_', num2str(i), '$ [$Nm$]'];
    ylabel(str)
    % ylabel('$T_n$ [$mJ$]')
    str = ['Confronto Coppie giunto ', num2str(i), ' - Traiettoria 2'];
    title(str)
    xlim([6 10])
end
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end

%% Prova comparazione norma coppie giunti

% %Preallocamento
% T_standard = zeros(1,length(tout_standard));
% T_weight = zeros(1,length(tout_weight));
% T_nullsp = zeros(1,length(tout_nullsp));
% T_mpc = zeros(1,length(tout_mpc));
% 
% %Calcolo norma delle coppie su tutti i giunti nel tempo
% for i = 1:length(tout_standard)
%     T_standard(i) = norm(tConfig_standard(i,:));
% end
% 
% for i = 1:length(tout_weight)
%     T_weight(i) = norm(tConfig_weight(i,:));
% end
% 
% for i = 1:length(tout_nullsp)
%     T_nullsp(i) = norm(tConfig_nullsp(i,:));
% end
% 
% for i = 1:length(tConfig_mpc)
%     T_mpc(i) = norm(tConfig_mpc(i,:));
% end
% 
% %Plot
% figure(9)
% plot(tout_standard,T_standard)      %Standard
% hold on
% grid minor
% plot(tout_weight,T_weight)          %Pesata
% plot(tout_nullsp,T_nullsp)          %Null-space
% plot(linspace(0,tout_mpc(end),length(T_mpc)), T_mpc)    %MPC
% xlabel('Tempo [$s$]')
% ylabel('$T_n$ [$Nm$]')
% title('Confronto norma coppie giunti')
% legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')

%% Plot comparazione errore di posizionamento
switch traiettoria
    case 1
%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Errore di posizione\error_standard.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Errore di posizione\error_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Errore di posizione\error_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 1\Errore di posizione\error_mpc.mat");

figure(10)
% subplot(2,1,1)
plot(tout_standard, 1000*norm_err_standard)
hold on
plot(tout_nullsp, 1000*norm_err_nullsp)
plot(tout_weight, 1000*norm_err_weight)
plot(tout_mpc, 1000*norm_err_mpc)
xline([6 8],'r--', LineWidth=1.2)
grid minor
xlabel('Tempo [$s$]')
ylabel('Err. [$mm$]')
title('Errore di posizione End-Effector - Traiettoria 1')
legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    case 2
%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di posizione\error_standard.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di posizione\error_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di posizione\error_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di posizione\error_mpc.mat");

figure(10)
plot(tout_standard, 1000*norm_err_standard)
hold on
plot(tout_nullsp, 1000*norm_err_nullsp)
plot(tout_weight, 1000*norm_err_weight)
plot(tout_mpc, 1000*norm_err_mpc)
xline([6 8],'r--', LineWidth=1.2)
grid minor
xlabel('Tempo [$s$]')
ylabel('Err. [$mm$]')
title('Errore di posizione End-Effector - Traiettoria 2')
legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end

%% Errore di orientamento
switch traiettoria
    case 1

    case 2
%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di orientamento\errang_standard.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di orientamento\errang_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di orientamento\errang_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\traiettoria 2\Errore di orientamento\errang_mpc.mat");

% figure(11) %%% Così stampo theta, e non l'errore delta_theta
% plot(tout_standard, theta_standard)
% hold on
% plot(tout_nullsp, theta_nullsp)
% plot(tout_weight, theta_weight)
% plot(tout_mpc, theta_mpc)
% grid minor
% xlabel('Tempo [$s$]')
% ylabel('$\theta$ [$deg$]')
% title('Errore di orientamento End-Effector - Traiettoria 2')
% legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')

figure(11)
plot(tout_standard, theta_standard - 60)
hold on
plot(tout_nullsp, theta_nullsp - 60)
plot(tout_weight, theta_weight - 60)
plot(tout_mpc, theta_mpc - 60)
grid minor
xlabel('Tempo [$s$]')
ylabel('$\Delta\theta$ [$deg$]')
title('Errore di orientamento End-Effector - Traiettoria 2')
legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end





