function y = outputFunction(x, u)
% https://it.mathworks.com/help/mpc/ug/specify-prediction-model-for-nonlinear-mpc.html

% x: Current states, specified as a column vector of length Dimensions.NumberOfStates.
% u: Current inputs, specified as a column vector of length Dimensions.NumberOfInputs.
    % in questo caso u = tau

l = length(x)/2;    % Indice che separa le posizioni dei giunti dalle velocità dei giunti in "x"
q = x(1 : l);       % [rad], Posizioni dei giunti
% v = x(l+1 : end);   % [rad/s], Velocità dei giunti

y = q; % Output: Posizione dei giunti (per raggiungere la posizione desiderata)
% y = x;

%% Prova output come posizione e velocità dell'End Effector
% persistent robot
% if isempty(robot)
%     robot = rbtFcn();
%     robot.DataFormat = 'column';
% end
% 
% l = length(x)/2;    % Indice che separa le posizioni dei giunti dalle velocità dei giunti in "x"
% q = x(1 : l);       % [rad], Posizioni dei giunti
% v = x(l+1 : end);   % [rad/s], Velocità dei giunti
% 
% % M = massMatrix(robot, q);               % Matrice di inerzia
% % Cv = velocityProduct(robot, q, v);      % Coriolis + effetto centrifugo
% % G = gravityTorque(robot, q);            % Gravità
% J = geometricJacobian(robot, q, 'Body9');   % Matrice Jacobiana
% 
% vEE = J*v; %[rad/s, m/s], Vettore delle velocità dell'End Effector
% tformEE = getTransform(robot, q, 'Body9', 'Base'); % Trasformazione omogenea End Effector
% rotEE = tform2eul(tformEE);     %[rad], Angoli di Eulero ZYX End Effector
% posEE = tform2trvec(tformEE);   %[m], Vettore di traslazione End Effector
% 
% y = [posEE rotEE, vEE];


end