function w0 = optimization_fun(M, J, invJ, wmConfig, v_d)
    w_start = zeros(7,1); %vettore di partenza
   
    A = invJ * v_d;
    Z = eye(7) - invJ*J;
    const_term = wmConfig - A;
    
    % Define objective using matrix operations
    fun = @(w) 0.5 * (A + Z*w)' * M * (A + Z*w);

    %% fmincon
    %Inequality constraints
    D = [];
    b = [];
    %Equality constraints
    Deq = []; %eye(7);
    beq = []; %zeros(7,1);
    %Lower/Upper boundaries
    lb = [];
    ub = [];
 
    % Nonlinear constraints as matrix equation
    nonlcon = @(w) deal([], const_term - Z*w);
    
    % Fixed solver configuration
    opts = optimoptions('fmincon',...
        'Algorithm','sqp',...
        'StepTolerance',1e-18, ...
        'MaxIterations',400,...
        'Display','iter', ...
        'UseParallel', false);

    % Execute optimization
    w0 = fmincon(fun, w_start, D, b, Deq, beq, lb, ub, nonlcon, opts);

    %% particleswarm
    % nvars = 7;
    % opts = optimoptions('particleswarm',...
    % 'SwarmSize', 200, ...
    % 'MaxIterations', 100*nvars,...
    % 'MaxStallIterations', 50,...
    % 'FunctionTolerance', 1e-10,...
    % 'Display', 'Iter',...
    % 'UseParallel', false);
    % 
    % fun = @(w) 0.5 * (A + (w*Z)')' * M * (A + (w*Z)'); %obj. fun considerando w vettore riga
    % 
    % w0 = particleswarm(fun, nvars, lb, ub, opts)'; %particleswarm lavora con vettori riga
    % w0 = zeros(7,1);
end



