function [z] = dynFunction(x, tau)
% https://it.mathworks.com/help/mpc/ug/specify-prediction-model-for-nonlinear-mpc.html

% x: Current states, specified as a column vector of length Dimensions.NumberOfStates.
% u(tau): Current inputs, specified as a column vector of length Dimensions.NumberOfInputs.
% z: State function output, returned as a column vector of length Nx. For a continuous-time
    % prediction model, z contains the state derivatives, dx/dt, and for discrete-time prediction
    % models, z contains the next states, x(k+1).
    % In questo caso conterrà le derivate di posizione e velocità
    
% disp(['Coppie ricevute: ', num2str(tau')]); % Stampa le coppie

persistent robot
if isempty(robot)
    robot = rbtFcn();
    robot.DataFormat = 'column';
end

l = length(x)/2;    % Indice che separa le posizioni dei giunti dalle velocità dei giunti in "x"
q = x(1 : l);       % [rad], Posizioni dei giunti
v = x(l+1 : end);   % [rad/s], Velocità dei giunti

% M = massMatrix(robot, q);               % Matrice di inerzia
% Cv = velocityProduct(robot, q, v);      % Coriolis + effetto centrifugo
% G = gravityTorque(robot, q);            % Gravità
% J = geometricJacobian(robot, q, 'Body9'); %Jacobiana 6xn

% Informazioni per interpolare il valore di forza al tempo attuale
load external_force.mat;    %Variabili extForce, tout
load actual_time.mat;       %Variabile actTime
fx = interp1(tstep, xforce, actTime); %Componente x
fy = interp1(tstep, yforce, actTime); %Componente y
fz = interp1(tstep, zforce, actTime); %Considero solo la componente z
%La matrice delle forze per il dataformat column è 6xn
wrench = [0 0 0 fx fy fz]';     %Vettore torque/forze esterne, 6x1

%test: uso la funzione del robotics toolbox
f_matrix = externalForce(robot, 'Body9', wrench, q);

% xdd = M\(-Cv - G + tau - J'*wrench); % Dinamica del manipolatore. Calcolo accelerazione
             % {- J'*fext}, con fext matrice(?) delle forze esterne applicate
% xdd = M\(-Cv - G + tau - J'*wrench);
%test
xdd = forwardDynamics(robot,q,v,tau,f_matrix);

z = zeros(14,1);    % Preallocazione output
z(1 : l) = v;       % Derivata della posizione (velocità)
z(l+1 : end) = xdd; % Derivata della velocità (accelerazione)

end