function cost = costFunction2(X, U, e, data)
% https://it.mathworks.com/help/mpc/ug/specify-cost-function-for-nonlinear-mpc.html

% x: State trajectory from time k to time k+p, specified as a (p+1)-by-Nx array. 
    % The first row of X contains the current state values, which means that the 
    % solver does not use the values in X(1,:) as decision variables during optimization.
% u: Input trajectory from time k to time k+p, specified as a (p+1)-by-Nu array. 
    % The final row of U is always a duplicate of the preceding row; that is, 
    % U(end,:) = U(end-1,:). Therefore, the values in the final row of U are not
    % independent decision variables during optimization.
% e: Slack variable for constraint softening, specified as a nonnegative scalar. 
    % e is zero if there are no soft constraints in your controller. If you have nonlinear
    % soft constraints defined in your inequality constraint function (Model.CustomIneqConFcn),
    % use a positive penalty weight on e and make them part of the cost function.

    persistent robot
    if isempty(robot)
        robot = rbtFcn();
        robot.DataFormat = 'column';
    end
    % if isempty(des)
    %     p_d = [0.25 0.2 0.1]';
    %     rot_d = [pi/8 pi/2 pi/4];
    %     q_init = [10 -15 0 100 0 95 0]' * pi/180; % Convertito in radianti
    %     des_tform = eul2tform(rot_d);
    %     des_tform(1:3, 4) = p_d;
    %     ik = inverseKinematics("RigidBodyTree", robot);
    %     [des, ~] = ik('Body9', des_tform, ones(6,1), q_init);
    % end

    p = data.PredictionHorizon;
    l = length(X(1,:))/2;

    des = data.References(1:l);

    % Pesi per bilanciare i diversi termini del costo
    w_kinetic = 1;  % Peso per l'energia cinetica
    w_position = 1; % Peso per l'errore di posizione
    % w_input = 0.01;   % Peso per la penalizzazione dell'input
    w_slack =  1;    % Peso per la slack variable

    total_kinetic_energy = 0;
    total_position_error = 0;
    % total_input_cost = 0;

    for i = 1:p+1
        q = X(i, 1:l);
        v = X(i, l+1:end);

        % Calcolo dell'energia cinetica
        M = massMatrix(robot, q');
        kinetic_energy = 0.5 * v * M * v';
        total_kinetic_energy = total_kinetic_energy + kinetic_energy;

        % Calcolo dell'errore di posizione
        position_error = norm(q - des);
        total_position_error = total_position_error + position_error;%^2; %test: elevo al quadrato l'errore

        % % Calcolo del costo dell'input (escluso l'ultimo timestep)
        % if i <= p
        %     input_cost = norm(U(i,:))^2;
        %     total_input_cost = total_input_cost + input_cost;
        % end
    end

    % Normalizzazione e combinazione dei costi
    cost = w_kinetic * total_kinetic_energy / (p+1) + ...
           w_position * total_position_error / (p+1) + ...  % w_input * total_input_cost / p + ...
           w_slack * e^2;
            
end
