function cost = costFunction(X, U, e, data)
% https://it.mathworks.com/help/mpc/ug/specify-cost-function-for-nonlinear-mpc.html

% x: State trajectory from time k to time k+p, specified as a (p+1)-by-Nx array. 
    % The first row of X contains the current state values, which means that the 
    % solver does not use the values in X(1,:) as decision variables during optimization.
% u: Input trajectory from time k to time k+p, specified as a (p+1)-by-Nu array. 
    % The final row of U is always a duplicate of the preceding row; that is, 
    % U(end,:) = U(end-1,:). Therefore, the values in the final row of U are not
    % independent decision variables during optimization.
% e: Slack variable for constraint softening, specified as a nonnegative scalar. 
    % e is zero if there are no soft constraints in your controller. If you have nonlinear
    % soft constraints defined in your inequality constraint function (Model.CustomIneqConFcn),
    % use a positive penalty weight on e and make them part of the cost function.

persistent robot
if isempty(robot)
    robot = rbtFcn();
    robot.DataFormat = 'column';
end

p = data.PredictionHorizon;     % Coincide con l'orizzonte di previsione
l = length(X(1,:))/2;   % Indice che separa le posizioni dei giunti dalle velocità dei giunti in "x"
q = X(1, 1 : l);       % [rad], Posizioni dei giunti

%% Calcolo funzione di costo
% Il costo è rappresentato dalla somma dei valori di energia cinetica
% calcolati in ogni step compreso nell'orizzonte di previsione, escludendo
% l'istante iniziale

persistent des
if isempty(des) % Definizione vettore delle posizioni di giunto desiderate
    p_d = [0.25 0.2 0.1]';      %[m], posizione richiesta
    rot_d = [pi/8 pi/2 pi/4];   %[rad] Angoli di Eulero ZYX
    q_init = [10 -15 0 100 0 95 0]'*pi/180; %[rad], Configurazione iniziale giunti
    des_tform = eul2tform(rot_d);
    des_tform(1:3, 4) = p_d; % Trasformazione omogenea desiderata end effector
    ik = inverseKinematics("RigidBodyTree",robot); % Solver
    [des, ~] = ik('Body9', des_tform, ones(6,1), q_init); % Config. desiderata
end

err = zeros(l,1);
for i = 1:l
    err(i) = q(i) - des(i); % Vettori degli errori rispetto alla posizione voluta
end

cost = norm(err); %inizializzazione costo

for i = 2:p+1 % è sconsigliato utilizzare X(1, :) dato che contiene lo stato attuale del sistema
    q = X(i, 1:l);           % [rad], Posizioni dei giunti
    v = X(i, l+1:end);       % [rad/s], Velocità dei giunti

    M = massMatrix(robot, q);   % Matrice di inerzia

    cost = cost + 0.5 * v * M * v';    % Energia cinetica del manipolatore, incrementale.
                                       % v è definito come vettore riga
end

% cost = cost + 0.1*norm(U)^2; %termine che penalizza le coppie
cost = cost + 10*e^2; % prova di utilizzo della slack variable "e" per i soft constraints
% Qual è il ruolo della slack variable? è una grandezza da usare solo nel
% caso in cui i soft constraints vengano superati? è giusto implementarla
% così oppure va rivisto?

end