%% Nonlinear Model Predictive Control
clc

%% Definizione oggetto
n = 7; %Numero di giunti del manipolatore
nlmpcObj = nlmpc(2*n, 2*n, n); %Oggetto del modello (2*n states, n output, n input)
                                                   %([q, qd]   , [q, qd] , [tau]  )

%% Definizione proprietà del modello
%https://it.mathworks.com/help/mpc/ref/nlmpc.html

nlmpcObj.Ts = 0.05;                 %[s], Passo di campionamento MPC
nlmpcObj.PredictionHorizon = 6;%10    % Orizzonte di previsione
nlmpcObj.ControlHorizon = 2;        % Orizzonte di controllo

    % sottostruttura "Model"
nlmpcObj.Model.StateFcn = "dynFunction";        % Equazione dinamica del manipolatore
% nlmpcObj.Jacobian.StateFcn = "stateJacobian";  % Jacobiana della funzione di stato
% nlmpcObj.Jacobian.StateFcn = "dynJacobian";    % Jacobiana della funzione di stato
% nlmpcObj.Model.OutputFcn = "outputFunction";    % Stabilisce che l'output è costituito dalla posizione dei giunti
nlmpcObj.Model.IsContinuousTime = true;         % Da verificare

    % sottostruttura "Optimization"
% nlmpcObj.Optimization.CustomCostFcn = "costFunction2"; % Funzione di costo da minimizzare
nlmpcObj.Optimization.ReplaceStandardCost = false;
% nlmpcObj.Jacobian.CustomCostFcn = "costJacobian";
% nlmpcObj.Optimization.CustomEqConFcn = "eqCostFunction"; % Vincolo di uguaglianza
nlmpcObj.Optimization.UseSuboptimalSolution = false; % Se non converge ad una soluzione ottimale entro le iterazioni massime, fornisce una soluzione subottimale
nlmpcObj.Optimization.SolverOptions.MaxIterations = 300; % default: 400

%% Pesi
% nlmpcObj.Weights.OutputVariables = [3*ones(1,7) zeros(1,7)];
nlmpcObj.Weights.OutputVariables = [2*ones(1,7) 0.5*ones(1,7)];
% nlmpcObj.Weights.OutputVariables = [3*ones(1,7) 0.3*ones(1,7)];
nlmpcObj.Weights.ManipulatedVariablesRate = 0.2*ones(1,7);

%% Definizione vincoli
%https://it.mathworks.com/help/mpc/ug/specify-constraints-for-nonlinear-mpc.html

% qLimSup = pi/180*[180 130 180 145 180 145 180];     %[rad], Limiti superiori posizione dei giunti
% qLimInf = -qLimSup;                                 %[rad], Limiti inferiori posizione dei giunti
% qLimSupSoft = pi/180*[170 120 170 135 170 135 170];     %[rad], Limiti superiori come vincolo morbido
% qLimInfSoft = -qLimSupSoft;                             %[rad], Limiti inferiori come vincolo morbido
% 
% vLimSup = 1; %pi/180*40;    %[rad/s], Limiti superiori velocità dei giunti
% % vLimSup = 0.5;
% vLimInf = -vLimSup;     %[rad/s], Limiti inferiori velocità dei giunti
% %Modifica: il valore precedente era 20, non 35
% vLimSupSoft = 0.92; %pi/180*35;    %[rad/s], Limiti superiori come vincolo morbido
% % vLimSupSoft = 0.3;
% vLimInfSoft = -vLimSupSoft; %[rad/s], Limiti inferiori come vincolo morbido
% 
% tLimSup = 3;          %[Nm], Limiti superiori coppie motori
% tLimInf = -tLimSup;     %[Nm], Limiti inferiori coppie motori
% 
% nlmpcObj.Weights.ECR = 10000; % Slack variable (default: 10000)
% 
% for i=1:n   % Definizione vincoli per i n gradi di libertà
%     % Vincoli posizione giunti  (HARD constraint)
%     nlmpcObj.States(i).Min = qLimInf(i);
%     nlmpcObj.States(i).Max = qLimSup(i);
%     % Vincoli output (posizione giunti)  (SOFT constraint)
%     nlmpcObj.OutputVariables(i).Min = qLimInfSoft(i);
%     nlmpcObj.OutputVariables(i).MinECR = 1;
%     nlmpcObj.OutputVariables(i).Max = qLimSupSoft(i);
%     nlmpcObj.OutputVariables(i).MaxECR = 1;
% 
%     % Vincoli velocità giunti   (HARD constraint)
%     nlmpcObj.States(i+n).Min = vLimInf;
%     nlmpcObj.States(i+n).Max = vLimSup;
%     % Vincoli output (velocità giunti) (SOFT constraint)
%     nlmpcObj.OutputVariables(i+n).Min = vLimInfSoft;
%     nlmpcObj.OutputVariables(i+n).MinECR = 1;
%     nlmpcObj.OutputVariables(i+n).Max = vLimSupSoft;
%     nlmpcObj.OutputVariables(i+n).MaxECR = 1;
% 
%     % Vincoli coppie motori (manipulated variable)  (SOFT constraint)
%     nlmpcObj.ManipulatedVariables(i).Min = tLimInf;
%     nlmpcObj.ManipulatedVariables(i).MinECR = 1;
%     nlmpcObj.ManipulatedVariables(i).Max = tLimSup;
%     nlmpcObj.ManipulatedVariables(i).MaxECR = 1;
% end
% clear i

%% Vincoli di passività
% nlmpcObj.Passivity.EnforceConstraint = true;
% nlmpcObj.Passivity.InputFcn = "passivityInput";
% nlmpcObj.Passivity.OutputFcn = "passivityOutput";

%% Validate Functions
% valori di esempio di x (stati) e mv (coppie)
x_prova = pi/180*[10 -15 0 100 0 95 0 0 0 0 0 0 0 0]; %[rad], 14 elementi, posizioni e vel giunti
mv_prova = [0 0 0 0 0 0 0];
validateFcns(nlmpcObj, x_prova, mv_prova)
% mv_init = nlmpcmove(nlmpcObj, x_prova, mv_prova,des_config)

%% Caricamento dati per controllo MPC
% dataConfig = load('q_qd_clock.mat');
traiettoria
switch traiettoria
    case 1
        dataConfig = load("reference_traiettorie\traiettoria1.mat");
    case 2
        dataConfig = load("reference_traiettorie\traiettoria2.mat");
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1, 2 o 3)')
        return
end
% dataConfig = load('reference_short.mat');

% plot(dataConfig.tout, dataConfig.qmConfig)
% figure
% plot(dataConfig.tout, dataConfig.wmConfig)


