function [dZdX, dZdU] = stateJacobian(x, tau)
    persistent robot
    if isempty(robot)
        robot = rbtFcn();
        robot.DataFormat = 'column';
    end

    l = length(x)/2; % Numero di giunti (es. 7)
    q = x(1:l)';     % Posizioni dei giunti (vettore colonna)
    v = x(l+1:end);   % Velocità dei giunti (vettore colonna)

    % Calcolo delle matrici dinamiche
    M = massMatrix(robot, q');
    Cv = velocityProduct(robot, q', v);
    G = gravityTorque(robot, q');

    % Derivata numerica di M rispetto a q (approssimazione)
    epsilon = 1e-6; % Passo per la differenza finita
    dMdq = zeros(l, l, l);
    for i = 1:l
        q_perturbed = q;
        q_perturbed(i) = q_perturbed(i) + epsilon;
        M_perturbed = massMatrix(robot, q_perturbed');
        dMdq(:,:,i) = (M_perturbed - M) / epsilon;
    end

    % Inizializzazione della Jacobiana rispetto agli stati
    dZdX = zeros(2*l, 2*l);

    % Parte superiore: derivata della velocità (z(1:l) = v)
    dZdX(1:l, l+1:end) = eye(l);

    % Parte inferiore: derivata dell'accelerazione (z(l+1:end) = xdd)
    % Contributo delle variazioni di posizione
    for i = 1:l
        dZdX(l+1:end, i) = -M \ (dMdq(:,:,i) * v');
    end

    % Jacobiana rispetto agli input (tau)
    dZdU = zeros(2*l, l);
    dZdU(l+1:end, :) = M \ eye(l);
end
