function [G, Gmv, Ge] = costJacobian(X, U, e, data)
    persistent robot des
    if isempty(robot)
        robot = rbtFcn();
        robot.DataFormat = 'column';
    end
    if isempty(des)
        % Configurazione desiderata
        p_d = [0.25 0.2 0.1]';
        rot_d = [pi/8 pi/2 pi/4];
        q_init = [10 -15 0 100 0 95 0]' * pi/180;
        des_tform = eul2tform(rot_d);
        des_tform(1:3, 4) = p_d;
        ik = inverseKinematics("RigidBodyTree", robot);
        [des, ~] = ik('Body9', des_tform, ones(6,1), q_init);
    end

    p = data.PredictionHorizon;
    l = length(X(1,:))/2;

    % Calcola la dimensione corretta per G
    % num_states = size(X, 2); % Numero totale di stati (colonne di X)
    % G = zeros(p, num_states);  % Jacobiana rispetto agli stati (X)
    G = zeros(size(X(2:end, :)));
    Gmv = zeros(size(U(2:end, :))); % Jacobiana rispetto agli ingressi (U)
    Ge = 2 * 10 * e;          % Jacobiana rispetto alla slack variable

    for i = 2:p+1
        q = X(i, 1:l)'; %vettore colonna
        v = X(i, l+1:end); %vettore riga

        % Calcolo della matrice di inerzia
        M = massMatrix(robot, q);

        % Derivata del termine dell'energia cinetica rispetto a X
        kinetic_term = v * M; % Risultato è 1 x l
        G(i-1, l+1:end) = G(i-1, l+1:end) + kinetic_term; % Aggiorna solo la parte relativa alle velocità

        % Derivata del termine dell'errore di posizione rispetto a X
        position_error_term = 2 * (q - des)';
        G(i-1, 1:l) = G(i-1, 1:l) + position_error_term; % Aggiorna solo la parte relativa alle posizioni
        
        Gmv(i-1, :) = Gmv(i-1, :) + 2*0.01 * U(i, :); % Penalizzazione quadratica sugli input
    end

    % Penalizzazione delle coppie (input)
    % Gmv(:) = Gmv(:) + 2*0.01 * U(2:end, :); % Penalizzazione quadratica sugli input
end
