function dM_dq = compute_dM_dq(robot, q)
    % Calcola la derivata numerica della matrice di inerzia rispetto a q
    numJoints = length(q);
    dM_dq = zeros(numJoints, numJoints, numJoints); % Tensor 3D

    delta = 1e-6; % Piccola variazione per differenze finite

    for i = 1:numJoints
        qPerturbPlus = q;
        qPerturbMinus = q;
        qPerturbPlus(i) = qPerturbPlus(i) + delta;
        qPerturbMinus(i) = qPerturbMinus(i) - delta;

        MPlus = massMatrix(robot, qPerturbPlus);
        MMinus = massMatrix(robot, qPerturbMinus);

        dM_dq(:, :, i) = (MPlus - MMinus) / (2 * delta); % Differenze finite
    end
end
