function dG_dq = compute_dG_dq(robot, q)
    % Calcola la derivata numerica del termine gravitazionale rispetto a q
    numJoints = length(q);
    dG_dq = zeros(numJoints, numJoints); % Matrice 2D

    delta = 1e-6; % Piccola variazione per differenze finite

    for i = 1:numJoints
        qPerturbPlus = q;
        qPerturbMinus = q;
        qPerturbPlus(i) = qPerturbPlus(i) + delta;
        qPerturbMinus(i) = qPerturbMinus(i) - delta;

        GPlus = gravityTorque(robot, qPerturbPlus);
        GMinus = gravityTorque(robot, qPerturbMinus);

        dG_dq(:, i) = (GPlus - GMinus) / (2 * delta); % Differenze finite
    end
end
