function J_inv = Jacobian_fnc_base_EE(a, d, alpha, q1, q2, q3, q4, q5, q6, q7)

    % Funzione di trasformazione omogenea per ogni giunto
    M = @(qi, alpha_i, a_i, d_i) [cos(qi), -sin(qi)*cos(alpha_i), sin(qi)*sin(alpha_i), a_i*cos(qi);
                                   sin(qi), cos(qi)*cos(alpha_i), -cos(qi)*sin(alpha_i), a_i*sin(qi);
                                   0, sin(alpha_i), cos(alpha_i), d_i;
                                   0, 0, 0, 1];
    
    % Calcolo delle matrici di trasformazione per ciascun giunto
    A01 = M(q1, alpha(1), a(1), d(1));
    A12 = M(q2, alpha(2), a(2), d(2));
    A23 = M(q3, alpha(3), a(3), d(3));
    A34 = M(q4, alpha(4), a(4), d(4));
    A45 = M(q5, alpha(5), a(5), d(5));
    A56 = M(q6, alpha(6), a(6), d(6));
    A67 = M(q7, alpha(7), a(7), d(7));

    % Calcolo delle trasformazioni cumulative
    A02 = A01 * A12;
    A03 = A01 * A12 * A23;
    A04 = A01 * A12 * A23 * A34;
    A05 = A01 * A12 * A23 * A34 * A45;
    A06 = A01 * A12 * A23 * A34 * A45 * A56;
    A07 = A01 * A12 * A23 * A34 * A45 * A56 * A67;

    % Posizione finale dell'effettore
    p = A06(1:3, 4);  % Coordinate x, y, z dell'effettore finale

    % Vettori z per ogni giunto
    A01z = A01(1:3, 3);
    A02z = A02(1:3, 3);
    A03z = A03(1:3, 3);
    A04z = A04(1:3, 3);
    A05z = A05(1:3, 3);
    A06z = A06(1:3, 3);
    A07z = A07(1:3, 3);

    % Posizioni dei giunti (prima della posizione finale)
    A01p = A01(1:3, 4);
    A02p = A02(1:3, 4);
    A03p = A03(1:3, 4);
    A04p = A04(1:3, 4);
    A05p = A05(1:3, 4);
    A06p = A06(1:3, 4);
    A07p = A07(1:3, 4);

    % Calcolo della matrice Jacobiana
    z0 = [0; 0; 1];  % Vettore z per il primo giunto
    J = [cross(z0, (p - A01p)), cross(A01z, (p - A02p)), cross(A02z, (p - A03p)), ...
         cross(A03z, (p - A04p)), cross(A04z, (p - A05p)), cross(A05z, (p - A06p)), cross(A06z, (p - A07p));
         z0, A01z, A02z, A03z, A04z, A05z, A06z];

    % Inversa della Jacobiana (pseudoinversa)
    J_inv = J' / (J * J');
    
    % Verifica della singolarità 
    rank_J = rank(J(1:3, :));  % Rango della Jacobiana
    if rank_J < 3
        disp('Il robot è in singolarità');
    else
        disp('Il robot non è in singolarità');
    end
end
