close all, clc

%% Latex
% Setup iniziale
set(0,'defaultTextInterpreter','latex'); % imposta l'interprete latex per i testi
set(0, 'defaultAxesTickLabelInterpreter','latex'); % imposta l'interprete latex per i testi degli 
set(0, 'defaultLegendInterpreter','latex'); % imposta l'interprete latex per le legende

FONT = 'Times'; % font dei testi
FontSize = 18; % dimensione dei testi in pt
set(0,'DefaultaxesFontSize', FontSize,'defaultAxesFontName',FONT,...
    'defaultTextFontSize',FontSize,'defaultTextFontName',FONT,...
    'defaultUicontrolFontSize',FontSize,'defaultUicontrolFontName',FONT,...
    'defaultUitableFontSize',FontSize,'defaultUitableFontName',FONT); %imposta font e dimensione 

set(0,'defaultLineLineWidth',1.5); % imposta lo spessore di default delle curve rappresentate

set(0,'DefaultaxesLineWidth', 0.5) % imposta lo spessore delle linee degli assi
set( 0, 'defaultAxesTickDir', 'out' ,'defaultAxesTickDirMode', 'manual',...
    'defaultAxesXMinorTick','on','defaultAxesYMinorTick','on','defaultAxesZMinorTick','on',...
    'defaultAxesBox', 'off'); % imposta la formattazione degli assi
set(0,'defaultLegendBox' , 'on');

% setting figure deafult size in centimiters.
FigWidth = 30; % figure width in cm. use \the\textwidth and \the\columnwidth on latex to check 
FighHeigth = FigWidth*9/16; % figure heigth in cm. Set accordingly to your desired aspect ratio. 
set(0, 'defaultFigureUnits', 'centimeters', 'defaultFigurePosition', [0 0 FigWidth FighHeigth]);

%% Plot Energia cinetica nel tempo. Confronto metodi

%pseudoinversa standard:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni en. cinetica\ekData_std.mat");
%pseudoinversa pesata:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni en. cinetica\ekData_weight.mat");
%pseudoinversa nullspace:
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni en. cinetica\ekData_nullsp.mat");
%MPC
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni en. cinetica\ekData_mpc.mat");

%Plot
figure(1)
plot(tout_std, 1000*Ek_std)         %standard
grid on
xlabel('Tempo [$s$]')
ylabel('$E_k$ [$mJ$]')
title('Confronto Energia Cinetica manipolatore')
hold on
plot(tout_weight, 1000*Ek_weight)   %pesata
plot(tout_nullsp, 1000*Ek_nullsp)   %nullspace
plot(tout_mpc, 1000*Ek_mpc)         %MPC
legend('Pseudoinv. standard','Pseudoinv. pesata','Pseudoinv. nullspace', 'MPC')

%% Plot Coppie ai giunti. Confronto

%pseudoinversa standard
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni coppie giunti\T_standard.mat");
%pseudoinversa pesata
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni coppie giunti\T_weight.mat");
%pseudoinversa nullspace
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni coppie giunti\T_nullsp.mat");
%mpc
load("C:\Users\antod\Dropbox (Politecnico Di Torino Studenti)\Polito\Magistrale\Tesi\MATLAB\7DOF\output\force test\comparazioni coppie giunti\T_mpc.mat");

for i=1:7
    figure(i+1)
    plot(tout_standard,tConfig_standard(:,i))
    hold on
    grid minor
    plot(tout_weight,tConfig_weight(:,i))
    plot(tout_nullsp,tConfig_nullsp(:,i))
    plot(linspace(0,tout_mpc(end),length(tConfig_mpc(:,1))), tConfig_mpc(:,i))
    legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')
    xlabel('Tempo [$s$]')
    str = ['$T_', num2str(i), '$ [$Nm$]'];
    ylabel(str)
    % ylabel('$T_n$ [$mJ$]')
    str = ['Confronto Coppie giunto ', num2str(i)];
    title(str)
    xline([6 8],'r--', LineWidth=1.2)
end

%% Prova comparazione norma coppie giunti

%Preallocamento
T_standard = zeros(1,length(tout_standard));
T_weight = zeros(1,length(tout_weight));
T_nullsp = zeros(1,length(tout_nullsp));
T_mpc = zeros(1,length(tout_mpc));

%Calcolo norma delle coppie su tutti i giunti nel tempo
for i = 1:length(tout_standard)
    T_standard(i) = norm(tConfig_standard(i,:));
end

for i = 1:length(tout_weight)
    T_weight(i) = norm(tConfig_weight(i,:));
end

for i = 1:length(tout_nullsp)
    T_nullsp(i) = norm(tConfig_nullsp(i,:));
end

for i = 1:length(tConfig_mpc)
    T_mpc(i) = norm(tConfig_mpc(i,:));
end

%Plot
figure(9)
plot(tout_standard,T_standard)      %Standard
hold on
grid minor
plot(tout_weight,T_weight)          %Pesata
plot(tout_nullsp,T_nullsp)          %Null-space
plot(linspace(0,tout_mpc(end),length(T_mpc)), T_mpc)    %MPC
xlabel('Tempo [$s$]')
ylabel('$T_n$ [$Nm$]')
title('Confronto norma coppie giunti')
legend('Ps. standard','Ps. pesata','Ps. null-space','MPC')






