function u = passivityInput(x, tau)

persistent robot
if isempty(robot)
    robot = rbtFcn();
    robot.DataFormat = 'column';
end

n = length(x)/2;
q = x(1 : n);       % [rad], Posizioni dei giunti
% v = x(n+1 : end);   % [rad/s], Velocità dei giunti
K = 5;      % Error gain

% M = massMatrix(robot, q);               % Matrice di inerzia
% Cv = velocityProduct(robot, q, v);      % Coriolis + effetto centrifugo
G = gravityTorque(robot, q);            % Gravità

% Per ottenere la configurazione desiderata serve avere il target da
% raggiungere, ma così facendo la variabile p_d e rot_d non si aggiornano
% semplicemente cambiando lo scritp "import_robot.m"... Vanno cambiate
% manualmente ogni volta che si cambia il target
persistent des
if isempty(des) % Definizione vettore delle posizioni di giunto desiderate
    p_d = [0.25 0.2 0.1]';      %[m], posizione richiesta
    rot_d = [pi/8 pi/2 pi/4];   %[rad] Angoli di Eulero ZYX
    q_init = [10 -15 0 100 0 95 0]'; %[deg], Configurazione iniziale giunti
    des_tform = eul2tform(rot_d);
    des_tform(1:3, 4) = p_d; % Trasformazione omogenea desiderata end effector
    ik = inverseKinematics("RigidBodyTree",robot); % Solver
    [des, ~] = ik('Body9', des_tform, ones(6,1), q_init*pi/180); % Config. desiderata
end

err = zeros(n,1);
for i = 1:n
    err(i) = q(i) - des(i); % Vettori degli errori rispetto alla posizione voluta
end

% Utilizzo la stessa funzione fornita nell'esempio di matlab "Control Robot Manipulator Using Passivity-Based Nonlinear MPC"
u = tau - G + K*err;

end




