clear; clc; close all

%% Importazione e definizione modello robot

%Definizione dimensioni manipolatore

%Base (cilindro)
base_dim = [60 50];%[mm] Radius, Length del cilindro di base

%Link (parallelepipedi)
link_wdt = [20 20 20 20 10 10 10];%[mm] Larghezza dei link
link_dpt = [20 20 20 20 10 10 10];%[mm] Profondità dei link
link_lgt = [40 100 100 175 20 30 20];%[mm] Lunghezza dei link

rho = 2740;%[kg/m^3] Densità link (Alluminio)

%End Effector (sfera)
ee_radius = 4;%[mm] Raggio sfera End Effector
ee_weight = 10;%[kg] Massa End Effector

%Giunti
% q_init = [10 -15 0 100 0 95 0]; %[deg], Configurazione iniziale giunti
% q_init = [0 0 0 0 0 0 0];
% q_init = 180/pi*[-1.629 -1.251 1.652 1.376 -0.3525 0.5451 1.598]; %[deg], posizione finale da raggiungere
% q_init = [-6 20 10 50 0 -60 0];
% q_init = randi(120, 1, 7);

% g = 9.806; %[m/s^2], accel. di gravità
g = 0;

% Traiettorie alternative
traiettoria = 2

switch traiettoria
    case 1
        q_init = [10 -15 0 100 0 95 0]; %[deg], Configurazione iniziale giunti
        p_d = [0.25 0.2 0.1]';      %[m]
        rot_d = [pi/8 pi/2 pi/4];   %[rad] Angoli di Eulero ZYX
    case 2
        q_init = [0 30 0 60 0 30 0];    %[deg], Configurazione iniziale giunti
        p_d = [0.2 0 0.05]';        %[m]
        rot_d = [0 pi*9/10 0];      %[rad] Angoli di Eulero ZYX
    otherwise
        disp('Traiettoria non accettata. Inserirne una valida(1 o 2)')
        return
end

[DOF7_Arm, ArmInfo] = importrobot("Robot_7DOF.slx");

robot = buildrobot();

%% Impostazione parametri cinematici

% v_d = @(t) min(a0*t, v0, (2*a0*(norm(p_error)).^0.5))*p_error/norm(p_error);
a0 = 0.07; %[m/s^2], accelerazione iniziale massima
v0 = 0.05; %[m/s], velocità massima
alpha0 = 0.3; %[rad/s^2], accel. angolare massima
omega0 = 0.5; %[rad/s], vel. angolare massima

%% Posizione e orientazione desiderati
% 
% % Posizione richiesta
% %0.26 0 0.15
% p_d = [0.25 0.2 0.1]'; %[m]
% % p_d = [0.2 0.15 0.1]'; %newref short
% % p_d = 0.2*rand(3, 1);
% 
% % Angolo richiesto
% % quat_d = [1 0 0 0]';
% rot_d = [pi/8 pi/2 pi/4];            %[rad] Angoli di Eulero ZYX
% % rot_d = [0 pi/2 0];
% % rot_d = pi*rand(1, 3);
% % Rotation_matrix =  [1 0 0            % Matrice di rotazione
% %                     0 1 0
% %                     0 0 1];
% des_tform = eul2tform(rot_d);
% des_tform(1:3, 4) = p_d; % Trasformazione omogenea desiderata end effector
DOF7_Arm.DataFormat = 'row';
% ik = inverseKinematics("RigidBodyTree",DOF7_Arm); % Solver
% [des_config, solInfo] = ik('Body9', des_tform, ones(6,1), q_init*pi/180); % Config. desiderata
% des_config = [des_config zeros(1,7)];

%% Function che definisce il manipolatore

writeAsFunction(DOF7_Arm,"rbtFcn");

%% Forza esterna agente sull'End Effector

% Sistema di riferimento solidale all'End Effector
f_ext_x = 0;    %[N]
f_ext_y = 0;    %[N]
f_ext_z = -10;   %[N] Gain che moltiplica il segnale di forza di 1N, lungo z
appliedForce(f_ext_x, f_ext_y, f_ext_z)
load('external_force.mat');
clear f_ext_x f_ext_y f_ext_z

%% Comandi di prova

% show(DOF7_Arm,randomConfiguration(DOF7_Arm))
% des_config = [-1.629 -1.251 1.652 1.376 -0.3525 0.5451 1.598];
% DOF7_Arm.DataFormat = 'row';
% show(DOF7_Arm, des_config)

% DOF7_Arm.DataFormat = 'row';
% tau_gravity = gravityTorque(DOF7_Arm)

%% Export reference for MPC
% save('traiettoria1', 'qmConfig', 'tout', 'wmConfig')






