function [Y,Yp,Ypp,tau]=forma_acost_asimm(tauv)
%forma_acostante.m seguendo una legge ad accelerazione costante
%crea tre vettori una contenente alzata adimensionale,
%velocità geometrica adimensionale, accelerazione geometrica
%adimensionale ed inoltre la variabile tau (tempo od alzata adimensionale)

a=tauv; %fine tratto con acc. >0
n = 1/a - 1;
CAp = 2*(n+1);
CAm = -2/n*(n+1);
CA = max(abs(CAp), abs(CAm)); %coefficiente di accelerazione
Cv = 2; %coefficiente di velocità

%tratto I 0<tau<a accelerazione>0
tau1=linspace(0,a,250);
tau2=linspace(a,1,250);

YII1 = CAp*ones(size(tau1));
YII2 = CAm*ones(size(tau2));

YI1 = Cv*tau1*(n+1);
YI2 = Cv/n*(n+1)*(1-tau2);

Y1 = tau1.^2*(n+1);
Y2 = -1/n + 2*tau2/n*(n+1) - tau2.^2/n*(n+1);

%totale
tau=[tau1 tau2];
Y=[Y1 Y2];
Yp=[YI1 YI2];
Ypp=[YII1 YII2];

end