function ceq = eqCostFunction(X,U,data)
% https://it.mathworks.com/help/mpc/ug/specify-constraints-for-nonlinear-mpc.html

persistent robot
if isempty(robot)
    robot = rbtFcn();
    robot.DataFormat = 'column';
end

p = data.PredictionHorizon;
l = length(X(1,:))/2;

total_kinetic_energy = 0;

for i = 1:p+1
    q = X(i, 1:l);
    v = X(i, l+1:end);

    % Calcolo dell'energia cinetica
    M = massMatrix(robot, q');
    kinetic_energy = 0.5 * v * M * v';
    total_kinetic_energy = total_kinetic_energy + kinetic_energy;
end

ceq = total_kinetic_energy;

end