function X = weighted_pinv(A, weights, tol)

[U,s,V] = svd(A,'econ','vector');
if ~isempty(s) && isnan(s(1))
    X = nan(size(A, 2), size(A, 1), 'like', A);
    return
end

% Ensure weights are a column vector
if isrow(weights)
    weights = weights';
end

% Apply weighting to singular values
s_weighted = s .* weights;

if nargin < 3
    tol = max(size(A)) * eps(norm(s_weighted,inf));
elseif ~isnumeric(tol) || ~isreal(tol) || ~isscalar(tol)
    error(message('MATLAB:pinv:invalidSecondArgument'))
end

r = sum(s_weighted > tol);
V = matlab.internal.math.viewColumns(V,r);
U = matlab.internal.math.viewColumns(U,r);
s_weighted = matlab.internal.math.viewColumns(s_weighted.',r);
X = (V./s_weighted)*U';
end