clear; clc; close all

%% Importazione e definizione modello robot

%Definizione dimensioni manipolatore

%Base (cilindro)
base_dim = [60 50];%[mm] Radius, Length del cilindro di base

%Link (parallelepipedi)
link_wdt = [20 20 20 20 10 10 10];%[mm] Larghezza dei link
link_dpt = [20 20 20 20 10 10 10];%[mm] Profondità dei link
link_lgt = [40 100 100 175 20 30 20];%[mm] Lunghezza dei link

%End Effector (sfera)
ee_radius = 4;%[mm] Raggio sfera End Effector
ee_weight = 0.5;%[kg] Massa End Effector

%Giunti
q_init = [10 -15 0 100 0 95 0]; %[deg] Configurazione iniziale giunti

[DOF7_Arm, ArmInfo] = importrobot("Robot_7DOF.slx");

%% Impostazione parametri cinematici

% v_d = @(t) min(a0*t, v0, (2*a0*(norm(p_error)).^0.5))*p_error/norm(p_error);
a0 = 0.2; %[m/s^2], accelerazione iniziale massima
v0 = 0.1; %[m/s], velocità massima
alpha0 = 0.8; %[rad/s^2], accel. angolare massima
omega0 = 1.0; %[rad/s], vel. angolare massima

%% Posizione e orientazione desiderati

%0.26 0 0.15
p_d = [0.2 0.2 0.15]'; %[m], posizione richiesta

qdot_0 = [0 0 0 0 0 0 0]'; %[rad/s], vettore delle velocità dei giunti
                        % da proiettare nel null-space di J

%angolo richiesto
% quat_d = [1 0 0 0]';
rot_d = [pi/8 pi/2 pi/4];            % Angoli di Eulero ZYX
Rotation_matrix =  [1 0 0            % Matrice di rotazione
                    0 1 0
                    0 0 1];

%% Definizione forma accelerazione

% a, c indicano le frazioni unitarie da dedicare ai segmenti della funzione
% di forma scelta
a = 0.15; %accelerazione crescente
c = 0.2; %accelerazione decrescente
ts = 2.5; %[s], tempo di spostamento %% DA RIMUOVERE
    % voglio definire una accel. massima, invece di un tempo da rispettare

[Y,YI,YII,tau]=forma_trapezoidale(a,c); % trapezoidale modificata
% [Y,YI,YII,tau]=forma_biarmonica;

% ydd = YII*h/ts^2 (m/s^2)      accelerazione
% yd = YI*h/ts (m/s)            velocità
% y = YI*h (m)                  alzata
% in questo caso l'alzata equivale all'errore iniziale in posizione

Htrasf = getTransform(DOF7_Arm, homeConfiguration(DOF7_Arm), "Body9", "Base");
pos0 = tform2trvec(Htrasf)';
err0 = norm(p_d-pos0); % norma dell'errore di posizione
err_span = linspace(0, err0, 500);

ydd = YII*err0/ts^2;
% ydd = fliplr(ydd);
tvec = tau*ts;


%%

% show(DOF7_Arm,randomConfiguration(DOF7_Arm))

% DOF7_Arm.DataFormat = 'row';
% tau_gravity = gravityTorque(DOF7_Arm)

