function [Y,YI,YII,tau]=forma_trapezoidale(a,c)
%a: tratto sinusoidale      c: tratto cosinusoidale
    b = 1 - a - c;
    
    % I tratto, sinusoidale
    tau1= linspace(0, a/2,100);

    % II tratto, costante
    tau2 = linspace(a/2, (1-c)/2, 100);

    % III tratto, cosinusoidale
    tau3 = linspace((1-c)/2, (1+c)/2, 100);

    % IV tratto, costante
    tau4 = linspace((1+c)/2, (1-(a/2)), 100);

    % V tratto, sinusoidale
    tau5 = linspace((1-(a/2)), 1, 100);

    tau = [tau1 tau2 tau3 tau4 tau5];

    Ca = 1 / (a/pi + 2*(c^2 - a^2)/pi^2 + ((1-a)^2 - c^2)/4); %coeff. di accel.

    %primo tratto: accelerazione=seno
YII1=Ca*sin((pi/a)*tau1); %accelerazione adimensionale punteria
YI1=Ca*((a/pi)-(a/pi)*cos((pi/a)*tau1)); %velocità adimensionale punteria
Y1=Ca*((a/pi)*tau1-(a/pi)^2*sin((pi/a)*tau1)); %spostamento punteria

%secondo tratto: accelerazione=costante=Ca
YII2=Ca*ones(size(tau2)); %accelerazione adimensionale punteria
YI2=Ca*(tau2+a*((1/pi)-0.5)); %velocità adimensionale punteria
Y2=Ca*(((tau2).^2)/2+a*((1/pi)-0.5)*tau2+a^2*((1/8)-(1/pi)^2));%spostamentopunteria

%terzo tratto: accelerazione=coseno
YII3=Ca*cos((pi/c)*(tau3-(1-c)/2)); %accelerazione adimensionale punteria
YI3=Ca*(a/pi+b/2+(c/pi)*sin((pi/c)*(tau3-(1-c)/2))); %velocità adimensionalepunteria
Y3=Ca*((a/pi+b/2)*tau3-(c/pi)^2*cos((pi/c)*(tau3-(1-c)/2))+(c/pi)^2+a^2*(1/8-(1/pi)^2)-(1-c)^2/8); %spostamento punteria

%quarto tratto: accelerazione=costante=-Ca
YII4=-Ca*ones(size(tau4)); %accelerazione adimensionale punteria
YI4=Ca*(-tau4+(a/pi)+1-(a/2)); %velocità adimensionale punteria
Y4=Ca*(-(tau4.^2)/2+(a/pi+1-a/2)*tau4+(2*c^2-a^2)*(1/(pi)^2-1/8)-1/4); %spostamentopunteria

%quinto tratto: accelerazione=seno
YII5=(Ca)*(sin((pi/a)*(tau5-1))); %accelerazione adimensionale punteria
YI5=Ca*(a/pi-(a/pi)*cos((pi/a)*(tau5-1))); %velocità adimensionale punteria
Y5=Ca*((a/pi)*tau5+(2*(c^2-a^2)/(pi)^2)+((1-a)^2-c^2)/4-(a/pi)^2*sin((pi/a)*(tau5-1))); %spostamento punteria

%vettori complessivi per legge trapezoidale modificata
YII=[YII1 YII2 YII3 YII4 YII5]; %accelerazione adimensionale
YI=[YI1 YI2 YI3 YI4 YI5]; %velocità adimensionale
Y=[Y1 Y2 Y3 Y4 Y5]; %spostamento adimensionale

end