function [Y,Yp,Ypp,tau]=forma_acostante(tauv,tauw);
%forma_acostante.m seguendo una legge ad accelerazione costante
%crea tre vettori una contenente alzata adimensionale,
%velocità geometrica adimensionale, accelerazione geometrica
%adimensionale ed inoltre la variabile tau (tempo od alzata adimensionale)

a=tauv; %fine tratto con acc. >0
b=tauw; %fine tratto con acc. =0

%tratto I 0<tau<a accelerazione>0
tauI=linspace(0,a,200);
YI=tauI.^2/(a-a^2+a*b);
YpI=2*tauI/(a-a^2+a*b);
YppI=2/(a-a^2+a*b)*ones(size(tauI));

%tratto II a<tau<b accelerazione=0
tauII=linspace(a,b,100);
YII=(2*tauII-a)/(1-a+b);
YpII=2*ones(size(tauII))/(1-a+b);
YppII=0*ones(size(tauII));

%tratto III b<tau<1 accelerazione <0
tauIII=linspace(b,1,200);
YIII=(2*tauIII-a)/(1-a+b)-(tauIII-b).^2/((1-b)*(1-a+b));
YpIII=2/(1-a+b)-2*(tauIII-b)/((1-b)*(1-a+b));
YppIII=-2*ones(size(tauIII))/((1-b)*(1-a+b));

%totale
tau=[tauI tauII tauIII];
Y=[YI YII YIII];
Yp=[YpI YpII YpIII];
Ypp=[YppI YppII YppIII];