# variables.sh

# Configuration Variables #

# WAZUH URL #
#VERSION BTW MANAGER AND AGENT HAVE TO MATCH#

# Define the Wazuh version
#export WAZUH_AGENT_VERSION="4.9.0-1"
export WAZUH_VERSION="4.9"

# Repository URL for the Wazuh agent
export WAZUH_GPG_KEY="https://packages.wazuh.com/$WAZUH_VERSION/apt/doc/wazuh-key.gpg"
export WAZUH_AGENT_REPO_URL="https://packages.wazuh.com/4.x/apt/"

# Wazuh manager installation script URL
export WAZUH_MANAGER_INSTALL_SCRIPT_URL="https://packages.wazuh.com/$WAZUH_VERSION/wazuh-install.sh"

export WAZUH_MANAGER_CONFIG_SCRIPT_URL="https://packages.wazuh.com/$WAZUH_VERSION/config.yml"

# IP Addresses #

# Export Manager IPss
export MANAGER_IP="192.168.56.13"
export ATTACKER_IP="192.168.56.15"
export DEFENDER_IP="192.168.56.14"

# export WAZUH_INDEXER_IP="192.168.56.12"  # Removed space around the '='
# export WAZUH_DASHBOARD_IP="192.168.56.12"  # Removed space around the '='

# PORTS #
#export AGENT_PORT="1514"
# DEFINE NAMES #
export MANAGER_NAME="wazidx1"
export NODES=($MANAGER_NAME "wazagent1" "wazagent2")
export NODES_STR=$(IFS=" "; echo "${NODES[*]}") # Convert the NODES array into a space-separated string for python scripts


# KEYS - Do not forget id !#
export KEY_TYPE_SSH="id_ed25519"
export KEY_TYPE_SSH_VM="id_rsa"

# CRON JOB PATHS #
export PATH_TO_CRON_FILE="/etc/cron.d/vagrant_sync_jobs"
export PATH_TO_LOGROTATION_VM_FOLDER="/etc/logrotate.d/config_manager"
# Folders path no beginning (except for vagrant) or ending with a /#
export EPHEMERE_FOLDER_PATH="ephemere"
export PATH_TO_BACKUP_FOLDER="backup"  # Backup folder path
export PATH_TO_SSH_KEYS_FOLDER="ephemere/keys"
export PATH_TO_LOGROTATION_FOLDER="VM/setups/logrotation"
# File paths to use on VMs#
export PATH_TO_SSH_KEYS="ephemere/keys.txt"
export PATH_TO_SSH_HOST_KEY="ephemere/host_key.pub"
export PATH_TO_CREDENTIALS="ephemere/credentials.txt"
export PATH_TO_BIN="ephemere/bin.txt"
# CSV files path #
export PATH_TO_CSV_NODES_INFO="ephemere/csv/nodes_info.csv"

#PYTHON programs
#CSV
export PATH_TO_BUILD_INITIAL_CSV="src/build_initial_csv.py"
#Utils
export PATH_TO_IPLIST_TO_CBDLIST_PYTHON="src/vagrant_programs/iplist-to-cdblist.py"
# Logs #
export PATH_TO_LOG_DIR="/vagrant/log"
export PATH_TO_CRON_JOB_LOGS="$PATH_TO_LOG_DIR/cron_jobs.log"
export TERMINAL_LOGS_PATH='terminal_log.txt'
# Wazuh logs #
export PATH_TO_ALERT_LOGS="/var/ossec/logs/alerts/alerts.log"
export PATH_TO_HOST_ALERTS_LOGS="/vagrant/src/log/alerts.log"

#Shared files #
export PATH_TO_CONFIG_MANAGER="/vagrant/VM/configs/manager/config_manager.sh" 
export PATH_TO_SURICATA_YML="/vagrant/VM/configs/agents/yml/suricata.yml"
export PATH_TO_VM_SURICATA_YML="/etc/suricata/suricata.yaml"
export PATH_TO_VM_SURICATA_SIGNATURES=""
export PATH_TO_SSH_CONFIG="host/configs/config"

#INFO Careful , modify only agent.conf files hosting on the vagrant folder. There is a cron job running to ensure centralized conf on the host !.
# TODO configuring attacker and defender groups...
export PATH_TO_VICTIM_AGENT_CONF_FILE="VM/configs/manager/conf/default/agent.conf"
export PATH_TO_SERVER_VICTIM_AGENT_CONF_FILE="/var/ossec/etc/shared/default/agent.conf"

export PATH_TO_ATTACKER_AGENT_CONF_FILE="VM/configs/manager/conf/default/agent.conf"

# Local rules #
export PATH_TO_LOCAL_RULES_TELER="/vagrant/host/localrules/localrules_teler.yml"  
export PATH_TO_LOCAL_RULES_ALIENVAULT='/vagrant/host/localrules/localrules_alienvault.yml'
#NOTE Specified in the suricata yml configuration
export NETWORK_INTERFACE="enp0s8"
# Names #
export EPHEMERE_FOLDER_NAMES=("bin" "log" "keys" "csv")
export EPHEMERE_FILE_NAMES=("credentials.txt" "bin.txt")
export SSH_HOME_FOLDER="/home/$(hostname)/.ssh"
export SSH_CONFIG_FILE="/home/$(hostname)/.ssh/config"
export SSH_ROOT_FOLDER="/$HOME/.ssh"

# SCENARIOS #
export PATH_TO_SCENARIOS_FILE='host/scenarios/scenarios.sh'
export PATH_TO_SCENARIOS_FOLDER='host/scenarios'

# Brute force
export PATH_TO_BRUTE_FORCE_ATTACKER="host/scenarios/brute_force/attacker/brute_force_attacker.sh"
export PATH_TO_BRUTE_FORCE_DEFENDER="host/scenarios/brute_force/defender/brute_force_defender.sh"
export PATH_TO_BRUTE_FORCE_MANAGER="host/scenarios/brute_force/manager/brute_force_manager.sh"
#DVWA 
export PATH_TO_DVWA_ATTACKER="host/scenarios/dvwa/attacker/dvwa_attacker.sh"
export PATH_TO_DVWA_DEFENDER="host/scenarios/dvwa/defender/dvwa_defender.sh"
export PATH_TO_DVWA_MANAGER="host/scenarios/dvwa/manager/dvwa_manager.sh"

# Web attacks DVWA
export PATH_TO_TELER_DIR="/var/log/teler"   
export PATH_TO_TELER_LOGS="$PATH_TO_TELER_DIR/output.log"

#Config file for log exporting of teller.
export PATH_TO_TELER_YML="VM/configs/agents/yml/teler.yml"

# NOTE This path is due to docker mappping the docker image of the website to teller log folder.
# 'With the volume mapping -v /var/log/teler/:/var/log/apache2/, these logs are accessible on the host at /var/log/teler/.'
export PATH_TO_APACHE_LOGS="$PATH_TO_TELER_DIR/access.log"

# AlienVault
export PATH_TO_ALIENVAULT_ATTACKER="host/scenarios/alienvault/attacker/alienvault_attacker.sh"
export PATH_TO_ALIENVAULT_DEFENDER="host/scenarios/alienvault/defender/alienvault_defender.sh"
export PATH_TO_ALIENVAULT_MANAGER="host/scenarios/alienvault/manager/alienvault_manager.sh"

export PATH_TO_OSSEC_LISTS_DIR='/var/ossec/etc/lists'
export PATH_TO_APACHE2_DIR='/var/log/apache2'
export PATH_TO_APACHE2_LOGS="$PATH_TO_APACHE2_DIR/access.log"
export PATH_TO_ALIENVAULT_IP_LIST='/var/ossec/etc/lists/alienvault_reputation.ipset'
export PATH_TO_RELATIVE_ALIENVAULT_BLACKLIST="etc/lists/blacklist-alienvault"
export PATH_TO_ALIENVAULT_BLACKLIST="/var/ossec/$PATH_TO_RELATIVE_ALIENVAULT_BLACKLIST"

# YARA 
export PATH_TO_YARA_SCRIPT="/vagrant/src/bash_scripts/yara.sh"
export PATH_TO_YARA_MALWARE_DIR="/tmp/yara/malware"
export PATH_TO_YARA_RULES="/vagrant/yara/rules/yara_rules.yar"

# TESTS #
export VAGRANT_TESTS=true
export WAZUH_TESTS=true
export PATH_TO_TESTS_FILE='./common/tests/tests.sh'


# XML files rules 
export PATH_TO_WEB_RULES_XML='/var/ossec/ruleset/rules/0245-web_rules.xml'
export PATH_TO_LOCAL_RULES_XML='/var/ossec/etc/rules/local_rules.xml
'


# PATH TO USEFUL SCRIPTS 
export PATH_TO_UTILS='/vagrant/utils.sh'
export PATH_TO_SOURCER='/vagrant/sourcer.sh'

# HERE Python #
# Source 
export PATH_TO_PYTHON_SCRIPTS='/vagrant/src'
export PATH_TO_UTILS_WAZUH='/vagrant/src/wazuh_library/utils_wazuh.py'
export PATH_TO_UTILS_TESTS='/vagrant/src/wazuh_library/utils_tests.py'
export MODULE_TO_UTILS_TESTS='utils_tests'
export MODULE_TO_UTILS='utils'