# HERE Typography class variables / for logger #

DEBUG_LEVEL = "DEBUG"
PATH_TO_LOGS="log"
PATH_TO_SRC = "vagrant/src"


# HERE from src/ #

# HERE XML files #

#HERE Host configuration files 
PATH_TO_OSSEC_AGENT_ATTACKER="conf_files/ossec_agent_test.conf"
PATH_TO_OSSEC_AGENT_DEFENDER="conf_files/ossec_agent_test.conf"
PATH_TO_OSSEC_AGENT_MANAGER="conf_files/ossec_test.conf"

# HERE Base host configuration files
PATH_TO_OSSEC_AGENT_BASE_MANAGER = "conf_files/ossec_base.conf"
PATH_TO_OSSEC_AGENT_BASE_ATTACKER = "conf_files/ossec_agent_base.conf"
PATH_TO_OSSEC_AGENT_BASE_DEFENDER = "conf_files/ossec_agent_base.conf"

PATH_TO_OSSEC_FOLDER = "conf_files/"
PATH_TO_BACKUP_CONF_FOLDER = "conf_files/backup"

PATH_TO_OSSEC_AGENT_TEST_MANAGER = "conf_files/ossec_test.conf" # For testing purposes.

# Paths to local rules XML files

PATH_TO_LOCAL_RULES = "xml_files/local_rules.xml"
PATH_TO_VM_LOCAL_RULES = "/var/ossec/etc/rules/local_rules.xml"
# Paths to local decoder XML files
PATH_TO_LOCAL_DECODER = "xml_files/local_decoder.xml"
PATH_TO_VM_LOCAL_DECODER = "/var/ossec/etc/decoders/local_decoder.xml"

# HERE Bash scripts | RELATIVE PATHS !
PATH_TO_RUN_SSH_FUNCTION = "./run_ssh_function.sh"
PATH_TO_RUN_SSH_SCRIPT ="./run_ssh_script.sh"

PATH_TO_BASH_SCRIPTS = "src/bash_scripts" # ABSOLUT AS IT IS PARSED ON THE VM
NAME_MALWARE_SCRIPT = "malware_downloader.sh"
# HERE USEFUL directories
PATH_TO_AGENT_TYPES_DIR = "agents_elements/agent_types"

# HERE Python functions # 

# UTILS functions to run remotely #
PATH_TO_UTILS='/vagrant/src/utils.py'

# HERE Utils functions #

# Utils functions accepted types : 
FUNCTION_REQUIRED_AGENT_TYPES = {
    "simulate_file_change": {
        "agent_type": "defender",
    },
    "test_who_data": {
        "agent_type": "defender",
    },
    "check_fim_change": {
        "agent_type": "manager",
    },
    "configure_audit": {
        "agent_type": "manager",
    },
    "manage_ip_in_hosts_allow": {
        "agent_type": "manager",
    }
}

# HERE YARA 
PATH_TO_YARA_MALWARE_DIR = "/tmp/yara/malware"
PATH_TO_YARA_RULES = "/vagrant/yara/rules/yara_rules.yar"

# HERE For VM's | absolute paths #

# HERE VM configuration files 
PATH_TO_VM_OSSEC_AGENT_MANAGER = "/var/ossec/etc/ossec.conf"
PATH_TO_VM_OSSEC_AGENT_ATTACKER = "/var/ossec/etc/ossec.conf"
PATH_TO_VM_OSSEC_AGENT_DEFENDER = "/var/ossec/etc/ossec.conf"


# HERE VM & host alert log files# Absolut path
PATH_TO_VM_ALERTS = "/var/ossec/logs/alerts/alerts.json"
PATH_TO_HOST_ALERTS="log/alerts.json"


# HERE TMP folder

PATH_TO_TMP_FOLDER = "vagrant/src/tmp"